/*
 *	@(#)LwsFog.java 1.13 01/01/11 07:26:32
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package com.sun.j3d.loaders.lw3d;



import java.io.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import java.util.Enumeration;


/**
 * This class creates a Fog object from the data in a Scene file.
 */

class LwsFog extends TextfileParser {

    /* data from the file */
	float minDist, maxDist, minAmount, maxAmount;
	int backdropFog;
    Color3f color;
    int type;
	Fog fogObject = null;
   
	/**
	* Constructor: parses stream and stores fog data
	*/ 
    LwsFog(StreamTokenizer st, int debugVals) {
	debugPrinter.setValidOutput(debugVals);
	debugOutput(TRACE, "LwsFog()");
	color = new Color3f(0f, 0f, 0f);
	
	try {
	    
	    while (!isCurrentToken(st, "DitherIntensity")) {
		debugOutputLn(LINE_TRACE, "currentToken = " + st.sval);
		
		if (isCurrentToken(st, "FogMinDist")) {
		    minDist = (float)getNumber(st);
		}
		else if (isCurrentToken(st, "FogMaxDist")) {
		    maxDist = (float)getNumber(st);
		}
		else if (isCurrentToken(st, "FogMinAmount")) {
		    minAmount = (float)getNumber(st);
		}
		else if (isCurrentToken(st, "FogMaxAmount")) {
		    maxAmount = (float)getNumber(st);
		}
		else if (isCurrentToken(st, "BackdropFog")) {
		    backdropFog = (int)getNumber(st);
		}
		else if (isCurrentToken(st, "FogColor")) {
		    color.x = (float)getNumber(st)/255f;
		    color.y = (float)getNumber(st)/255f;
		    color.z = (float)getNumber(st)/255f;
		}
		st.nextToken();
	    }
	    st.pushBack();   // push token back on stack
	}
	catch (Exception e) {
	    System.out.println("Exception in constructor: " + e);
	    return;
	}
    }

	/**
	* Creates Java3d Fog object given the fog parameters in the file.
	* Note that various fog parameters in lw3d are not currently handled.
	*/
    void createJava3dObject()
    {
		/* TODO:  there are various attributes of lw fog that
		we're not currently handing, including non-linear fog
		(need to understand the two different types - these may
		map onto java3d's expontential fog node), non-solid
		backdrop colors (how to handle this?), min/max amount
		(j3d only handles 0 -> 1 case)*/
		fogObject = new LinearFog(color, minDist, maxDist);
		debugOutputLn(VALUES,
			      "just set linearFog with color, minDist, maxDist = " +
			      color + ", " +
			      minDist + ", " +
			      maxDist);
		BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100000.0);
		fogObject.setInfluencingBounds(bounds);
    }

    Fog getObjectNode()
    {
	return fogObject;
    }

    void printVals()
    {
	debugOutputLn(VALUES, "  FOG vals: ");
    }

    
}	
