/*
 *	@(#)LwsEnvelopeFrame.java 1.13 01/01/11 07:26:35
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package com.sun.j3d.loaders.lw3d;



import java.io.*;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Point3f;

/**
 * This class represents one keyframe in an envelope sequence.
 */

class LwsEnvelopeFrame extends TextfileParser {

    /* data from the file */
    double value;
    double frameNumber;
    int linearValue;
    double tension, continuity, bias;


	/**
	* Constructor: parses stream and stores data for one keyframe of
	* an envelope sequence
	*/    
    LwsEnvelopeFrame(StreamTokenizer st)
    {
	try {
	    value = getNumber(st);
	    debugOutputLn(VALUES, "value = " + value);
	    frameNumber = (int)getNumber(st);
	    linearValue = (int)getNumber(st);
	    debugOutputLn(VALUES, "framenum, linear " + frameNumber + " , " + linearValue);
	    tension = getNumber(st);
	    continuity = getNumber(st);
	    bias = getNumber(st);
	    debugOutputLn(VALUES, "tension, cont, bias = " + tension + ", " + continuity + ", " + bias);
	    //System.out.println("   FRAME VALS");
	    //printVals();
	}
	catch (Exception e) {
	    debugOutputLn(EXCEPTION, "Exception in constructor: " + e);
	    return;
	}
    }


    double getValue() {
	return value;
    }
    

    double getFrameNum() {
	return frameNumber;
    }

    
    void printVals() {
	debugOutputLn(VALUES, "         value = " + value);
	debugOutputLn(VALUES, "         frameNum = " + frameNumber);
	debugOutputLn(VALUES, "         lin = " + linearValue);
	debugOutputLn(VALUES, "         tension = " + tension);
	debugOutputLn(VALUES, "         continuity = " + continuity);
	debugOutputLn(VALUES, "         bias = " + bias);
    }

}	
