/*
 *	@(#)LwsEnvelope.java 1.15 01/01/11 07:26:34
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package com.sun.j3d.loaders.lw3d;

import java.io.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.internal.J3dUtilsI18N;

/**
 * This class is a superclass for any implementation of envelopes; the
 * only subclass currently is LwsEnvelopeLightIntensity. LwsEnvelope
 * parses the data in a Scene file and extracts the envelope data.
 */

class LwsEnvelope extends TextfileParser {

    /* data from the file */
    String name;
    LwsEnvelopeFrame frames[];
    int numFrames;
    int numChannels;
    boolean loop;
    float totalTime;
    int totalFrames;
    Behavior behaviors;

	/**
	* Constructor: calls getEnvelope() to parse the stream for the
	* envelope data
	*/    
    LwsEnvelope(StreamTokenizer st, int frames, float time)
    {
	try {
	    numFrames = 0;
	    totalTime = time;
	    totalFrames = frames;
	    name = getName(st);
	    getEnvelope(st);
	}
	catch (Exception e) {
	    debugOutputLn(EXCEPTION, "Exception in constructor: " + e);
	    return;
	}
    }

	/**
	* Parses the stream to retrieve all envelope data.  Creates
	* LwsEnvelopeFrame objects for each keyframe of the envelope 
	* (these frames differ slightly from LwsFrame objects because
	* envelopes contain slightly different data)
	*/
    void getEnvelope(StreamTokenizer st)
	throws IOException
    {
	debugOutputLn(TRACE, "getEnvelope()");
	numChannels = (int)getNumber(st);
	if (numChannels != 1) {
	    throw new IOException(J3dUtilsI18N.getString("LwsEnvelope0"));
	}
	debugOutputLn(LINE_TRACE, "got channels");

	numFrames = (int)getNumber(st);
	frames = new LwsEnvelopeFrame[numFrames];
	debugOutputLn(VALUES, "got frames" + numFrames);

	for (int i = 0; i < numFrames; ++i) {
	    frames[i] = new LwsEnvelopeFrame(st);
	}
	debugOutput(LINE_TRACE, "got all frames");

	st.nextToken();
	while (!isCurrentToken(st, "EndBehavior")) {
	    // There is an undocumented "FrameOffset" in some files
	    st.nextToken();
	}
	int repeatVal = (int)getNumber(st);
	if (repeatVal == 1)
	    loop = false;
	else
	    loop = true;
    }

	/**
	* This superclass does nothing here - if the loader understands
	* how to deal with a particular type of envelope, it will use
	* a subclass of LwsEnvelope that will override this method
	*/
    void createJava3dBehaviors(TransformGroup target) {
	behaviors = null;
    }

    Behavior getBehaviors() {
	return behaviors;
    }
    
    
    LwsEnvelopeFrame getFirstFrame() {
	if (numFrames > 0)
	    return frames[0];
	else
	    return null;
    }

    
    void printVals() {
	debugOutputLn(VALUES, "   name = " + name);
	debugOutputLn(VALUES, "   numChannels = " + numChannels);
	debugOutputLn(VALUES, "   numFrames = " + numFrames);
	debugOutputLn(VALUES, "   loop = " + loop);
	for (int i = 0; i < numFrames; ++i) {
	    debugOutputLn(VALUES, "       FRAME " + i);
	    frames[i].printVals();
	}
    }

}	
