/*
 *	@(#)LwsBackground.java 1.13 01/01/11 07:26:33
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package com.sun.j3d.loaders.lw3d;



import java.io.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import java.util.Enumeration;


/**
 * This class creates a Background object (solid color only, no geometry)
 * according to some of the data stored in a Scene file. Note: Lightwave
 * defines much more complex backgrounds that the loader currently
 * handles. It should be possible to se Background Geometry to handle
 * most of these cases, if there's time and will to work on the problem.
 */

class LwsBackground extends TextfileParser {

    /* data from the file */
	int solidBackdrop;
    Color3f color, zenithColor, skyColor, groundColor, nadirColor;
	Background backgroundObject = null;


	/**
	* Constructor: parses stream and retrieves all Background-related data
	*/    
    LwsBackground(StreamTokenizer st, int debugVals) {
	debugPrinter.setValidOutput(debugVals);
	debugOutput(TRACE, "LwsBackground()");
	color = new Color3f(0f, 0f, 0f);
	zenithColor = new Color3f(0f, 0f, 0f);
	skyColor = new Color3f(0f, 0f, 0f);
	groundColor = new Color3f(0f, 0f, 0f);
	nadirColor = new Color3f(0f, 0f, 0f);
	
	try {
	    
	    solidBackdrop = (int)getNumber(st);
	    while (!isCurrentToken(st, "FogType")) {
		debugOutputLn(LINE_TRACE, "currentToken = " + st.sval);
		
		if (isCurrentToken(st, "BackdropColor")) {
		    color.x = (float)getNumber(st)/255f;
		    color.y = (float)getNumber(st)/255f;
		    color.z = (float)getNumber(st)/255f;
		}
		else if (isCurrentToken(st, "NadirColor")) {
		    nadirColor.x = (float)getNumber(st)/255f;
		    nadirColor.y = (float)getNumber(st)/255f;
		    nadirColor.z = (float)getNumber(st)/255f;
		}
		else if (isCurrentToken(st, "SkyColor")) {
		    skyColor.x = (float)getNumber(st)/255f;
		    skyColor.y = (float)getNumber(st)/255f;
		    skyColor.z = (float)getNumber(st)/255f;
		}
		else if (isCurrentToken(st, "GroundColor")) {
		    groundColor.x = (float)getNumber(st)/255f;
		    groundColor.y = (float)getNumber(st)/255f;
		    groundColor.z = (float)getNumber(st)/255f;
		}
		else if (isCurrentToken(st, "NadirColor")) {
		    nadirColor.x = (float)getNumber(st)/255f;
		    nadirColor.y = (float)getNumber(st)/255f;
		    nadirColor.z = (float)getNumber(st)/255f;
		}
		st.nextToken();
	    }
	    st.pushBack();   // push token back on stack
	}
	catch (Exception e) {
	    System.out.println("Exception in constructor: " + e);
	    return;
	}
    }

	/**
	* Creates Java3d objects from the background data.  Note that there
	* are plenty of lw3d background attributes that the loader currently
	* ignores.  Some of these may best be handled by creating background
	* geometry rather than a solid background color
	*/
    void createJava3dObject()
    {
		/* TODO:  there are various attributes of 
		backdrops that we're not currently handling.  In 
		particular, if the file calls for a gradient background
		(solidBackdrop == 0), we ignore the request and just
		create a solid background from the sky color instead.
		We should be able to do something with the
		various colors specified, perhaps by creating
		background geometry with the appropriate vertex
		colors?

		*/
	if (solidBackdrop != 0) {
	    backgroundObject = new Background(color);
	    debugOutput(VALUES, "Background color = " + color);
	}
	else {
	    backgroundObject = new Background(skyColor);
	    debugOutput(VALUES, "Background color = " + skyColor);
	}
	BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100000.0);
	backgroundObject.setApplicationBounds(bounds);
    }

    Background getObjectNode() {
	return backgroundObject;
    }

    void printVals() {
	debugOutputLn(VALUES, "  BACKGROUND vals: ");
    }

    
}	
