/*
 *	@(#)LightIntensityPathInterpolator.java 1.13 01/01/11 07:26:34
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package com.sun.j3d.loaders.lw3d;

import java.util.*;

import javax.media.j3d.Alpha;
import javax.media.j3d.Light;

/**
 * This Interpolator object modifies the intensity of a Light object
 * according to the keyframes in a light intensity envelope.<BR>
 */

class LightIntensityPathInterpolator extends FloatValueInterpolator {

    LwLightObject theLight;

    LightIntensityPathInterpolator(Alpha alpha,
					  float knots[],
					  float values[],
					  Object target) {

	super(alpha, knots, values);
	theLight = (LwLightObject)target;
    }

    /**
     * This method is invoked by the behavior scheduler every frame.  It maps
     * the alpha value that corresponds to the current time into the 
     * appropriate light intensity for that time as obtained by interpolating
     * between the light intensity values for each knot point that were passed  
     * to this class.
     * @param criteria enumeration of criteria that have triggered this wakeup
     */

    public void processStimulus(Enumeration criteria) {
        /* Handle stimulus */

        if (this.getAlpha() != null) {

            // Let FloatValueInterpolator calculate the correct 
            // interpolated value
            computePathInterpolation();

            // Set light intensity to the value calculated by 
            // FloatValueInterpolator
            if (theLight != null) 
               theLight.setIntensity(currentValue);

            if ((this.getAlpha()).finished())
                return;
        }

        wakeupOn(defaultWakeupCriterion);

    }

}

