/*
 *	@(#)LWOBFileReader.java 1.18 01/01/11 07:26:31
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package com.sun.j3d.loaders.lw3d;



import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;



class LWOBFileReader extends BufferedInputStream {



    // Debugging constants
    final static int TRACE = DebugOutput.TRACE;
    final static int VALUES = DebugOutput.VALUES;
    final static int MISC = DebugOutput.MISC;
    final static int LINE_TRACE = DebugOutput.LINE_TRACE;
    final static int NONE = DebugOutput.NONE;
    final static int EXCEPTION = DebugOutput.EXCEPTION;

    protected DebugOutput debugPrinter;

    protected String theFilename;

    protected int marker;



    protected void debugOutputLn(int outputType, String theOutput) {
        if (theOutput.equals(""))
            debugPrinter.println(outputType, theOutput);
        else
            debugPrinter.println(outputType,
                                 getClass().getName() + "::" + theOutput);
    } // End of debugOutputLn



    // Return a string consisting of the next 4 bytes in the file
    public String getToken() {
        byte tokenBuffer[] = new byte[4];
        try {
            int readResult = read(tokenBuffer, 0, 4);
            if (readResult == -1) {
                debugOutputLn(LINE_TRACE, "no token - returning null");
                return null;
            }
            return new String(tokenBuffer);
        }
        catch (Exception e) {
            debugOutputLn(EXCEPTION, "getToken: " + e);
        }
        return null;
    }



    /**
     * Skip ahead amount bytes in the file
     */
    public void skipLength(int amount) {
	try {
	    skip((long)amount);
	    marker += amount;
	}
	catch (Exception e) {
	    debugOutputLn(EXCEPTION, "skipLength: " + e);
	}
    }



    /**
     * Read four bytes from the file and return their integer value 
     */
    public int getInt() {
        try {
	    int x = 0;
	    for (int i = 0 ; i < 4 ; i++) {
		int readResult = read();
		if (readResult == -1) throw new IOException("Unexpected EOF");
		x = (x << 8) | readResult;
	    }
            return x;
        }
        catch (Exception e) {
            debugOutputLn(EXCEPTION, "getInt: " + e);
        }
        return 0;
    }



    /**
     * Read four bytes from the file and return their float value
     */
    public float getFloat() {
	return Float.intBitsToFloat(getInt());
    } // End of getFloat



    /**
     * Returns the name of the file associated with this stream
     */
    public String getFilename() {
	return theFilename;
    } // End of getFilename



    /**
     * Returns a string read from the file.  The string is assumed to
     * end with '0'.
     */
    public String getString() {
      byte buf[] = new byte[512];
      try {
	  byte b;
	  int len = 0;
	  do {
	    b = (byte)read();
	    buf[len++] = b;
	  } while (b != 0);
	  // Have to read an even number of bytes
	  if (len % 2 != 0) read();
      }
      catch (Exception e) {
	  debugOutputLn(EXCEPTION, "getString: " + e);
      }
      return new String(buf);
    } // End of getString



    /*
     * Read an array of xyz values
     */
    public void getVerts(float ar[], int num) throws IOException {
      for (int i = 0 ; i < num ; i++) {
	ar[i * 3 + 0] = getFloat();
	ar[i * 3 + 1] = getFloat();
	ar[i * 3 + 2] = -getFloat();
      }
    } // End of getVerts



    /**
     * Reads two bytes from the file and returns their integer value
     */
    public int getShortInt() {
	int i = 0;
	try {
	    i = read();
	    i = (i << 8) | read();
	    // Sign extension
	    if ((i & 0x8000) != 0) i |= 0xffff0000;
	}
	catch (Exception e) {
	    debugOutputLn(EXCEPTION, "getShortInt: " + e);
	}
	return i;
    } // End of getShortInt



    /**
     * Returns the current position in the file
     */
    public int getMarker() {
      // protected field inherited from BufferedInputStream
      return marker;
    } // End of getMarker



    public int read() throws IOException {
      marker++;
      return super.read();
    } // End of read()



    public int read(byte[] buffer, int offset, int count) throws IOException {
      int ret = super.read(buffer, offset, count);
      if (ret != -1) marker += ret;
      return ret;
    } // End of read(byte[], int, int)



    /**
     * Constructor.
     */
    public LWOBFileReader(String filename) throws FileNotFoundException {
	super(new FileInputStream(filename));

	// Add constants on this line to get more debug output
	debugPrinter = new DebugOutput(127);

	marker = 0;
    } // End of constructor

  public LWOBFileReader(java.net.URL url) throws java.io.IOException {
    super(url.openStream());

    // add constants on this line to get more debug output
    debugPrinter = new DebugOutput(127);

    marker = 0;
  }

} // End of file LWOBFileReader
