/*
 *	@(#)ImageScaler.java 1.11 01/01/11 07:26:33
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package com.sun.j3d.loaders.lw3d;


import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

/**
 * This class resizes an image to be the nearest power of 2 wide and high.
 * This facility now exists inside of the TextureLoader class, so
 * ImageScaler should be eliminated at some point.
 */

class ImageScaler {

    int origW, origH;
    Image origImage;
    
    ImageScaler(Image image, int w, int h) {
	origImage = image;
	origW = w;
	origH = h;
    }

    ImageScaler(BufferedImage image) {
	origImage = image;
	origW = image.getWidth();
	origH = image.getHeight();
    }

	/**
	* Utility method to return closes poser of 2 to the given integer
	*/    
    int getClosestPowerOf2(int value) {

	if (value < 1)
	    return value;
	
	int powerValue = 1;
	for (int i = 1; i < 20; ++i) {
	    powerValue *= 2;
	    if (value < powerValue) {
		// Found max bound of power, determine which is closest
		int minBound = powerValue/2;
		if ((powerValue - value) >
		    (value - minBound))
		    return minBound;
		else
		    return powerValue;
	    }
	}
	// shouldn't reach here...
	return 1;
    }
	 
	/**
	* Returns an Image that has been scaled from the original image to
	* the closest power of 2
	*/   
    Image getScaledImage() {
	int newWidth = getClosestPowerOf2(origW);
	int newHeight = getClosestPowerOf2(origH);

	// If the image is already a power of 2 wide/tall, no need to scale
	if (newWidth == origW &&
	    newHeight == origH)
	    return origImage;

	Image scaledImage = null;
	
	if (origImage instanceof BufferedImage) {
		// If BufferedImage, then we have some work to do
	    BufferedImage origImageB = (BufferedImage)origImage;
	    scaledImage =
		new BufferedImage(newWidth,
				  newHeight,
				  origImageB.getType());
	    BufferedImage scaledImageB = (BufferedImage)scaledImage;
	    float widthScale = (float)origW/(float)newWidth;
	    float heightScale = (float)origH/(float)newHeight;
	    int origPixels[] = ((DataBufferInt)origImageB.getRaster().getDataBuffer()).getData();
	    int newPixels[] = ((DataBufferInt)scaledImageB.getRaster().getDataBuffer()).getData();
	    for (int row = 0; row < newHeight; ++row) {
		for (int column = 0; column < newWidth; ++column) {
		    int oldRow = Math.min(origH-1,
					  (int)((float)(row)*
						heightScale + .5f));
		    int oldColumn =
			Math.min(origW-1, 
				 (int)((float)column*widthScale + .5f));
		    newPixels[row*newWidth + column] =
			origPixels[oldRow*origW + oldColumn];
		}
	    }
	}
	else {
		// If regular Image, then the work is done for us
	    scaledImage = origImage.getScaledInstance(newWidth,
						      newHeight,
						      Image.SCALE_DEFAULT);
	}
	return scaledImage;
    }
}
