/*
 *	@(#)EnvelopeHandler.java 1.13 01/01/11 07:26:33
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package com.sun.j3d.loaders.lw3d;

import java.io.StreamTokenizer;
import java.io.IOException;
import java.lang.reflect.Constructor;



/**
 * This class is used in implementing Envelope objects (of which there
 * is currently only one - LightIntensity).
 * The class is called whenever the parser has encountered
 * a token which could have an envelope description.  If the
 * token simply has a numeric value, this value is stored.
 * If, instead, there is an envelope, then the class creates
 * the envelope class and parses that information.
 */

class EnvelopeHandler extends TextfileParser {

    float theValue = 0;
    boolean hasValue = false;
    boolean hasEnvelope = true;
    LwsEnvelope theEnvelope = null;

	/**
	* Constructor: This constructor is used if there is no existing
	* implementation for this type of envelope.  The real constructor
	* is called with the generic LwsEnvelope class name, which will
	* allow s to parse and ignore the envelope data
	*/
    EnvelopeHandler(StreamTokenizer st,
        int totalFrames, float totalTime) {
        this(st, totalFrames, totalTime,
	     "com.sun.j3d.utils.loaders.lw3d.LwsEnvelope");
    }

	/**
	* Constructor: This constructor is called with the name of a class
	* that can handle the encountered envelope.  This is done so that this
	* EnvelopeHandler class can generically call the given class to handle
	* the envelope, whether it results in parsing/ignoring the data or 
	* in actually using the data
	*/
    EnvelopeHandler(StreamTokenizer st,
			   int totalFrames,
			   float totalTime,
			   String envClassName) {
	try {
	    theValue = (float)getNumber(st);
            hasValue = true;
	}
	catch (IOException e) {
	    if (st.ttype == '(') {
		st.pushBack();
                try {
		// This code creates a new instance for the given class name
		    Class envClass = Class.forName(envClassName);
		    Constructor constructors[] = envClass.getConstructors();
		    Constructor con = constructors[0];
		    Object args[] = new Object[3];
		    args[0] = (Object)st;
		    args[1] = (Object)(new Integer(totalFrames));
		    args[2] = (Object)(new Float(totalTime));
		    theEnvelope = (LwsEnvelope)con.newInstance(args);
                }
                catch (Exception e1) {
                    debugOutputLn(DebugOutput.EXCEPTION,
				  "Exception in constructor: " + e1);
		}
                hasEnvelope = true;
	    }
	}
    }
}
