/*
 *	@(#)JSSample.java 1.20 01/01/11 07:25:48
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

/*
 * Java Sound Sample object
 */
package com.sun.j3d.audioengines.javasound;

import javax.media.j3d.*;
import com.sun.j3d.audioengines.*;

/**
 * The Sample Class extended for Java Sound Mixer specific audio device.
 */

public class JSSample extends com.sun.j3d.audioengines.Sample
{
    /*
     * NOTE: for this device type there is exactly one sample associated
     *       with each sound.
     */

    /** 
     *  Sound Data Types
     *  
     *  Samples can be processed as streaming or buffered data.
     *  Fully spatializing sound sources may require data to be buffered.
     */ 
    /**
     *  Sound data specified as Streaming is not copied by the AudioDevice
     *  driver implementation.  It is up the application to ensure that
     *  this data is continuously accessible during sound rendering.
     *  Futhermore, full sound spatialization may not be possible, for
     *  all AudioDevice implementations on unbuffered sound data.
     */ 
    public static final int STREAMING_AUDIO_DATA = 1;
    /** 
     *  Sound data specified as Buffered is copied by the AudioDevice
     *  driver implementation.
     */ 
    public static final int BUFFERED_AUDIO_DATA = 2;
    /** 
     *  MIDI data 
     *  %%% TODO differentiate between STREAMING and BUFFERED MIDI data
     *      right now all MIDI data is buffered
     */ 
    public static final int STREAMING_MIDI_DATA = 3;
    public static final int BUFFERED_MIDI_DATA = 3;
    public static final int UNSUPPORTED_DATA_TYPE = -1;

    public static final int NULL_SAMPLE = -1;

    /**
     *  sound data types: BUFFERED (cached) or STREAMING (non-cached)
     */  
    int   dataType = BUFFERED_AUDIO_DATA;

    /**
     *  Offset pointer within currently playing sample data
     */  
    long      dataOffset = 0;

    /*
     * Left and Right absolute values last sent to audio driver
     */  
    float     leftGain     = 1.0f;
    float     rightGain    = 1.0f;
    int       leftDelay = 0;                        // left ITD in millisec
    int       rightDelay = 0;                       // right ITD in millisec

    /*
     * Maintain continuously playing silent sound sources.
     */  
    long      timeDeactivated = 0;
    long      positionDeactivated   = 0;

    long      sampleLength = 0;
    long      loopStartOffset = 0; // for most this will be 0
    long      loopLength = 0;      // for most this is end sample - sampleLength
    long      attackLength = 0;    // portion of sample before loop section
    long      releaseLength = 0;   // portion of sample after loop section

    int       rate = -1;           // sample rate from stream/clip
    float     rateRatio = 1.0f;

    public JSSample() {
        super();
        if (debugFlag) 
            debugPrintln("JSSample constructor");
    }

    public void  setDataType(int type) {
        dataType = type;
    }

    public int   getDataType() {
        return dataType;
    }

    public float getGain() {
        return gain;
    }

    /**
     * Clears/re-initialize fields associated with sample data for
     * this sound,
     * and frees any device specific data associated with this sample.
     */  
    public void clear() {
        if (debugFlag)
            debugPrintln("JSSample.clear() entered"); 
        super.clear();
        // %%% TODO unload sound data at device
        dataType = BUFFERED_AUDIO_DATA;
        dataOffset = 0;
        leftGain     = 1.0f;
        rightGain   = 1.0f;
        leftDelay      = 0;
        rightDelay     = 0;
        timeDeactivated = 0;
        positionDeactivated = 0;
        sampleLength = 0;
        loopStartOffset = 0;
        loopLength = 0;
        attackLength = 0;
        releaseLength = 0;
        rate = -1;
        if (debugFlag)
            debugPrintln("JSSample.clear() exited"); 
    }

    void reset() {
    }

    public void  setGain(float scaleFactor) {
        gain = scaleFactor;
        leftGain = scaleFactor;
        rightGain = scaleFactor;
        return;
    }

    public void   setSampleRate(int rate) {
        this.rate = rate;
    }

    public int    getSampleRate() {
        return rate;
    }

    public void render(int dirtyFlags, View view, AuralParameters attribs) {
        if (debugFlag)
            debugPrint("JSSample.render - gain " + gain);
        leftGain     = gain;
        rightGain    = gain;
        leftDelay    = 0;
        rightDelay   = 0;
        float freqScaleFactor = attribs.getFrequencyScaleFactor();
        if (attribs != null) {
            if (freqScaleFactor <= 0.0f) {
                // %%% TODO Pause Sample
            }
            else
                rateRatio = freqScaleFactor;
        }
        else 
            rateRatio = 1.0f; 
    }
 
    /*
     * Stop
     */
    public void stop() {
        super.stop();
    }

    /*
     * Process request for Reverb
     */  
    public int   getReverbIndex() { 
        // %%% TODO change when/if Reverb supported for Background sounds
        return NULL_SAMPLE; 
    }

    /*
     * Process request for Filtering fields
     */  
    public boolean  getFilterFlag() { 
        return false;
    }
    public float  getFilterFreq() { 
        return -1.0f;
    }
}
