/*
 *	@(#)AuralParameters.java 1.18 01/01/11 07:25:35
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package com.sun.j3d.audioengines;

import javax.media.j3d.*;
import javax.vecmath.*;

/**
 * The AuralParameters Class defines a set of fields that correspond to
 * AuralAttribute fields.
 *
 * Error checking on all parameters passed to these methods is already
 * explicitly being done by the Java 3D core code that calls these methods.
 */

public class AuralParameters
{
    // Speed of Sound in meters/milliseconds
    public static final float  SPEED_OF_SOUND  = 0.344f;
    public static final int    NO_FILTERING    = -1;

    float     rolloff = 1.0f;
    float     reflectionCoefficient = 1.0f;
    float     reverbDelay = 0.0f;
    int       reverbOrder = 0;
    int       filterType = NO_FILTERING;
    double[]  filterDistance = new double[2];  // start out with array of two
    float[]   filterCutoff   = new float[2];  // start out with array of two
    float     frequencyScaleFactor = 1.0f;
    float     velocityScaleFactor = 1.0f;

    /**
     * Construct a new AuralParameters object
     */  
    public AuralParameters() {
    }

    public void setRolloff(float rolloff) {
        this.rolloff = rolloff;
        return;
    }
    public float getRolloff() {
        return this.rolloff;
    }

    public void setReflectionCoefficient(float coefficient) {
        reflectionCoefficient = coefficient;
        return;
    }
    public float getReflectionCoefficient() {
        return this.reflectionCoefficient;
    }

    public void setReverbDelay(float reverbDelay) {
        this.reverbDelay = reverbDelay;
        return;
    }
    public float getReverbDelay() {
        return this.reverbDelay;
    }

    public void setReverbOrder(int reverbOrder) {
        this.reverbOrder = reverbOrder;
        return;
    }

    public int getReverbOrder() {
        return this.reverbOrder;
    }

    public void setDistanceFilter(int filterType, double[] distance, 
              float[]  filterCutoff) {
        boolean error = false;
        boolean allocate = false;
        int attenuationLength = 0;
        if (distance == null || filterCutoff == null) {
            error = true;
        } 
        else {
            attenuationLength = distance.length;
            if (attenuationLength == 0 || filterType == NO_FILTERING) {
                error = true;
            }
        }  
        if (error) {
            this.filterType = NO_FILTERING;
            this.filterDistance = null;
            this.filterCutoff   = null;
            if (debugFlag)
                debugPrint("setDistanceFilter NO_FILTERING");
            return;
        }
        this.filterType = filterType;
            if (debugFlag)
                debugPrint("setDistanceFilter type = " + filterType);
        if ((filterDistance == null) || (filterCutoff == null)) {
            allocate = true;
        }
        else if (attenuationLength > filterDistance.length) {
            allocate = true;
        }
        if (allocate) {
            if (debugFlag)
                debugPrint("setDistanceFilter length = " + attenuationLength);
            this.filterDistance = new double[attenuationLength];
            this.filterCutoff   = new float[attenuationLength];
        }
        System.arraycopy(distance, 0, this.filterDistance, 0, 
                         attenuationLength); 
        System.arraycopy(filterCutoff, 0, this.filterCutoff, 0, 
                         attenuationLength); 

        if (debugFlag) {
            debugPrint("setDistanceFilter arrays = ");
            for (int i=0; i<attenuationLength; i++)
                debugPrint(this.filterDistance[i] + "," + this.filterCutoff[i]);
            debugPrint("setDistanceFilter passed in = ");
            for (int i=0; i<attenuationLength; i++)
                debugPrint((float)(filterDistance[i]) + "," + filterCutoff[i]);
        }
        return;
    }
    public int  getDistanceFilterLength() {
        if (filterDistance != null)
            return filterDistance.length;
        return 0;
    }

    public int  getDistanceFilterType() {
        return filterType;
    }

    public void getDistanceFilter(double[] distance, float[]  filterCutoff) {
        if (distance == null || filterCutoff == null)
            return;
        int attenuationLength = distance.length;
        if (attenuationLength == 0 ||
            (filterDistance==null) || (filterCutoff==null))
            return;
        if (attenuationLength > filterDistance.length)
            attenuationLength = filterDistance.length;
        System.arraycopy(this.filterDistance, 0, distance, 0,
                         attenuationLength); 
        System.arraycopy(this.filterCutoff, 0, filterCutoff, 0,
                         attenuationLength); 
        return;
    }

    public void setFrequencyScaleFactor(float frequencyScaleFactor) {
        this.frequencyScaleFactor = frequencyScaleFactor;
        return;
    }
    public float getFrequencyScaleFactor() {
        return this.frequencyScaleFactor;
    }

    public void setVelocityScaleFactor(float velocityScaleFactor) {
        this.velocityScaleFactor = velocityScaleFactor;
        return;
    }
    public float getVelocityScaleFactor() {
        return this.velocityScaleFactor;
    }

    /**
     ** Debug print mechanism for Sound nodes
     **/ 
    static final
    protected boolean  debugFlag = false;

    static final // 'static final' so internal error prints will not be compiled
    protected boolean internalErrors = false;

    protected void debugPrint(String message) {
        if (debugFlag)
            System.out.println(message);
    }
 
}
