/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.Locale;
import javax.media.j3d.VirtualUniverse;

public class SimpleUniverse
extends VirtualUniverse {
    protected Locale locale;
    protected Viewer viewer;

    public SimpleUniverse() {
        this(null, 1, null, null);
    }

    public SimpleUniverse(int n) {
        this(null, n, null, null);
    }

    public SimpleUniverse(Canvas3D canvas3D) {
        this(null, 1, canvas3D, null);
    }

    public SimpleUniverse(Canvas3D canvas3D, int n) {
        this(null, n, canvas3D, null);
    }

    public SimpleUniverse(HiResCoord hiResCoord, int n, Canvas3D canvas3D, URL uRL) {
        this.locale = hiResCoord == null ? new Locale((VirtualUniverse)this) : new Locale((VirtualUniverse)this, hiResCoord);
        ViewingPlatform viewingPlatform = new ViewingPlatform(n);
        this.viewer = new Viewer(canvas3D, uRL);
        this.viewer.setViewingPlatform(viewingPlatform);
        this.locale.addBranchGraph((BranchGroup)viewingPlatform);
    }

    public SimpleUniverse(ViewingPlatform viewingPlatform, Viewer viewer) {
        this.locale = new Locale((VirtualUniverse)this);
        this.viewer = viewer;
        this.viewer.setViewingPlatform(viewingPlatform);
        this.locale.addBranchGraph((BranchGroup)viewingPlatform);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public ViewingPlatform getViewingPlatform() {
        return this.viewer.getViewingPlatform();
    }

    public Canvas3D getCanvas() {
        return this.getCanvas(0);
    }

    public Canvas3D getCanvas(int n) {
        return this.viewer.getCanvases();
    }

    public void addBranchGraph(BranchGroup branchGroup) {
        this.locale.addBranchGraph(branchGroup);
    }

    public static GraphicsConfiguration getPreferredConfiguration() {
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("j3d.stereo");
            }
        });
        if (string != null) {
            if (string.equals("REQUIRED")) {
                graphicsConfigTemplate3D.setStereo(1);
            } else if (string.equals("PREFERRED")) {
                graphicsConfigTemplate3D.setStereo(2);
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
    }
}

