/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.image;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;

public class TextureLoader {
    public static final int GENERATE_MIPMAP = 1;
    public static final int BY_REFERENCE = 2;
    public static final int Y_UP = 4;
    private static ColorSpace cs = ColorSpace.getInstance(1000);
    private static int[] nBits = new int[]{8, 8, 8, 8};
    private static int[] bandOffset = new int[]{0, 1, 2, 3};
    private static ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, true, false, 1, 0);
    private Texture2D tex = null;
    private BufferedImage bufferedImage = null;
    private ImageComponent2D imageComponent = null;
    private int textureFormat = 6;
    private int imageComponentFormat = 2;
    private int flags;
    private boolean byRef;
    private boolean yUp;
    private boolean useJAI = false;
    private Method jaiGetWidth;
    private Method jaiGetHeight;
    private Method jaiGetAsBufferedImage;
    private Method jaiGetRendering;
    private Method jaiCreate;
    private boolean doneJAICheck = false;
    private boolean jaiInstalled = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public TextureLoader(BufferedImage bufferedImage) {
        this(bufferedImage, new String("RGBA"), 0);
    }

    public TextureLoader(BufferedImage bufferedImage, String string) {
        this(bufferedImage, string, 0);
    }

    public TextureLoader(BufferedImage bufferedImage, int n) {
        this(bufferedImage, new String("RGBA"), n);
    }

    public TextureLoader(BufferedImage bufferedImage, String string, int n) {
        this.parseFormat(string);
        this.flags = n;
        this.bufferedImage = bufferedImage;
        if ((n & 2) != 0) {
            this.byRef = true;
        }
        if ((n & 4) != 0) {
            this.yUp = true;
        }
    }

    public TextureLoader(Image image, Component component) {
        this(image, new String("RGBA"), 0, component);
    }

    public TextureLoader(Image image, String string, Component component) {
        this(image, string, 0, component);
    }

    public TextureLoader(Image image, int n, Component component) {
        this(image, new String("RGBA"), n, component);
    }

    public TextureLoader(Image image, String string, int n, Component component) {
        if (component == null) {
            component = new Container();
        }
        this.parseFormat(string);
        this.flags = n;
        this.bufferedImage = this.createBufferedImage(image, component);
        if ((n & 2) != 0) {
            this.byRef = true;
        }
        if ((n & 4) != 0) {
            this.yUp = true;
        }
    }

    public TextureLoader(String string, Component component) {
        this(string, new String("RGBA"), 0, component);
    }

    public TextureLoader(String string, String string2, Component component) {
        this(string, string2, 0, component);
    }

    public TextureLoader(String string, int n, Component component) {
        this(string, new String("RGBA"), n, component);
    }

    public TextureLoader(String string, String string2, int n, Component component) {
        if (component == null) {
            component = new Container();
        }
        final Toolkit toolkit = Toolkit.getDefaultToolkit();
        final Image[] imageArray = new Image[1];
        final String string3 = string;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                imageArray[0] = toolkit.createImage(string3);
                return null;
            }
        });
        this.parseFormat(string2);
        this.flags = n;
        this.bufferedImage = this.createBufferedImage(imageArray[0], component);
        if (this.bufferedImage == null && this.JAIInstalled()) {
            this.parseFormat(string2);
            this.bufferedImage = this.JAIgetImage(string, component);
        }
        if (this.bufferedImage == null) {
            System.err.println("Error loading Image " + string);
        }
        if ((n & 2) != 0) {
            this.byRef = true;
        }
        if ((n & 4) != 0) {
            this.yUp = true;
        }
    }

    private BufferedImage JAIgetImage(String string, Component component) {
        final String string2 = string;
        BufferedImage bufferedImage = null;
        try {
            Object t = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Object object = TextureLoader.this.jaiCreate.invoke(null, "fileload", string2);
                        TextureLoader.this.jaiGetRendering.invoke(object, new Object[0]);
                        return object;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return null;
                    }
                }
            });
            int n = (Integer)this.jaiGetWidth.invoke(t, new Object[0]);
            int n2 = (Integer)this.jaiGetHeight.invoke(t, new Object[0]);
            WritableRaster writableRaster = Raster.createInterleavedRaster(0, n, n2, n * 4, 4, bandOffset, null);
            bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
            Graphics graphics = bufferedImage.getGraphics();
            BufferedImage bufferedImage2 = (BufferedImage)this.jaiGetAsBufferedImage.invoke(t, new Object[0]);
            graphics.drawImage(bufferedImage2, 0, 0, component);
        }
        catch (Exception exception) {
            return null;
        }
        return bufferedImage;
    }

    private BufferedImage JAIgetImage(URL uRL, Component component) {
        final URL uRL2 = uRL;
        BufferedImage bufferedImage = null;
        try {
            Object t = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Object object = TextureLoader.this.jaiCreate.invoke(null, "URL", uRL2);
                        TextureLoader.this.jaiGetRendering.invoke(object, new Object[0]);
                        return object;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return null;
                    }
                }
            });
            int n = (Integer)this.jaiGetWidth.invoke(t, new Object[0]);
            int n2 = (Integer)this.jaiGetHeight.invoke(t, new Object[0]);
            WritableRaster writableRaster = Raster.createInterleavedRaster(0, n, n2, n * 4, 4, bandOffset, null);
            bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
            Graphics graphics = bufferedImage.getGraphics();
            BufferedImage bufferedImage2 = (BufferedImage)this.jaiGetAsBufferedImage.invoke(t, new Object[0]);
            graphics.drawImage(bufferedImage2, 0, 0, component);
        }
        catch (Exception exception) {
            return null;
        }
        return bufferedImage;
    }

    private boolean JAIInstalled() {
        if (!this.doneJAICheck) {
            try {
                Class<?> clazz = Class.forName("javax.media.jai.PlanarImage");
                this.jaiGetWidth = clazz.getDeclaredMethod("getWidth", new Class[0]);
                this.jaiGetHeight = clazz.getDeclaredMethod("getHeight", new Class[0]);
                this.jaiGetAsBufferedImage = clazz.getDeclaredMethod("getAsBufferedImage", new Class[0]);
                Class<?> clazz2 = Class.forName("javax.media.jai.JAI");
                this.jaiCreate = clazz2.getDeclaredMethod("create", class$java$lang$String == null ? (class$java$lang$String = TextureLoader.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = TextureLoader.class$("java.lang.Object")) : class$java$lang$Object);
                Class<?> clazz3 = Class.forName("javax.media.jai.RenderedOp");
                this.jaiGetRendering = clazz3.getDeclaredMethod("getRendering", new Class[0]);
                this.jaiInstalled = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.jaiInstalled = false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
                this.jaiInstalled = false;
                System.exit(0);
            }
            this.doneJAICheck = true;
        }
        return this.jaiInstalled;
    }

    public TextureLoader(URL uRL, Component component) {
        this(uRL, new String("RGBA"), 0, component);
    }

    public TextureLoader(URL uRL, String string, Component component) {
        this(uRL, string, 0, component);
    }

    public TextureLoader(URL uRL, int n, Component component) {
        this(uRL, new String("RGBA"), n, component);
    }

    public TextureLoader(URL uRL, String string, int n, Component component) {
        if (component == null) {
            component = new Container();
        }
        final Toolkit toolkit = Toolkit.getDefaultToolkit();
        final Image[] imageArray = new Image[1];
        final URL uRL2 = uRL;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                imageArray[0] = toolkit.getImage(uRL2);
                return null;
            }
        });
        this.parseFormat(string);
        this.flags = n;
        this.bufferedImage = this.createBufferedImage(imageArray[0], component);
        if (this.bufferedImage == null && this.JAIInstalled()) {
            this.bufferedImage = this.JAIgetImage(uRL, component);
        }
        if (this.bufferedImage == null) {
            System.err.println("Error loading Image " + uRL.toString());
        }
        if ((n & 2) != 0) {
            this.byRef = true;
        }
        if ((n & 4) != 0) {
            this.yUp = true;
        }
    }

    public ImageComponent2D getImage() {
        if (this.imageComponent == null) {
            this.imageComponent = new ImageComponent2D(this.imageComponentFormat, this.bufferedImage, this.byRef, this.yUp);
        }
        return this.imageComponent;
    }

    public ImageComponent2D getScaledImage(float f, float f2) {
        if (f == 1.0f && f2 == 1.0f) {
            return this.getImage();
        }
        return new ImageComponent2D(this.imageComponentFormat, this.getScaledImage(this.bufferedImage, f, f2), this.byRef, this.yUp);
    }

    public ImageComponent2D getScaledImage(int n, int n2) {
        if (this.bufferedImage.getWidth() == n && this.bufferedImage.getHeight() == n2) {
            return this.getImage();
        }
        return new ImageComponent2D(this.imageComponentFormat, this.getScaledImage(this.bufferedImage, n, n2), this.byRef, this.yUp);
    }

    public Texture getTexture() {
        ImageComponent2D[] imageComponent2DArray = null;
        BufferedImage[] bufferedImageArray = null;
        if (this.tex == null) {
            if (this.bufferedImage == null) {
                return null;
            }
            int n = this.getClosestPowerOf2(this.bufferedImage.getWidth());
            int n2 = this.getClosestPowerOf2(this.bufferedImage.getHeight());
            if ((this.flags & 1) != 0) {
                BufferedImage bufferedImage = this.bufferedImage;
                int n3 = n;
                int n4 = n2;
                int n5 = Math.max(this.computeLog(n), this.computeLog(n2)) + 1;
                imageComponent2DArray = new ImageComponent2D[n5];
                bufferedImageArray = new BufferedImage[n5];
                this.tex = new Texture2D(2, this.textureFormat, n, n2);
                int n6 = 0;
                while (n6 < n5) {
                    bufferedImageArray[n6] = this.getScaledImage(bufferedImage, n3, n4);
                    imageComponent2DArray[n6] = new ImageComponent2D(this.imageComponentFormat, bufferedImageArray[n6], this.byRef, this.yUp);
                    this.tex.setImage(n6, (ImageComponent)imageComponent2DArray[n6]);
                    if (n3 > 1) {
                        n3 >>= 1;
                    }
                    if (n4 > 1) {
                        n4 >>= 1;
                    }
                    bufferedImage = bufferedImageArray[n6];
                    ++n6;
                }
            } else {
                imageComponent2DArray = new ImageComponent2D[1];
                bufferedImageArray = new BufferedImage[]{this.getScaledImage(this.bufferedImage, n, n2)};
                imageComponent2DArray[0] = new ImageComponent2D(this.imageComponentFormat, bufferedImageArray[0], this.byRef, this.yUp);
                this.tex = new Texture2D(1, this.textureFormat, n, n2);
                this.tex.setImage(0, (ImageComponent)imageComponent2DArray[0]);
            }
            this.tex.setMinFilter(3);
            this.tex.setMagFilter(3);
        }
        return this.tex;
    }

    private BufferedImage createBufferedImage(Image image, Component component) {
        component.prepareImage(image, null);
        while (true) {
            int n;
            if (((n = component.checkImage(image, null)) & 0x40) != 0) {
                return null;
            }
            if ((n & 0x20) != 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int n = image.getWidth(component);
        int n2 = image.getHeight(component);
        WritableRaster writableRaster = Raster.createInterleavedRaster(0, n, n2, n * 4, 4, bandOffset, null);
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, component);
        return bufferedImage;
    }

    private void parseFormat(String string) {
        if (string.equals("RGBA")) {
            this.imageComponentFormat = 2;
            this.textureFormat = 6;
        } else if (string.equals("RGBA4")) {
            this.imageComponentFormat = 6;
            this.textureFormat = 6;
        } else if (string.equals("RGB5_A1")) {
            this.imageComponentFormat = 4;
            this.textureFormat = 6;
        } else if (string.equals("RGB")) {
            this.imageComponentFormat = 1;
            this.textureFormat = 5;
        } else if (string.equals("RGB4")) {
            this.imageComponentFormat = 5;
            this.textureFormat = 5;
        } else if (string.equals("RGB5")) {
            this.imageComponentFormat = 3;
            this.textureFormat = 5;
        } else if (string.equals("R3_G3_B2")) {
            this.imageComponentFormat = 9;
            this.textureFormat = 5;
        } else if (string.equals("LUM8_ALPHA8")) {
            this.imageComponentFormat = 8;
            this.textureFormat = 4;
        } else if (string.equals("LUM4_ALPHA4")) {
            this.imageComponentFormat = 7;
            this.textureFormat = 4;
        } else if (string.equals("LUMINANCE")) {
            this.imageComponentFormat = 10;
            this.textureFormat = 2;
        } else if (string.equals("ALPHA")) {
            this.imageComponentFormat = 10;
            this.textureFormat = 3;
        }
    }

    private BufferedImage getScaledImage(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        float f = (float)n / (float)n3;
        float f2 = (float)n2 / (float)n4;
        return this.getScaledImage(bufferedImage, f, f2);
    }

    private BufferedImage getScaledImage(BufferedImage bufferedImage, float f, float f2) {
        if (f == 1.0f && f2 == 1.0f) {
            return bufferedImage;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f, f2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        int n = (int)((double)((float)bufferedImage.getWidth() * f) + 0.5);
        int n2 = (int)((double)((float)bufferedImage.getHeight() * f2) + 0.5);
        WritableRaster writableRaster = Raster.createInterleavedRaster(0, n, n2, n * 4, 4, bandOffset, null);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, false, null);
        affineTransformOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    private int computeLog(int n) {
        int n2 = 0;
        if (n == 0) {
            return -1;
        }
        while (n != 1) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }

    private int getClosestPowerOf2(int n) {
        if (n < 1) {
            return n;
        }
        int n2 = 1;
        while (n >= (n2 *= 2)) {
        }
        int n3 = n2 / 2;
        if (n2 - n > n - n3) {
            return n3;
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

