/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import com.sun.j3d.utils.compression.CommandStream;
import com.sun.j3d.utils.compression.CompressionStreamColor;
import com.sun.j3d.utils.compression.CompressionStreamElement;
import com.sun.j3d.utils.compression.CompressionStreamNormal;
import com.sun.j3d.utils.compression.CompressionStreamVertex;
import com.sun.j3d.utils.compression.HuffmanTable;
import com.sun.j3d.utils.compression.MeshBuffer;
import com.sun.j3d.utils.geometry.GeometryInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;

public class CompressionStream {
    private static final boolean benchmark = false;
    private static final boolean noMeshNormalSubstitution = true;
    static final int RESTART = 1;
    static final int REPLACE_MIDDLE = 2;
    static final int REPLACE_OLDEST = 3;
    static final int MESH_PUSH = 1;
    static final int NO_MESH_PUSH = 0;
    int streamType;
    int vertexFormat;
    boolean vertexColor3;
    boolean vertexColor4;
    boolean vertexNormals;
    Point3d[] mcBounds = new Point3d[2];
    Point3d[] ncBounds = new Point3d[2];
    Point3i[] qcBounds = new Point3i[2];
    double[] center = new double[3];
    double positionRangeMaximum;
    double scale;
    int positionQuant;
    int colorQuant;
    int normalQuant;
    boolean positionQuantChanged;
    boolean colorQuantChanged;
    boolean normalQuantChanged;
    int[] lastPosition = new int[3];
    int[] lastColor = new int[4];
    int lastSextant;
    int lastOctant;
    int lastU;
    int lastV;
    boolean lastSpecialNormal;
    boolean firstPosition;
    boolean firstColor;
    boolean firstNormal;
    int byteCount = 0;
    int vertexCount = 0;
    int meshReferenceCount = 0;
    MeshBuffer meshBuffer = new MeshBuffer();
    private Collection stream;
    private boolean lastElementColor = false;
    private boolean lastLastElementColor = false;
    private boolean lastElementNormal = false;
    private boolean lastLastElementNormal = false;
    private Point3f p3f = new Point3f();
    private Color3f c3f = new Color3f();
    private Color4f c4f = new Color4f();
    private Vector3f n3f = new Vector3f();

    private CompressionStream() {
        this.stream = new LinkedList();
        this.mcBounds[0] = new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.mcBounds[1] = new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.qcBounds[0] = new Point3i(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.qcBounds[1] = new Point3i(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.ncBounds[0] = new Point3d();
        this.ncBounds[1] = new Point3d();
    }

    CompressionStream(int n, int n2) {
        this();
        this.setStreamType(n);
        this.setVertexFormat(n2);
    }

    private int getConnectionType(GeometryArray geometryArray) {
        if (geometryArray instanceof TriangleStripArray || geometryArray instanceof IndexedTriangleStripArray || geometryArray instanceof TriangleFanArray || geometryArray instanceof IndexedTriangleFanArray || geometryArray instanceof TriangleArray || geometryArray instanceof IndexedTriangleArray || geometryArray instanceof QuadArray || geometryArray instanceof IndexedQuadArray) {
            return 2;
        }
        if (geometryArray instanceof LineArray || geometryArray instanceof IndexedLineArray || geometryArray instanceof LineStripArray || geometryArray instanceof IndexedLineStripArray) {
            return 1;
        }
        return 0;
    }

    private void setStreamType(int n) {
        this.streamType = n;
    }

    private void setVertexFormat(int n) {
        this.vertexFormat = n;
        this.vertexNormals = false;
        this.vertexColor4 = false;
        this.vertexColor3 = false;
        if ((n & 2) == 2) {
            this.vertexNormals = true;
        }
        if ((n & 4) == 4) {
            if ((n & 0xC) == 12) {
                this.vertexColor4 = true;
            } else {
                this.vertexColor3 = true;
            }
        }
    }

    void quantize(HuffmanTable huffmanTable) {
        this.positionQuant = 16;
        this.colorQuant = 9;
        this.normalQuant = 6;
        this.center[0] = (this.mcBounds[1].x + this.mcBounds[0].x) / 2.0;
        this.center[1] = (this.mcBounds[1].y + this.mcBounds[0].y) / 2.0;
        this.center[2] = (this.mcBounds[1].z + this.mcBounds[0].z) / 2.0;
        double d = this.mcBounds[1].x - this.mcBounds[0].x;
        double d2 = this.mcBounds[1].y - this.mcBounds[0].y;
        double d3 = this.mcBounds[1].z - this.mcBounds[0].z;
        this.positionRangeMaximum = d > d2 ? d : d2;
        if (d3 > this.positionRangeMaximum) {
            this.positionRangeMaximum = d3;
        }
        this.scale = 2.0 / this.positionRangeMaximum * 0.999969482421875;
        this.normalQuantChanged = true;
        this.colorQuantChanged = true;
        this.positionQuantChanged = true;
        this.firstNormal = true;
        this.firstColor = true;
        this.firstPosition = true;
        Iterator iterator = this.stream.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CompressionStreamElement)) continue;
            ((CompressionStreamElement)e).quantize(this, huffmanTable);
            this.lastLastElementColor = this.lastElementColor;
            this.lastLastElementNormal = this.lastElementNormal;
            this.lastElementNormal = false;
            this.lastElementColor = false;
            if (e instanceof CompressionStreamColor) {
                this.lastElementColor = true;
                continue;
            }
            if (!(e instanceof CompressionStreamNormal)) continue;
            this.lastElementNormal = true;
        }
        this.ncBounds[0].x = (double)this.qcBounds[0].x / 32768.0;
        this.ncBounds[0].y = (double)this.qcBounds[0].y / 32768.0;
        this.ncBounds[0].z = (double)this.qcBounds[0].z / 32768.0;
        this.ncBounds[1].x = (double)this.qcBounds[1].x / 32768.0;
        this.ncBounds[1].y = (double)this.qcBounds[1].y / 32768.0;
        this.ncBounds[1].z = (double)this.qcBounds[1].z / 32768.0;
    }

    void outputCommands(HuffmanTable huffmanTable, CommandStream commandStream) {
        int n = this.vertexNormals ? 1 : 0;
        int n2 = this.vertexColor3 || this.vertexColor4 ? 1 : 0;
        int n3 = this.vertexColor4 ? 1 : 0;
        int n4 = 0x18 | n;
        long l = n2 << 2 | n3 << 1;
        commandStream.addCommand(n4, 8, l, 3);
        huffmanTable.outputCommands(commandStream);
        Iterator iterator = this.stream.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CompressionStreamElement)) continue;
            ((CompressionStreamElement)e).outputCommand(huffmanTable, commandStream);
        }
        commandStream.end();
    }

    int getByteCount() {
        return this.byteCount;
    }

    int getVertexCount() {
        return this.vertexCount;
    }

    int getMeshReferenceCount() {
        return this.meshReferenceCount;
    }

    void addVertex(Point3f point3f, int n) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, (Color3f)null, n, 0));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, int n) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, (Color3f)null, n, 0));
    }

    void addVertex(Point3f point3f, Color3f color3f, int n) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, color3f, n, 0));
    }

    void addVertex(Point3f point3f, Color4f color4f, int n) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, color4f, n, 0));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Color3f color3f, int n) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, color3f, n, 0));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Color4f color4f, int n) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, color4f, n, 0));
    }

    void addVertex(Point3f point3f, int n, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, (Color3f)null, n, n2));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, int n, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, (Color3f)null, n, n2));
    }

    void addVertex(Point3f point3f, Color3f color3f, int n, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, color3f, n, n2));
    }

    void addVertex(Point3f point3f, Color4f color4f, int n, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, color4f, n, n2));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Color3f color3f, int n, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, color3f, n, n2));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Color4f color4f, int n, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, color4f, n, n2));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Object object, int n, int n2) {
        if (this.vertexColor3) {
            this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, (Color3f)object, n, n2));
        } else {
            this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, (Color4f)object, n, n2));
        }
    }

    void addMeshReference(int n, int n2) {
        this.stream.add(new MeshReference(n, n2));
    }

    void addColor(Color3f color3f) {
        this.stream.add(new CompressionStreamColor(this, color3f));
    }

    void addColor(Color4f color4f) {
        this.stream.add(new CompressionStreamColor(this, color4f));
    }

    void addNormal(Vector3f vector3f) {
        this.stream.add(new CompressionStreamNormal(this, vector3f));
    }

    void addPositionQuantization(int n) {
        this.stream.add(new PositionQuant(n));
    }

    void addColorQuantization(int n) {
        this.stream.add(new ColorQuant(n));
    }

    void addNormalQuantization(int n) {
        this.stream.add(new NormalQuant(n));
    }

    void addGeometryArray(GeometryArray geometryArray) {
        int n;
        if (this.streamType != this.getConnectionType(geometryArray)) {
            throw new IllegalArgumentException("GeometryArray has an inconsistent dimensionality");
        }
        if (this.vertexFormat != geometryArray.getVertexFormat()) {
            throw new IllegalArgumentException("GeometryArray has an inconsistent vertex format");
        }
        int n2 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        boolean bl = false;
        if (geometryArray instanceof IndexedGeometryArray) {
            bl = true;
            IndexedGeometryArray indexedGeometryArray = (IndexedGeometryArray)geometryArray;
            n2 = indexedGeometryArray.getIndexCount();
            nArray3 = new int[n2];
            indexedGeometryArray.getCoordinateIndices(0, nArray3);
            if (this.vertexNormals) {
                nArray2 = new int[n2];
                indexedGeometryArray.getNormalIndices(0, nArray2);
            }
            if (this.vertexColor3 || this.vertexColor4) {
                nArray = new int[n2];
                indexedGeometryArray.getColorIndices(0, nArray);
            }
        }
        int n3 = 0;
        int[] nArray4 = null;
        int n4 = 1;
        int n5 = geometryArray.getVertexCount();
        if (geometryArray instanceof TriangleStripArray || geometryArray instanceof IndexedTriangleStripArray || geometryArray instanceof LineStripArray || geometryArray instanceof IndexedLineStripArray) {
            n4 = 3;
        } else if (geometryArray instanceof TriangleFanArray || geometryArray instanceof IndexedTriangleFanArray) {
            n4 = 2;
        }
        if (n4 == 1) {
            int n6;
            if (geometryArray instanceof QuadArray || geometryArray instanceof IndexedQuadArray) {
                n6 = 4;
                n4 = 2;
            } else {
                n6 = geometryArray instanceof TriangleArray || geometryArray instanceof IndexedTriangleArray ? 3 : (geometryArray instanceof LineArray || geometryArray instanceof IndexedLineArray ? 2 : 1);
            }
            n3 = bl ? n2 / n6 : n5 / n6;
            nArray4 = new int[n3];
            Arrays.fill(nArray4, n6);
        } else if (bl) {
            IndexedGeometryStripArray indexedGeometryStripArray = (IndexedGeometryStripArray)geometryArray;
            n3 = indexedGeometryStripArray.getNumStrips();
            nArray4 = new int[n3];
            indexedGeometryStripArray.getStripIndexCounts(nArray4);
        } else {
            GeometryStripArray geometryStripArray = (GeometryStripArray)geometryArray;
            n3 = geometryStripArray.getNumStrips();
            nArray4 = new int[n3];
            geometryStripArray.getStripVertexCounts(nArray4);
        }
        Vector3f[] vector3fArray = null;
        Color3f[] color3fArray = null;
        Color4f[] color4fArray = null;
        Point3f[] point3fArray = new Point3f[n5];
        int n7 = 0;
        while (n7 < n5) {
            point3fArray[n7] = new Point3f();
            ++n7;
        }
        geometryArray.getCoordinates(0, point3fArray);
        if (this.vertexNormals) {
            vector3fArray = new Vector3f[n5];
            n = 0;
            while (n < n5) {
                vector3fArray[n] = new Vector3f();
                ++n;
            }
            geometryArray.getNormals(0, vector3fArray);
        }
        if (this.vertexColor3) {
            color3fArray = new Color3f[n5];
            n = 0;
            while (n < n5) {
                color3fArray[n] = new Color3f();
                ++n;
            }
            geometryArray.getColors(0, color3fArray);
        } else if (this.vertexColor4) {
            color4fArray = new Color4f[n5];
            n = 0;
            while (n < n5) {
                color4fArray[n] = new Color4f();
                ++n;
            }
            geometryArray.getColors(0, color4fArray);
        }
        n = 0;
        if (bl) {
            int n8 = 0;
            while (n8 < n3) {
                int n9 = 1;
                int n10 = 0;
                while (n10 < nArray4[n8]) {
                    int n11 = nArray3[n];
                    int n12 = this.meshBuffer.getMeshReference(n11);
                    if (n12 == -1 || this.vertexNormals && nArray2[n] != this.meshBuffer.getNormalIndex(n12)) {
                        Vector3f vector3f;
                        int n13 = this.vertexNormals ? nArray2[n] : -1;
                        int n14 = this.vertexColor3 || this.vertexColor4 ? nArray[n] : -1;
                        Point3f point3f = point3fArray[n11];
                        Vector3f vector3f2 = vector3f = this.vertexNormals ? vector3fArray[n13] : null;
                        Color3f color3f = this.vertexColor3 ? color3fArray[n14] : (this.vertexColor4 ? color4fArray[n14] : null);
                        this.addVertex(point3f, vector3f, (Object)color3f, n9, 1);
                        this.meshBuffer.push(n11, n14, n13);
                    } else {
                        if (this.vertexNormals) {
                            // empty if block
                        }
                        if (this.vertexColor3 && nArray[n] != this.meshBuffer.getColorIndex(n12)) {
                            this.addColor(color3fArray[nArray[n]]);
                        } else if (this.vertexColor4 && nArray[n] != this.meshBuffer.getColorIndex(n12)) {
                            this.addColor(color4fArray[nArray[n]]);
                        }
                        this.addMeshReference(n9, n12);
                    }
                    n9 = n4;
                    ++n;
                    ++n10;
                }
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < n3) {
                int n16 = 1;
                int n17 = 0;
                while (n17 < nArray4[n15]) {
                    Point3f point3f = point3fArray[n];
                    int n18 = this.meshBuffer.getMeshReference(point3f);
                    if (n18 == -1 || this.vertexNormals && !vector3fArray[n].equals((Tuple3f)this.meshBuffer.getNormal(n18))) {
                        Vector3f vector3f;
                        Vector3f vector3f3 = vector3f = this.vertexNormals ? vector3fArray[n] : null;
                        Color3f color3f = this.vertexColor3 ? color3fArray[n] : (this.vertexColor4 ? color4fArray[n] : null);
                        this.addVertex(point3f, vector3f, (Object)color3f, n16, 1);
                        this.meshBuffer.push(point3f, (Object)color3f, vector3f);
                    } else {
                        if (this.vertexNormals) {
                            // empty if block
                        }
                        if (this.vertexColor3 && !color3fArray[n].equals((Tuple3f)this.meshBuffer.getColor3(n18))) {
                            this.addColor(color3fArray[n]);
                        } else if (this.vertexColor4 && !color4fArray[n].equals((Tuple4f)this.meshBuffer.getColor4(n18))) {
                            this.addColor(color4fArray[n]);
                        }
                        this.addMeshReference(n16, n18);
                    }
                    n16 = n4;
                    ++n;
                    ++n17;
                }
                ++n15;
            }
        }
    }

    void print() {
        System.out.println("\nstream has " + this.stream.size() + " entries");
        System.out.println("uncompressed size " + this.byteCount + " bytes");
        System.out.println("upper position bound: " + this.mcBounds[1].toString());
        System.out.println("lower position bound: " + this.mcBounds[0].toString());
        System.out.println("X, Y, Z centers (" + (float)this.center[0] + " " + (float)this.center[1] + " " + (float)this.center[2] + ")\n" + "scale " + (float)this.scale + "\n");
        Iterator iterator = this.stream.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next().toString() + "\n");
        }
    }

    public CompressionStream(int n, int n2, int n3, Shape3D[] shape3DArray) {
        this();
        if (shape3DArray == null || shape3DArray[0] == null) {
            throw new IllegalArgumentException("null Shape3D");
        }
        long l = 0L;
        Geometry geometry = shape3DArray[0].getGeometry();
        if (!(geometry instanceof GeometryArray)) {
            throw new IllegalArgumentException("Shape3D at index 0 is not a GeometryArray");
        }
        GeometryArray geometryArray = (GeometryArray)geometry;
        int n4 = geometryArray.getVertexFormat();
        int n5 = this.getConnectionType(geometryArray);
        this.setStreamType(n5);
        this.setVertexFormat(n4);
        this.addPositionQuantization(n);
        this.addColorQuantization(n2);
        this.addNormalQuantization(n3);
        int n6 = 0;
        while (n6 < shape3DArray.length) {
            Material material;
            geometry = shape3DArray[n6].getGeometry();
            if (!(geometry instanceof GeometryArray)) {
                throw new IllegalArgumentException("Shape3D at index " + n6 + " is not a GeometryArray");
            }
            Appearance appearance = shape3DArray[n6].getAppearance();
            if (appearance != null && (material = appearance.getMaterial()) != null) {
                material.getDiffuseColor(this.c3f);
                if (this.vertexColor4) {
                    this.c4f.set(this.c3f.x, this.c3f.y, this.c3f.z, 1.0f);
                    this.addColor(this.c4f);
                } else {
                    this.addColor(this.c3f);
                }
            }
            this.addGeometryArray((GeometryArray)geometry);
            ++n6;
        }
    }

    public CompressionStream(Shape3D[] shape3DArray) {
        this(16, 9, 6, shape3DArray);
    }

    public CompressionStream(int n, int n2, int n3, GeometryInfo[] geometryInfoArray) {
        this();
        if (geometryInfoArray == null || geometryInfoArray[0] == null) {
            throw new IllegalArgumentException("null GeometryInfo");
        }
        GeometryArray geometryArray = geometryInfoArray[0].getGeometryArray();
        int n4 = geometryArray.getVertexFormat();
        int n5 = this.getConnectionType(geometryArray);
        this.setStreamType(n5);
        this.setVertexFormat(n4);
        this.addPositionQuantization(n);
        this.addColorQuantization(n2);
        this.addNormalQuantization(n3);
        int n6 = 0;
        while (n6 < geometryInfoArray.length) {
            this.addGeometryArray(geometryInfoArray[n6].getGeometryArray());
            ++n6;
        }
    }

    public CompressionStream(GeometryInfo[] geometryInfoArray) {
        this(16, 9, 6, geometryInfoArray);
    }

    class MeshReference
    extends CompressionStreamElement {
        int stripFlag;
        int meshIndex;

        MeshReference(int n, int n2) {
            this.stripFlag = n;
            this.meshIndex = n2;
            ++CompressionStream.this.meshReferenceCount;
        }

        void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
            CompressionStreamVertex compressionStreamVertex = CompressionStream.this.meshBuffer.getVertex(this.meshIndex);
            CompressionStream.this.lastPosition[0] = compressionStreamVertex.xAbsolute;
            CompressionStream.this.lastPosition[1] = compressionStreamVertex.yAbsolute;
            CompressionStream.this.lastPosition[2] = compressionStreamVertex.zAbsolute;
            if (!(compressionStreamVertex.color == null || CompressionStream.this.lastElementColor || CompressionStream.this.lastElementNormal && CompressionStream.this.lastLastElementColor)) {
                CompressionStream.this.lastColor[0] = compressionStreamVertex.color.rAbsolute;
                CompressionStream.this.lastColor[1] = compressionStreamVertex.color.gAbsolute;
                CompressionStream.this.lastColor[2] = compressionStreamVertex.color.bAbsolute;
                CompressionStream.this.lastColor[3] = compressionStreamVertex.color.aAbsolute;
            }
            if (!(compressionStreamVertex.normal == null || CompressionStream.this.lastElementNormal || CompressionStream.this.lastElementColor && CompressionStream.this.lastLastElementNormal)) {
                CompressionStream.this.lastSextant = compressionStreamVertex.normal.sextant;
                CompressionStream.this.lastOctant = compressionStreamVertex.normal.octant;
                CompressionStream.this.lastU = compressionStreamVertex.normal.uAbsolute;
                CompressionStream.this.lastV = compressionStreamVertex.normal.vAbsolute;
                CompressionStream.this.lastSpecialNormal = compressionStreamVertex.normal.specialNormal;
            }
        }

        void outputCommand(HuffmanTable huffmanTable, CommandStream commandStream) {
            int n = 32;
            long l = this.stripFlag & 1;
            commandStream.addCommand(n |= (this.meshIndex & 0xF) << 1 | this.stripFlag >> 1, 8, l, 1);
        }

        public String toString() {
            return "meshReference: stripFlag " + this.stripFlag + " meshIndex " + this.meshIndex;
        }
    }

    class ColorQuant
    extends CompressionStreamElement {
        int value;

        ColorQuant(int n) {
            this.value = n;
        }

        void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
            CompressionStream.this.colorQuant = this.value;
            CompressionStream.this.colorQuantChanged = true;
        }

        public String toString() {
            return "colorQuant: " + this.value;
        }
    }

    class NormalQuant
    extends CompressionStreamElement {
        int value;

        NormalQuant(int n) {
            this.value = n;
        }

        void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
            CompressionStream.this.normalQuant = this.value;
            CompressionStream.this.normalQuantChanged = true;
        }

        public String toString() {
            return "normalQuant: " + this.value;
        }
    }

    class PositionQuant
    extends CompressionStreamElement {
        int value;

        PositionQuant(int n) {
            this.value = n;
        }

        void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
            CompressionStream.this.positionQuant = this.value;
            CompressionStream.this.positionQuantChanged = true;
            CompressionStream.this.scale = 2.0 / CompressionStream.this.positionRangeMaximum * ((double)((1 << this.value - 1) - 1) / (double)(1 << this.value - 1));
        }

        public String toString() {
            return "positionQuant: " + this.value;
        }
    }
}

