/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.vp;

import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedFrames;

public abstract class ViewPlatformAWTBehavior
extends ViewPlatformBehavior
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final boolean DEBUG = false;
    protected static final int POST_ID = 9998;
    protected WakeupOnElapsedFrames frameWakeup;
    protected WakeupOnBehaviorPost postWakeup;
    protected Transform3D targetTransform;
    protected boolean motion = false;
    public static final int MOUSE_LISTENER = 1;
    public static final int MOUSE_MOTION_LISTENER = 2;
    public static final int KEY_LISTENER = 4;
    private ArrayList eventQueue;
    private int listenerFlags;
    private Canvas3D canvas;

    public ViewPlatformAWTBehavior(Canvas3D canvas3D, int n) {
        this.listenerFlags = n;
        this.canvas = canvas3D;
        if (canvas3D == null) {
            throw new NullPointerException();
        }
    }

    public void initialize() {
        this.eventQueue = new ArrayList();
        this.frameWakeup = new WakeupOnElapsedFrames(0);
        this.postWakeup = new WakeupOnBehaviorPost((Behavior)this, 9998);
        this.wakeupOn((WakeupCondition)this.postWakeup);
    }

    public void processStimulus(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            WakeupCondition wakeupCondition = (WakeupCondition)enumeration.nextElement();
            if (wakeupCondition instanceof WakeupOnBehaviorPost) {
                this.motion = true;
                continue;
            }
            if (!(wakeupCondition instanceof WakeupOnElapsedFrames)) continue;
            AWTEvent[] aWTEventArray = null;
            ArrayList arrayList = this.eventQueue;
            synchronized (arrayList) {
                aWTEventArray = this.eventQueue.toArray(new AWTEvent[this.eventQueue.size()]);
                this.eventQueue.clear();
            }
            this.processAWTEvents(aWTEventArray);
            if (!this.motion) continue;
            this.integrateTransforms();
        }
        if (this.motion) {
            this.wakeupOn((WakeupCondition)this.frameWakeup);
        } else {
            this.wakeupOn((WakeupCondition)this.postWakeup);
        }
    }

    public void setEnable(boolean bl) {
        if (bl == this.getEnable()) {
            return;
        }
        super.setEnable(bl);
        this.enableListeners(bl);
    }

    private void enableListeners(boolean bl) {
        if (bl) {
            if ((this.listenerFlags & 1) != 0) {
                this.canvas.addMouseListener(this);
            }
            if ((this.listenerFlags & 2) != 0) {
                this.canvas.addMouseMotionListener(this);
            }
            if ((this.listenerFlags & 4) != 0) {
                this.canvas.addKeyListener(this);
            }
        } else {
            if ((this.listenerFlags & 1) != 0) {
                this.canvas.removeMouseListener(this);
            }
            if ((this.listenerFlags & 2) != 0) {
                this.canvas.removeMouseMotionListener(this);
            }
            if ((this.listenerFlags & 4) != 0) {
                this.canvas.removeKeyListener(this);
            }
        }
    }

    public void setViewingPlatform(ViewingPlatform viewingPlatform) {
        super.setViewingPlatform(viewingPlatform);
        if (viewingPlatform == null) {
            this.enableListeners(false);
        } else {
            this.enableListeners(true);
        }
    }

    protected abstract void processAWTEvents(AWTEvent[] var1);

    protected abstract void integrateTransforms();

    protected void queueAWTEvent(AWTEvent aWTEvent) {
        ArrayList arrayList = this.eventQueue;
        synchronized (arrayList) {
            this.eventQueue.add(aWTEvent);
            if (this.eventQueue.size() == 1) {
                this.postId(9998);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.queueAWTEvent(keyEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.queueAWTEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.queueAWTEvent(keyEvent);
    }
}

