/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.objectfile;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

class ObjectFileParser
extends StreamTokenizer {
    private static final char BACKSLASH = '\\';

    void setup() {
        this.resetSyntax();
        this.eolIsSignificant(true);
        this.lowerCaseMode(true);
        this.wordChars(33, 126);
        this.commentChar(33);
        this.whitespaceChars(32, 32);
        this.whitespaceChars(10, 10);
        this.whitespaceChars(13, 13);
        this.whitespaceChars(9, 9);
        this.ordinaryChar(35);
        this.ordinaryChar(47);
        this.ordinaryChar(92);
    }

    boolean getToken() {
        boolean bl = false;
        try {
            do {
                int n;
                if ((n = this.nextToken()) == 92) {
                    n = this.nextToken();
                    if (this.ttype == 10) continue;
                    bl = true;
                    continue;
                }
                bl = true;
            } while (!bl);
        }
        catch (IOException iOException) {
            System.err.println("IO error on line " + this.lineno() + ": " + iOException.getMessage());
            return false;
        }
        return true;
    }

    void printToken() {
        switch (this.ttype) {
            case 10: {
                System.out.println("Token EOL");
                break;
            }
            case -1: {
                System.out.println("Token EOF");
                break;
            }
            case -3: {
                System.out.println("Token TT_WORD: " + this.sval);
                break;
            }
            case 47: {
                System.out.println("Token /");
                break;
            }
            case 92: {
                System.out.println("Token \\");
                break;
            }
            case 35: {
                System.out.println("Token #");
            }
        }
    }

    boolean skipToNextLine() {
        boolean bl = false;
        while (this.ttype != 10) {
            if (this.getToken()) continue;
            return false;
        }
        return true;
    }

    boolean getNumber() {
        try {
            if (this.getToken()) {
                if (this.ttype != -3) {
                    throw new IOException("Expected number on line " + this.lineno());
                }
            } else {
                return false;
            }
            this.nval = Double.valueOf(this.sval);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(numberFormatException.getMessage());
            return false;
        }
        return true;
    }

    ObjectFileParser(Reader reader) {
        super(reader);
        this.setup();
    }
}

