/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines;

public class AuralParameters {
    public static final float SPEED_OF_SOUND = 0.344f;
    public static final int NO_FILTERING = -1;
    float rolloff = 1.0f;
    float reflectionCoefficient = 1.0f;
    float reverbDelay = 0.0f;
    int reverbOrder = 0;
    int filterType = -1;
    double[] filterDistance = new double[2];
    float[] filterCutoff = new float[2];
    float frequencyScaleFactor = 1.0f;
    float velocityScaleFactor = 1.0f;
    protected static final boolean debugFlag = false;
    protected static final boolean internalErrors = false;

    public void setRolloff(float f) {
        this.rolloff = f;
    }

    public float getRolloff() {
        return this.rolloff;
    }

    public void setReflectionCoefficient(float f) {
        this.reflectionCoefficient = f;
    }

    public float getReflectionCoefficient() {
        return this.reflectionCoefficient;
    }

    public void setReverbDelay(float f) {
        this.reverbDelay = f;
    }

    public float getReverbDelay() {
        return this.reverbDelay;
    }

    public void setReverbOrder(int n) {
        this.reverbOrder = n;
    }

    public int getReverbOrder() {
        return this.reverbOrder;
    }

    public void setDistanceFilter(int n, double[] dArray, float[] fArray) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        if (dArray == null || fArray == null) {
            bl = true;
        } else {
            n2 = dArray.length;
            if (n2 == 0 || n == -1) {
                bl = true;
            }
        }
        if (bl) {
            this.filterType = -1;
            this.filterDistance = null;
            this.filterCutoff = null;
            return;
        }
        this.filterType = n;
        if (this.filterDistance == null || fArray == null) {
            bl2 = true;
        } else if (n2 > this.filterDistance.length) {
            bl2 = true;
        }
        if (bl2) {
            this.filterDistance = new double[n2];
            this.filterCutoff = new float[n2];
        }
        System.arraycopy(dArray, 0, this.filterDistance, 0, n2);
        System.arraycopy(fArray, 0, this.filterCutoff, 0, n2);
    }

    public int getDistanceFilterLength() {
        if (this.filterDistance != null) {
            return this.filterDistance.length;
        }
        return 0;
    }

    public int getDistanceFilterType() {
        return this.filterType;
    }

    public void getDistanceFilter(double[] dArray, float[] fArray) {
        if (dArray == null || fArray == null) {
            return;
        }
        int n = dArray.length;
        if (n == 0 || this.filterDistance == null || fArray == null) {
            return;
        }
        if (n > this.filterDistance.length) {
            n = this.filterDistance.length;
        }
        System.arraycopy(this.filterDistance, 0, dArray, 0, n);
        System.arraycopy(this.filterCutoff, 0, fArray, 0, n);
    }

    public void setFrequencyScaleFactor(float f) {
        this.frequencyScaleFactor = f;
    }

    public float getFrequencyScaleFactor() {
        return this.frequencyScaleFactor;
    }

    public void setVelocityScaleFactor(float f) {
        this.velocityScaleFactor = f;
    }

    public float getVelocityScaleFactor() {
        return this.velocityScaleFactor;
    }

    protected void debugPrint(String string) {
    }
}

