/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import sun.awt.X11GraphicsDevice;

public class X11GraphicsConfig
extends GraphicsConfiguration {
    X11GraphicsDevice screen;
    int visual;
    ColorModel colorModel;
    long aData;

    public static X11GraphicsConfig getConfig(X11GraphicsDevice x11GraphicsDevice, int n) {
        return new X11GraphicsConfig(x11GraphicsDevice, n);
    }

    public static X11GraphicsConfig getConfig(X11GraphicsDevice x11GraphicsDevice, int n, int n2) {
        return new X11GraphicsConfig(x11GraphicsDevice, n);
    }

    private native int getNumColors();

    private native void init(int var1, int var2);

    private native ColorModel makeColorModel();

    private X11GraphicsConfig(X11GraphicsDevice x11GraphicsDevice, int n) {
        this.screen = x11GraphicsDevice;
        this.visual = n;
        this.init(n, this.screen.getScreen());
    }

    public GraphicsDevice getDevice() {
        return this.screen;
    }

    public int getVisual() {
        return this.visual;
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        ColorModel colorModel = this.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                return this.createCompatibleImage(n, n2);
            }
            case 2: 
            case 3: {
                ColorModel colorModel = this.getColorModel(n3);
                WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
                return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            }
        }
        throw new IllegalArgumentException("Unknown transparency type " + n3);
    }

    public synchronized ColorModel getColorModel() {
        if (this.colorModel == null) {
            this.colorModel = this.makeColorModel();
            if (this.colorModel == null) {
                this.colorModel = Toolkit.getDefaultToolkit().getColorModel();
            }
        }
        return this.colorModel;
    }

    public ColorModel getColorModel(int n) {
        if (n == 1) {
            return this.getColorModel();
        }
        if (n == 2) {
            return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
        }
        if (n == 3) {
            return ColorModel.getRGBdefault();
        }
        return null;
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public AffineTransform getNormalizingTransform() {
        double d = this.getXResolution(this.screen.getScreen()) / 72.0;
        double d2 = this.getYResolution(this.screen.getScreen()) / 72.0;
        return new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
    }

    private native double getXResolution(int var1);

    private native double getYResolution(int var1);

    public String toString() {
        return "X11GraphicsConfig[dev=" + this.screen + ",vis=0x" + Integer.toHexString(this.visual) + "]";
    }

    private static native void initIDs();

    public native Rectangle getBounds();

    static {
        X11GraphicsConfig.initIDs();
    }
}

