/*
 * Decompiled with CFR 0.152.
 */
package demos.Images;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.awt.image.RescaleOp;
import javax.swing.JComboBox;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageOps
extends ControlsSurface
implements ChangeListener {
    protected JSlider slider1;
    protected JSlider slider2;
    private static String[] imgName = new String[]{"bld.jpg", "boat.png"};
    private static BufferedImage[] img = new BufferedImage[imgName.length];
    private static String[] opsName = new String[]{"Threshold", "RescaleOp", "Invert", "Yellow Invert", "3x3 Blur", "3x3 Sharpen", "3x3 Edge", "5x5 Edge"};
    private static BufferedImageOp[] biop = new BufferedImageOp[opsName.length];
    private static int rescaleFactor = 128;
    private static float rescaleOffset = 0.0f;
    private static int low = 100;
    private static int high = 200;
    private int opsIndex;
    private int imgIndex;

    public ImageOps() {
        this.setBackground(Color.white);
        int n = 0;
        while (n < imgName.length) {
            Image image = this.getImage(imgName[n]);
            int n2 = image.getWidth(this);
            int n3 = image.getHeight(this);
            ImageOps.img[n] = new BufferedImage(n2, n3, 1);
            img[n].createGraphics().drawImage(image, 0, 0, null);
            ++n;
        }
        this.slider1 = new JSlider(1, 0, 255, low);
        this.slider1.setPreferredSize(new Dimension(15, 100));
        this.slider1.addChangeListener(this);
        this.slider2 = new JSlider(1, 0, 255, high);
        this.slider2.setPreferredSize(new Dimension(15, 100));
        this.slider2.addChangeListener(this);
        this.setControls(new Component[]{new DemoControls(this), this.slider1, this.slider2});
        this.setConstraints(new String[]{"North", "West", "East"});
    }

    public static void thresholdOp(int n, int n2) {
        byte[] byArray = new byte[256];
        int n3 = 0;
        while (n3 < 256) {
            byArray[n3] = n3 > n2 ? -1 : (n3 < n ? 0 : (int)n3);
            ++n3;
        }
        ImageOps.biop[0] = new LookupOp(new ByteLookupTable(0, byArray), null);
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        int n3 = img[this.imgIndex].getWidth(null);
        int n4 = img[this.imgIndex].getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 1);
        biop[this.opsIndex].filter(img[this.imgIndex], bufferedImage);
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.getImageType() <= 1) {
            this.setImageType(2);
        }
        if (changeEvent.getSource().equals(this.slider1)) {
            if (this.opsIndex == 0) {
                ImageOps.thresholdOp(this.slider1.getValue(), high);
            } else {
                rescaleFactor = this.slider1.getValue();
                ImageOps.biop[1] = new RescaleOp((float)rescaleFactor / 128.0f, rescaleOffset, null);
            }
        } else if (this.opsIndex == 0) {
            ImageOps.thresholdOp(low, this.slider2.getValue());
        } else {
            rescaleOffset = this.slider2.getValue();
            ImageOps.biop[1] = new RescaleOp((float)rescaleFactor / 128.0f, rescaleOffset, null);
        }
        this.repaint();
    }

    public static void main(String[] stringArray) {
        Surface.createDemoFrame(new ImageOps());
    }

    static {
        ImageOps.thresholdOp(low, high);
        int n = 1;
        ImageOps.biop[n++] = new RescaleOp(1.0f, 0.0f, null);
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        int n2 = 0;
        while (n2 < 256) {
            byArray[n2] = (byte)(256 - n2);
            byArray2[n2] = (byte)n2;
            ++n2;
        }
        ImageOps.biop[n++] = new LookupOp(new ByteLookupTable(0, byArray), null);
        byte[][] byArrayArray = new byte[][]{byArray, byArray, byArray2};
        ImageOps.biop[n++] = new LookupOp(new ByteLookupTable(0, byArrayArray), null);
        int[][] nArrayArray = new int[][]{{3, 3}, {3, 3}, {3, 3}, {5, 5}};
        float[][] fArrayArray = new float[][]{{0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f}, {-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f}, {0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f}, {-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 24.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f}};
        int n3 = 0;
        while (n3 < fArrayArray.length) {
            ImageOps.biop[n] = new ConvolveOp(new Kernel(nArrayArray[n3][0], nArrayArray[n3][1], fArrayArray[n3]));
            ++n3;
            ++n;
        }
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        ImageOps demo;
        JComboBox imgCombo;
        JComboBox opsCombo;
        Font font = new Font("serif", 0, 10);

        public DemoControls(ImageOps imageOps) {
            super(imageOps.name);
            this.demo = imageOps;
            this.setBackground(Color.gray);
            this.imgCombo = new JComboBox();
            this.add(this.imgCombo);
            this.imgCombo.setFont(this.font);
            int n = 0;
            while (n < imgName.length) {
                this.imgCombo.addItem(imgName[n]);
                ++n;
            }
            this.imgCombo.addActionListener(this);
            this.opsCombo = new JComboBox();
            this.add(this.opsCombo);
            this.opsCombo.setFont(this.font);
            int n2 = 0;
            while (n2 < opsName.length) {
                this.opsCombo.addItem(opsName[n2]);
                ++n2;
            }
            this.opsCombo.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(this.opsCombo)) {
                this.demo.opsIndex = this.opsCombo.getSelectedIndex();
                if (this.demo.opsIndex == 0) {
                    this.demo.slider1.setValue(low);
                    this.demo.slider2.setValue(high);
                    this.demo.slider1.setEnabled(true);
                    this.demo.slider2.setEnabled(true);
                } else if (this.demo.opsIndex == 1) {
                    this.demo.slider1.setValue(rescaleFactor);
                    this.demo.slider2.setValue((int)rescaleOffset);
                    this.demo.slider1.setEnabled(true);
                    this.demo.slider2.setEnabled(true);
                } else {
                    this.demo.slider1.setEnabled(false);
                    this.demo.slider2.setEnabled(false);
                }
            } else if (actionEvent.getSource().equals(this.imgCombo)) {
                this.demo.imgIndex = this.imgCombo.getSelectedIndex();
            }
            this.demo.repaint(10L);
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 32);
        }

        public void run() {
            try {
                Thread.sleep(1111L);
            }
            catch (Exception exception) {
                return;
            }
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                int n = 0;
                while (n < imgName.length) {
                    this.imgCombo.setSelectedIndex(n);
                    int n2 = 0;
                    while (n2 < opsName.length) {
                        this.opsCombo.setSelectedIndex(n2);
                        if (n2 <= 1) {
                            int n3 = 50;
                            while (n3 <= 200) {
                                this.demo.slider1.setValue(n3);
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (InterruptedException interruptedException) {
                                    return;
                                }
                                n3 += 10;
                            }
                        }
                        try {
                            Thread.sleep(4444L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            this.thread = null;
        }
    }
}

