/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.CompileState;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupOnTransformChange;

class TransformGroupRetained
extends GroupRetained {
    Transform3D transform = new Transform3D();
    Transform3D invTransform = null;
    Transform3D normalTransform = null;
    Transform3D currentTransform = new Transform3D();
    Transform3D[][] childLocalToVworld = null;
    int[][] childLocalToVworldIndex = null;
    Transform3D[][] childTrans = null;
    int[][] childTransIndex = null;
    Object[] targets = null;
    int targetThreads = 0;
    ArrayList transformChange = null;
    boolean[] isDirty = null;
    int boundingLeafTargetStartIndex = 0;
    ArrayList childTransformLinks = new ArrayList(1);
    TransformGroupRetained parentTransformGroup = null;
    boolean needNormalsTransform = false;
    ArrayList users = new ArrayList();
    ArrayList mergedChildTransforms = new ArrayList();
    HashKey currentKey = new HashKey();
    boolean aboveAViewPlatform = false;
    int maxTransformLevel = -1;
    int[] transformLevels = null;

    TransformGroupRetained() {
        this.nodeType = 24;
    }

    void setTransform(Transform3D transform3D) {
        J3dMessage j3dMessage = null;
        Transform3D transform3D2 = null;
        if (this.staticTransform != null) {
            transform3D2 = VirtualUniverse.mc.getTransform3D(this.staticTransform.transform);
            transform3D2.mul(transform3D);
            this.transform.setWithLock(transform3D2);
        } else {
            transform3D2 = VirtualUniverse.mc.getTransform3D(transform3D);
            this.transform.setWithLock(transform3D);
        }
        if (this.transformChange != null) {
            this.notifyConditions();
        }
        if (this.source.isLive()) {
            int n;
            if (this.aboveAViewPlatform && !transform3D.isCongruent()) {
                throw new BadTransformException(J3dI18N.getString("ViewPlatformRetained0"));
            }
            if (this.targets.length > this.boundingLeafTargetStartIndex) {
                n = this.boundingLeafTargetStartIndex;
                while (n < this.targets.length) {
                    this.targetThreads |= ((BoundingLeafRetained)this.targets[n]).transformTargetThreads;
                    ++n;
                }
            }
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 3;
            j3dMessage.threads = this.targetThreads;
            j3dMessage.args[0] = this.targets;
            j3dMessage.args[1] = this;
            j3dMessage.args[2] = transform3D2;
            if (this.boundingLeafTargetStartIndex < this.targets.length) {
                ArrayList arrayList = new ArrayList();
                n = this.boundingLeafTargetStartIndex;
                while (n < this.targets.length) {
                    ArrayList arrayList2;
                    ArrayList arrayList3 = arrayList2 = ((BoundingLeafRetained)this.targets[n]).users;
                    synchronized (arrayList3) {
                        int n2 = 0;
                        while (n2 < arrayList2.size()) {
                            arrayList.add(arrayList2.get(n2));
                            ++n2;
                        }
                    }
                    ++n;
                }
                j3dMessage.args[3] = arrayList;
            } else {
                j3dMessage.args[3] = null;
            }
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void getTransform(Transform3D transform3D) {
        this.transform.getWithLock(transform3D);
        if (this.staticTransform != null) {
            Transform3D transform3D2 = this.staticTransform.getInvTransform();
            transform3D.mul(transform3D2, transform3D);
        }
    }

    Transform3D getInvTransform() {
        if (this.invTransform == null) {
            this.invTransform = new Transform3D(this.transform);
            this.invTransform.invert();
        }
        return this.invTransform;
    }

    Transform3D getNormalTransform() {
        if (this.normalTransform == null) {
            this.normalTransform = new Transform3D(this.transform);
            this.normalTransform.invert();
            this.normalTransform.transpose();
        }
        return this.normalTransform;
    }

    void setLocalToVworld(SetLiveState setLiveState, Transform3D[][] transform3DArray, int[][] nArray) {
        Object object;
        int n;
        if (!this.inSharedGroup) {
            if (this.localToVworld == null) {
                this.localToVworld = new Transform3D[1][];
                this.localToVworldIndex = new int[1][];
                this.parentTransformGroups = new ArrayList[1];
                this.childLocalToVworld = new Transform3D[1][];
                this.childLocalToVworldIndex = new int[1][];
                this.transformLevels = new int[1];
                this.isDirty = new boolean[1];
            }
            this.localToVworld[0] = setLiveState.currentTransforms[0];
            this.localToVworldIndex[0] = setLiveState.currentTransformsIndex[0];
            this.parentTransformGroups[0] = (ArrayList)setLiveState.parentTransformGroups[0].clone();
            this.branchGroupPaths.add(setLiveState.branchGroupPaths.get(0));
            this.childLocalToVworld[0] = transform3DArray[0];
            this.childLocalToVworldIndex[0] = nArray[0];
            this.transformLevels[0] = setLiveState.transformLevels[0];
            this.setAuxData(setLiveState, 0, 0);
            return;
        }
        if (this.localToVworld == null) {
            this.localToVworld = new Transform3D[setLiveState.keys.length][];
            this.localToVworldIndex = new int[setLiveState.keys.length][];
            this.parentTransformGroups = new ArrayList[setLiveState.keys.length];
            this.localToVworldKeys = new HashKey[setLiveState.keys.length];
            this.childLocalToVworld = new Transform3D[setLiveState.keys.length][];
            this.childLocalToVworldIndex = new int[setLiveState.keys.length][];
            this.transformLevels = new int[setLiveState.keys.length];
            this.isDirty = new boolean[setLiveState.keys.length];
            n = 0;
        } else {
            n = this.localToVworld.length + setLiveState.keys.length;
            object = new Transform3D[n][];
            HashKey[] hashKeyArray = new HashKey[n];
            ArrayList[] arrayListArray = new ArrayList[n];
            int[][] nArrayArray = new int[n][];
            Transform3D[][] transform3DArrayArray = new Transform3D[n][];
            int[][] nArrayArray2 = new int[n][];
            int[] nArray2 = new int[n];
            boolean[] blArray = new boolean[n];
            n = this.localToVworld.length;
            System.arraycopy(this.localToVworld, 0, object, 0, this.localToVworld.length);
            System.arraycopy(this.localToVworldIndex, 0, nArrayArray, 0, this.localToVworldIndex.length);
            System.arraycopy(this.localToVworldKeys, 0, hashKeyArray, 0, this.localToVworldKeys.length);
            System.arraycopy(this.parentTransformGroups, 0, arrayListArray, 0, this.parentTransformGroups.length);
            System.arraycopy(this.childLocalToVworld, 0, transform3DArrayArray, 0, this.childLocalToVworld.length);
            System.arraycopy(this.childLocalToVworldIndex, 0, nArrayArray2, 0, this.childLocalToVworldIndex.length);
            System.arraycopy(this.transformLevels, 0, nArray2, 0, this.transformLevels.length);
            System.arraycopy(this.isDirty, 0, blArray, 0, this.isDirty.length);
            this.localToVworld = object;
            this.localToVworldIndex = nArrayArray;
            this.parentTransformGroups = arrayListArray;
            this.localToVworldKeys = hashKeyArray;
            this.childLocalToVworld = transform3DArrayArray;
            this.childLocalToVworldIndex = nArrayArray2;
            this.transformLevels = nArray2;
            this.isDirty = blArray;
        }
        object = new int[1];
        int n2 = n;
        int n3 = 0;
        while (n2 < this.localToVworld.length) {
            if (setLiveState.keys[n3].equals(this.localToVworldKeys, (int[])object, 0, n2)) {
                System.out.println("Found matching hashKey in setLocalToVworld.");
                System.out.println("We're in TROUBLE!!!");
            }
            if (object[0] == n2) {
                this.localToVworldKeys[n2] = setLiveState.keys[n3];
                this.localToVworld[n2] = setLiveState.currentTransforms[n3];
                this.localToVworldIndex[n2] = setLiveState.currentTransformsIndex[n3];
                this.parentTransformGroups[n2] = (ArrayList)setLiveState.parentTransformGroups[n3].clone();
                this.childLocalToVworld[n2] = transform3DArray[n3];
                this.childLocalToVworldIndex[n2] = nArray[n3];
                this.transformLevels[n2] = setLiveState.transformLevels[n3];
            } else {
                reference var8_7 = object[0] + true;
                int n4 = n2 - object[0];
                System.arraycopy(this.localToVworldKeys, (int)object[0], this.localToVworldKeys, (int)var8_7, n4);
                System.arraycopy(this.localToVworld, (int)object[0], this.localToVworld, (int)var8_7, n4);
                System.arraycopy(this.localToVworldIndex, (int)object[0], this.localToVworldIndex, (int)var8_7, n4);
                System.arraycopy(this.parentTransformGroups, (int)object[0], this.parentTransformGroups, (int)var8_7, n4);
                System.arraycopy(this.childLocalToVworld, (int)object[0], this.childLocalToVworld, (int)var8_7, n4);
                System.arraycopy(this.childLocalToVworldIndex, (int)object[0], this.childLocalToVworldIndex, (int)var8_7, n4);
                System.arraycopy(this.transformLevels, (int)object[0], this.transformLevels, (int)var8_7, n4);
                System.arraycopy(this.isDirty, (int)object[0], this.isDirty, (int)var8_7, n4);
                this.localToVworldKeys[object[0]] = setLiveState.keys[n3];
                this.localToVworld[object[0]] = setLiveState.currentTransforms[n3];
                this.localToVworldIndex[object[0]] = setLiveState.currentTransformsIndex[n3];
                this.parentTransformGroups[object[0]] = (ArrayList)setLiveState.parentTransformGroups[n3].clone();
                this.childLocalToVworld[object[0]] = transform3DArray[n3];
                this.childLocalToVworldIndex[object[0]] = nArray[n3];
                this.transformLevels[object[0]] = setLiveState.transformLevels[n3];
            }
            this.branchGroupPaths.add((int)object[0], setLiveState.branchGroupPaths.get(n3));
            this.setAuxData(setLiveState, n3, (int)object[0]);
            ++n2;
            ++n3;
        }
    }

    synchronized void removeCondition(WakeupOnTransformChange wakeupOnTransformChange) {
        this.transformChange.remove(this.transformChange.indexOf(wakeupOnTransformChange));
    }

    synchronized void addCondition(WakeupOnTransformChange wakeupOnTransformChange) {
        this.transformChange.add(wakeupOnTransformChange);
    }

    synchronized void notifyConditions() {
        int n = 0;
        while (n < this.transformChange.size()) {
            ((WakeupOnTransformChange)this.transformChange.get(n)).setTriggered();
            ++n;
        }
    }

    boolean isStatic() {
        return super.isStatic() && !this.source.getCapability(17) && !this.source.getCapability(18);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        this.transform.mul(transformGroupRetained.transform, this.transform);
    }

    void traverse(boolean bl, int n) {
        System.out.println();
        int n2 = 0;
        while (n2 < n) {
            System.out.print(".");
            ++n2;
        }
        System.out.print(this);
        if (this.isStatic()) {
            System.out.print(" (s)");
        } else {
            System.out.print(" (w)");
        }
        System.out.println();
        System.out.println(this.transform.toString());
        super.traverse(true, n);
    }

    void compile(CompileState compileState) {
        boolean bl = compileState.keepTG;
        compileState.keepTG = false;
        boolean bl2 = compileState.needNormalsTransform;
        compileState.needNormalsTransform = false;
        super.compile(compileState);
        if (compileState.keepTG) {
            this.mergeFlag = 0;
        }
        if (this.mergeFlag == 0) {
            this.parentTransformGroup = compileState.parentTransformGroup;
            compileState.parentTransformGroup = this;
            compileState.staticTransform = null;
            compileState.parentGroup = null;
            super.merge(compileState);
        } else {
            this.mergeFlag = 1;
        }
        compileState.parentTransformGroup = this.parentTransformGroup;
        compileState.keepTG = bl;
        this.needNormalsTransform = compileState.needNormalsTransform;
        compileState.needNormalsTransform = bl2;
    }

    void merge(CompileState compileState) {
        Transform3D transform3D;
        if (compileState.staticTransform != null) {
            this.staticTransform = compileState.staticTransform;
            this.mergeTransform(compileState.staticTransform);
        }
        if (this.mergeFlag == 1 && this.needNormalsTransform && !(transform3D = this.getNormalTransform()).isCongruent()) {
            this.mergeFlag = 0;
        }
        if (this.mergeFlag == 1) {
            TransformGroupRetained transformGroupRetained = compileState.staticTransform;
            compileState.staticTransform = this;
            super.merge(compileState);
            compileState.staticTransform = transformGroupRetained;
        } else {
            compileState.parentGroup.compiledChildrenList.add(this);
            this.parent = compileState.parentGroup;
        }
        this.mergeFlag = 2;
    }

    void setLive(SetLiveState setLiveState) {
        int n;
        int n2;
        Transform3D transform3D = null;
        ArrayList[] arrayListArray = null;
        ArrayList[] arrayListArray2 = null;
        ArrayList[] arrayListArray3 = null;
        ArrayList[] arrayListArray4 = null;
        int n3 = 0;
        int n4 = 0;
        arrayListArray3 = setLiveState.transformTargets;
        arrayListArray4 = setLiveState.transformBLTargets;
        n3 = setLiveState.transformTargetThreads;
        n4 = setLiveState.traverseFlags;
        if (arrayListArray3 == null) {
            arrayListArray = new ArrayList[1];
            arrayListArray2 = new ArrayList[1];
        } else {
            arrayListArray = new ArrayList[arrayListArray3.length];
            arrayListArray2 = new ArrayList[arrayListArray3.length];
        }
        int n5 = 0;
        while (n5 < arrayListArray.length) {
            arrayListArray[n5] = new ArrayList();
            arrayListArray2[n5] = new ArrayList();
            ++n5;
        }
        setLiveState.transformTargets = arrayListArray;
        setLiveState.transformBLTargets = arrayListArray2;
        setLiveState.transformTargetThreads = 0;
        setLiveState.traverseFlags = 0;
        this.inSharedGroup = setLiveState.inSharedGroup;
        transform3D = VirtualUniverse.mc.getTransform3D(null);
        this.transform.getWithLock(transform3D);
        this.currentTransform.set(transform3D);
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            this.childTrans = new Transform3D[setLiveState.currentTransforms.length][2];
            this.childTransIndex = new int[setLiveState.currentTransforms.length][2];
            n5 = 0;
            while (n5 < setLiveState.currentTransforms.length) {
                this.childTrans[n5][0] = new Transform3D();
                this.childTrans[n5][0].mul(setLiveState.currentTransforms[n5][setLiveState.currentTransformsIndex[n5][1]], transform3D);
                this.childTrans[n5][1] = new Transform3D(this.childTrans[n5][0]);
                this.childTransIndex[n5][0] = 0;
                this.childTransIndex[n5][1] = 0;
                ++n5;
            }
            if (!setLiveState.inSharedGroup) {
                setLiveState.transformLevels[0] = setLiveState.transformLevels[0] + 1;
                this.maxTransformLevel = setLiveState.transformLevels[0];
            } else {
                n5 = 0;
                while (n5 < setLiveState.keys.length) {
                    int n6 = n5;
                    setLiveState.transformLevels[n6] = setLiveState.transformLevels[n6] + 1;
                    if (setLiveState.transformLevels[n5] > this.maxTransformLevel) {
                        this.maxTransformLevel = setLiveState.transformLevels[n5];
                    }
                    ++n5;
                }
            }
            this.setLocalToVworld(setLiveState, this.childTrans, this.childTransIndex);
            n5 = 0;
            while (n5 < setLiveState.parentTransformGroups.length) {
                setLiveState.parentTransformGroups[n5].add(this);
                ++n5;
            }
        }
        ArrayList arrayList = setLiveState.childTransformLinks;
        GroupRetained groupRetained = setLiveState.parentTransformLink;
        Transform3D[][] transform3DArray = setLiveState.currentTransforms;
        int[][] nArray = setLiveState.currentTransformsIndex;
        setLiveState.childTransformLinks = this.childTransformLinks;
        setLiveState.parentTransformLink = this;
        setLiveState.currentTransforms = this.childTrans;
        setLiveState.currentTransformsIndex = this.childTransIndex;
        super.doSetLive(setLiveState);
        if (arrayList != null) {
            ArrayList arrayList2 = arrayList;
            synchronized (arrayList2) {
                if (!this.inSharedGroup || !arrayList.contains(this)) {
                    arrayList.add(this);
                }
            }
        }
        setLiveState.childTransformLinks = arrayList;
        this.parentTransformLink = setLiveState.parentTransformLink = groupRetained;
        if (!setLiveState.inSharedGroup) {
            setLiveState.transformLevels[0] = setLiveState.transformLevels[0] - 1;
        } else {
            n5 = 0;
            while (n5 < setLiveState.keys.length) {
                int n7 = n5++;
                setLiveState.transformLevels[n7] = setLiveState.transformLevels[n7] - 1;
            }
        }
        n5 = 0;
        while (n5 < setLiveState.parentTransformGroups.length) {
            ((AbstractCollection)setLiveState.parentTransformGroups[n5]).remove(this);
            ++n5;
        }
        setLiveState.currentTransforms = transform3DArray;
        setLiveState.currentTransformsIndex = nArray;
        this.targetThreads = setLiveState.transformTargetThreads | 0x2000 | 0x100 | 0x80;
        setLiveState.transformTargets = arrayListArray3;
        if (arrayListArray3 != null) {
            setLiveState.transformTargetThreads |= n3;
            n2 = 0;
            while (n2 < setLiveState.transformTargets.length) {
                n = arrayListArray[n2].size();
                n5 = 0;
                while (n5 < n) {
                    setLiveState.transformTargets[n2].add(arrayListArray[n2].get(n5));
                    ++n5;
                }
                ++n2;
            }
        }
        setLiveState.transformBLTargets = arrayListArray4;
        if (arrayListArray4 != null) {
            n2 = 0;
            while (n2 < setLiveState.transformBLTargets.length) {
                n = arrayListArray2[n2].size();
                n5 = 0;
                while (n5 < n) {
                    setLiveState.transformBLTargets[n2].add(arrayListArray2[n2].get(n5));
                    ++n5;
                }
                ++n2;
            }
        }
        n5 = 0;
        while (n5 < arrayListArray.length) {
            this.updateTargets(null, arrayListArray[n5], null, arrayListArray2[n5], this.targetThreads);
            ++n5;
        }
        if ((setLiveState.traverseFlags & 1) != 0) {
            this.aboveAViewPlatform = true;
        }
        setLiveState.traverseFlags |= n4;
        if (this.aboveAViewPlatform && !transform3D.isCongruent()) {
            throw new BadTransformException(J3dI18N.getString("ViewPlatformRetained0"));
        }
        super.markAsLive();
    }

    void clearLive(SetLiveState setLiveState) {
        Cloneable cloneable;
        ArrayList[] arrayListArray = setLiveState.transformTargets;
        ArrayList[] arrayListArray2 = setLiveState.transformBLTargets;
        if (setLiveState.transformTargets == null) {
            setLiveState.transformTargets = new ArrayList[1];
            setLiveState.transformBLTargets = new ArrayList[1];
            setLiveState.transformTargets[0] = new ArrayList(1);
            setLiveState.transformBLTargets[0] = new ArrayList(1);
        }
        super.clearLive(setLiveState);
        if (!this.inSharedGroup || this.localToVworldKeys == null) {
            if (this.parentTransformLink != null) {
                cloneable = this.parentTransformLink instanceof TransformGroupRetained ? ((TransformGroupRetained)this.parentTransformLink).childTransformLinks : ((SharedGroupRetained)this.parentTransformLink).childTransformLinks;
                ArrayList arrayList = cloneable;
                synchronized (arrayList) {
                    ((AbstractCollection)((Object)cloneable)).remove(this);
                }
            }
            cloneable = this.childTransformLinks;
            synchronized (cloneable) {
                this.childTransformLinks.clear();
            }
            this.parentTransformLink = null;
            this.aboveAViewPlatform = false;
        }
        this.updateTargets(setLiveState.nodeList, null, setLiveState.transformBLTargets[0], null, 0);
        this.updateTargets(setLiveState.transformTargets[0], null);
        cloneable = this;
        synchronized (cloneable) {
            if (this.inSharedGroup) {
                if (this.transformLevels != null) {
                    this.maxTransformLevel = this.transformLevels[0];
                    int n = 1;
                    while (n < this.transformLevels.length) {
                        if (this.transformLevels[n] > this.maxTransformLevel) {
                            this.maxTransformLevel = this.transformLevels[n];
                        }
                        ++n;
                    }
                } else {
                    this.maxTransformLevel = -1;
                }
            } else {
                this.maxTransformLevel = -1;
            }
        }
        if (arrayListArray == null) {
            setLiveState.transformTargets = null;
            setLiveState.transformBLTargets = null;
        }
    }

    void computeCombineBounds(Bounds bounds) {
        BoundingSphere boundingSphere = new BoundingSphere();
        boundingSphere.setRadius(-1.0);
        if (this.boundsAutoCompute) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    nodeRetained.computeCombineBounds(boundingSphere);
                }
                --n;
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                boundingSphere.set(this.localBounds);
            }
        }
        Transform3D transform3D = this.transform;
        synchronized (transform3D) {
            boundingSphere.transform(this.transform);
        }
        bounds.combine(boundingSphere);
    }

    final void updateTargets(ArrayList arrayList, ArrayList arrayList2) {
        this.updateTargets(arrayList, arrayList2, null, null, 0);
    }

    void updateTargets(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, int n) {
        int n2;
        Object object;
        int n3 = 0;
        if (this.targets == null) {
            int n4 = 0;
            if (arrayList2 != null) {
                n4 = arrayList2.size();
            }
            if (arrayList4 != null) {
                n4 += arrayList4.size();
            }
            Object[] objectArray = new Object[n4];
            if (arrayList2 != null) {
                int n5 = arrayList2.size();
                n3 = 0;
                while (n3 < n5) {
                    objectArray[n3] = arrayList2.get(n3);
                    ++n3;
                }
            }
            this.boundingLeafTargetStartIndex = n3;
            if (arrayList4 != null) {
                int n6 = 0;
                while (n6 < arrayList4.size()) {
                    objectArray[n3++] = arrayList4.get(n6);
                    ++n6;
                }
            }
            this.targets = objectArray;
            this.targetThreads = n;
            return;
        }
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        this.targetThreads |= n;
        if (arrayList != null) {
            n3 = 0;
            while (n3 < this.boundingLeafTargetStartIndex) {
                object = this.targets[n3];
                if (!arrayList.contains(object)) {
                    arrayList5.add(object);
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < this.boundingLeafTargetStartIndex) {
                arrayList5.add(this.targets[n3]);
                ++n3;
            }
        }
        if (arrayList2 != null) {
            n2 = arrayList2.size();
            n3 = 0;
            while (n3 < n2) {
                arrayList5.add(arrayList2.get(n3));
                ++n3;
            }
        }
        int n7 = arrayList5.size();
        if (arrayList3 != null) {
            n3 = this.boundingLeafTargetStartIndex;
            while (n3 < this.targets.length) {
                object = this.targets[n3];
                if (!arrayList3.contains(object)) {
                    arrayList5.add(object);
                }
                ++n3;
            }
        }
        if (arrayList4 != null) {
            n2 = arrayList4.size();
            n3 = 0;
            while (n3 < n2) {
                arrayList5.add(arrayList4.get(n3));
                ++n3;
            }
        }
        this.boundingLeafTargetStartIndex = n7;
        this.targets = arrayList5.toArray();
    }

    void processChildLocalToVworld(ArrayList arrayList, ArrayList arrayList2) {
        if (this.inSharedGroup) {
            if (this.localToVworldKeys != null) {
                int n = 0;
                while (n < this.localToVworldKeys.length) {
                    if (this.isDirty[n]) {
                        this.updateChildLocalToVworld(this.localToVworldKeys[n], n, arrayList, arrayList2);
                    }
                    ++n;
                }
            }
        } else if (this.isDirty[0]) {
            this.updateChildLocalToVworld(arrayList, arrayList2);
        }
    }

    void updateChildLocalToVworld(HashKey hashKey, int n, ArrayList arrayList, ArrayList arrayList2) {
        this.isDirty[n] = false;
        if (this.localToVworld != null) {
            arrayList.add(this);
            arrayList2.add(hashKey);
            TransformGroupRetained transformGroupRetained = this;
            synchronized (transformGroupRetained) {
                Transform3D transform3D = this.getCurrentLocalToVworld(n);
                Transform3D transform3D2 = this.getUpdateChildLocalToVworld(n);
                transform3D2.mul(transform3D, this.currentTransform);
            }
            ArrayList arrayList3 = this.childTransformLinks;
            synchronized (arrayList3) {
                int n2 = 0;
                while (n2 < this.childTransformLinks.size()) {
                    Object e = this.childTransformLinks.get(n2);
                    if (e instanceof TransformGroupRetained) {
                        TransformGroupRetained transformGroupRetained2 = (TransformGroupRetained)e;
                        transformGroupRetained2.updateChildLocalToVworld(transformGroupRetained2.localToVworldKeys[n], n, arrayList, arrayList2);
                    } else {
                        LinkRetained linkRetained = (LinkRetained)e;
                        if (linkRetained.sharedGroup.childTransformLinks.size() != 0) {
                            this.currentKey.set(this.localToVworldKeys[n]);
                            this.currentKey.append(LinkRetained.plus).append(linkRetained.nodeId);
                            if (linkRetained.sharedGroup.localToVworldKeys != null) {
                                int n3 = this.currentKey.equals(linkRetained.sharedGroup.localToVworldKeys, 0, linkRetained.sharedGroup.localToVworldKeys.length);
                                if (n3 < 0) {
                                    System.out.println("TransformGroupRetained : Can't find hashKey");
                                }
                                if (n3 < linkRetained.sharedGroup.localToVworldKeys.length) {
                                    linkRetained.sharedGroup.updateChildLocalToVworld(linkRetained.sharedGroup.localToVworldKeys[n3], n3, arrayList, arrayList2);
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    void updateChildLocalToVworld(ArrayList arrayList, ArrayList arrayList2) {
        this.isDirty[0] = false;
        if (this.localToVworld != null) {
            arrayList.add(this);
            TransformGroupRetained transformGroupRetained = this;
            synchronized (transformGroupRetained) {
                Transform3D transform3D = this.getCurrentLocalToVworld(0);
                Transform3D transform3D2 = this.getUpdateChildLocalToVworld(0);
                transform3D2.mul(transform3D, this.currentTransform);
            }
            ArrayList arrayList3 = this.childTransformLinks;
            synchronized (arrayList3) {
                int n = 0;
                while (n < this.childTransformLinks.size()) {
                    Object e = this.childTransformLinks.get(n);
                    if (e instanceof TransformGroupRetained) {
                        TransformGroupRetained transformGroupRetained2 = (TransformGroupRetained)e;
                        transformGroupRetained2.updateChildLocalToVworld(arrayList, arrayList2);
                    } else {
                        LinkRetained linkRetained = (LinkRetained)e;
                        if (linkRetained.sharedGroup.childTransformLinks.size() != 0) {
                            this.currentKey.reset();
                            this.currentKey.append(this.locale.nodeId);
                            this.currentKey.append(LinkRetained.plus).append(linkRetained.nodeId);
                            if (linkRetained.sharedGroup.localToVworldKeys != null) {
                                int n2 = this.currentKey.equals(linkRetained.sharedGroup.localToVworldKeys, 0, linkRetained.sharedGroup.localToVworldKeys.length);
                                if (n2 < 0) {
                                    System.out.println("TransformGroupRetained : Can't find hashKey");
                                }
                                if (n2 < linkRetained.sharedGroup.localToVworldKeys.length) {
                                    linkRetained.sharedGroup.updateChildLocalToVworld(linkRetained.sharedGroup.localToVworldKeys[n2], n2, arrayList, arrayList2);
                                }
                            }
                        }
                    }
                    ++n;
                }
            }
        }
    }

    void transformBounds(SceneGraphPath sceneGraphPath, Bounds bounds) {
        if (!((NodeRetained)sceneGraphPath.item.retained).inSharedGroup) {
            bounds.transform(this.getCurrentChildLocalToVworld());
        } else {
            HashKey hashKey = new HashKey("");
            sceneGraphPath.getHashKey(hashKey);
            bounds.transform(this.getCurrentChildLocalToVworld(hashKey));
        }
    }

    Transform3D getUpdateChildLocalToVworld(int n) {
        int n2 = this.childLocalToVworldIndex[n][1];
        if (n2 == this.childLocalToVworldIndex[n][0]) {
            this.childLocalToVworldIndex[n][1] = n2 ^= 1;
        }
        return this.childLocalToVworld[n][n2];
    }

    Transform3D getCurrentChildLocalToVworld() {
        return this.getCurrentChildLocalToVworld(0);
    }

    Transform3D getCurrentChildLocalToVworld(int n) {
        return this.childLocalToVworld[n][this.childLocalToVworldIndex[n][1]];
    }

    Transform3D getCurrentChildLocalToVworld(HashKey hashKey) {
        if (!this.inSharedGroup) {
            return this.childLocalToVworld[0][this.childLocalToVworldIndex[0][1]];
        }
        int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (n >= 0) {
            return this.childLocalToVworld[n][this.childLocalToVworldIndex[n][1]];
        }
        return new Transform3D();
    }

    Transform3D getLastChildLocalToVworld(HashKey hashKey) {
        if (!this.inSharedGroup) {
            return this.childLocalToVworld[0][this.childLocalToVworldIndex[0][0]];
        }
        int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (n >= 0) {
            return this.childLocalToVworld[n][this.childLocalToVworldIndex[n][0]];
        }
        return new Transform3D();
    }
}

