/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Hashtable;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.TextureRetained;
import javax.vecmath.Color4f;

public abstract class Texture
extends NodeComponent {
    public static final int ALLOW_ENABLE_READ = 0;
    public static final int ALLOW_ENABLE_WRITE = 1;
    public static final int ALLOW_BOUNDARY_MODE_READ = 2;
    public static final int ALLOW_FILTER_READ = 3;
    public static final int ALLOW_IMAGE_READ = 4;
    public static final int ALLOW_IMAGE_WRITE = 7;
    public static final int ALLOW_FORMAT_READ = 9;
    public static final int ALLOW_SIZE_READ = 8;
    public static final int ALLOW_MIPMAP_MODE_READ = 5;
    public static final int ALLOW_BOUNDARY_COLOR_READ = 6;
    public static final int FASTEST = 0;
    public static final int NICEST = 1;
    public static final int BASE_LEVEL_POINT = 2;
    public static final int BASE_LEVEL_LINEAR = 3;
    public static final int MULTI_LEVEL_POINT = 4;
    public static final int MULTI_LEVEL_LINEAR = 5;
    public static final int CLAMP = 2;
    public static final int WRAP = 3;
    public static final int BASE_LEVEL = 1;
    public static final int MULTI_LEVEL_MIPMAP = 2;
    public static final int INTENSITY = 1;
    public static final int LUMINANCE = 2;
    public static final int ALPHA = 3;
    public static final int LUMINANCE_ALPHA = 4;
    public static final int RGB = 5;
    public static final int RGBA = 6;

    public Texture() {
    }

    public Texture(int n, int n2, int n3, int n4) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture0"));
        }
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 5 && n2 != 6) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture1"));
        }
        int n5 = Texture.getPowerOf2(n3);
        if (n5 == -1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture2"));
        }
        int n6 = Texture.getPowerOf2(n4);
        if (n6 == -1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture3"));
        }
        ((TextureRetained)this.retained).initialize(n2, n3, n5, n4, n6, n);
    }

    public void setBoundaryModeS(int n) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initBoundaryModeS(n);
    }

    public int getBoundaryModeS() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture4"));
        }
        return ((TextureRetained)this.retained).getBoundaryModeS();
    }

    public void setBoundaryModeT(int n) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initBoundaryModeT(n);
    }

    public int getBoundaryModeT() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture4"));
        }
        return ((TextureRetained)this.retained).getBoundaryModeT();
    }

    public void setMinFilter(int n) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initMinFilter(n);
    }

    public int getMinFilter() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture6"));
        }
        return ((TextureRetained)this.retained).getMinFilter();
    }

    public void setMagFilter(int n) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initMagFilter(n);
    }

    public int getMagFilter() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture6"));
        }
        return ((TextureRetained)this.retained).getMagFilter();
    }

    public void setImage(int n, ImageComponent imageComponent) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture15"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setImage(n, imageComponent);
        } else {
            ((TextureRetained)this.retained).initImage(n, imageComponent);
        }
    }

    public ImageComponent getImage(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture9"));
        }
        return ((TextureRetained)this.retained).getImage(n);
    }

    public void setImages(ImageComponent[] imageComponentArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture15"));
        }
        if (imageComponentArray == null) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture20"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setImages(imageComponentArray);
        } else {
            ((TextureRetained)this.retained).initImages(imageComponentArray);
        }
    }

    public ImageComponent[] getImages() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture9"));
        }
        return ((TextureRetained)this.retained).getImages();
    }

    public int getFormat() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture19"));
        }
        return ((TextureRetained)this.retained).getFormat();
    }

    public int getWidth() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture16"));
        }
        return ((TextureRetained)this.retained).getWidth();
    }

    public int getHeight() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture17"));
        }
        return ((TextureRetained)this.retained).getHeight();
    }

    public int numMipMapLevels() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture18"));
        }
        return ((TextureRetained)this.retained).numMipMapLevels();
    }

    public void setMipMapMode(int n) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initMipMapMode(n);
    }

    public int getMipMapMode() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture10"));
        }
        return ((TextureRetained)this.retained).getMipMapMode();
    }

    public void setEnable(boolean bl) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture11"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setEnable(bl);
        } else {
            ((TextureRetained)this.retained).initEnable(bl);
        }
    }

    public boolean getEnable() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture12"));
        }
        return ((TextureRetained)this.retained).getEnable();
    }

    static int getPowerOf2(int n) {
        if (n < 1) {
            return -1;
        }
        int n2 = 0;
        int n3 = n;
        while (n2 < 32) {
            if ((n3 & Integer.MIN_VALUE) != 0) {
                if ((n3 & Integer.MAX_VALUE) == 0) {
                    return 31 - n2;
                }
                return -1;
            }
            n3 <<= 1;
            ++n2;
        }
        return -1;
    }

    public void setBoundaryColor(Color4f color4f) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initBoundaryColor(color4f);
    }

    public void setBoundaryColor(float f, float f2, float f3, float f4) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initBoundaryColor(f, f2, f3, f4);
    }

    public void getBoundaryColor(Color4f color4f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture13"));
        }
        ((TextureRetained)this.retained).getBoundaryColor(color4f);
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        Hashtable hashtable = nodeComponent.nodeHashtable;
        TextureRetained textureRetained = (TextureRetained)nodeComponent.retained;
        TextureRetained textureRetained2 = (TextureRetained)this.retained;
        textureRetained2.initBoundaryModeS(textureRetained.getBoundaryModeS());
        textureRetained2.initBoundaryModeT(textureRetained.getBoundaryModeT());
        textureRetained2.initMinFilter(textureRetained.getMinFilter());
        textureRetained2.initMagFilter(textureRetained.getMagFilter());
        textureRetained2.initMipMapMode(textureRetained.getMipMapMode());
        textureRetained2.initEnable(textureRetained.getEnable());
        Color4f color4f = new Color4f();
        textureRetained.getBoundaryColor(color4f);
        textureRetained2.initBoundaryColor(color4f);
        int n = textureRetained.numLevels - 1;
        while (n >= 0) {
            ImageComponent imageComponent = (ImageComponent)this.getNodeComponent(textureRetained.getImage(n), bl, hashtable);
            if (imageComponent != null) {
                textureRetained2.initImage(n, imageComponent);
            }
            --n;
        }
    }

    boolean duplicateChild() {
        if (this.getDuplicateOnCloneTree()) {
            return true;
        }
        int n = ((TextureRetained)this.retained).numLevels;
        TextureRetained textureRetained = (TextureRetained)this.retained;
        int n2 = 0;
        while (n2 < n) {
            ImageComponent imageComponent = textureRetained.getImage(n2);
            if (imageComponent != null && imageComponent.getDuplicateOnCloneTree()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

