/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AuralAttributesRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.ConeSoundRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.PointSoundRetained;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.SoundscapeRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;

class SoundStructure
extends J3dStructure {
    UnorderList sounds = new UnorderList(class$javax$media$j3d$SoundRetained == null ? (class$javax$media$j3d$SoundRetained = SoundStructure.class$("javax.media.j3d.SoundRetained")) : class$javax$media$j3d$SoundRetained);
    UnorderList soundscapes = new UnorderList(class$javax$media$j3d$SoundscapeRetained == null ? (class$javax$media$j3d$SoundscapeRetained = SoundStructure.class$("javax.media.j3d.SoundscapeRetained")) : class$javax$media$j3d$SoundscapeRetained);
    UnorderList viewPlatforms = new UnorderList(class$javax$media$j3d$ViewPlatformRetained == null ? (class$javax$media$j3d$ViewPlatformRetained = SoundStructure.class$("javax.media.j3d.ViewPlatformRetained")) : class$javax$media$j3d$ViewPlatformRetained);
    BoundingSphere tempSphere = new BoundingSphere();
    BoundingSphere vpsphere = new BoundingSphere();
    ArrayList objList = new ArrayList();
    ArrayList xformChangeList = new ArrayList();
    ArrayList switchChangeLeafNodes = new ArrayList();
    ArrayList switchChangeLeafMasks = new ArrayList();
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;
    static /* synthetic */ Class class$javax$media$j3d$SoundRetained;
    static /* synthetic */ Class class$javax$media$j3d$SoundscapeRetained;
    static /* synthetic */ Class class$javax$media$j3d$ViewPlatformRetained;

    SoundStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 512);
    }

    void processMessages(long l) {
        J3dMessage[] j3dMessageArray = this.getMessages(l);
        int n = this.getNumMessage();
        if (j3dMessageArray != null) {
            int n2 = 0;
            while (n2 < n) {
                switch (j3dMessageArray[n2].type) {
                    case 0: {
                        this.insertNodes((Object[])j3dMessageArray[n2].args[0]);
                        break;
                    }
                    case 1: {
                        this.removeNodes((Object[])j3dMessageArray[n2].args[0]);
                        break;
                    }
                    case 38: {
                        this.changeNodeAttrib(j3dMessageArray[n2]);
                        break;
                    }
                    case 45: {
                        this.changeNodeState(j3dMessageArray[n2]);
                        break;
                    }
                    case 39: 
                    case 40: {
                        this.changeNodeAttrib(j3dMessageArray[n2]);
                        break;
                    }
                    case 3: {
                        this.updateTransformChange(j3dMessageArray[n2].args, l);
                    }
                }
                j3dMessageArray[n2].decRefcount();
                ++n2;
            }
        }
    }

    void insertNodes(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof SoundRetained) {
                this.addSound((SoundRetained)object);
            }
            if (object instanceof SoundscapeRetained) {
                this.addSoundscape((SoundscapeRetained)object);
            }
            ++n;
        }
    }

    void addSound(SoundRetained soundRetained) {
        this.sounds.add(soundRetained);
    }

    void addSoundscape(SoundscapeRetained soundscapeRetained) {
        this.soundscapes.add(soundscapeRetained);
    }

    void removeNodes(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof SoundRetained) {
                this.deleteSound((SoundRetained)object);
            }
            if (object instanceof SoundscapeRetained) {
                this.deleteSoundscape((SoundscapeRetained)object);
            }
            ++n;
        }
    }

    void deleteSound(SoundRetained soundRetained) {
        if (!this.sounds.isEmpty()) {
            int n = this.sounds.indexOf(soundRetained);
            this.sounds.remove(n);
        }
    }

    void deleteSoundscape(SoundscapeRetained soundscapeRetained) {
        boolean bl = this.soundscapes.remove(soundscapeRetained);
    }

    void changeNodeAttrib(J3dMessage j3dMessage) {
        Object object = j3dMessage.args[0];
        Object object2 = j3dMessage.args[1];
        if (object instanceof SoundRetained) {
            int n = (Integer)object2;
            if ((n & 0x100) > 0) {
                // empty if block
            }
            if ((n & 1) > 0) {
                this.loadSound((SoundRetained)object, true);
            }
            if ((n & 0x20) > 0) {
                this.enableSound((SoundRetained)object);
            }
            ((SoundRetained)object).updateMirrorObject(j3dMessage.args);
        }
        if (object instanceof SoundscapeRetained) {
            ((SoundscapeRetained)object).updateTransformChange();
        }
    }

    void changeNodeState(J3dMessage j3dMessage) {
        Object object = j3dMessage.args[0];
        Object object2 = j3dMessage.args[1];
        if (object instanceof SoundRetained) {
            int n = (Integer)object2;
            if ((n & 1) > 0) {
                this.loadSound((SoundRetained)object, false);
            }
            ((SoundRetained)object).updateMirrorObject(j3dMessage.args);
        }
    }

    boolean intersect(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        int n = this.viewPlatforms.arraySize() - 1;
        while (n >= 0) {
            viewPlatformRetainedArray[n].schedSphere.getWithLock(this.tempSphere);
            if (this.tempSphere.intersect(bounds)) {
                return true;
            }
            --n;
        }
        return false;
    }

    void loadSound(SoundRetained soundRetained, boolean bl) {
        MediaContainer mediaContainer = soundRetained.getSoundData();
        ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        int n = this.viewPlatforms.arraySize() - 1;
        while (n >= 0) {
            View[] viewArray = viewPlatformRetainedArray[n].getViewList();
            int n2 = viewArray.length - 1;
            while (n2 >= 0) {
                View view = viewArray[n2];
                view.soundScheduler.loadSound(soundRetained, bl);
                --n2;
            }
            --n;
        }
    }

    void enableSound(SoundRetained soundRetained) {
        ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        int n = this.viewPlatforms.arraySize() - 1;
        while (n >= 0) {
            View[] viewArray = viewPlatformRetainedArray[n].getViewList();
            int n2 = viewArray.length - 1;
            while (n2 >= 0) {
                View view = viewArray[n2];
                view.soundScheduler.enableSound(soundRetained);
                --n2;
            }
            --n;
        }
    }

    UnorderList getSoundList() {
        return this.sounds;
    }

    UnorderList getSoundscapeList() {
        return this.soundscapes;
    }

    void updateTransformChange(Object[] objectArray, long l) {
        Object[] objectArray2 = (Object[])objectArray[0];
        int n = 0;
        while (n < objectArray2.length) {
            LeafRetained leafRetained;
            if (objectArray2[n] instanceof ConeSoundRetained) {
                this.xformChangeList.add(objectArray2[n]);
                leafRetained = (ConeSoundRetained)objectArray2[n];
                ((ConeSoundRetained)leafRetained).updateTransformChange();
            }
            if (objectArray2[n] instanceof PointSoundRetained) {
                this.xformChangeList.add(objectArray2[n]);
                leafRetained = (PointSoundRetained)objectArray2[n];
                ((PointSoundRetained)leafRetained).updateTransformChange();
            }
            if (objectArray2[n] instanceof SoundRetained) {
                this.xformChangeList.add(objectArray2[n]);
                leafRetained = (SoundRetained)objectArray2[n];
                ((SoundRetained)leafRetained).updateTransformChange();
            }
            if (objectArray2[n] instanceof SoundscapeRetained) {
                this.xformChangeList.add(objectArray2[n]);
                leafRetained = (SoundscapeRetained)objectArray2[n];
                ((SoundscapeRetained)leafRetained).updateTransformChange();
            }
            if (objectArray2[n] instanceof AuralAttributesRetained) {
                this.xformChangeList.add(objectArray2[n]);
            }
            ++n;
        }
    }

    void debugPrint(String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

