/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.MediaContainer;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.SoundScheduler;

class SoundSchedulerAtom {
    SoundRetained sound = null;
    MediaContainer soundData = null;
    long startTime = 0L;
    long endTime = 0L;
    long sampleLength = 0L;
    long loopStartOffset = 0L;
    long loopLength = 0L;
    long attackLength = 0L;
    long releaseLength = 0L;
    int loadStatus = 0;
    boolean playing = false;
    int numberChannels = 0;
    boolean activated = false;
    static final int OFF = 0;
    static final int ON = 1;
    static final int PENDING_ON = 2;
    static final int PENDING_OFF = 3;
    int enabled = 0;
    static final int DO_NOTHING = 0;
    static final int LEAVE_OFF = 1;
    static final int LEAVE_SILENT = 2;
    static final int LEAVE_AUDIBLE = 3;
    static final int RESTART_AUDIBLE = 4;
    static final int START_AUDIBLE = 5;
    static final int RESTART_SILENT = 6;
    static final int START_SILENT = 7;
    static final int MAKE_AUDIBLE = 8;
    static final int MAKE_SILENT = 9;
    static final int TURN_OFF = 10;
    static final int UPDATE = 11;
    static final int COMPLETE = 12;
    int schedulingAction = 0;
    static final int SOUND_OFF = 0;
    static final int SOUND_AUDIBLE = 1;
    static final int SOUND_SILENT = 2;
    static final int SOUND_COMPLETE = 3;
    int status = 0;
    int attribsDirty = 0;
    int stateDirty = 0;
    int sampleId = -1;
    SoundScheduler soundScheduler = null;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    SoundSchedulerAtom() {
    }

    synchronized void calculateEndTime() {
        SoundRetained soundRetained = this.sound.sgSound;
        int n = soundRetained.loopCount;
        if (this.sampleLength == -1L || this.loopLength == -1L || n < 0) {
            this.endTime = -1L;
        } else if (this.playing && this.startTime > 0L) {
            this.endTime = this.startTime + this.attackLength + this.loopLength * (long)(n + 1) + this.releaseLength;
        } else {
            long l = System.currentTimeMillis();
            this.endTime = l + (this.loopLength - (l - this.startTime - this.attackLength) % this.loopLength + this.releaseLength);
        }
    }

    void setEnableState(int n) {
        this.enabled = n;
        switch (n) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 0: {
                break;
            }
        }
    }

    synchronized int calcActiveSchedAction() {
        SoundRetained soundRetained = this.sound.sgSound;
        int n = 0;
        this.activated = true;
        switch (this.enabled) {
            case 2: {
                this.setEnableState(1);
                if (this.status == 0) {
                    n = 5;
                    break;
                }
                n = 4;
                break;
            }
            case 1: {
                if (this.status == 0) {
                    n = 5;
                    break;
                }
                if (this.status == 2) {
                    n = 8;
                    break;
                }
                n = 3;
                break;
            }
            case 3: {
                this.setEnableState(0);
            }
            case 0: {
                if (this.status == 1) {
                    if (soundRetained.release) {
                        if (this.enabled == 3) {
                            this.calculateEndTime();
                        }
                        n = 3;
                        break;
                    }
                    n = 10;
                    break;
                }
                if (this.status == 2) {
                    if (soundRetained.release) {
                        this.calculateEndTime();
                        n = 8;
                        break;
                    }
                    n = 10;
                    break;
                }
                n = 1;
                break;
            }
        }
        return n;
    }

    synchronized int calcInactiveSchedAction() {
        int n = 0;
        SoundRetained soundRetained = this.sound.sgSound;
        this.activated = false;
        switch (this.enabled) {
            case 2: {
                this.setEnableState(1);
                if (soundRetained.continuous) {
                    if (this.status == 0) {
                        n = 7;
                        break;
                    }
                    n = 6;
                    break;
                }
                if (this.status == 0) {
                    n = 1;
                    break;
                }
                n = 10;
                break;
            }
            case 1: {
                if (soundRetained.continuous) {
                    if (this.status == 1) {
                        n = 9;
                        break;
                    }
                    if (this.status == 0) {
                        n = 7;
                        break;
                    }
                    n = 2;
                    break;
                }
                if (this.status == 0) {
                    n = 1;
                    break;
                }
                n = 10;
                break;
            }
            case 3: {
                this.setEnableState(0);
            }
            case 0: {
                if (soundRetained.release && soundRetained.continuous) {
                    if (this.enabled == 3) {
                        this.calculateEndTime();
                    }
                    if (this.status == 1) {
                        n = 9;
                        break;
                    }
                    if (this.status == 2) {
                        n = 2;
                        break;
                    }
                    n = 1;
                    break;
                }
                if (this.status == 0) {
                    n = 1;
                    break;
                }
                n = 10;
                break;
            }
        }
        return n;
    }

    void debugPrint(String string) {
    }

    void setAttribsDirtyFlag(int n) {
        this.attribsDirty |= n;
    }

    void setStateDirtyFlag(int n) {
        this.stateDirty |= n;
    }

    void clearAttribsDirtyFlag(int n) {
        this.attribsDirty &= ~n;
    }

    void clearAttribsDirtyFlag() {
        this.attribsDirty = 0;
    }

    void clearStateDirtyFlag(int n) {
        this.stateDirty &= ~n;
    }

    void clearStateDirtyFlag() {
        this.stateDirty = 0;
    }

    boolean testDirtyFlag(int n, int n2) {
        return (n & n2) > 0;
    }

    boolean testDirtyFlags() {
        if ((this.attribsDirty & 0xFFFF) > 0) {
            return true;
        }
        return (this.stateDirty & 0xFFFF) > 0;
    }
}

