/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.Appearance;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CompileState;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.FogRetained;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.MRSWLock;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrderedGroupRetained;
import javax.media.j3d.OrderedPath;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.RasterRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.Text3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class Shape3DRetained
extends LeafRetained {
    static final int GEOMETRY_CHANGED = 1;
    static final int APPEARANCE_CHANGED = 2;
    static final int COLLISION_CHANGED = 4;
    static final int BOUNDS_CHANGED = 8;
    static final int APPEARANCEOVERRIDE_CHANGED = 16;
    static final int LAST_DEFINED_BIT = 16;
    static final int targetThreads = 4224;
    AppearanceRetained appearance = null;
    ArrayList geometryList = null;
    private GeometryAtom geomAtom = null;
    private MRSWLock mirrorShape3DLock = null;
    ArrayList mirrorShape3D = new ArrayList(1);
    NodeRetained sourceNode = null;
    HashKey key = null;
    ArrayList parentList = null;
    boolean inImmCtx = false;
    int isDirty = 65535;
    LightRetained[] lights = null;
    int numlights = 0;
    FogRetained[] fogs = null;
    int numfogs = 0;
    ModelClipRetained[] modelClips = null;
    int numModelClips = 0;
    AlternateAppearanceRetained[] altApps = null;
    int numAltApps = 0;
    BranchGroupRetained[] branchGroupPath;
    boolean isPickable = true;
    boolean isCollidable = true;
    SwitchRetained closestSwitchParent = null;
    int closestSwitchIndex = -1;
    boolean visible = true;
    boolean appearanceOverrideEnable = false;
    AppearanceRetained otherAppearance = null;
    Bounds bounds = null;
    BoundingBox vwcBounds = null;
    Bounds collisionBound = null;
    Bounds collisionVwcBound = null;
    boolean useSwitchVwcBounds = false;
    boolean inOrderedGroup = false;
    OrderedPath orderedPath = null;

    Shape3DRetained() {
        this.nodeType = 11;
        this.numlights = 0;
        this.numfogs = 0;
        this.numModelClips = 0;
        this.numAltApps = 0;
        this.localBounds = new BoundingBox((Bounds)null);
        this.mirrorShape3DLock = new MRSWLock();
        this.geometryList = new ArrayList();
        this.geometryList.add(null);
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds == null ? null : (Bounds)bounds.clone();
        if (this.source.isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8192;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
            j3dMessage.args[1] = this.collisionBound;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 35;
            j3dMessage.threads = 8384;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
            j3dMessage.args[1] = this.localBounds;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    Bounds getCollisionBounds(int n) {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    void addGeometry(Geometry geometry) {
        GeometryRetained geometryRetained;
        GeometryRetained geometryRetained2 = null;
        if (this.geometryList.size() > 0 && (geometryRetained = (GeometryRetained)this.geometryList.get(0)) != null && geometry != null && !geometryRetained.isEquivalenceClass((GeometryRetained)geometry.retained)) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained5"));
        }
        if (((Shape3D)this.source).isLive()) {
            if (geometry != null) {
                if (((GeometryRetained)geometry.retained).getInImmCtx()) {
                    throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained0"));
                }
                geometryRetained2 = (GeometryRetained)geometry.retained;
                geometryRetained2.setLive(this.inBackgroundGroup, this.refCount);
                this.geometryList.add(geometryRetained2);
            } else {
                this.geometryList.add(null);
                geometryRetained2 = null;
            }
            this.sendDataChangedMessage(geometryRetained2);
        } else if (this.inImmCtx) {
            if (geometry != null && geometry.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained1"));
            }
        } else if (geometry != null) {
            this.geometryList.add((GeometryRetained)geometry.retained);
        } else {
            this.geometryList.add(null);
        }
    }

    void setGeometry(Geometry geometry, int n) {
        GeometryRetained geometryRetained;
        GeometryRetained geometryRetained2 = null;
        GeometryRetained geometryRetained3 = null;
        int n2 = this.geometryList.size();
        if (n2 > 1 && (geometryRetained = (GeometryRetained)this.geometryList.get(0)) != null && geometry != null && !geometryRetained.isEquivalenceClass((GeometryRetained)geometry.retained)) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained5"));
        }
        if (((Shape3D)this.source).isLive()) {
            if (geometry != null && ((GeometryRetained)geometry.retained).getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained0"));
            }
            geometryRetained3 = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained3 != null) {
                geometryRetained3.clearLive(this.refCount);
                int n3 = 0;
                while (n3 < this.mirrorShape3D.size()) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n3);
                    geometryRetained3.removeUser(shape3DRetained);
                    ++n3;
                }
                geometryRetained3.decRefCnt();
            }
            if (geometry != null) {
                geometryRetained2 = (GeometryRetained)geometry.retained;
                geometryRetained2.incRefCnt();
                geometryRetained2.setLive(this.inBackgroundGroup, this.refCount);
                this.geometryList.set(n, geometryRetained2);
                this.sendDataChangedMessage(geometryRetained2);
            } else {
                this.geometryList.set(n, null);
                this.sendDataChangedMessage(null);
            }
        } else if (this.inImmCtx) {
            if (geometry != null && geometry.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained1"));
            }
        } else {
            geometryRetained3 = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained3 != null) {
                geometryRetained3.decRefCnt();
            }
            if (geometry != null) {
                this.geometryList.set(n, (GeometryRetained)geometry.retained);
                ((GeometryRetained)geometry.retained).incRefCnt();
            } else {
                this.geometryList.set(n, null);
            }
        }
    }

    void insertGeometry(Geometry geometry, int n) {
        GeometryRetained geometryRetained;
        GeometryRetained geometryRetained2 = null;
        Object var7_4 = null;
        int n2 = this.geometryList.size();
        if (n2 > 1 && (geometryRetained = (GeometryRetained)this.geometryList.get(0)) != null && geometry != null && !geometryRetained.isEquivalenceClass((GeometryRetained)geometry.retained)) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained5"));
        }
        if (((Shape3D)this.source).isLive()) {
            if (geometry != null && ((GeometryRetained)geometry.retained).getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained0"));
            }
            if (geometry != null) {
                geometryRetained2 = (GeometryRetained)geometry.retained;
                geometryRetained2.incRefCnt();
                this.geometryList.add(n, geometryRetained2);
                geometryRetained2.setLive(this.inBackgroundGroup, this.refCount);
                this.sendDataChangedMessage(geometryRetained2);
            } else {
                this.geometryList.add(n, null);
                this.sendDataChangedMessage(null);
            }
        } else if (this.inImmCtx) {
            if (geometry != null && geometry.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained1"));
            }
        } else if (geometry != null) {
            this.geometryList.add(n, (GeometryRetained)geometry.retained);
            ((GeometryRetained)geometry.retained).incRefCnt();
        } else {
            this.geometryList.add(n, null);
        }
    }

    void removeGeometry(int n) {
        GeometryRetained geometryRetained = null;
        if (((Shape3D)this.source).isLive()) {
            geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null) {
                geometryRetained.clearLive(this.refCount);
                geometryRetained.decRefCnt();
                int n2 = 0;
                while (n2 < this.mirrorShape3D.size()) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n2);
                    geometryRetained.removeUser(shape3DRetained);
                    ++n2;
                }
            }
            this.geometryList.remove(n);
            this.sendDataChangedMessage(null);
        } else {
            geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null) {
                geometryRetained.decRefCnt();
            }
            this.geometryList.remove(n);
        }
    }

    Geometry getGeometry(int n, int n2) {
        GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
        return geometryRetained == null ? null : (Geometry)geometryRetained.source;
    }

    Enumeration getAllGeometries(int n) {
        GeometryRetained geometryRetained = null;
        Vector<Geometry> vector = new Vector<Geometry>();
        int n2 = 0;
        while (n2 < this.geometryList.size()) {
            geometryRetained = (GeometryRetained)this.geometryList.get(n2);
            if (geometryRetained != null) {
                vector.add((Geometry)geometryRetained.source);
            } else {
                vector.add(null);
            }
            ++n2;
        }
        return vector.elements();
    }

    int numGeometries(int n) {
        return this.geometryList.size();
    }

    void setAppearance(Appearance appearance) {
        boolean bl = false;
        if (((Shape3D)this.source).isLive()) {
            Shape3DRetained shape3DRetained;
            int n;
            if (appearance != null && ((AppearanceRetained)appearance.retained).getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained2"));
            }
            if (this.appearance != null) {
                this.appearance.clearLive(this.refCount);
                n = 0;
                while (n < this.mirrorShape3D.size()) {
                    shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n);
                    this.appearance.removeAMirrorUser(shape3DRetained);
                    ++n;
                }
            }
            if (appearance != null) {
                ((AppearanceRetained)appearance.retained).setLive(this.inBackgroundGroup, this.refCount);
                this.appearance = (AppearanceRetained)appearance.retained;
                n = 0;
                while (n < this.mirrorShape3D.size()) {
                    shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n);
                    this.appearance.addAMirrorUser(shape3DRetained);
                    ++n;
                }
                if (this.appearance.renderingAttributes != null && this.visible != this.appearance.renderingAttributes.visible) {
                    this.visible = this.appearance.renderingAttributes.visible;
                    bl = true;
                }
            } else if (!this.visible) {
                this.visible = true;
                bl = true;
            }
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 4224;
            if (bl) {
                j3dMessage.threads |= 0x40;
            }
            j3dMessage.type = 24;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(2);
            j3dMessage.args[2] = this.mirrorShape3D.clone();
            j3dMessage.args[3] = appearance == null ? null : this.appearance.mirror.clone();
            j3dMessage.args[4] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D);
            VirtualUniverse.mc.processMessage(j3dMessage);
        } else {
            this.appearance = appearance == null ? null : (AppearanceRetained)appearance.retained;
        }
    }

    Appearance getAppearance() {
        return this.appearance == null ? null : (Appearance)this.appearance.source;
    }

    boolean intersect(SceneGraphPath sceneGraphPath, PickShape pickShape) {
        Transform3D transform3D = null;
        transform3D = sceneGraphPath.getTransform();
        if (transform3D == null) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained3"));
        }
        PickShape pickShape2 = pickShape;
        Transform3D transform3D2 = VirtualUniverse.mc.getTransform3D(null);
        transform3D2.invert(transform3D);
        pickShape2 = pickShape2.transform(transform3D2);
        VirtualUniverse.mc.addToTransformFreeList(transform3D2);
        if (this instanceof OrientedShape3DRetained) {
            View view = null;
            boolean bl = false;
            int n = VirtualUniverse.mc.numOfViews();
            int n2 = 0;
            while (n2 < n) {
                view = VirtualUniverse.mc.getView(n2);
                if (view.primaryView) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl && view != null) {
                Transform3D transform3D3 = ((OrientedShape3DRetained)this).getOrientedTransform(view.viewIndex);
                Transform3D transform3D4 = VirtualUniverse.mc.getTransform3D(null);
                transform3D4.invert(transform3D3);
                pickShape2 = pickShape2.transform(transform3D4);
                VirtualUniverse.mc.addToTransformFreeList(transform3D4);
            }
        }
        int n = 0;
        while (n < this.geometryList.size()) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null && (geometryRetained.mirrorGeometry == null ? geometryRetained.intersect(pickShape2) : geometryRetained.mirrorGeometry.intersect(pickShape2))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean intersect(SceneGraphPath sceneGraphPath, PickRay pickRay, double[] dArray) {
        int n;
        Object object;
        Transform3D transform3D = null;
        transform3D = sceneGraphPath.getTransform();
        if (transform3D == null) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained3"));
        }
        PickRay pickRay2 = pickRay;
        if (this instanceof OrientedShape3DRetained) {
            object = null;
            n = 0;
            int n2 = VirtualUniverse.mc.numOfViews();
            int n3 = 0;
            while (n3 < n2) {
                object = VirtualUniverse.mc.getView(n3);
                if (((View)object).primaryView) {
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (n != 0 && object != null) {
                Transform3D transform3D2 = ((OrientedShape3DRetained)this).getOrientedTransform(((View)object).viewIndex);
                Transform3D transform3D3 = VirtualUniverse.mc.getTransform3D(null);
                transform3D3.invert(transform3D2);
                pickRay2 = (PickRay)((PickShape)pickRay2).transform(transform3D3);
                VirtualUniverse.mc.addToTransformFreeList(transform3D3);
            }
        }
        object = VirtualUniverse.mc.getTransform3D(null);
        ((Transform3D)object).invert(transform3D);
        pickRay2 = (PickRay)((PickShape)pickRay2).transform((Transform3D)object);
        VirtualUniverse.mc.addToTransformFreeList((Transform3D)object);
        n = this.geometryList.size();
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d();
        if (n == 1) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(0);
            if (geometryRetained != null) {
                if (geometryRetained.mirrorGeometry == null) {
                    if (geometryRetained.intersect(pickRay2, dArray, point3d)) {
                        GeometryRetained.processDistance(pickRay, dArray, transform3D, point3d, vector3d);
                        return true;
                    }
                } else if (geometryRetained.mirrorGeometry.intersect(pickRay2, dArray, point3d)) {
                    GeometryRetained.processDistance(pickRay, dArray, transform3D, point3d, vector3d);
                    return true;
                }
            }
            return false;
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = dArray[0];
        dArray[0] = Double.POSITIVE_INFINITY;
        boolean bl = false;
        int n4 = 0;
        while (n4 < this.geometryList.size()) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n4);
            if (geometryRetained != null) {
                if (geometryRetained.mirrorGeometry == null) {
                    bl = geometryRetained.intersect(pickRay2, dArray, point3d);
                    if (bl) {
                        GeometryRetained.processDistance(pickRay, dArray, transform3D, point3d, vector3d);
                    }
                } else {
                    bl = geometryRetained.mirrorGeometry.intersect(pickRay2, dArray, point3d);
                    if (bl) {
                        GeometryRetained.processDistance(pickRay, dArray, transform3D, point3d, vector3d);
                    }
                }
                if (bl && d > dArray[0]) {
                    d = dArray[0];
                }
            }
            ++n4;
        }
        if (d < Double.POSITIVE_INFINITY) {
            dArray[0] = d;
            return true;
        }
        dArray[0] = d2;
        return false;
    }

    void setAppearanceOverrideEnable(boolean bl) {
        if (((Shape3D)this.source).isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 4224;
            j3dMessage.type = 24;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(16);
            j3dMessage.args[2] = this.mirrorShape3D.clone();
            j3dMessage.args[3] = bl ? Boolean.TRUE : Boolean.FALSE;
            j3dMessage.args[4] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D);
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        this.appearanceOverrideEnable = bl;
    }

    boolean getAppearanceOverrideEnable() {
        return this.appearanceOverrideEnable;
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    private void initMirrorShape3D(SetLiveState setLiveState, Shape3DRetained shape3DRetained, int n) {
        shape3DRetained.inBackgroundGroup = this.inBackgroundGroup;
        shape3DRetained.geometryBackground = this.geometryBackground;
        shape3DRetained.source = this.source;
        shape3DRetained.universe = this.universe;
        shape3DRetained.inSharedGroup = false;
        shape3DRetained.locale = this.locale;
        shape3DRetained.parent = this.parent;
        boolean bl = shape3DRetained.inOrderedGroup = setLiveState.inOrderedGroups.get(n) == Boolean.TRUE;
        if (shape3DRetained.inOrderedGroup) {
            shape3DRetained.orderedPath = setLiveState.orderedPaths.getPath(n).clonePath();
        }
        if (setLiveState.useSwitchVwcBounds) {
            shape3DRetained.vwcBounds = (BoundingBox)setLiveState.switchVwcBounds.get(n);
            shape3DRetained.useSwitchVwcBounds = true;
        }
        shape3DRetained.staticTransform = this.staticTransform;
        shape3DRetained.appearanceOverrideEnable = this.appearanceOverrideEnable;
        shape3DRetained.geometryList = this.geometryList;
        shape3DRetained.sourceNode = this;
        if (this instanceof OrientedShape3DRetained) {
            OrientedShape3DRetained orientedShape3DRetained = (OrientedShape3DRetained)this;
            OrientedShape3DRetained orientedShape3DRetained2 = (OrientedShape3DRetained)shape3DRetained;
            orientedShape3DRetained2.initAlignmentMode(orientedShape3DRetained.mode);
            orientedShape3DRetained2.initAlignmentAxis(orientedShape3DRetained.axis);
            orientedShape3DRetained2.initRotationPoint(orientedShape3DRetained.rotationPoint);
        }
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        int n;
        int n2 = (Integer)objectArray[1];
        ArrayList arrayList = (ArrayList)objectArray[2];
        if ((n2 & 2) != 0) {
            n = 0;
            while (n < arrayList.size()) {
                ((Shape3DRetained)arrayList.get((int)n)).appearance = (AppearanceRetained)objectArray[3];
                ++n;
            }
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
            while (n < arrayList.size()) {
                ((Shape3DRetained)arrayList.get((int)n)).appearanceOverrideEnable = (Boolean)objectArray[3];
                ++n;
            }
        }
    }

    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            if (this.geometryList != null) {
                BoundingBox boundingBox = new BoundingBox((Bounds)null);
                int n = 0;
                while (n < this.geometryList.size()) {
                    GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
                    if (geometryRetained != null && geometryRetained.geoType != -1) {
                        geometryRetained.computeBoundingBox();
                        BoundingBox boundingBox2 = geometryRetained.geoBounds;
                        synchronized (boundingBox2) {
                            boundingBox.combine(geometryRetained.geoBounds);
                        }
                    }
                    ++n;
                }
                return boundingBox;
            }
            return null;
        }
        return super.getBounds();
    }

    Bounds getEffectiveBounds() {
        if (this.boundsAutoCompute) {
            return this.getBounds();
        }
        return super.getEffectiveBounds();
    }

    void computeCombineBounds(Bounds bounds) {
        if (this.boundsAutoCompute) {
            if (this.geometryList != null) {
                BoundingBox boundingBox = null;
                if (this.staticTransform != null) {
                    boundingBox = new BoundingBox((Bounds)null);
                }
                int n = 0;
                while (n < this.geometryList.size()) {
                    GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
                    if (geometryRetained != null && geometryRetained.geoType != -1) {
                        geometryRetained.computeBoundingBox();
                        BoundingBox boundingBox2 = geometryRetained.geoBounds;
                        synchronized (boundingBox2) {
                            if (this.staticTransform != null) {
                                boundingBox.set(geometryRetained.geoBounds);
                                boundingBox.transform(this.staticTransform.transform);
                                bounds.combine(boundingBox);
                            } else {
                                bounds.combine(geometryRetained.geoBounds);
                            }
                        }
                    }
                    ++n;
                }
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    void setLive(SetLiveState setLiveState) {
        this.doSetLive(setLiveState);
        this.markAsLive();
    }

    void doSetLive(SetLiveState setLiveState) {
        Cloneable cloneable;
        ContainsNodes containsNodes;
        Shape3DRetained shape3DRetained;
        int n;
        ArrayList<Shape3DRetained> arrayList = new ArrayList<Shape3DRetained>();
        super.doSetLive(setLiveState);
        this.nodeId = this.universe.getNodeId();
        if (this.inSharedGroup) {
            n = 0;
            while (n < setLiveState.keys.length) {
                int n2;
                shape3DRetained = this instanceof OrientedShape3DRetained ? new OrientedShape3DRetained() : new Shape3DRetained();
                shape3DRetained.key = setLiveState.keys[n];
                shape3DRetained.localToVworld = new Transform3D[1][];
                shape3DRetained.localToVworldIndex = new int[1][];
                int n3 = setLiveState.keys[n].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n3 < 0) {
                    System.out.println("Shape3dRetained : Can't find hashKey");
                }
                shape3DRetained.localToVworld[0] = this.localToVworld[n3];
                shape3DRetained.localToVworldIndex[0] = this.localToVworldIndex[n3];
                shape3DRetained.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(n3);
                shape3DRetained.isPickable = setLiveState.pickable[n];
                shape3DRetained.isCollidable = setLiveState.collidable[n];
                shape3DRetained.parentList = (ArrayList)setLiveState.parentTransformGroups[n].clone();
                this.initMirrorShape3D(setLiveState, shape3DRetained, n);
                if (setLiveState.switchLevels[n] >= 0) {
                    shape3DRetained.clearCompositeSwitchMask();
                    shape3DRetained.isNewSwitchLeaf = true;
                    containsNodes = setLiveState.containsNodesList.getContainsNodes(n3);
                    containsNodes.geoNodes.add(shape3DRetained);
                    shape3DRetained.closestSwitchParent = setLiveState.closestSwitchParents[n];
                    shape3DRetained.closestSwitchIndex = setLiveState.closestSwitchIndices[n];
                }
                if (setLiveState.lights != null) {
                    n2 = 0;
                    while (n2 < setLiveState.lights.size()) {
                        shape3DRetained.addLight((LightRetained)setLiveState.lights.get(n2));
                        ++n2;
                    }
                }
                if (setLiveState.fogs != null) {
                    n2 = 0;
                    while (n2 < setLiveState.fogs.size()) {
                        shape3DRetained.addFog((FogRetained)setLiveState.fogs.get(n2));
                        ++n2;
                    }
                }
                if (setLiveState.modelClips != null) {
                    n2 = 0;
                    while (n2 < setLiveState.modelClips.size()) {
                        shape3DRetained.addModelClip((ModelClipRetained)setLiveState.modelClips.get(n2));
                        ++n2;
                    }
                }
                if (setLiveState.altAppearances != null) {
                    n2 = 0;
                    while (n2 < setLiveState.altAppearances.size()) {
                        shape3DRetained.addAltApp((AlternateAppearanceRetained)setLiveState.altAppearances.get(n2));
                        ++n2;
                    }
                }
                cloneable = this.mirrorShape3D;
                synchronized (cloneable) {
                    this.mirrorShape3D.add(n3, shape3DRetained);
                }
                arrayList.add(shape3DRetained);
                ++n;
            }
        } else {
            shape3DRetained = this instanceof OrientedShape3DRetained ? new OrientedShape3DRetained() : new Shape3DRetained();
            shape3DRetained.localToVworld = new Transform3D[1][];
            shape3DRetained.localToVworldIndex = new int[1][];
            shape3DRetained.localToVworld[0] = this.localToVworld[0];
            shape3DRetained.localToVworldIndex[0] = this.localToVworldIndex[0];
            shape3DRetained.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(0);
            shape3DRetained.isPickable = setLiveState.pickable[0];
            shape3DRetained.isCollidable = setLiveState.collidable[0];
            shape3DRetained.parentList = (ArrayList)setLiveState.parentTransformGroups[0].clone();
            this.initMirrorShape3D(setLiveState, shape3DRetained, 0);
            if (setLiveState.lights != null) {
                n = 0;
                while (n < setLiveState.lights.size()) {
                    shape3DRetained.addLight((LightRetained)setLiveState.lights.get(n));
                    ++n;
                }
            }
            if (setLiveState.fogs != null) {
                n = 0;
                while (n < setLiveState.fogs.size()) {
                    shape3DRetained.addFog((FogRetained)setLiveState.fogs.get(n));
                    ++n;
                }
            }
            if (setLiveState.modelClips != null) {
                n = 0;
                while (n < setLiveState.modelClips.size()) {
                    shape3DRetained.addModelClip((ModelClipRetained)setLiveState.modelClips.get(n));
                    ++n;
                }
            }
            if (setLiveState.altAppearances != null) {
                n = 0;
                while (n < setLiveState.altAppearances.size()) {
                    shape3DRetained.addAltApp((AlternateAppearanceRetained)setLiveState.altAppearances.get(n));
                    ++n;
                }
            }
            cloneable = this.mirrorShape3D;
            synchronized (cloneable) {
                this.mirrorShape3D.add(shape3DRetained);
            }
            arrayList.add(shape3DRetained);
            if (setLiveState.switchLevels[0] >= 0) {
                shape3DRetained.clearCompositeSwitchMask();
                shape3DRetained.isNewSwitchLeaf = true;
                containsNodes = setLiveState.containsNodesList.getContainsNodes(0);
                containsNodes.geoNodes.add(shape3DRetained);
                shape3DRetained.closestSwitchParent = setLiveState.closestSwitchParents[0];
                shape3DRetained.closestSwitchIndex = setLiveState.closestSwitchIndices[0];
            }
        }
        int n4 = 0;
        while (n4 < arrayList.size()) {
            Object object;
            cloneable = (Shape3DRetained)arrayList.get(n4);
            if (this.appearance != null) {
                object = this.appearance.liveStateLock;
                synchronized (object) {
                    if (n4 == 0) {
                        if (this.appearance.getInImmCtx()) {
                            throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained2"));
                        }
                        this.appearance.setLive(this.inBackgroundGroup, setLiveState.refCount);
                        this.appearance.initMirrorObject();
                        if (this.appearance.renderingAttributes != null) {
                            this.visible = this.appearance.renderingAttributes.visible;
                        }
                    }
                    cloneable.appearance = (AppearanceRetained)this.appearance.mirror;
                    this.appearance.addAMirrorUser((Shape3DRetained)cloneable);
                }
            } else {
                cloneable.appearance = null;
            }
            if (this.geometryList != null) {
                int n5 = 0;
                while (n5 < this.geometryList.size()) {
                    GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n5);
                    if (geometryRetained != null) {
                        object = geometryRetained.liveStateLock;
                        synchronized (object) {
                            if (n4 == 0) {
                                if (geometryRetained.getInImmCtx()) {
                                    throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained4"));
                                }
                                geometryRetained.setLive(this.inBackgroundGroup, setLiveState.refCount);
                            }
                            geometryRetained.addUser((Shape3DRetained)cloneable);
                        }
                    }
                    ++n5;
                }
            }
            if (n4 == 0 && this.boundsAutoCompute) {
                if (!(this.localBounds instanceof BoundingBox)) {
                    this.localBounds = new BoundingBox((Bounds)null);
                }
                this.getCombineBounds((BoundingBox)this.localBounds);
            }
            this.initializeGAtom((Shape3DRetained)cloneable, !setLiveState.useSwitchVwcBounds);
            setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(cloneable));
            if (setLiveState.transformTargets != null) {
                setLiveState.transformTargets[n4].addAll(Shape3DRetained.getGeomAtomsList(cloneable));
                setLiveState.transformTargetThreads |= 0x20C0;
            }
            ++n4;
        }
        setLiveState.notifyThreads |= 0x30C0;
    }

    void clearMirrorShape() {
        this.source = null;
        this.sourceNode = null;
        this.parent = null;
        this.parentList = null;
        if (this.otherAppearance != null) {
            this.otherAppearance.sgApp.removeAMirrorUser(this);
            this.otherAppearance = null;
        }
        this.appearance = null;
        this.branchGroupPath = null;
        this.isPickable = true;
        this.isCollidable = true;
        this.branchGroupPath = null;
        this.geometryList = null;
        int n = 0;
        while (n < this.numfogs) {
            this.fogs[n] = null;
            ++n;
        }
        this.numfogs = 0;
        n = 0;
        while (n < this.numModelClips) {
            this.modelClips[n] = null;
            ++n;
        }
        this.numModelClips = 0;
        n = 0;
        while (n < this.numlights) {
            this.lights[n] = null;
            ++n;
        }
        this.numlights = 0;
        n = 0;
        while (n < this.numAltApps) {
            this.altApps[n] = null;
            ++n;
        }
        this.numAltApps = 0;
    }

    void clearLive(SetLiveState setLiveState) {
        ContainsNodes containsNodes;
        Shape3DRetained shape3DRetained;
        int n;
        ArrayList arrayList;
        ArrayList<Shape3DRetained> arrayList2 = new ArrayList<Shape3DRetained>();
        super.clearLive(setLiveState);
        if (this.inSharedGroup) {
            arrayList = this.mirrorShape3D;
            synchronized (arrayList) {
                Object[] objectArray = this.mirrorShape3D.toArray();
                n = 0;
                while (n < setLiveState.keys.length) {
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        shape3DRetained = (Shape3DRetained)objectArray[n2];
                        if (shape3DRetained.key.equals((Object)setLiveState.keys[n])) {
                            this.mirrorShape3D.remove(this.mirrorShape3D.indexOf(shape3DRetained));
                            if (setLiveState.containsNodesList != null && (containsNodes = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n])) != null) {
                                ((AbstractCollection)containsNodes.geoNodes).remove(shape3DRetained);
                            }
                            arrayList2.add(shape3DRetained);
                            setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
        arrayList = this.mirrorShape3D;
        synchronized (arrayList) {
            this.mirrorShape3D.remove(0);
        }
        if (setLiveState.containsNodesList != null && (containsNodes = setLiveState.containsNodesList.getContainsNodes(0)) != null) {
            ((AbstractCollection)containsNodes.geoNodes).remove(shape3DRetained);
        }
        arrayList2.add(shape3DRetained);
        setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
        int n3 = 0;
        while (n3 < arrayList2.size()) {
            Object object;
            Shape3DRetained shape3DRetained2 = (Shape3DRetained)arrayList2.get(n3);
            if (this.appearance != null) {
                object = this.appearance.liveStateLock;
                synchronized (object) {
                    if (n3 == 0) {
                        this.appearance.clearLive(setLiveState.refCount);
                    }
                    this.appearance.removeAMirrorUser(shape3DRetained2);
                }
            }
            if (this.geometryList != null) {
                int n4 = 0;
                while (n4 < this.geometryList.size()) {
                    GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n4);
                    if (geometryRetained != null) {
                        object = geometryRetained.liveStateLock;
                        synchronized (object) {
                            if (n3 == 0) {
                                geometryRetained.clearLive(setLiveState.refCount);
                            }
                            geometryRetained.removeUser(shape3DRetained2);
                        }
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        setLiveState.notifyThreads |= 0x10C0;
        if (!this.source.isLive()) {
            n = 0;
            while (n < this.numfogs) {
                this.fogs[n] = null;
                ++n;
            }
            this.numfogs = 0;
            n = 0;
            while (n < this.numModelClips) {
                this.modelClips[n] = null;
                ++n;
            }
            this.numModelClips = 0;
            n = 0;
            while (n < this.numlights) {
                this.lights[n] = null;
                ++n;
            }
            this.numlights = 0;
            n = 0;
            while (n < this.numAltApps) {
                this.altApps[n] = null;
                ++n;
            }
            this.numAltApps = 0;
        }
    }

    boolean isStatic() {
        return !this.source.getCapability(15) && !this.source.getCapability(13) && !this.source.getCapability(19);
    }

    boolean staticXformCanBeApplied() {
        if (VirtualUniverse.mc.isD3D()) {
            return false;
        }
        if (this.isPickable || this.isCollidable || this.source.getCapability(6) || this.source.getCapability(8)) {
            return false;
        }
        int n = 0;
        while (n < this.geometryList.size()) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null) {
                boolean bl;
                if (geometryRetained.refCnt > 1) {
                    return false;
                }
                boolean bl2 = this.isAlphaEditable(geometryRetained);
                if (geometryRetained instanceof GeometryArrayRetained) {
                    bl = ((GeometryArrayRetained)geometryRetained).texCoordSetMap != null && ((GeometryArrayRetained)geometryRetained).texCoordSetMap.length > 1;
                    boolean bl3 = geometryRetained.isEditable = !((GeometryArrayRetained)geometryRetained).isWriteStatic();
                    if (geometryRetained.source.capabilities.get(0) || geometryRetained.source.capabilities.get(4)) {
                        return false;
                    }
                } else {
                    bl = false;
                }
                if (!geometryRetained.canBeInDisplayList(bl2, bl)) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        if (compileState.switchLevel >= 0 && (!this.boundsAutoCompute || this.source.getCapability(13) || this.source.getCapability(10) || this.source.getCapability(4))) {
            compileState.switchVwcBoundsSharable = false;
        }
        if (this.isStatic() && this.staticXformCanBeApplied()) {
            this.mergeFlag = 1;
        } else {
            this.mergeFlag = 0;
            compileState.keepTG = true;
        }
        if (this.appearance != null) {
            this.appearance.compile(compileState);
            if (this.appearance.isStatic()) {
                AppearanceRetained appearanceRetained;
                this.appearance = appearanceRetained = compileState.getAppearance(this.appearance);
            }
        }
        int n = 0;
        while (n < this.geometryList.size()) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null) {
                geometryRetained.compile(compileState);
            }
            ++n;
        }
    }

    void merge(CompileState compileState) {
        if (this.mergeFlag == 0) {
            TransformGroupRetained transformGroupRetained = compileState.staticTransform;
            compileState.staticTransform = null;
            super.merge(compileState);
            compileState.staticTransform = transformGroupRetained;
        } else {
            super.merge(compileState);
        }
        if (this.shapeIsMergeable(compileState)) {
            compileState.addShape(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean shapeIsMergeable(CompileState var1_1) {
        var2_2 = true;
        var5_3 = null;
        var6_4 = 0;
        var4_5 = 0;
        if (this.staticTransform != null) {
            return false;
        }
        if (!(this.parent instanceof OrderedGroupRetained) && !(this.parent instanceof SwitchRetained)) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            var5_3 = (GeometryRetained)this.geometryList.get(var6_4);
            ++var6_4;
lbl11:
            // 2 sources

            ** while (var5_3 == null && var6_4 < this.geometryList.size())
        }
lbl12:
        // 1 sources

        if (!(var5_3 instanceof GeometryArrayRetained)) {
            return false;
        }
        var7_6 = (GeometryArrayRetained)var5_3;
        var4_5 = var6_4;
        while (var4_5 < this.geometryList.size() && var2_2) {
            var5_3 = (GeometryRetained)this.geometryList.get(var4_5);
            if (var5_3 != null) {
                var8_7 = (GeometryArrayRetained)var5_3;
                if (!var8_7.isWriteStatic()) {
                    var2_2 = false;
                }
                if (var8_7.vertexFormat != var7_6.vertexFormat) {
                    var2_2 = false;
                }
            }
            ++var4_5;
        }
        if (this.source.capabilities.get(17) || this.source.capabilities.get(15) || this.source.capabilities.get(19) || this.source.capabilities.get(10) || this.source.capabilities.get(4) || this.source.capabilities.get(8) || this.source.capabilities.get(6) || this.source.capabilities.get(13)) {
            var2_2 = false;
        }
        return var2_2;
    }

    void getMirrorShape3D(ArrayList arrayList, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        arrayList.add(shape3DRetained);
    }

    void addLight(LightRetained lightRetained) {
        if (this.lights == null) {
            this.lights = new LightRetained[10];
        } else if (this.lights.length == this.numlights) {
            LightRetained[] lightRetainedArray = new LightRetained[this.numlights * 2];
            int n = 0;
            while (n < this.numlights) {
                lightRetainedArray[n] = this.lights[n];
                ++n;
            }
            this.lights = lightRetainedArray;
        }
        this.lights[this.numlights] = lightRetained;
        ++this.numlights;
    }

    void removeLight(LightRetained lightRetained) {
        int n = 0;
        while (n < this.numlights) {
            if (this.lights[n] == lightRetained) {
                this.lights[n] = null;
                break;
            }
            ++n;
        }
        ++n;
        while (n < this.numlights) {
            this.lights[n - 1] = this.lights[n];
            ++n;
        }
        --this.numlights;
    }

    void addFog(FogRetained fogRetained) {
        if (this.fogs == null) {
            this.fogs = new FogRetained[10];
        } else if (this.fogs.length == this.numfogs) {
            FogRetained[] fogRetainedArray = new FogRetained[this.numfogs * 2];
            int n = 0;
            while (n < this.numfogs) {
                fogRetainedArray[n] = this.fogs[n];
                ++n;
            }
            this.fogs = fogRetainedArray;
        }
        this.fogs[this.numfogs] = fogRetained;
        ++this.numfogs;
    }

    void removeFog(FogRetained fogRetained) {
        int n = 0;
        while (n < this.numfogs) {
            if (this.fogs[n] == fogRetained) {
                this.fogs[n] = null;
                break;
            }
            ++n;
        }
        ++n;
        while (n < this.numfogs) {
            this.fogs[n - 1] = this.fogs[n];
            ++n;
        }
        --this.numfogs;
    }

    void addModelClip(ModelClipRetained modelClipRetained) {
        if (this.modelClips == null) {
            this.modelClips = new ModelClipRetained[10];
        } else if (this.modelClips.length == this.numModelClips) {
            ModelClipRetained[] modelClipRetainedArray = new ModelClipRetained[this.numModelClips * 2];
            int n = 0;
            while (n < this.numModelClips) {
                modelClipRetainedArray[n] = this.modelClips[n];
                ++n;
            }
            this.modelClips = modelClipRetainedArray;
        }
        this.modelClips[this.numModelClips] = modelClipRetained;
        ++this.numModelClips;
    }

    void removeModelClip(ModelClipRetained modelClipRetained) {
        int n = 0;
        while (n < this.numModelClips) {
            if (this.modelClips[n] == modelClipRetained) {
                this.modelClips[n] = null;
                break;
            }
            ++n;
        }
        ++n;
        while (n < this.numModelClips) {
            this.modelClips[n - 1] = this.modelClips[n];
            ++n;
        }
        --this.numModelClips;
    }

    void addAltApp(AlternateAppearanceRetained alternateAppearanceRetained) {
        if (this.altApps == null) {
            this.altApps = new AlternateAppearanceRetained[10];
        } else if (this.altApps.length == this.numAltApps) {
            AlternateAppearanceRetained[] alternateAppearanceRetainedArray = new AlternateAppearanceRetained[this.numAltApps * 2];
            int n = 0;
            while (n < this.numAltApps) {
                alternateAppearanceRetainedArray[n] = this.altApps[n];
                ++n;
            }
            this.altApps = alternateAppearanceRetainedArray;
        }
        this.altApps[this.numAltApps] = alternateAppearanceRetained;
        ++this.numAltApps;
    }

    void removeAltApp(AlternateAppearanceRetained alternateAppearanceRetained) {
        int n = 0;
        while (n < this.numAltApps) {
            if (this.altApps[n] == alternateAppearanceRetained) {
                this.altApps[n] = null;
                break;
            }
            ++n;
        }
        ++n;
        while (n < this.numAltApps) {
            this.altApps[n - 1] = this.altApps[n];
            ++n;
        }
        --this.numAltApps;
    }

    void updatePickable(HashKey[] hashKeyArray, boolean[] blArray) {
        super.updatePickable(hashKeyArray, blArray);
        if (!this.inSharedGroup) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.isPickable = blArray[0];
        } else {
            int n = this.mirrorShape3D.size();
            int n2 = 0;
            while (n2 < hashKeyArray.length) {
                int n3 = 0;
                while (n3 < n) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n3);
                    if (hashKeyArray[n2].equals((Object)shape3DRetained.key)) {
                        shape3DRetained.isPickable = blArray[n2];
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    void updateCollidable(HashKey[] hashKeyArray, boolean[] blArray) {
        super.updateCollidable(hashKeyArray, blArray);
        if (!this.inSharedGroup) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.isCollidable = blArray[0];
        } else {
            int n = this.mirrorShape3D.size();
            int n2 = 0;
            while (n2 < hashKeyArray.length) {
                int n3 = 0;
                while (n3 < n) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n3);
                    if (hashKeyArray[n2].equals((Object)shape3DRetained.key)) {
                        shape3DRetained.isCollidable = blArray[n2];
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    private void sendDataChangedMessage(GeometryRetained geometryRetained) {
        Object object;
        Cloneable cloneable;
        GeometryAtom[] geometryAtomArray = null;
        GeometryAtom[] geometryAtomArray2 = null;
        Object var8_4 = null;
        int n = 0;
        GeometryRetained geometryRetained2 = null;
        int n2 = this.mirrorShape3D.size();
        if (n2 < 1) {
            return;
        }
        Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
        shape3DRetained.mirrorShape3DLock.writeLock();
        GeometryAtom geometryAtom = shape3DRetained.geomAtom;
        GeometryAtom geometryAtom2 = new GeometryAtom();
        if (geometryRetained != null) {
            geometryRetained.addUser(shape3DRetained);
        }
        int n3 = this.geometryList.size();
        int n4 = 0;
        while (n4 < n3) {
            geometryRetained2 = (GeometryRetained)this.geometryList.get(n4);
            if (geometryRetained2 != null) {
                geometryAtom2.geoType = geometryRetained2.geoType;
                geometryAtom2.alphaEditable = shape3DRetained.isAlphaEditable(geometryRetained2);
                break;
            }
            ++n4;
        }
        if (geometryRetained2 != null && geometryRetained2.geoType == 16) {
            n4 = 0;
            while (n4 < n3) {
                geometryRetained2 = (GeometryRetained)this.geometryList.get(n4);
                if (geometryRetained2 != null) {
                    cloneable = (Text3DRetained)geometryRetained2;
                    n += ((Text3DRetained)cloneable).numChars;
                } else {
                    ++n;
                }
                ++n4;
            }
            geometryAtom2.geometryArray = new GeometryRetained[n];
            geometryAtom2.lastLocalTransformArray = new Transform3D[n];
            n = 0;
        } else {
            geometryAtom2.geometryArray = new GeometryRetained[n3];
        }
        geometryAtom2.locale = shape3DRetained.locale;
        geometryAtom2.visible = this.visible;
        geometryAtom2.source = shape3DRetained;
        int n5 = 0;
        while (n5 < n3) {
            geometryRetained2 = (GeometryRetained)this.geometryList.get(n5);
            if (geometryRetained2 == null) {
                geometryAtom2.geometryArray[n++] = null;
            } else if (geometryRetained2.geoType == 16) {
                cloneable = (Text3DRetained)geometryRetained2;
                n4 = 0;
                while (n4 < ((Text3DRetained)cloneable).numChars) {
                    if (((Text3DRetained)cloneable).font3D.fontData[((Text3DRetained)cloneable).charIndex[n4]] != null) {
                        GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)((Text3DRetained)cloneable).font3D.fontData[((Text3DRetained)cloneable).charIndex[n4]].retained;
                        geometryAtom2.geometryArray[n] = geometryArrayRetained;
                        geometryAtom2.lastLocalTransformArray[n] = ((Text3DRetained)cloneable).charTransforms[n4];
                    } else {
                        geometryAtom2.geometryArray[n] = null;
                        geometryAtom2.lastLocalTransformArray[n] = null;
                    }
                    ++n4;
                    ++n;
                }
            } else {
                geometryAtom2.geometryArray[n++] = geometryRetained2;
            }
            ++n5;
        }
        cloneable = new ArrayList();
        ArrayList<GeometryAtom> arrayList = new ArrayList<GeometryAtom>();
        ((ArrayList)cloneable).add(geometryAtom);
        arrayList.add(geometryAtom2);
        if (shape3DRetained.parentList != null) {
            n4 = 0;
            while (n4 < shape3DRetained.parentList.size()) {
                object = (TransformGroupRetained)shape3DRetained.parentList.get(n4);
                ((TransformGroupRetained)object).updateTargets((ArrayList)cloneable, arrayList);
                ++n4;
            }
        }
        geometryAtomArray2 = new GeometryAtom[n2];
        geometryAtomArray = new GeometryAtom[n2];
        geometryAtomArray2[0] = geometryAtom;
        geometryAtomArray[0] = geometryAtom2;
        shape3DRetained.geomAtom = geometryAtom2;
        shape3DRetained.mirrorShape3DLock.writeUnlock();
        n4 = 1;
        while (n4 < n2) {
            shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n4);
            shape3DRetained.mirrorShape3DLock.writeLock();
            geometryAtom = shape3DRetained.geomAtom;
            geometryAtom2 = new GeometryAtom();
            if (geometryRetained != null) {
                geometryRetained.addUser(shape3DRetained);
            }
            geometryAtom2.geoType = geometryAtomArray[0].geoType;
            geometryAtom2.locale = shape3DRetained.locale;
            geometryAtom2.visible = this.visible;
            geometryAtom2.source = shape3DRetained;
            geometryAtom2.alphaEditable = geometryAtomArray[0].alphaEditable;
            geometryAtom2.geometryArray = new GeometryRetained[geometryAtomArray[0].geometryArray.length];
            int n6 = 0;
            while (n6 < geometryAtom2.geometryArray.length) {
                geometryAtom2.geometryArray[n6] = geometryAtomArray[0].geometryArray[n6];
                ++n6;
            }
            ((ArrayList)cloneable).set(0, geometryAtom);
            arrayList.set(0, geometryAtom2);
            if (shape3DRetained.parentList != null) {
                n6 = 0;
                while (n6 < shape3DRetained.parentList.size()) {
                    object = (TransformGroupRetained)shape3DRetained.parentList.get(n6);
                    ((TransformGroupRetained)object).updateTargets((ArrayList)cloneable, arrayList);
                    ++n6;
                }
            }
            geometryAtomArray2[n4] = geometryAtom;
            geometryAtomArray[n4] = geometryAtom2;
            shape3DRetained.geomAtom = geometryAtom2;
            shape3DRetained.mirrorShape3DLock.writeUnlock();
            ++n4;
        }
        object = VirtualUniverse.mc.getMessage();
        ((J3dMessage)object).type = 24;
        ((J3dMessage)object).threads = 8384;
        ((J3dMessage)object).universe = this.universe;
        ((J3dMessage)object).args[0] = this;
        ((J3dMessage)object).args[1] = new Integer(1);
        ((J3dMessage)object).args[2] = geometryAtomArray2;
        ((J3dMessage)object).args[3] = geometryAtomArray;
        if (this.boundsAutoCompute) {
            this.getCombineBounds((BoundingBox)this.localBounds);
        }
        VirtualUniverse.mc.processMessage((J3dMessage)object);
    }

    Shape3DRetained getMirrorShape(SceneGraphPath sceneGraphPath) {
        if (!this.inSharedGroup) {
            return (Shape3DRetained)this.mirrorShape3D.get(0);
        }
        HashKey hashKey = new HashKey("");
        sceneGraphPath.getHashKey(hashKey);
        return this.getMirrorShape(hashKey);
    }

    Shape3DRetained getMirrorShape(HashKey hashKey) {
        int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (n >= 0) {
            return (Shape3DRetained)this.mirrorShape3D.get(n);
        }
        throw new RuntimeException("Shape3DRetained: MirrorShape Not found!");
    }

    void setBoundsAutoCompute(boolean bl) {
        if (bl != this.boundsAutoCompute) {
            if (bl) {
                this.localBounds = new BoundingBox((Bounds)null);
            }
            this.getCombineBounds((BoundingBox)this.localBounds);
            super.setBoundsAutoCompute(bl);
            if (this.source.isLive()) {
                J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                j3dMessage.type = 37;
                j3dMessage.threads = 8384;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
                j3dMessage.args[1] = this.localBounds;
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
    }

    void updateBounds() {
        this.localBounds = new BoundingBox((Bounds)null);
        this.getCombineBounds((BoundingBox)this.localBounds);
        ArrayList arrayList = this.mirrorShape3D;
        synchronized (arrayList) {
            if (this.source.isLive()) {
                J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                j3dMessage.type = 37;
                j3dMessage.threads = 8384;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
                j3dMessage.args[1] = this.localBounds;
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
    }

    boolean allowIntersect() {
        GeometryRetained geometryRetained = null;
        int n = 0;
        while (n < this.geometryList.size()) {
            geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null && !geometryRetained.source.capabilities.get(18)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean intersectGeometryList(Transform3D transform3D, Transform3D transform3D2, ArrayList arrayList) {
        int n = 0;
        while (n < this.geometryList.size()) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null) {
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    GeometryRetained geometryRetained2 = (GeometryRetained)arrayList.get(n2);
                    if (geometryRetained2 != null && geometryRetained.intersect(transform3D, transform3D2, geometryRetained2)) {
                        return true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return false;
    }

    boolean intersectGeometryList(Transform3D transform3D, Bounds bounds) {
        int n = 0;
        while (n < this.geometryList.size()) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null && geometryRetained.intersect(transform3D, bounds)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void initMirrorShape3D(SetLiveState setLiveState, MorphRetained morphRetained, int n) {
        Object var5_4 = null;
        this.universe = morphRetained.universe;
        this.inSharedGroup = morphRetained.inSharedGroup;
        this.inBackgroundGroup = morphRetained.inBackgroundGroup;
        this.geometryBackground = morphRetained.geometryBackground;
        this.parent = morphRetained.parent;
        this.locale = morphRetained.locale;
        boolean bl = this.inOrderedGroup = setLiveState.inOrderedGroups.get(n) == Boolean.TRUE;
        if (this.inOrderedGroup) {
            this.orderedPath = setLiveState.orderedPaths.getPath(n).clonePath();
        }
        this.staticTransform = morphRetained.staticTransform;
        if (morphRetained.boundsAutoCompute) {
            this.localBounds.set(morphRetained.localBounds);
        }
        this.bounds = this.localBounds;
        if (setLiveState.useSwitchVwcBounds) {
            this.vwcBounds = (BoundingBox)setLiveState.switchVwcBounds.get(n);
            this.useSwitchVwcBounds = true;
        } else {
            this.vwcBounds = new BoundingBox((Bounds)null);
            this.vwcBounds.transform(this.bounds, this.getCurrentLocalToVworld(0));
        }
        if (morphRetained.collisionBound == null) {
            this.collisionBound = null;
            this.collisionVwcBound = this.vwcBounds;
        } else {
            this.collisionBound = morphRetained.collisionBound;
            this.collisionVwcBound = (Bounds)this.collisionBound.clone();
            this.collisionVwcBound.transform(this.getCurrentLocalToVworld(0));
        }
        this.appearanceOverrideEnable = morphRetained.appearanceOverrideEnable;
        this.geometryList = new ArrayList();
        this.geometryList.add((GeometryArrayRetained)morphRetained.morphedGeometryArray.retained);
        GeometryAtom geometryAtom = new GeometryAtom();
        geometryAtom.geometryArray = new GeometryRetained[1];
        geometryAtom.locale = this.locale;
        geometryAtom.visible = morphRetained.visible;
        geometryAtom.source = this;
        GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(0);
        if (geometryRetained == null) {
            geometryAtom.geometryArray[0] = null;
        } else {
            geometryAtom.geometryArray[0] = (GeometryArrayRetained)morphRetained.morphedGeometryArray.retained;
            geometryAtom.geoType = geometryAtom.geometryArray[0].geoType;
        }
        this.geomAtom = geometryAtom;
        this.sourceNode = morphRetained;
    }

    void setMorphGeometry(Geometry geometry, ArrayList arrayList) {
        int n = arrayList.size();
        GeometryAtom[] geometryAtomArray = new GeometryAtom[n];
        GeometryAtom[] geometryAtomArray2 = new GeometryAtom[n];
        ArrayList<GeometryAtom> arrayList2 = new ArrayList<GeometryAtom>(1);
        ArrayList<GeometryAtom> arrayList3 = new ArrayList<GeometryAtom>(1);
        arrayList2.add(null);
        arrayList3.add(null);
        int n2 = 0;
        while (n2 < n) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList.get(n2);
            GeometryAtom geometryAtom = Shape3DRetained.getGeomAtom(shape3DRetained);
            shape3DRetained.geometryList = new ArrayList();
            shape3DRetained.geometryList.add((GeometryArrayRetained)geometry.retained);
            GeometryAtom geometryAtom2 = new GeometryAtom();
            geometryAtom2.geometryArray = new GeometryRetained[1];
            if (geometry == null) {
                geometryAtom2.geometryArray[0] = null;
            } else {
                geometryAtom2.geometryArray[0] = (GeometryArrayRetained)geometry.retained;
                geometryAtom2.geoType = geometryAtom2.geometryArray[0].geoType;
            }
            geometryAtom2.locale = this.locale;
            geometryAtom2.visible = geometryAtom.visible;
            geometryAtom2.source = this;
            geometryAtomArray[n2] = geometryAtom;
            geometryAtomArray2[n2] = geometryAtom2;
            arrayList2.set(0, geometryAtom);
            arrayList3.set(0, geometryAtom2);
            Shape3DRetained.setGeomAtom(shape3DRetained, geometryAtom2);
            if (shape3DRetained.parentList != null) {
                int n3 = 0;
                while (n3 < shape3DRetained.parentList.size()) {
                    TransformGroupRetained transformGroupRetained = (TransformGroupRetained)shape3DRetained.parentList.get(n3);
                    transformGroupRetained.updateTargets(arrayList2, arrayList3);
                    ++n3;
                }
            }
            ++n2;
        }
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.type = 24;
        j3dMessage.threads = 8384;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(1);
        j3dMessage.args[2] = geometryAtomArray;
        j3dMessage.args[3] = geometryAtomArray2;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    static final ArrayList getGeomAtomsList(ArrayList arrayList) {
        ArrayList<GeometryAtom> arrayList2 = new ArrayList<GeometryAtom>();
        Shape3DRetained shape3DRetained = null;
        ArrayList arrayList3 = arrayList;
        synchronized (arrayList3) {
            int n = arrayList.size() - 1;
            while (n >= 0) {
                shape3DRetained = (Shape3DRetained)arrayList.get(n);
                shape3DRetained.mirrorShape3DLock.readLock();
                if (shape3DRetained.geomAtom != null) {
                    arrayList2.add(shape3DRetained.geomAtom);
                }
                shape3DRetained.mirrorShape3DLock.readUnlock();
                --n;
            }
        }
        return arrayList2;
    }

    static final ArrayList getGeomAtomsList(ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<ArrayList<GeometryAtom>> arrayList3 = new ArrayList<ArrayList<GeometryAtom>>();
        ArrayList<GeometryAtom> arrayList4 = null;
        Shape3DRetained shape3DRetained = null;
        boolean bl = false;
        VirtualUniverse virtualUniverse = null;
        ArrayList arrayList5 = arrayList;
        synchronized (arrayList5) {
            int n = arrayList.size() - 1;
            while (n >= 0) {
                shape3DRetained = (Shape3DRetained)arrayList.get(n);
                if (!bl) {
                    if (virtualUniverse == null) {
                        virtualUniverse = shape3DRetained.universe;
                        arrayList2.add(shape3DRetained.universe);
                        arrayList4 = new ArrayList<GeometryAtom>();
                        arrayList3.add(arrayList4);
                    } else if (virtualUniverse != shape3DRetained.universe) {
                        bl = true;
                        arrayList2.add(shape3DRetained.universe);
                        arrayList4 = new ArrayList();
                        arrayList3.add(arrayList4);
                    }
                } else {
                    int n2 = arrayList2.indexOf(shape3DRetained.universe);
                    if (n2 < 0) {
                        arrayList2.add(shape3DRetained.universe);
                        arrayList4 = new ArrayList();
                        arrayList3.add(arrayList4);
                    } else {
                        arrayList4 = (ArrayList<GeometryAtom>)arrayList3.get(n2);
                    }
                }
                shape3DRetained.mirrorShape3DLock.readLock();
                if (shape3DRetained.geomAtom != null) {
                    arrayList4.add(shape3DRetained.geomAtom);
                }
                shape3DRetained.mirrorShape3DLock.readUnlock();
                --n;
            }
        }
        return arrayList3;
    }

    static final ArrayList getGeomAtomsList(Shape3DRetained shape3DRetained) {
        ArrayList<GeometryAtom> arrayList = new ArrayList<GeometryAtom>();
        shape3DRetained.mirrorShape3DLock.readLock();
        if (shape3DRetained.geomAtom != null) {
            arrayList.add(shape3DRetained.geomAtom);
        }
        shape3DRetained.mirrorShape3DLock.readUnlock();
        return arrayList;
    }

    static final GeometryAtom getGeomAtom(Shape3DRetained shape3DRetained) {
        shape3DRetained.mirrorShape3DLock.readLock();
        GeometryAtom geometryAtom = shape3DRetained.geomAtom;
        shape3DRetained.mirrorShape3DLock.readUnlock();
        return geometryAtom;
    }

    static final void setGeomAtom(Shape3DRetained shape3DRetained, GeometryAtom geometryAtom) {
        shape3DRetained.mirrorShape3DLock.writeLock();
        shape3DRetained.geomAtom = geometryAtom;
        shape3DRetained.mirrorShape3DLock.writeUnlock();
    }

    boolean isAlphaEditable(GeometryRetained geometryRetained) {
        boolean bl = false;
        if (this.appearanceOverrideEnable) {
            bl = true;
        } else if (geometryRetained != null && geometryRetained.noAlpha && this.appearance != null) {
            AppearanceRetained appearanceRetained = this.appearance;
            if (this.source.capabilities.get(15) || this.source.capabilities.get(19) || appearanceRetained.source.capabilities.get(13) || appearanceRetained.source.capabilities.get(11) || appearanceRetained.renderingAttributes != null && appearanceRetained.renderingAttributes.source.capabilities.get(3) || appearanceRetained.transparencyAttributes != null && (appearanceRetained.transparencyAttributes.source.capabilities.get(1) || appearanceRetained.transparencyAttributes.source.capabilities.get(3))) {
                bl = true;
            } else if (geometryRetained instanceof GeometryArrayRetained && (appearanceRetained.source.capabilities.get(7) || appearanceRetained.textureAttributes != null && appearanceRetained.textureAttributes.source.capabilities.get(1))) {
                bl = true;
            } else if (geometryRetained instanceof RasterRetained && (((RasterRetained)geometryRetained).type & 1) != 0 && ((RasterRetained)geometryRetained).source.capabilities.get(5)) {
                bl = true;
            }
        }
        return bl;
    }

    void getCombineBounds(BoundingBox boundingBox) {
        if (this.geometryList != null) {
            BoundingBox boundingBox2 = null;
            if (this.staticTransform != null) {
                boundingBox2 = new BoundingBox((Bounds)null);
            }
            BoundingBox boundingBox3 = boundingBox;
            synchronized (boundingBox3) {
                boundingBox.setLower(1.0, 1.0, 1.0);
                boundingBox.setUpper(-1.0, -1.0, -1.0);
                int n = 0;
                while (n < this.geometryList.size()) {
                    GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
                    if (geometryRetained != null && geometryRetained.geoType != -1) {
                        BoundingBox boundingBox4 = geometryRetained.geoBounds;
                        synchronized (boundingBox4) {
                            if (this.staticTransform != null) {
                                boundingBox2.set(geometryRetained.geoBounds);
                                boundingBox2.transform(this.staticTransform.transform);
                                boundingBox.combine(boundingBox2);
                            } else {
                                boundingBox.combine(geometryRetained.geoBounds);
                            }
                        }
                    }
                    ++n;
                }
            }
            if (this instanceof OrientedShape3DRetained) {
                double d = Math.abs(boundingBox.lower.x);
                double d2 = Math.abs(boundingBox.upper.x);
                if (d2 > d) {
                    d = d2;
                }
                if ((d2 = Math.abs(boundingBox.lower.y)) > d) {
                    d = d2;
                }
                if ((d2 = Math.abs(boundingBox.upper.y)) > d) {
                    d = d2;
                }
                if ((d2 = Math.abs(boundingBox.lower.z)) > d) {
                    d = d2;
                }
                if ((d2 = Math.abs(boundingBox.upper.z)) > d) {
                    d = d2;
                }
                boundingBox.setLower(-d, -d, -d);
                boundingBox.setUpper(d, d, d);
            }
        }
    }

    boolean isEquivalent(Shape3DRetained shape3DRetained) {
        if (this.appearance != shape3DRetained.appearance || this.appearanceOverrideEnable != shape3DRetained.appearanceOverrideEnable || this.isPickable != shape3DRetained.isPickable || this.isCollidable != shape3DRetained.isCollidable) {
            return false;
        }
        if (this.boundsAutoCompute) {
            if (!shape3DRetained.boundsAutoCompute) {
                return false;
            }
        } else if (this.localBounds != null) {
            if (shape3DRetained.localBounds != null) {
                return this.localBounds.equals(shape3DRetained.localBounds);
            }
        } else if (shape3DRetained.localBounds != null) {
            return false;
        }
        if (this.collisionBound != null) {
            if (shape3DRetained.collisionBound == null) {
                return false;
            }
            return this.collisionBound.equals(shape3DRetained.collisionBound);
        }
        return shape3DRetained.collisionBound == null;
    }

    void initializeGAtom(Shape3DRetained shape3DRetained, boolean bl) {
        Text3DRetained text3DRetained;
        int n = 0;
        int n2 = this.geometryList.size();
        GeometryRetained geometryRetained = null;
        shape3DRetained.bounds = this.localBounds;
        if (bl) {
            shape3DRetained.vwcBounds = new BoundingBox((Bounds)null);
            shape3DRetained.vwcBounds.transform(shape3DRetained.bounds, shape3DRetained.getCurrentLocalToVworld(0));
        }
        if (this.collisionBound == null) {
            shape3DRetained.collisionBound = null;
            shape3DRetained.collisionVwcBound = shape3DRetained.vwcBounds;
        } else {
            shape3DRetained.collisionBound = this.collisionBound;
            shape3DRetained.collisionVwcBound = (Bounds)shape3DRetained.collisionBound.clone();
            shape3DRetained.collisionVwcBound.transform(shape3DRetained.getCurrentLocalToVworld(0));
        }
        GeometryAtom geometryAtom = new GeometryAtom();
        int n3 = 0;
        while (n3 < n2) {
            geometryRetained = (GeometryRetained)this.geometryList.get(n3);
            if (geometryRetained != null) {
                geometryAtom.geoType = geometryRetained.geoType;
                geometryAtom.alphaEditable = shape3DRetained.isAlphaEditable(geometryRetained);
                break;
            }
            ++n3;
        }
        if (geometryRetained != null && geometryRetained.geoType == 16) {
            n3 = 0;
            while (n3 < n2) {
                geometryRetained = (GeometryRetained)this.geometryList.get(n3);
                if (geometryRetained != null) {
                    text3DRetained = (Text3DRetained)geometryRetained;
                    n += text3DRetained.numChars;
                } else {
                    ++n;
                }
                ++n3;
            }
            geometryAtom.geometryArray = new GeometryRetained[n];
            geometryAtom.lastLocalTransformArray = new Transform3D[n];
            n = 0;
        } else {
            geometryAtom.geometryArray = new GeometryRetained[n2];
        }
        n3 = 0;
        while (n3 < this.geometryList.size()) {
            geometryRetained = (GeometryRetained)this.geometryList.get(n3);
            if (geometryRetained == null) {
                geometryAtom.geometryArray[n3] = null;
            } else if (geometryRetained.geoType == 16) {
                text3DRetained = (Text3DRetained)geometryRetained;
                int n4 = 0;
                while (n4 < text3DRetained.numChars) {
                    if (text3DRetained.font3D.fontData[text3DRetained.charIndex[n4]] != null) {
                        GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)text3DRetained.font3D.fontData[text3DRetained.charIndex[n4]].retained;
                        geometryAtom.geometryArray[n] = geometryArrayRetained;
                        geometryAtom.lastLocalTransformArray[n] = text3DRetained.charTransforms[n4];
                    } else {
                        geometryAtom.geometryArray[n] = null;
                        geometryAtom.lastLocalTransformArray[n] = null;
                    }
                    ++n4;
                    ++n;
                }
            } else {
                geometryAtom.geometryArray[n3] = geometryRetained;
            }
            ++n3;
        }
        geometryAtom.locale = shape3DRetained.locale;
        geometryAtom.visible = this.visible;
        geometryAtom.source = shape3DRetained;
        shape3DRetained.geomAtom = geometryAtom;
    }
}

