/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;

public class RotationInterpolator
extends Interpolator {
    TransformGroup target;
    Transform3D axis = new Transform3D();
    Transform3D axisInverse = new Transform3D();
    float minimumAngle;
    float maximumAngle;
    Transform3D rotation = new Transform3D();
    Transform3D temp = new Transform3D();
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    RotationInterpolator() {
    }

    public RotationInterpolator(Alpha alpha, TransformGroup transformGroup) {
        super(alpha);
        this.target = transformGroup;
        this.axis.setIdentity();
        this.axisInverse.setIdentity();
        this.minimumAngle = 0.0f;
        this.maximumAngle = (float)Math.PI * 2;
    }

    public RotationInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float f, float f2) {
        super(alpha);
        this.target = transformGroup;
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
        this.minimumAngle = f;
        this.maximumAngle = f2;
    }

    public void setMinimumAngle(float f) {
        this.minimumAngle = f;
    }

    public float getMinimumAngle() {
        return this.minimumAngle;
    }

    public void setMaximumAngle(float f) {
        this.maximumAngle = f;
    }

    public float getMaximumAngle() {
        return this.maximumAngle;
    }

    public void setAxisOfRotation(Transform3D transform3D) {
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
    }

    public Transform3D getAxisOfRotation() {
        return this.axis;
    }

    public void setTarget(TransformGroup transformGroup) {
        this.target = transformGroup;
    }

    public TransformGroup getTarget() {
        return this.target;
    }

    public void processStimulus(Enumeration enumeration) {
        WakeupCriterion wakeupCriterion = this.passiveWakeupCriterion;
        if (this.alpha != null) {
            float f = this.alpha.value();
            if (f != this.prevAlphaValue) {
                double d = (1.0 - (double)f) * (double)this.minimumAngle + (double)(f * this.maximumAngle);
                this.rotation.rotY(d);
                this.temp.mul(this.axis, this.rotation);
                this.temp.mul(this.temp, this.axisInverse);
                this.target.setTransform(this.temp);
                this.prevAlphaValue = f;
            }
            if (!this.alpha.finished()) {
                wakeupCriterion = this.defaultWakeupCriterion;
            }
        }
        this.wakeupOn(wakeupCriterion);
    }

    public Node cloneNode(boolean bl) {
        RotationInterpolator rotationInterpolator = new RotationInterpolator();
        rotationInterpolator.duplicateNode(this, bl);
        return rotationInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        RotationInterpolator rotationInterpolator = (RotationInterpolator)node;
        this.setAxisOfRotation(rotationInterpolator.getAxisOfRotation());
        this.setMinimumAngle(rotationInterpolator.getMinimumAngle());
        this.setMaximumAngle(rotationInterpolator.getMaximumAngle());
        this.setTarget(rotationInterpolator.getTarget());
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        TransformGroup transformGroup = this.getTarget();
        if (transformGroup != null) {
            this.setTarget((TransformGroup)nodeReferenceTable.getNewObjectReference(transformGroup));
        }
    }
}

