/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

class RenderingAttributesRetained
extends NodeComponentRetained {
    static final int DEPTH_ENABLE_CHANGED = 1;
    static final int DEPTH_WRITE_ENABLE_CHANGED = 2;
    static final int ALPHA_TEST_VALUE_CHANGED = 4;
    static final int ALPHA_TEST_FUNC_CHANGED = 8;
    static final int VISIBLE_CHANGED = 16;
    static final int IGNORE_VCOLOR_CHANGED = 32;
    static final int RASTER_OP_ENABLE_CHANGED = 64;
    static final int RASTER_OP_VALUE_CHANGED = 128;
    boolean depthBufferEnable = true;
    boolean depthBufferWriteEnable = true;
    float alphaTestValue = 0.0f;
    int alphaTestFunction = 0;
    boolean visible = true;
    boolean ignoreVertexColors = false;
    boolean rasterOpEnable = false;
    int rasterOp = 3;
    static final int LESS = 0;
    static final int LEQUAL = 1;

    RenderingAttributesRetained() {
    }

    final void initVisible(boolean bl) {
        this.visible = bl;
    }

    final void setVisible(boolean bl) {
        this.initVisible(bl);
        this.sendMessage(16, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getVisible() {
        return this.visible;
    }

    final void initIgnoreVertexColors(boolean bl) {
        this.ignoreVertexColors = bl;
    }

    final void setIgnoreVertexColors(boolean bl) {
        this.initIgnoreVertexColors(bl);
        this.sendMessage(32, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getIgnoreVertexColors() {
        return this.ignoreVertexColors;
    }

    final void initDepthBufferEnable(boolean bl) {
        this.depthBufferEnable = bl;
    }

    final void setDepthBufferEnable(boolean bl) {
        this.initDepthBufferEnable(bl);
        this.sendMessage(1, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getDepthBufferEnable() {
        return this.depthBufferEnable;
    }

    final void initDepthBufferWriteEnable(boolean bl) {
        this.depthBufferWriteEnable = bl;
    }

    final void setDepthBufferWriteEnable(boolean bl) {
        this.initDepthBufferWriteEnable(bl);
        this.sendMessage(2, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getDepthBufferWriteEnable() {
        return this.depthBufferWriteEnable;
    }

    final void initAlphaTestValue(float f) {
        this.alphaTestValue = f;
    }

    final void setAlphaTestValue(float f) {
        this.initAlphaTestValue(f);
        this.sendMessage(4, new Float(f));
    }

    final float getAlphaTestValue() {
        return this.alphaTestValue;
    }

    final void initAlphaTestFunction(int n) {
        this.alphaTestFunction = n;
    }

    final void setAlphaTestFunction(int n) {
        this.initAlphaTestFunction(n);
        this.sendMessage(8, new Integer(n));
    }

    final int getAlphaTestFunction() {
        return this.alphaTestFunction;
    }

    final void initRasterOpEnable(boolean bl) {
        this.rasterOpEnable = bl;
    }

    final void setRasterOpEnable(boolean bl) {
        this.initRasterOpEnable(bl);
        this.sendMessage(64, new Boolean(bl));
    }

    final boolean getRasterOpEnable() {
        return this.rasterOpEnable;
    }

    final void initRasterOp(int n) {
        this.rasterOp = n;
    }

    final void setRasterOp(int n) {
        this.initRasterOp(n);
        this.sendMessage(128, new Integer(n));
    }

    final int getRasterOp() {
        return this.rasterOp;
    }

    native void updateNative(int var1, boolean var2, boolean var3, boolean var4, boolean var5, float var6, int var7, boolean var8, boolean var9, int var10);

    void updateNative(int n, boolean bl, boolean bl2) {
        this.updateNative(n, bl, bl2, this.depthBufferEnable, this.depthBufferWriteEnable, this.alphaTestValue, this.alphaTestFunction, this.ignoreVertexColors, this.rasterOpEnable, this.rasterOp);
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                RenderingAttributesRetained renderingAttributesRetained = new RenderingAttributesRetained();
                renderingAttributesRetained.set(this);
                renderingAttributesRetained.source = this.source;
                this.mirror = renderingAttributesRetained;
            }
        } else {
            ((RenderingAttributesRetained)this.mirror).set(this);
        }
    }

    synchronized void initMirrorObject() {
        ((RenderingAttributesRetained)this.mirror).set(this);
    }

    synchronized void updateMirrorObject(int n, Object object) {
        RenderingAttributesRetained renderingAttributesRetained = (RenderingAttributesRetained)this.mirror;
        if ((n & 1) != 0) {
            renderingAttributesRetained.depthBufferEnable = (Boolean)object;
        } else if ((n & 2) != 0) {
            renderingAttributesRetained.depthBufferWriteEnable = (Boolean)object;
        } else if ((n & 4) != 0) {
            renderingAttributesRetained.alphaTestValue = ((Float)object).floatValue();
        } else if ((n & 8) != 0) {
            renderingAttributesRetained.alphaTestFunction = (Integer)object;
        } else if ((n & 0x10) != 0) {
            renderingAttributesRetained.visible = (Boolean)object;
        } else if ((n & 0x20) != 0) {
            renderingAttributesRetained.ignoreVertexColors = (Boolean)object;
        } else if ((n & 0x40) != 0) {
            renderingAttributesRetained.rasterOpEnable = (Boolean)object;
        } else if ((n & 0x80) != 0) {
            renderingAttributesRetained.rasterOp = (Integer)object;
        }
    }

    boolean equivalent(RenderingAttributesRetained renderingAttributesRetained) {
        return this == renderingAttributesRetained || renderingAttributesRetained != null && renderingAttributesRetained.depthBufferEnable == this.depthBufferEnable && renderingAttributesRetained.depthBufferWriteEnable == this.depthBufferWriteEnable && renderingAttributesRetained.alphaTestValue == this.alphaTestValue && renderingAttributesRetained.alphaTestFunction == this.alphaTestFunction && renderingAttributesRetained.visible == this.visible && renderingAttributesRetained.ignoreVertexColors == this.ignoreVertexColors && renderingAttributesRetained.rasterOpEnable == this.rasterOpEnable && renderingAttributesRetained.rasterOp == this.rasterOp;
    }

    protected void set(RenderingAttributesRetained renderingAttributesRetained) {
        this.depthBufferEnable = renderingAttributesRetained.depthBufferEnable;
        this.depthBufferWriteEnable = renderingAttributesRetained.depthBufferWriteEnable;
        this.alphaTestValue = renderingAttributesRetained.alphaTestValue;
        this.alphaTestFunction = renderingAttributesRetained.alphaTestFunction;
        this.visible = renderingAttributesRetained.visible;
        this.ignoreVertexColors = renderingAttributesRetained.ignoreVertexColors;
        this.rasterOpEnable = renderingAttributesRetained.rasterOpEnable;
        this.rasterOp = renderingAttributesRetained.rasterOp;
    }

    final void sendMessage(int n, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 10;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            if (n == 16) {
                j3dMessage.threads |= 0x40;
            }
            j3dMessage.type = 10;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(n2);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            j3dMessage.args[3] = arrayList2.get(n2);
            VirtualUniverse.mc.processMessage(j3dMessage);
            ++n2;
        }
    }
}

