/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Appearance;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.Background;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.DrawingSurfaceObject;
import javax.media.j3d.Fog;
import javax.media.j3d.Geometry;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dThread;
import javax.media.j3d.Light;
import javax.media.j3d.ModelClip;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Raster;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RendererStructure;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Sound;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

class Renderer
extends J3dThread {
    int objectId = -1;
    static final int WAIT = 0;
    static final int NOTIFY_AND_WAIT = 1;
    static final int NOTIFY = 2;
    static final int DECAL_NONE = 0;
    static final int DECAL_1ST_CHILD = 1;
    static final int DECAL_NTH_CHILD = 2;
    static final int NUM_ACCUMULATION_SAMPLES = 8;
    static final float[] ACCUM_SAMPLES_X = new float[]{-0.54818f, 0.56438f, 0.39462f, -0.54498f, -0.8379f, -0.39263f, 0.32254f, 0.84216f};
    static final float[] ACCUM_SAMPLES_Y = new float[]{0.55331f, -0.53495f, 0.4154f, -0.52829f, 0.82102f, -0.27383f, 0.09133f, -0.84399f};
    static final float accumValue = 0.125f;
    static final int RENDER = 0;
    static final int SWAP = 1;
    static final int RESOURCE = 2;
    static final int REQUESTRENDER = 3;
    static final int REQUESTCLEANUP = 4;
    RendererStructure rendererStructure = new RendererStructure();
    Transform3D bgVworldToVpc = new Transform3D();
    long lasttime;
    long currtime;
    float numframes = 0.0f;
    static final boolean doTiming = false;
    private static int numInstances = 0;
    private int instanceNum = -1;
    boolean sharedStereoZBuffer;
    int sharedCtx = 0;
    long sharedCtxTimeStamp = 0L;
    private int display;
    int rendererBit = 0;
    ArrayList dirtyRenderMoleculeList = new ArrayList();
    ArrayList dirtyRenderAtomList = new ArrayList();
    ArrayList textureIdResourceFreeList = new ArrayList();
    ArrayList displayListResourceFreeList = new ArrayList();
    CanvasViewCache copyOfCvCache = new CanvasViewCache(null, null, null);
    J3dMessage[] renderMessage;
    Screen3D onScreen;
    Screen3D offScreen;
    double[] accumLeftProjMat = new double[16];
    double[] accumRightProjMat = new double[16];
    double[] accumInfLeftProjMat = new double[16];
    double[] accumInfRightProjMat = new double[16];
    J3dMessage[] m;
    int nmesg = 0;
    ArrayList listOfCtxs = new ArrayList();
    ArrayList listOfCanvases = new ArrayList();
    boolean needToRebuildDisplayList = false;
    boolean needToResendTextureDown = false;

    native void freeContext(int var1, int var2);

    native void D3DCleanUp();

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    Renderer(ThreadGroup threadGroup) {
        super(threadGroup);
        this.setName("J3D-Renderer-" + this.getInstanceNum());
        this.type = 16;
        this.rendererBit = VirtualUniverse.mc.getRendererBit();
        this.renderMessage = new J3dMessage[1];
    }

    void doWork(long l) {
        block143: {
            RenderBin renderBin = null;
            Canvas3D canvas3D = null;
            View view = null;
            int n = 1;
            boolean bl = false;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 1.0f;
            float f4 = 1.0f;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            boolean bl2 = true;
            boolean bl3 = false;
            Transform3D transform3D = null;
            int n2 = (Integer)this.args[0];
            try {
                if (n2 == 1) {
                    bl2 = VirtualUniverse.mc.doDsiRenderLock;
                    Object[] objectArray = (Object[])this.args[2];
                    view = (View)this.args[3];
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        block142: {
                            Canvas3D canvas3D2 = (Canvas3D)objectArray[n3];
                            if (canvas3D2.isRunning) {
                                try {
                                    if (!canvas3D2.active || canvas3D2.ctx == 0 || canvas3D2.view == null || !canvas3D2.imageReady) break block142;
                                    if (canvas3D2.useDoubleBuffer) {
                                        DrawingSurfaceObject drawingSurfaceObject = canvas3D2.drawingSurfaceObject;
                                        synchronized (drawingSurfaceObject) {
                                            if (canvas3D2.validCtx) {
                                                if (!canvas3D2.drawingSurfaceObject.renderLock(bl2)) {
                                                    break block142;
                                                }
                                                canvas3D2.syncRender(canvas3D2.ctx, true);
                                                canvas3D2.swapBuffers(canvas3D2.ctx, canvas3D2.screen.display, canvas3D2.window);
                                                canvas3D2.drawingSurfaceObject.unLock(bl2);
                                            }
                                        }
                                    }
                                    canvas3D2.view.inCanvasCallback = true;
                                    try {
                                        canvas3D2.postSwap();
                                    }
                                    catch (RuntimeException runtimeException) {
                                        System.err.println("Exception occurred during Canvas3D callback:");
                                        runtimeException.printStackTrace();
                                    }
                                    canvas3D2.imageReady = false;
                                    canvas3D2.view.inCanvasCallback = false;
                                    if (!canvas3D2.ctxChanged) {
                                        canvas3D2.canvasDirty = 7743;
                                        canvas3D2.modelMatrix = null;
                                        canvas3D2.ra = null;
                                    } else {
                                        canvas3D2.ctxChanged = false;
                                    }
                                }
                                catch (NullPointerException nullPointerException) {
                                    canvas3D2.drawingSurfaceObject.unLock(bl2);
                                }
                            }
                        }
                        ++n3;
                    }
                    if (view != null && view.viewCache.getDoHeadTracking()) {
                        VirtualUniverse.mc.sendRunMessage(view, 16);
                    }
                    break block143;
                }
                if (n2 == 4) {
                    Canvas3D canvas3D3 = (Canvas3D)this.args[1];
                    if (canvas3D3 == null) {
                        this.removeAllCtxs();
                    } else {
                        this.removeCtx(canvas3D3);
                    }
                    return;
                }
                this.nmesg = 0;
                int n4 = 0;
                if (n2 == 0) {
                    this.m = this.renderMessage;
                    this.m[0] = VirtualUniverse.mc.getMessage();
                    this.m[0].type = 43;
                    this.m[0].incRefcount();
                    this.m[0].args[0] = this.args[1];
                    n4 = 1;
                } else {
                    this.m = this.rendererStructure.getMessages();
                    if (this.m == null) {
                        return;
                    }
                    bl2 = false;
                    n4 = this.rendererStructure.getNumMessage();
                }
                while (this.nmesg < n4) {
                    int n5;
                    int n6;
                    boolean bl4;
                    Object object;
                    canvas3D = (Canvas3D)this.m[this.nmesg].args[0];
                    int n7 = this.m[this.nmesg].type;
                    if (canvas3D.view == null || !canvas3D.firstPaintCalled) {
                        if (n7 == 42) {
                            canvas3D.offScreenRendering = false;
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (n7 == 44) {
                        int n8 = (Integer)this.m[this.nmesg].args[1];
                        if (this.needToResendTextureDown) {
                            ++VirtualUniverse.mc.resendTexTimestamp;
                            this.needToResendTextureDown = false;
                        }
                        switch (n8) {
                            case 0: {
                                canvas3D.graphicsContext3D.doClear();
                                break;
                            }
                            case 1: {
                                canvas3D.graphicsContext3D.doDraw((Geometry)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 2: {
                                canvas3D.doSwap();
                                break;
                            }
                            case 3: {
                                canvas3D.graphicsContext3D.doReadRaster((Raster)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 4: {
                                canvas3D.graphicsContext3D.doSetAppearance((Appearance)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 5: {
                                canvas3D.graphicsContext3D.doSetBackground((Background)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 6: {
                                canvas3D.graphicsContext3D.doSetFog((Fog)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 7: {
                                canvas3D.graphicsContext3D.doSetLight((Light)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 8: {
                                canvas3D.graphicsContext3D.doInsertLight((Light)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 9: {
                                canvas3D.graphicsContext3D.doRemoveLight((Integer)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 10: {
                                canvas3D.graphicsContext3D.doAddLight((Light)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 11: {
                                canvas3D.graphicsContext3D.doSetHiRes((HiResCoord)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 12: {
                                transform3D = (Transform3D)this.m[this.nmesg].args[2];
                                canvas3D.graphicsContext3D.doSetModelTransform(transform3D);
                                VirtualUniverse.mc.addToTransformFreeList(transform3D);
                                break;
                            }
                            case 13: {
                                transform3D = (Transform3D)this.m[this.nmesg].args[2];
                                canvas3D.graphicsContext3D.doMultiplyModelTransform(transform3D);
                                VirtualUniverse.mc.addToTransformFreeList(transform3D);
                                break;
                            }
                            case 14: {
                                canvas3D.graphicsContext3D.doSetSound((Sound)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 15: {
                                canvas3D.graphicsContext3D.doInsertSound((Sound)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 16: {
                                canvas3D.graphicsContext3D.doRemoveSound((Integer)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 17: {
                                canvas3D.graphicsContext3D.doAddSound((Sound)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 18: {
                                canvas3D.graphicsContext3D.doSetAuralAttributes((AuralAttributes)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 19: {
                                canvas3D.graphicsContext3D.doSetBufferOverride((Boolean)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 20: {
                                canvas3D.graphicsContext3D.doSetFrontBufferRendering((Boolean)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 21: {
                                canvas3D.graphicsContext3D.doSetStereoMode((Integer)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 22: {
                                canvas3D.graphicsContext3D.doFlush((Boolean)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 23: {
                                canvas3D.graphics2D.doFlush();
                                break;
                            }
                            case 24: {
                                canvas3D.graphicsContext3D.doSetModelClip((ModelClip)this.m[this.nmesg].args[2]);
                                break;
                            }
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    this.m[this.nmesg++].decRefcount();
                    if (!(n7 != 42 || canvas3D.window != 0 && canvas3D.active)) {
                        canvas3D.offScreenRendering = false;
                        continue;
                    }
                    if (!canvas3D.active) continue;
                    renderBin = canvas3D.view.renderBin;
                    if (!canvas3D.drawingSurfaceObject.contextLock(bl2)) break;
                    if (canvas3D.useSharedCtx && this.sharedCtx == 0) {
                        this.display = canvas3D.screen.display;
                        Object object2 = VirtualUniverse.mc.contextCreationLock;
                        synchronized (object2) {
                            this.sharedCtx = canvas3D.createContext(canvas3D.screen.display, canvas3D.window, canvas3D.vid, 0, canvas3D.offScreen);
                            this.sharedCtxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
                            this.needToRebuildDisplayList = true;
                        }
                    }
                    if (canvas3D.ctx == 0) {
                        Object object3 = VirtualUniverse.mc.contextCreationLock;
                        synchronized (object3) {
                            canvas3D.ctx = canvas3D.createContext(canvas3D.screen.display, canvas3D.window, canvas3D.vid, this.sharedCtx, canvas3D.offScreen);
                            canvas3D.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
                            this.listOfCtxs.add(new Integer(canvas3D.ctx));
                            this.listOfCanvases.add(canvas3D);
                            if (renderBin.nodeComponentList.size() > 0) {
                                int n9 = 0;
                                while (n9 < renderBin.nodeComponentList.size()) {
                                    object = (NodeComponentRetained)renderBin.nodeComponentList.get(n9);
                                    ((NodeComponentRetained)object).evaluateExtensions(canvas3D.extensionsSupported);
                                    ++n9;
                                }
                            }
                            if (canvas3D.multiTexAccelerated) {
                                canvas3D.numTexUnitSupported = canvas3D.getTextureUnitCount(canvas3D.ctx);
                            }
                        }
                        canvas3D.resetImmediateRendering(0);
                        if (!canvas3D.useSharedCtx) {
                            this.needToRebuildDisplayList = true;
                        }
                    } else if (canvas3D.isRunning) {
                        canvas3D.makeCtxCurrent();
                    }
                    canvas3D.drawingSurfaceObject.unLock(bl2);
                    if (renderBin == null) continue;
                    if (this.needToResendTextureDown) {
                        ++VirtualUniverse.mc.resendTexTimestamp;
                        this.needToResendTextureDown = false;
                    }
                    if (canvas3D.useSharedCtx) {
                        if (this.textureIdResourceFreeList.size() > 0 || this.displayListResourceFreeList.size() > 0) {
                            RenderBin.freeResource(canvas3D, this.displayListResourceFreeList, this.textureIdResourceFreeList, true);
                            this.textureIdResourceFreeList.clear();
                            this.displayListResourceFreeList.clear();
                        }
                    } else if (canvas3D.textureIdResourceFreeList.size() > 0 || canvas3D.displayListResourceFreeList.size() > 0) {
                        RenderBin.freeResource(canvas3D, canvas3D.displayListResourceFreeList, canvas3D.textureIdResourceFreeList, false);
                        canvas3D.textureIdResourceFreeList.clear();
                        canvas3D.displayListResourceFreeList.clear();
                    }
                    canvas3D.updateViewCache(false, this.copyOfCvCache, null, renderBin.geometryBackground != null);
                    boolean bl5 = bl2 = bl2 && VirtualUniverse.mc.doDsiRenderLock;
                    if (!canvas3D.drawingSurfaceObject.renderLock(bl2)) break;
                    canvas3D.setViewport(canvas3D.ctx, 0, 0, this.copyOfCvCache.getCanvasWidth(), this.copyOfCvCache.getCanvasHeight());
                    if (canvas3D.useSharedCtx) {
                        if (this.needToRebuildDisplayList) {
                            renderBin.updateAllRenderMolecule(this, canvas3D);
                            this.needToRebuildDisplayList = false;
                        } else if (this.dirtyRenderMoleculeList.size() > 0 || this.dirtyRenderAtomList.size() > 0) {
                            renderBin.updateDirtyDisplayLists(canvas3D, this.dirtyRenderMoleculeList, this.dirtyRenderAtomList, true);
                        }
                        this.dirtyRenderMoleculeList.clear();
                        this.dirtyRenderAtomList.clear();
                    } else {
                        if (this.needToRebuildDisplayList) {
                            renderBin.updateAllRenderMolecule(canvas3D);
                            this.needToRebuildDisplayList = false;
                        } else if (canvas3D.dirtyRenderMoleculeList.size() > 0 || canvas3D.dirtyRenderAtomList.size() > 0) {
                            renderBin.updateDirtyDisplayLists(canvas3D, canvas3D.dirtyRenderMoleculeList, canvas3D.dirtyRenderAtomList, false);
                        }
                        canvas3D.dirtyRenderMoleculeList.clear();
                        canvas3D.dirtyRenderAtomList.clear();
                    }
                    if (canvas3D.localEyeLightingEnable != canvas3D.ctxEyeLightingEnable) {
                        canvas3D.ctxUpdateEyeLightingEnable(canvas3D.ctx, canvas3D.localEyeLightingEnable);
                        canvas3D.ctxEyeLightingEnable = canvas3D.localEyeLightingEnable;
                    }
                    if (bl4 = this.copyOfCvCache.getUseStereo()) {
                        n6 = 2;
                        n5 = 0;
                        this.sharedStereoZBuffer = VirtualUniverse.mc.sharedStereoZBuffer;
                    } else {
                        n6 = 1;
                        n5 = 2;
                        this.sharedStereoZBuffer = false;
                    }
                    if (canvas3D.view.getSceneAntialiasingEnable() && canvas3D.sceneAntialiasingAvailable) {
                        if (!VirtualUniverse.mc.isD3D()) {
                            bl = true;
                            n = 8;
                            System.arraycopy(this.copyOfCvCache.getLeftProjection().mat, 0, this.accumLeftProjMat, 0, 16);
                            f3 = (float)canvas3D.canvasViewCache.getPhysicalWindowWidth() / (float)canvas3D.canvasViewCache.getCanvasWidth();
                            f4 = (float)canvas3D.canvasViewCache.getPhysicalWindowHeight() / (float)canvas3D.canvasViewCache.getCanvasHeight();
                            d = this.accumLeftProjMat[3];
                            d2 = this.accumLeftProjMat[7];
                            if (bl4) {
                                System.arraycopy(this.copyOfCvCache.getRightProjection().mat, 0, this.accumRightProjMat, 0, 16);
                                d3 = this.accumRightProjMat[3];
                                d4 = this.accumRightProjMat[7];
                            }
                            if (renderBin.geometryBackground != null) {
                                System.arraycopy(this.copyOfCvCache.getInfLeftProjection().mat, 0, this.accumInfLeftProjMat, 0, 16);
                                d5 = this.accumInfLeftProjMat[3];
                                d6 = this.accumInfLeftProjMat[7];
                                if (bl4) {
                                    System.arraycopy(this.copyOfCvCache.getInfRightProjection().mat, 0, this.accumInfRightProjMat, 0, 16);
                                    d7 = this.accumInfRightProjMat[3];
                                    d8 = this.accumInfRightProjMat[7];
                                }
                            }
                        } else if (!canvas3D.d3dAntialiasingSet) {
                            canvas3D.setFullSceneAntialiasing(canvas3D.ctx, true);
                            canvas3D.d3dAntialiasingSet = true;
                        }
                    } else if (canvas3D.d3dAntialiasingSet) {
                        canvas3D.setFullSceneAntialiasing(canvas3D.ctx, false);
                        canvas3D.d3dAntialiasingSet = false;
                    }
                    if (renderBin.geometryBackground != null) {
                        renderBin.updateInfVworldToVpc();
                    }
                    canvas3D.setRenderMode(canvas3D.ctx, 2, canvas3D.useDoubleBuffer);
                    if (!bl && !this.sharedStereoZBuffer) {
                        if (VirtualUniverse.mc.isJ3dG2dDrawPixel) {
                            canvas3D.clear(canvas3D.ctx, renderBin.background.color.x, renderBin.background.color.y, renderBin.background.color.z, renderBin.background.image);
                        } else {
                            if (this.objectId == -1) {
                                this.objectId = VirtualUniverse.mc.getTexture2DId();
                            }
                            canvas3D.textureclear(canvas3D.ctx, renderBin.background.xmax, renderBin.background.ymax, renderBin.background.color.x, renderBin.background.color.y, renderBin.background.color.z, this.objectId, renderBin.background.texImage);
                        }
                    }
                    canvas3D.drawingSurfaceObject.unLock(bl2);
                    canvas3D.view.inCanvasCallback = true;
                    try {
                        canvas3D.preRender();
                    }
                    catch (RuntimeException runtimeException) {
                        System.err.println("Exception occurred during Canvas3D callback:");
                        runtimeException.printStackTrace();
                    }
                    canvas3D.view.inCanvasCallback = false;
                    if (!canvas3D.drawingSurfaceObject.renderLock(bl2)) break;
                    int n10 = 0;
                    while (n10 < n6) {
                        if (bl) {
                            canvas3D.clearAccum(canvas3D.ctx);
                        }
                        canvas3D.setRenderMode(canvas3D.ctx, n5, canvas3D.useDoubleBuffer);
                        int n11 = 0;
                        while (n11 < n) {
                            if (bl) {
                                f = ACCUM_SAMPLES_X[n11] * f3;
                                f2 = ACCUM_SAMPLES_Y[n11] * f4;
                                this.accumLeftProjMat[3] = d + this.accumLeftProjMat[0] * (double)f + this.accumLeftProjMat[1] * (double)f2;
                                this.accumLeftProjMat[7] = d2 + this.accumLeftProjMat[4] * (double)f + this.accumLeftProjMat[5] * (double)f2;
                                if (bl4) {
                                    this.accumRightProjMat[3] = d3 + this.accumRightProjMat[0] * (double)f + this.accumRightProjMat[1] * (double)f2;
                                    this.accumRightProjMat[7] = d4 + this.accumRightProjMat[4] * (double)f + this.accumRightProjMat[5] * (double)f2;
                                }
                                if (renderBin.geometryBackground != null) {
                                    this.accumInfLeftProjMat[3] = d5 + this.accumInfLeftProjMat[0] * (double)f + this.accumInfLeftProjMat[1] * (double)f2;
                                    this.accumInfLeftProjMat[7] = d6 + this.accumInfLeftProjMat[4] * (double)f + this.accumInfLeftProjMat[5] * (double)f2;
                                    if (bl4) {
                                        this.accumInfRightProjMat[3] = d7 + this.accumInfRightProjMat[0] * (double)f + this.accumInfRightProjMat[1] * (double)f2;
                                        this.accumInfRightProjMat[7] = d8 + this.accumInfRightProjMat[4] * (double)f + this.accumInfRightProjMat[5] * (double)f2;
                                    }
                                }
                            }
                            if (bl || this.sharedStereoZBuffer) {
                                if (VirtualUniverse.mc.isJ3dG2dDrawPixel) {
                                    canvas3D.clear(canvas3D.ctx, renderBin.background.color.x, renderBin.background.color.y, renderBin.background.color.z, renderBin.background.image);
                                } else {
                                    if (this.objectId == -1) {
                                        this.objectId = VirtualUniverse.mc.getTexture2DId();
                                    }
                                    canvas3D.textureclear(canvas3D.ctx, renderBin.background.xmax, renderBin.background.ymax, renderBin.background.color.x, renderBin.background.color.y, renderBin.background.color.z, this.objectId, renderBin.background.texImage);
                                }
                            }
                            if (renderBin.geometryBackground != null) {
                                if (n10 == 0) {
                                    canvas3D.vpcToEc = this.copyOfCvCache.getInfLeftVpcToEc();
                                    if (bl) {
                                        canvas3D.setProjectionMatrix(canvas3D.ctx, this.accumInfLeftProjMat);
                                    } else {
                                        canvas3D.setProjectionMatrix(canvas3D.ctx, this.copyOfCvCache.getInfLeftProjection().mat);
                                    }
                                } else {
                                    canvas3D.vpcToEc = this.copyOfCvCache.getInfRightVpcToEc();
                                    if (bl) {
                                        canvas3D.setProjectionMatrix(canvas3D.ctx, this.accumInfRightProjMat);
                                    } else {
                                        canvas3D.setProjectionMatrix(canvas3D.ctx, this.copyOfCvCache.getInfRightProjection().mat);
                                    }
                                }
                                canvas3D.vworldToEc.mul(canvas3D.vpcToEc, this.copyOfCvCache.getInfVworldToVpc());
                                renderBin.renderBackground(canvas3D);
                            }
                            if (n10 == 0) {
                                canvas3D.vpcToEc = this.copyOfCvCache.getLeftVpcToEc();
                                if (bl) {
                                    canvas3D.setProjectionMatrix(canvas3D.ctx, this.accumLeftProjMat);
                                } else {
                                    canvas3D.setProjectionMatrix(canvas3D.ctx, this.copyOfCvCache.getLeftProjection().mat);
                                }
                            } else {
                                canvas3D.vpcToEc = this.copyOfCvCache.getRightVpcToEc();
                                if (bl) {
                                    canvas3D.setProjectionMatrix(canvas3D.ctx, this.accumRightProjMat);
                                } else {
                                    canvas3D.setProjectionMatrix(canvas3D.ctx, this.copyOfCvCache.getRightProjection().mat);
                                }
                            }
                            canvas3D.vworldToEc.mul(canvas3D.vpcToEc, this.copyOfCvCache.getVworldToVpc());
                            object = this.copyOfCvCache;
                            synchronized (object) {
                                if (n10 == 0) {
                                    canvas3D.setFrustumPlanes(this.copyOfCvCache.getLeftFrustumPlanesInVworld());
                                } else {
                                    canvas3D.setFrustumPlanes(this.copyOfCvCache.getRightFrustumPlanesInVworld());
                                }
                            }
                            renderBin.renderOpaque(canvas3D);
                            renderBin.renderOrdered(canvas3D);
                            canvas3D.drawingSurfaceObject.unLock(bl2);
                            canvas3D.view.inCanvasCallback = true;
                            try {
                                canvas3D.renderField(n5);
                            }
                            catch (RuntimeException runtimeException) {
                                System.err.println("Exception occurred during Canvas3D callback:");
                                runtimeException.printStackTrace();
                            }
                            canvas3D.view.inCanvasCallback = false;
                            if (canvas3D.drawingSurfaceObject.renderLock(bl2)) {
                                renderBin.renderTransparent(canvas3D);
                                if (bl) {
                                    canvas3D.accum(canvas3D.ctx, 0.125f);
                                }
                                ++n11;
                                continue;
                            }
                            break block143;
                        }
                        if (bl) {
                            canvas3D.accumReturn(canvas3D.ctx);
                        }
                        if (bl4) {
                            n5 = 1;
                            canvas3D.rightStereoPass = true;
                        }
                        ++n10;
                    }
                    canvas3D.imageReady = true;
                    canvas3D.rightStereoPass = false;
                    canvas3D.setRenderMode(canvas3D.ctx, 2, canvas3D.useDoubleBuffer);
                    canvas3D.drawingSurfaceObject.unLock(bl2);
                    canvas3D.view.inCanvasCallback = true;
                    try {
                        canvas3D.postRender();
                    }
                    catch (RuntimeException runtimeException) {
                        System.err.println("Exception occurred during Canvas3D callback:");
                        runtimeException.printStackTrace();
                    }
                    canvas3D.view.inCanvasCallback = false;
                    if (!canvas3D.offScreenRendering) continue;
                    canvas3D.syncRender(canvas3D.ctx, true);
                    canvas3D.endOffScreenRendering();
                    canvas3D.view.inCanvasCallback = true;
                    try {
                        canvas3D.postSwap();
                    }
                    catch (RuntimeException runtimeException) {
                        System.err.println("Exception occurred during Canvas 3D callback:");
                        runtimeException.printStackTrace();
                    }
                    canvas3D.offScreenRendering = false;
                    canvas3D.view.inCanvasCallback = false;
                }
            }
            catch (NullPointerException nullPointerException) {
                if (canvas3D == null) break block143;
                canvas3D.drawingSurfaceObject.unLock(bl2);
            }
        }
    }

    void shutdown() {
        this.removeAllCtxs();
        if (VirtualUniverse.mc.isD3D()) {
            this.D3DCleanUp();
        }
    }

    void cleanup() {
        super.cleanup();
        this.renderMessage = new J3dMessage[1];
        this.rendererStructure = new RendererStructure();
        this.bgVworldToVpc = new Transform3D();
        this.numframes = 0.0f;
        this.sharedCtx = 0;
        this.sharedCtxTimeStamp = 0L;
        this.dirtyRenderMoleculeList.clear();
        this.dirtyRenderAtomList.clear();
        this.textureIdResourceFreeList.clear();
        this.displayListResourceFreeList.clear();
        this.copyOfCvCache = new CanvasViewCache(null, null, null);
        this.onScreen = null;
        this.offScreen = null;
        this.m = null;
        this.nmesg = 0;
        this.lasttime = 0L;
        this.currtime = 0L;
        this.display = 0;
    }

    void removeCtx(Canvas3D canvas3D) {
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            if (canvas3D.ctx != 0) {
                int n = this.listOfCtxs.indexOf(new Integer(canvas3D.ctx));
                if (n >= 0) {
                    this.listOfCtxs.remove(n);
                    this.listOfCanvases.remove(n);
                }
                if (canvas3D.screen != null) {
                    this.freeContext(canvas3D.screen.display, canvas3D.ctx);
                }
                canvas3D.ctx = 0;
                canvas3D.ctxTimeStamp = 0L;
            }
        }
    }

    void removeAllCtxs() {
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            if (this.sharedCtx != 0) {
                this.freeContext(this.display, this.sharedCtx);
                this.sharedCtx = 0;
                this.sharedCtxTimeStamp = 0L;
            }
            int n = 0;
            while (n < this.listOfCanvases.size()) {
                Canvas3D canvas3D = (Canvas3D)this.listOfCanvases.get(n);
                if (canvas3D.screen != null && canvas3D.ctx != 0) {
                    this.freeContext(canvas3D.screen.display, canvas3D.ctx);
                    canvas3D.ctx = 0;
                    canvas3D.ctxTimeStamp = 0L;
                }
                ++n;
            }
            this.listOfCanvases.clear();
            this.listOfCtxs.clear();
        }
    }
}

