/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.Dimension;
import java.awt.Point;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.DepthComponent;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.RasterRetained;
import javax.vecmath.Point3f;

public class Raster
extends Geometry {
    public static final int RASTER_COLOR = 1;
    public static final int RASTER_DEPTH = 2;
    public static final int RASTER_COLOR_DEPTH = 3;
    public static final int ALLOW_POSITION_READ = 0;
    public static final int ALLOW_POSITION_WRITE = 1;
    public static final int ALLOW_OFFSET_READ = 2;
    public static final int ALLOW_OFFSET_WRITE = 3;
    public static final int ALLOW_IMAGE_READ = 4;
    public static final int ALLOW_IMAGE_WRITE = 5;
    public static final int ALLOW_DEPTH_COMPONENT_READ = 6;
    public static final int ALLOW_DEPTH_COMPONENT_WRITE = 7;
    public static final int ALLOW_SIZE_READ = 8;
    public static final int ALLOW_SIZE_WRITE = 9;
    public static final int ALLOW_TYPE_READ = 10;

    public Raster() {
    }

    public Raster(Point3f point3f, int n, int n2, int n3, int n4, int n5, ImageComponent2D imageComponent2D, DepthComponent depthComponent) {
        ((RasterRetained)this.retained).setPosition(point3f);
        ((RasterRetained)this.retained).setType(n);
        ((RasterRetained)this.retained).setOffset(n2, n3);
        ((RasterRetained)this.retained).setSize(n4, n5);
        ((RasterRetained)this.retained).setImage(imageComponent2D);
        ((RasterRetained)this.retained).setDepthComponent(depthComponent);
    }

    public Raster(Point3f point3f, int n, Point point, Dimension dimension, ImageComponent2D imageComponent2D, DepthComponent depthComponent) {
        ((RasterRetained)this.retained).setPosition(point3f);
        ((RasterRetained)this.retained).setType(n);
        ((RasterRetained)this.retained).setOffset(point.x, point.y);
        ((RasterRetained)this.retained).setSize(dimension.width, dimension.height);
        ((RasterRetained)this.retained).setImage(imageComponent2D);
        ((RasterRetained)this.retained).setDepthComponent(depthComponent);
    }

    void createRetained() {
        this.retained = new RasterRetained();
        this.retained.setSource(this);
    }

    public void setPosition(Point3f point3f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster0"));
        }
        ((RasterRetained)this.retained).setPosition(point3f);
    }

    public void getPosition(Point3f point3f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster1"));
        }
        ((RasterRetained)this.retained).getPosition(point3f);
    }

    public void setType(int n) {
        this.checkForLiveOrCompiled();
        ((RasterRetained)this.retained).setType(n);
    }

    public int getType() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster2"));
        }
        return ((RasterRetained)this.retained).getType();
    }

    public void setOffset(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster7"));
        }
        ((RasterRetained)this.retained).setOffset(n, n2);
    }

    public void setOffset(Point point) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster7"));
        }
        ((RasterRetained)this.retained).setOffset(point.x, point.y);
    }

    public void getOffset(Point point) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster8"));
        }
        ((RasterRetained)this.retained).getOffset(point);
    }

    public void setSize(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster9"));
        }
        ((RasterRetained)this.retained).setSize(n, n2);
    }

    public void setSize(Dimension dimension) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster9"));
        }
        ((RasterRetained)this.retained).setSize(dimension.width, dimension.height);
    }

    public void getSize(Dimension dimension) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster1"));
        }
        ((RasterRetained)this.retained).getSize(dimension);
    }

    public void setImage(ImageComponent2D imageComponent2D) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster3"));
        }
        ((RasterRetained)this.retained).setImage(imageComponent2D);
    }

    public ImageComponent2D getImage() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster4"));
        }
        return ((RasterRetained)this.retained).getImage();
    }

    public void setDepthComponent(DepthComponent depthComponent) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster5"));
        }
        ((RasterRetained)this.retained).setDepthComponent(depthComponent);
    }

    public DepthComponent getDepthComponent() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster6"));
        }
        return ((RasterRetained)this.retained).getDepthComponent();
    }

    public NodeComponent cloneNodeComponent() {
        Raster raster = new Raster();
        raster.duplicateNodeComponent(this);
        return raster;
    }

    public void duplicateNodeComponent(NodeComponent nodeComponent) {
        this.checkDuplicateNodeComponent(nodeComponent);
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        RasterRetained rasterRetained = (RasterRetained)nodeComponent.retained;
        RasterRetained rasterRetained2 = (RasterRetained)this.retained;
        Point3f point3f = new Point3f();
        rasterRetained.getPosition(point3f);
        rasterRetained2.setPosition(point3f);
        rasterRetained2.setType(rasterRetained.getType());
        Point point = new Point();
        rasterRetained.getOffset(point);
        rasterRetained2.setOffset(point.x, point.y);
        Dimension dimension = new Dimension();
        rasterRetained.getSize(dimension);
        rasterRetained2.setSize(dimension.width, dimension.height);
        rasterRetained2.setImage((ImageComponent2D)this.getNodeComponent(rasterRetained.getImage(), bl, nodeComponent.nodeHashtable));
        rasterRetained2.setDepthComponent((DepthComponent)this.getNodeComponent(rasterRetained.getDepthComponent(), bl, nodeComponent.nodeHashtable));
    }

    boolean duplicateChild() {
        if (this.getDuplicateOnCloneTree()) {
            return true;
        }
        RasterRetained rasterRetained = (RasterRetained)this.retained;
        NodeComponent nodeComponent = rasterRetained.getImage();
        if (nodeComponent != null && nodeComponent.getDuplicateOnCloneTree()) {
            return true;
        }
        nodeComponent = rasterRetained.getDepthComponent();
        return nodeComponent != null && nodeComponent.getDuplicateOnCloneTree();
    }
}

