/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.SoundRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

class PointSoundRetained
extends SoundRetained {
    Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    Point3f xformPosition = new Point3f();
    Transform3D trans = new Transform3D();
    float[] attenuationDistance;
    float[] attenuationGain;

    PointSoundRetained() {
        this.nodeType = 13;
    }

    void setPosition(Point3f point3f) {
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(point3f, this.position);
        } else {
            this.position.set((Tuple3f)point3f);
        }
        this.dispatchAttribChange(512, new Point3f(this.position));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setPosition(float f, float f2, float f3) {
        this.position.x = f;
        this.position.y = f2;
        this.position.z = f3;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.position);
        }
        this.dispatchAttribChange(512, new Point3f(this.position));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void getPosition(Point3f point3f) {
        if (this.staticTransform != null) {
            Transform3D transform3D = this.staticTransform.getInvTransform();
            transform3D.transform(this.position, point3f);
        } else {
            point3f.set((Tuple3f)this.position);
        }
    }

    void getXformPosition(Point3f point3f) {
        point3f.set((Tuple3f)this.xformPosition);
    }

    void setDistanceGain(Point2f[] point2fArray) {
        if (point2fArray == null) {
            this.attenuationDistance = null;
            this.attenuationGain = null;
            return;
        }
        int n = point2fArray.length;
        this.attenuationDistance = new float[n];
        this.attenuationGain = new float[n];
        int n2 = 0;
        while (n2 < n) {
            this.attenuationDistance[n2] = point2fArray[n2].x;
            this.attenuationGain[n2] = point2fArray[n2].y;
            ++n2;
        }
        this.dispatchAttribChange(1024, point2fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setDistanceGain(float[] fArray, float[] fArray2) {
        if (fArray == null) {
            this.attenuationDistance = null;
            this.attenuationGain = null;
            return;
        }
        int n = fArray2.length;
        int n2 = fArray.length;
        this.attenuationDistance = new float[n2];
        this.attenuationGain = new float[n2];
        System.arraycopy(fArray, 0, this.attenuationDistance, 0, n2);
        if (n2 <= n) {
            System.arraycopy(fArray2, 0, this.attenuationGain, 0, n2);
        } else {
            System.arraycopy(fArray2, 0, this.attenuationGain, 0, n);
            int n3 = n;
            while (n3 < n2) {
                this.attenuationGain[n3] = fArray2[n - 1];
                ++n3;
            }
        }
        Point2f[] point2fArray = new Point2f[n2];
        int n4 = 0;
        while (n4 < n2) {
            point2fArray[n4] = new Point2f(this.attenuationDistance[n4], this.attenuationGain[n4]);
            ++n4;
        }
        this.dispatchAttribChange(1024, point2fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    int getDistanceGainLength() {
        if (this.attenuationDistance == null) {
            return 0;
        }
        return this.attenuationDistance.length;
    }

    void getDistanceGain(Point2f[] point2fArray) {
        if (point2fArray == null) {
            return;
        }
        if (this.attenuationDistance == null || this.attenuationGain == null) {
            return;
        }
        int n = this.attenuationDistance.length;
        int n2 = point2fArray.length;
        if (n > n2) {
            n = n2;
        }
        int n3 = 0;
        while (n3 < n) {
            point2fArray[n3].x = this.attenuationDistance[n3];
            point2fArray[n3].y = this.attenuationGain[n3];
            ++n3;
        }
    }

    void getDistanceGain(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return;
        }
        if (this.attenuationDistance == null || this.attenuationGain == null) {
            return;
        }
        int n = fArray.length;
        int n2 = this.attenuationDistance.length;
        if (n > n2) {
            n = n2;
        }
        System.arraycopy(this.attenuationDistance, 0, fArray, 0, n);
        n2 = this.attenuationDistance.length;
        int n3 = fArray2.length;
        if (n3 > n2) {
            n3 = n2;
        }
        System.arraycopy(this.attenuationGain, 0, fArray2, 0, n3);
    }

    synchronized void initMirrorObject(PointSoundRetained pointSoundRetained) {
        super.initMirrorObject(pointSoundRetained);
        this.trans.transform(this.position, pointSoundRetained.xformPosition);
    }

    void updateTransformChange() {
        super.updateTransformChange();
        this.getLastLocalToVworld().transform(this.position, this.xformPosition);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        transformGroupRetained.transform.transform(this.position, this.position);
    }
}

