/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CompileState;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

class OrientedShape3DRetained
extends Shape3DRetained {
    static final int ALIGNMENT_CHANGED = 32;
    static final int AXIS_CHANGED = 64;
    static final int ROTATION_CHANGED = 128;
    int mode = 0;
    Vector3f axis = new Vector3f(0.0f, 1.0f, 0.0f);
    Point3f rotationPoint = new Point3f(0.0f, 0.0f, 1.0f);
    private Vector3d nAxis = new Vector3d(0.0, 1.0, 0.0);
    private Point3d viewPosition = new Point3d();
    private Point3d yUpPoint = new Point3d();
    private Vector3d eyeVec = new Vector3d();
    private Vector3d yUp = new Vector3d();
    private Vector3d zAxis = new Vector3d();
    private Vector3d yAxis = new Vector3d();
    private Vector3d vector = new Vector3d();
    private AxisAngle4d aa = new AxisAngle4d();
    private Transform3D xform = new Transform3D();
    private Transform3D zRotate = new Transform3D();
    boolean orientedTransformDirty = true;
    Transform3D[] orientedTransforms = new Transform3D[1];
    static final double EPSILON = 1.0E-6;

    public OrientedShape3DRetained() {
        this.nodeType = 28;
    }

    void initAlignmentMode(int n) {
        this.mode = n;
    }

    void setAlignmentMode(int n) {
        if (this.mode != n) {
            this.initAlignmentMode(n);
            this.sendChangedMessage(32, new Integer(n));
        }
    }

    int getAlignmentMode() {
        return this.mode;
    }

    void initAlignmentAxis(Vector3f vector3f) {
        this.initAlignmentAxis(vector3f.x, vector3f.y, vector3f.z);
    }

    void initAlignmentAxis(float f, float f2, float f3) {
        this.axis.set(f, f2, f3);
        double d = 1.0 / Math.sqrt(this.axis.x * this.axis.x + this.axis.y * this.axis.y + this.axis.z * this.axis.z);
        this.nAxis.x = (double)this.axis.x * d;
        this.nAxis.y = (double)this.axis.y * d;
        this.nAxis.z = (double)this.axis.z * d;
    }

    void setAlignmentAxis(Vector3f vector3f) {
        this.setAlignmentAxis(vector3f.x, vector3f.y, vector3f.z);
    }

    void setAlignmentAxis(float f, float f2, float f3) {
        this.initAlignmentAxis(f, f2, f3);
        if (this.mode == 0) {
            this.sendChangedMessage(64, new Vector3f(f, f2, f3));
        }
    }

    void getAlignmentAxis(Vector3f vector3f) {
        vector3f.set((Tuple3f)this.axis);
    }

    void initRotationPoint(Point3f point3f) {
        this.rotationPoint.set((Tuple3f)point3f);
    }

    void initRotationPoint(float f, float f2, float f3) {
        this.rotationPoint.set(f, f2, f3);
    }

    void setRotationPoint(Point3f point3f) {
        this.setRotationPoint(point3f.x, point3f.y, point3f.z);
    }

    void setRotationPoint(float f, float f2, float f3) {
        this.initRotationPoint(f, f2, f3);
        if (this.mode == 1) {
            this.sendChangedMessage(128, new Point3f(f, f2, f3));
        }
    }

    void getRotationPoint(Point3f point3f) {
        point3f.set((Tuple3f)this.rotationPoint);
    }

    void sendChangedMessage(int n, Object object) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.type = 46;
        j3dMessage.threads = 4224;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = this.mirrorShape3D.clone();
        j3dMessage.args[4] = this;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        if ((n & 0xE0) != 0) {
            ArrayList arrayList = (ArrayList)objectArray[3];
            Object object = objectArray[2];
            if ((n & 0x20) != 0) {
                int n2 = (Integer)object;
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    OrientedShape3DRetained orientedShape3DRetained = (OrientedShape3DRetained)arrayList.get(n3);
                    orientedShape3DRetained.initAlignmentMode(n2);
                    ++n3;
                }
            } else if ((n & 0x40) != 0) {
                Vector3f vector3f = (Vector3f)object;
                int n4 = 0;
                while (n4 < arrayList.size()) {
                    OrientedShape3DRetained orientedShape3DRetained = (OrientedShape3DRetained)arrayList.get(n4);
                    orientedShape3DRetained.initAlignmentAxis(vector3f);
                    ++n4;
                }
            } else if ((n & 0x80) != 0) {
                Point3f point3f = (Point3f)object;
                int n5 = 0;
                while (n5 < arrayList.size()) {
                    OrientedShape3DRetained orientedShape3DRetained = (OrientedShape3DRetained)arrayList.get(n5);
                    orientedShape3DRetained.initRotationPoint(point3f);
                    ++n5;
                }
            }
        } else {
            super.updateImmediateMirrorObject(objectArray);
        }
    }

    Transform3D getOrientedTransform(int n) {
        Transform3D[] transform3DArray = this.orientedTransforms;
        synchronized (transform3DArray) {
            if (n >= this.orientedTransforms.length) {
                Transform3D transform3D = new Transform3D();
                Transform3D[] transform3DArray2 = new Transform3D[n + 1];
                int n2 = 0;
                while (n2 < this.orientedTransforms.length) {
                    transform3DArray2[n2] = this.orientedTransforms[n2];
                    ++n2;
                }
                transform3DArray2[n] = transform3D;
            } else if (this.orientedTransforms[n] == null) {
                this.orientedTransforms[n] = new Transform3D();
            }
        }
        return this.orientedTransforms[n];
    }

    synchronized void updateOrientedTransform(Canvas3D canvas3D, int n) {
        double d = 0.0;
        Transform3D transform3D = this.getOrientedTransform(n);
        if (this.mode == 0) {
            canvas3D.getCenterEyeInImagePlate(this.viewPosition);
            canvas3D.getImagePlateToVworld(this.xform);
            this.xform.transform(this.viewPosition);
            this.xform.set(this.getCurrentLocalToVworld());
            this.xform.invert();
            this.xform.transform(this.viewPosition);
            this.eyeVec.set((Tuple3d)this.viewPosition);
            this.eyeVec.normalize();
            boolean bl = this.projectToPlane(this.eyeVec, this.nAxis);
            if (bl) {
                this.zAxis.x = 0.0;
                this.zAxis.y = 0.0;
                this.zAxis.z = 1.0;
                bl = this.projectToPlane(this.zAxis, this.nAxis);
            }
            if (bl) {
                this.vector.cross(this.eyeVec, this.zAxis);
                double d2 = this.vector.dot(this.nAxis) > 0.0 ? 1.0 : -1.0;
                double d3 = this.eyeVec.dot(this.zAxis);
                if (d3 > 1.0) {
                    d3 = 1.0;
                } else if (d3 < -1.0) {
                    d3 = -1.0;
                }
                d = d2 * Math.acos(d3);
                this.aa.x = this.nAxis.x;
                this.aa.y = this.nAxis.y;
                this.aa.z = this.nAxis.z;
                this.aa.angle = -d;
                transform3D.set(this.aa);
            } else {
                transform3D.setIdentity();
            }
        } else {
            double d4;
            canvas3D.getCenterEyeInImagePlate(this.viewPosition);
            this.yUpPoint.set((Tuple3d)this.viewPosition);
            this.yUpPoint.y += 0.01;
            canvas3D.getImagePlateToVworld(this.xform);
            this.xform.transform(this.viewPosition);
            this.xform.transform(this.yUpPoint);
            this.xform.set(this.getCurrentLocalToVworld());
            this.xform.invert();
            this.xform.transform(this.viewPosition);
            this.xform.transform(this.yUpPoint);
            this.eyeVec.set((Tuple3d)this.viewPosition);
            this.eyeVec.normalize();
            this.yUp.set((Tuple3d)this.yUpPoint);
            this.yUp.sub((Tuple3d)this.viewPosition);
            this.yUp.normalize();
            this.zAxis.x = 0.0;
            this.zAxis.y = 0.0;
            this.zAxis.z = 1.0;
            this.vector.cross(this.eyeVec, this.zAxis);
            double d5 = this.vector.length();
            if (d5 > 1.0E-4) {
                d4 = this.eyeVec.dot(this.zAxis);
                if (d4 > 1.0) {
                    d4 = 1.0;
                } else if (d4 < -1.0) {
                    d4 = -1.0;
                }
                d = Math.acos(d4);
                this.aa.x = this.vector.x;
                this.aa.y = this.vector.y;
                this.aa.z = this.vector.z;
                this.aa.angle = -d;
                this.zRotate.set(this.aa);
            } else {
                this.zRotate.set(1.0);
            }
            this.yAxis.x = 0.0;
            this.yAxis.y = 1.0;
            this.yAxis.z = 0.0;
            this.zRotate.transform(this.yAxis);
            boolean bl = this.projectToPlane(this.yAxis, this.eyeVec);
            if (bl) {
                bl = this.projectToPlane(this.yUp, this.eyeVec);
            }
            if (bl) {
                d4 = this.yUp.dot(this.yAxis);
                if (d4 > 1.0) {
                    d4 = 1.0;
                } else if (d4 < -1.0) {
                    d4 = -1.0;
                }
                d = Math.acos(d4);
                this.vector.cross(this.yUp, this.yAxis);
                if (this.eyeVec.dot(this.vector) < 0.0) {
                    d *= -1.0;
                }
                this.aa.x = this.eyeVec.x;
                this.aa.y = this.eyeVec.y;
                this.aa.z = this.eyeVec.z;
                this.aa.angle = -d;
                this.xform.set(this.aa);
                this.vector.x = this.rotationPoint.x;
                this.vector.y = this.rotationPoint.y;
                this.vector.z = this.rotationPoint.z;
                transform3D.set(this.vector);
                transform3D.mul(this.xform);
                transform3D.mul(this.zRotate);
                this.vector.scale(-1.0);
                this.xform.set(this.vector);
                transform3D.mul(this.xform);
            } else {
                transform3D.setIdentity();
            }
        }
    }

    private boolean projectToPlane(Vector3d vector3d, Vector3d vector3d2) {
        double d = vector3d2.dot(vector3d);
        vector3d.x -= vector3d2.x * d;
        vector3d.y -= vector3d2.y * d;
        vector3d.z -= vector3d2.z * d;
        double d2 = vector3d.length();
        if (d2 < 1.0E-6) {
            return false;
        }
        vector3d.scale(1.0 / d2);
        return true;
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        this.mergeFlag = 0;
        compileState.keepTG = true;
    }
}

