/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfiguration;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.NativeScreenInfo;
import javax.media.j3d.VirtualUniverse;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;

class NativeConfigTemplate3D {
    static final int RED_SIZE = 0;
    static final int GREEN_SIZE = 1;
    static final int BLUE_SIZE = 2;
    static final int ACCUM_BUFFER = 3;
    static final int DEPTH_SIZE = 4;
    static final int DOUBLEBUFFER = 5;
    static final int STEREO = 6;
    static final int NUM_ITEMS = 7;

    NativeConfigTemplate3D() {
        VirtualUniverse.createMC();
    }

    native int chooseOglVisual(int var1, int var2, int[] var3);

    native boolean isStereoAvailable(int var1, int var2, int var3);

    native boolean isDoubleBufferAvailable(int var1, int var2, int var3);

    native boolean isSceneAntialiasingAvailable(int var1, int var2, int var3);

    GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration[] graphicsConfigurationArray) {
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)((X11GraphicsConfig)graphicsConfigurationArray[0]).getDevice();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo(x11GraphicsDevice);
        int n = nativeScreenInfo.getDisplay();
        int n2 = nativeScreenInfo.getScreen();
        int[] nArray = new int[7];
        nArray[0] = graphicsConfigTemplate3D.getRedSize();
        nArray[1] = graphicsConfigTemplate3D.getGreenSize();
        nArray[2] = graphicsConfigTemplate3D.getBlueSize();
        nArray[4] = graphicsConfigTemplate3D.getDepthSize();
        nArray[5] = graphicsConfigTemplate3D.getDoubleBuffer();
        nArray[6] = graphicsConfigTemplate3D.getStereo();
        nArray[3] = graphicsConfigTemplate3D.getStereo();
        int n3 = this.chooseOglVisual(n, n2, nArray);
        if (n3 == 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = null;
        int n4 = 0;
        while (n4 < graphicsConfigurationArray.length) {
            if (((X11GraphicsConfig)graphicsConfigurationArray[n4]).getVisual() == n3) {
                graphicsConfiguration = graphicsConfigurationArray[n4];
                break;
            }
            ++n4;
        }
        return graphicsConfiguration;
    }

    boolean isGraphicsConfigSupported(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration graphicsConfiguration) {
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)((X11GraphicsConfig)graphicsConfiguration).getDevice();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo(x11GraphicsDevice);
        int n = nativeScreenInfo.getDisplay();
        int n2 = nativeScreenInfo.getScreen();
        int[] nArray = new int[7];
        nArray[0] = graphicsConfigTemplate3D.getRedSize();
        nArray[1] = graphicsConfigTemplate3D.getGreenSize();
        nArray[2] = graphicsConfigTemplate3D.getBlueSize();
        nArray[4] = graphicsConfigTemplate3D.getDepthSize();
        nArray[5] = graphicsConfigTemplate3D.getDoubleBuffer();
        nArray[6] = graphicsConfigTemplate3D.getStereo();
        nArray[3] = graphicsConfigTemplate3D.getStereo();
        int n3 = this.chooseOglVisual(n, n2, nArray);
        return n3 != 0;
    }

    boolean hasStereo(GraphicsConfiguration graphicsConfiguration) {
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)((X11GraphicsConfig)graphicsConfiguration).getDevice();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo(x11GraphicsDevice);
        int n = nativeScreenInfo.getDisplay();
        int n2 = nativeScreenInfo.getScreen();
        int n3 = ((X11GraphicsConfig)graphicsConfiguration).getVisual();
        return this.isStereoAvailable(n, n2, n3);
    }

    boolean hasDoubleBuffer(GraphicsConfiguration graphicsConfiguration) {
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)((X11GraphicsConfig)graphicsConfiguration).getDevice();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo(x11GraphicsDevice);
        int n = nativeScreenInfo.getDisplay();
        int n2 = nativeScreenInfo.getScreen();
        int n3 = ((X11GraphicsConfig)graphicsConfiguration).getVisual();
        return this.isDoubleBufferAvailable(n, n2, n3);
    }

    boolean hasSceneAntialiasing(GraphicsConfiguration graphicsConfiguration) {
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)((X11GraphicsConfig)graphicsConfiguration).getDevice();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo(x11GraphicsDevice);
        int n = nativeScreenInfo.getDisplay();
        int n2 = nativeScreenInfo.getScreen();
        int n3 = ((X11GraphicsConfig)graphicsConfiguration).getVisual();
        return this.isSceneAntialiasingAvailable(n, n2, n3);
    }

    static {
        VirtualUniverse.loadLibraries();
    }
}

