/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTError;
import java.awt.Toolkit;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.BHInternalNode;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BehaviorScheduler;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CompressedGeometryRenderMethod;
import javax.media.j3d.DefaultRenderMethod;
import javax.media.j3d.DisplayListRenderMethod;
import javax.media.j3d.DrawingSurfaceObjectAWT;
import javax.media.j3d.InputDevice;
import javax.media.j3d.InputDeviceBlockingThread;
import javax.media.j3d.InputDeviceScheduler;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dProperties;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.J3dThread;
import javax.media.j3d.J3dThreadData;
import javax.media.j3d.MasterControlThread;
import javax.media.j3d.NativeAPIInfo;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrientedShape3DRenderMethod;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.RenderMethod;
import javax.media.j3d.Renderer;
import javax.media.j3d.RenderingAttributesStructure;
import javax.media.j3d.Screen3D;
import javax.media.j3d.StructureUpdateThread;
import javax.media.j3d.Text3DRenderMethod;
import javax.media.j3d.TimerThread;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VertexArrayRenderMethod;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

class MasterControl {
    static final int CHECK_FOR_WORK = 0;
    static final int SET_WORK = 1;
    static final int RUN_THREADS = 2;
    static final int THREAD_DONE = 3;
    static final int WAIT_FOR_ALL = 4;
    static final int SET_WORK_FOR_REQUEST_RENDERER = 5;
    static final int RUN_RENDERER_CLEANUP = 6;
    static final int SLEEPING = 0;
    static final int RUNNING = 1;
    static final int WAITING_FOR_THREAD = 2;
    static final int WAITING_FOR_THREADS = 3;
    static final int WAITING_FOR_CPU = 4;
    static final int WAITING_FOR_RENDERER_CLEANUP = 5;
    static final int RENDER_OPENGL_SOLARIS = 0;
    static final int RENDER_OPENGL_WIN32 = 1;
    static final int RENDER_DIRECT3D = 2;
    static final Integer REQUESTRENDER = new Integer(3);
    static final Integer RENDER = new Integer(0);
    static final Integer SWAP = new Integer(1);
    static final Integer ACTIVATE_VIEW = new Integer(1);
    static final Integer DEACTIVATE_VIEW = new Integer(2);
    static final Integer START_VIEW = new Integer(3);
    static final Integer STOP_VIEW = new Integer(4);
    static final Integer REEVALUATE_CANVAS = new Integer(5);
    static final Integer UNREGISTER_VIEW = new Integer(6);
    static final Integer PHYSICAL_ENV_CHANGE = new Integer(7);
    static final Integer INPUTDEVICE_CHANGE = new Integer(8);
    static final Integer EMPTY_UNIVERSE = new Integer(9);
    static final Integer START_RENDERER = new Integer(10);
    static final Integer STOP_RENDERER = new Integer(11);
    static final Integer RENDER_ONCE = new Integer(12);
    static final Integer FREE_CONTEXT = new Integer(13);
    static final Integer FREE_DRAWING_SURFACE = new Integer(14);
    static final Integer FREE_MESSAGE = new Integer(15);
    static final Integer RESET_CANVAS = new Integer(16);
    private MasterControlThread mcThread = null;
    private UnorderList views = new UnorderList(1, class$javax$media$j3d$View == null ? (class$javax$media$j3d$View = MasterControl.class$("javax.media.j3d.View")) : class$javax$media$j3d$View);
    private int numActiveViews = 0;
    private Transform3D[] transformFreeList = new Transform3D[2];
    private int numFreeTransforms = 0;
    private Object transformFreeListLock = new Object();
    private UnorderList activeUniverseList = new UnorderList(class$javax$media$j3d$VirtualUniverse == null ? (class$javax$media$j3d$VirtualUniverse = MasterControl.class$("javax.media.j3d.VirtualUniverse")) : class$javax$media$j3d$VirtualUniverse);
    private UnorderList regUniverseList = new UnorderList(class$javax$media$j3d$VirtualUniverse == null ? (class$javax$media$j3d$VirtualUniverse = MasterControl.class$("javax.media.j3d.VirtualUniverse")) : class$javax$media$j3d$VirtualUniverse);
    private Object timeLock = new Object();
    private long time = 0L;
    private long waitTimestamp = 0L;
    private UnorderList stateWorkThreads = new UnorderList(class$javax$media$j3d$J3dThreadData == null ? (class$javax$media$j3d$J3dThreadData = MasterControl.class$("javax.media.j3d.J3dThreadData")) : class$javax$media$j3d$J3dThreadData);
    private UnorderList renderWorkThreads = new UnorderList(class$javax$media$j3d$J3dThreadData == null ? (class$javax$media$j3d$J3dThreadData = MasterControl.class$("javax.media.j3d.J3dThreadData")) : class$javax$media$j3d$J3dThreadData);
    private UnorderList requestRenderWorkThreads = new UnorderList(class$javax$media$j3d$J3dThreadData == null ? (class$javax$media$j3d$J3dThreadData = MasterControl.class$("javax.media.j3d.J3dThreadData")) : class$javax$media$j3d$J3dThreadData);
    private UnorderList renderThreadData = new UnorderList(class$javax$media$j3d$J3dThreadData == null ? (class$javax$media$j3d$J3dThreadData = MasterControl.class$("javax.media.j3d.J3dThreadData")) : class$javax$media$j3d$J3dThreadData);
    private UnorderList inputDeviceThreads = new UnorderList(1, class$javax$media$j3d$InputDeviceScheduler == null ? (class$javax$media$j3d$InputDeviceScheduler = MasterControl.class$("javax.media.j3d.InputDeviceScheduler")) : class$javax$media$j3d$InputDeviceScheduler);
    private boolean threadListsChanged;
    private int lastTransformStructureThread = 0;
    private int lastStructureUpdateThread = 0;
    private long currentTime;
    TimerThread timerThread;
    boolean running = true;
    private boolean workToDo = false;
    private boolean requestRenderWorkToDo = false;
    private int threadPending = 0;
    private int renderPending = 0;
    private int statePending = 0;
    private boolean renderWaiting = false;
    private boolean stateWaiting = false;
    private int state = 0;
    private int cpuLimit;
    private UnorderList messageFreeList = new UnorderList(class$javax$media$j3d$J3dMessage == null ? (class$javax$media$j3d$J3dMessage = MasterControl.class$("javax.media.j3d.J3dMessage")) : class$javax$media$j3d$J3dMessage);
    private UnorderList bhLeafFreeList = new UnorderList(class$javax$media$j3d$BHNode == null ? (class$javax$media$j3d$BHNode = MasterControl.class$("javax.media.j3d.BHNode")) : class$javax$media$j3d$BHNode);
    private UnorderList bhInternalFreeList = new UnorderList(class$javax$media$j3d$BHNode == null ? (class$javax$media$j3d$BHNode = MasterControl.class$("javax.media.j3d.BHNode")) : class$javax$media$j3d$BHNode);
    private UnorderList mirrorObjects = new UnorderList(class$javax$media$j3d$ObjectUpdate == null ? (class$javax$media$j3d$ObjectUpdate = MasterControl.class$("javax.media.j3d.ObjectUpdate")) : class$javax$media$j3d$ObjectUpdate);
    private RenderingAttributesStructure renderingAttributesStructure = new RenderingAttributesStructure();
    private DefaultRenderMethod defaultRenderMethod = null;
    private Text3DRenderMethod text3DRenderMethod = null;
    private VertexArrayRenderMethod vertexArrayRenderMethod = null;
    private DisplayListRenderMethod displayListRenderMethod = null;
    private CompressedGeometryRenderMethod compressedGeometryRenderMethod = null;
    private OrientedShape3DRenderMethod orientedShape3DRenderMethod = null;
    int currentCtx = 0;
    static long systemStartTime = System.currentTimeMillis();
    private int renderingAPI = 0;
    private boolean isD3DAPI = false;
    private boolean isWin32 = false;
    private NativeAPIInfo nativeAPIInfo = null;
    private J3dProperties j3dProperties = null;
    private int displayListIdCount = 1;
    UnorderList displayListIdFreeList = new UnorderList(class$java$lang$Integer == null ? (class$java$lang$Integer = MasterControl.class$("java.lang.Integer")) : class$java$lang$Integer);
    private int textureIdCount = 1;
    private UnorderList texture2DIdFreeList = new UnorderList(class$java$lang$Integer == null ? (class$java$lang$Integer = MasterControl.class$("java.lang.Integer")) : class$java$lang$Integer);
    private UnorderList texture3DIdFreeList = new UnorderList(class$java$lang$Integer == null ? (class$java$lang$Integer = MasterControl.class$("java.lang.Integer")) : class$java$lang$Integer);
    private long contextTimeStamp = 0L;
    private int canvasBitCount = 0;
    private UnorderList canvasBitFreeList = new UnorderList(class$java$lang$Integer == null ? (class$java$lang$Integer = MasterControl.class$("java.lang.Integer")) : class$java$lang$Integer);
    private int rendererCount = 0;
    static boolean jvm13 = false;
    static boolean jvm14 = false;
    boolean isSharedCtx = false;
    boolean sharedCtxOverride = false;
    boolean disableCompile = false;
    boolean isVertexBuffer = true;
    Object[] rendererCleanupArgs = new Object[]{new Integer(4), null};
    Object contextCreationLock = new Object();
    boolean doDsiRenderLock = false;
    boolean isJ3dG2dDrawPixel = true;
    boolean sharedStereoZBuffer;
    Hashtable deviceScreenMap = new Hashtable();
    UnorderList requestObjList = new UnorderList();
    private UnorderList requestTypeList = new UnorderList(class$java$lang$Integer == null ? (class$java$lang$Integer = MasterControl.class$("java.lang.Integer")) : class$java$lang$Integer);
    private UnorderList tempViewList = new UnorderList();
    private UnorderList renderOnceList = new UnorderList();
    private boolean pendingRequest = false;
    private static ThreadGroup rootThreadGroup;
    private static int threadPriority;
    private long sleepTime;
    private static Object mcThreadLock;
    private ArrayList timestampUpdateList = new ArrayList(3);
    private UnorderList freeMessageList = new UnorderList(8);
    int awt;
    int maxLights;
    private Object structureLock = new Object();
    int resendTexTimestamp = 0;
    String[] mtype = new String[]{"-INSERT_NODES                   ", "-REMOVE_NODES                   ", "-RUN                            ", "-TRANSFORM_CHANGED              ", "-UPDATE_VIEW                    ", "-STOP_THREAD                    ", "-COLORINGATTRIBUTES_CHANGED     ", "-LINEATTRIBUTES_CHANGED         ", "-POINTATTRIBUTES_CHANGED        ", "-POLYGONATTRIBUTES_CHANGED      ", "-RENDERINGATTRIBUTES_CHANGED    ", "-TEXTUREATTRIBUTES_CHANGED      ", "-TRANSPARENCYATTRIBUTES_CHANGED ", "-MATERIAL_CHANGED               ", "-TEXCOORDGENERATION_CHANGED     ", "-TEXTURE_CHANGED                ", "-MORPH_CHANGED                  ", "-GEOMETRY_CHANGED               ", "-APPEARANCE_CHANGED             ", "-LIGHT_CHANGED                  ", "-BACKGROUND_CHANGED             ", "-CLIP_CHANGED                   ", "-FOG_CHANGED                    ", "-BOUNDINGLEAF_CHANGED           ", "-SHAPE3D_CHANGED                ", "-TEXT3D_TRANSFORM_CHANGED       ", "-TEXT3D_DATA_CHANGED            ", "-SWITCH_CHANGED                 ", "-COND_MET                       ", "-BEHAVIOR_ENABLE                ", "-BEHAVIOR_DISABLE               ", "-INSERT_RENDERATOMS             ", "-ORDERED_GROUP_INSERTED         ", "-ORDERED_GROUP_REMOVED          ", "-COLLISION_BOUND_CHANGED        ", "-REGION_BOUND_CHANGED           ", "-MODELCLIP_CHANGED              ", "-BOUNDS_AUTO_COMPUTE_CHANGED    ", "-SOUND_ATTRIB_CHANGED           ", "-AURALATTRIBUTES_CHANGED        ", "-SOUNDSCAPE_CHANGED             ", "-ALTERNATEAPPEARANCE_CHANGED    ", "-RENDER_OFFSCREEN               ", "-RENDER_RETAINED                ", "-RENDER_IMMEDIATE               ", "-SOUND_STATE_CHANGED            ", "-ORIENTEDSHAPE3D_CHANGED        ", "-TEXTURE_UNIT_STATE_CHANGED     ", "-UPDATE_VIEWPLATFORM            ", "-BEHAVIOR_ACTIVATE              ", "-GEOMETRYARRAY_CHANGED          ", "-MEDIA_CONTAINER_CHANGED        "};
    static /* synthetic */ Class class$javax$media$j3d$View;
    static /* synthetic */ Class class$javax$media$j3d$VirtualUniverse;
    static /* synthetic */ Class class$javax$media$j3d$J3dThreadData;
    static /* synthetic */ Class class$javax$media$j3d$InputDeviceScheduler;
    static /* synthetic */ Class class$javax$media$j3d$J3dMessage;
    static /* synthetic */ Class class$javax$media$j3d$BHNode;
    static /* synthetic */ Class class$javax$media$j3d$ObjectUpdate;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$javax$media$j3d$PhysicalEnvironment;

    native int getAWT();

    private native boolean initializeJ3D();

    private native int getNumberOfProcessor();

    private native void setThreadConcurrency(int var1);

    private native int getThreadConcurrency();

    private native int getMaximumLights();

    MasterControl() {
        Integer n;
        Boolean bl;
        Boolean bl2;
        if (jvm14) {
            this.awt = this.getAWT();
        }
        this.nativeAPIInfo = new NativeAPIInfo();
        this.renderingAPI = this.nativeAPIInfo.getRenderingAPI();
        this.isD3DAPI = this.renderingAPI == 2;
        this.isWin32 = this.isD3DAPI || this.renderingAPI == 1;
        this.j3dProperties = new J3dProperties();
        if (this.getRenderingAPI() != 2) {
            bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("j3d.sharedctx");
                    if (string == null) {
                        return Boolean.FALSE;
                    }
                    MasterControl.this.sharedCtxOverride = true;
                    return new Boolean(string);
                }
            });
            this.isSharedCtx = bl2;
            if (this.sharedCtxOverride) {
                if (this.isSharedCtx) {
                    System.err.println("Java 3D: shared contexts enabled");
                } else {
                    System.err.println("Java 3D: shared contexts disabled");
                }
            }
        }
        bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("j3d.disablecompile");
                if (string == null) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        this.disableCompile = bl2;
        if (this.disableCompile) {
            System.err.println("Java 3D: Compile disabled");
        }
        Boolean bl3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("j3d.vertexbuffer", "true");
                Boolean bl = new Boolean(string);
                if (bl.booleanValue()) {
                    string = System.getProperty("j3d.displaylist", "true");
                    return new Boolean(string);
                }
                return bl;
            }
        });
        this.isVertexBuffer = bl3;
        if (!this.isVertexBuffer) {
            System.err.println("Java 3D: Display List/Vertex Buffer disabled");
        }
        Boolean bl4 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("j3d.renderLock", "false");
                return new Boolean(string);
            }
        });
        this.doDsiRenderLock = bl4;
        if (!this.isD3D()) {
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = "true";
                    String string2 = System.getProperty("j3d.g2ddrawpixel", string);
                    return new Boolean(string2);
                }
            });
            this.isJ3dG2dDrawPixel = bl;
        } else {
            this.isJ3dG2dDrawPixel = true;
        }
        bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = MasterControl.this.isWin32 ? "true" : "false";
                String string2 = System.getProperty("j3d.sharedstereozbuffer", string);
                return new Boolean(string2);
            }
        });
        this.sharedStereoZBuffer = bl;
        bl = null;
        final int n2 = this.getNumberOfProcessor() + 1;
        Integer n3 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger("j3d.threadLimit", n2);
            }
        });
        this.cpuLimit = n3;
        if (this.cpuLimit < 1) {
            this.cpuLimit = 1;
        }
        if (J3dDebug.debug || this.cpuLimit != n2) {
            System.err.println("Java 3D: concurrent threadLimit = " + this.cpuLimit);
        }
        int n4 = this.getThreadConcurrency();
        if (J3dDebug.debug) {
            System.err.println("System threadConcurrency = " + n4);
        }
        if (n4 != -1 && n4 < this.cpuLimit + 1) {
            n4 = this.cpuLimit + 1;
            if (J3dDebug.debug) {
                System.err.println("Setting system threadConcurrency to " + n4);
            }
            this.setThreadConcurrency(n4);
        }
        if ((n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger("j3d.deviceSampleTime", 0);
            }
        })) > 0) {
            InputDeviceScheduler.samplingTime = n;
            System.err.println("Java 3D: Input device sampling time = " + n + " ms");
        }
        if (!this.initializeJ3D()) {
            if (this.isGreenThreadUsed()) {
                System.err.print(J3dI18N.getString("MasterControl1"));
            }
            throw new RuntimeException(J3dI18N.getString("MasterControl0"));
        }
        this.maxLights = this.getMaximumLights();
    }

    public static String getProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    boolean isGreenThreadUsed() {
        String string;
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("java.vm.info");
                return string;
            }
        });
        return string2.indexOf(string = new String("green threads")) != -1;
    }

    static void loadLibraries() {
        Object object;
        try {
            object = Toolkit.getDefaultToolkit();
            object = null;
        }
        catch (AWTError aWTError) {
            // empty catch block
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("J3D");
                return null;
            }
        });
        object = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.version");
            }
        });
        jvm13 = !((String)object).startsWith("1.2");
        jvm14 = ((String)object).startsWith("1.4");
        if (jvm14) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.loadLibrary("jawt");
                    return null;
                }
            });
        }
    }

    InputDeviceBlockingThread getInputDeviceBlockingThread(final InputDevice inputDevice) {
        return (InputDeviceBlockingThread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    InputDeviceBlockingThread inputDeviceBlockingThread = new InputDeviceBlockingThread(rootThreadGroup, inputDevice);
                    inputDeviceBlockingThread.setPriority(threadPriority);
                    InputDeviceBlockingThread inputDeviceBlockingThread2 = inputDeviceBlockingThread;
                    return inputDeviceBlockingThread2;
                }
            }
        });
    }

    void setThreadPriority(final int n) {
        ThreadGroup threadGroup = rootThreadGroup;
        synchronized (threadGroup) {
            threadPriority = n;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread[] threadArray = new Thread[rootThreadGroup.activeCount()];
                    int n3 = rootThreadGroup.enumerate(threadArray);
                    int n2 = n3 - 1;
                    while (n2 >= 0) {
                        threadArray[n2].setPriority(n);
                        --n2;
                    }
                    return null;
                }
            });
        }
    }

    int getThreadPriority() {
        return threadPriority;
    }

    int getRendererBit() {
        return 1 << this.rendererCount++;
    }

    long getContextTimeStamp() {
        return ++this.contextTimeStamp;
    }

    Integer getDisplayListId() {
        UnorderList unorderList = this.displayListIdFreeList;
        synchronized (unorderList) {
            if (this.displayListIdFreeList.size() == 0) {
                Integer n = new Integer(++this.displayListIdCount);
                return n;
            }
            Integer n = (Integer)this.displayListIdFreeList.removeLastElement();
            return n;
        }
    }

    void freeDisplayListId(Integer n) {
        UnorderList unorderList = this.displayListIdFreeList;
        synchronized (unorderList) {
            this.displayListIdFreeList.add(n);
        }
    }

    int getTexture2DId() {
        UnorderList unorderList = this.texture2DIdFreeList;
        synchronized (unorderList) {
            if (this.texture2DIdFreeList.size() == 0) {
                int n = ++this.textureIdCount;
                return n;
            }
            int n = (Integer)this.texture2DIdFreeList.removeLastElement();
            return n;
        }
    }

    int getTexture3DId() {
        UnorderList unorderList = this.texture3DIdFreeList;
        synchronized (unorderList) {
            if (this.texture3DIdFreeList.size() == 0) {
                int n = ++this.textureIdCount;
                return n;
            }
            int n = (Integer)this.texture3DIdFreeList.removeLastElement();
            return n;
        }
    }

    void freeTexture2DId(int n) {
        UnorderList unorderList = this.texture2DIdFreeList;
        synchronized (unorderList) {
            this.texture2DIdFreeList.add(new Integer(n));
        }
    }

    void freeTexture3DId(int n) {
        UnorderList unorderList = this.texture3DIdFreeList;
        synchronized (unorderList) {
            this.texture3DIdFreeList.add(new Integer(n));
        }
    }

    int getCanvasBit() {
        UnorderList unorderList = this.canvasBitFreeList;
        synchronized (unorderList) {
            if (this.canvasBitFreeList.size() == 0) {
                if (this.canvasBitCount > 31) {
                    throw new InternalError();
                }
                int n = 1 << this.canvasBitCount++;
                return n;
            }
            int n = (Integer)this.canvasBitFreeList.removeLastElement();
            return n;
        }
    }

    void freeCanvasBit(int n) {
        UnorderList unorderList = this.canvasBitFreeList;
        synchronized (unorderList) {
            this.canvasBitFreeList.add(new Integer(n));
        }
    }

    Transform3D getTransform3D(Transform3D transform3D) {
        Transform3D transform3D2;
        Object object = this.transformFreeListLock;
        synchronized (object) {
            if (this.numFreeTransforms > 0) {
                --this.numFreeTransforms;
                transform3D2 = this.transformFreeList[this.numFreeTransforms];
                if (transform3D != null) {
                    transform3D2.set(transform3D);
                }
            } else {
                transform3D2 = transform3D != null ? new Transform3D(transform3D) : new Transform3D();
            }
        }
        return transform3D2;
    }

    void addToTransformFreeList(Transform3D transform3D) {
        Object object = this.transformFreeListLock;
        synchronized (object) {
            if (this.transformFreeList.length == this.numFreeTransforms) {
                Transform3D[] transform3DArray = new Transform3D[this.numFreeTransforms * 2];
                System.arraycopy(this.transformFreeList, 0, transform3DArray, 0, this.numFreeTransforms);
                this.transformFreeList = transform3DArray;
            }
            this.transformFreeList[this.numFreeTransforms++] = transform3D;
        }
    }

    void postRequest(Integer n, Object object) {
        Object object2 = mcThreadLock;
        synchronized (object2) {
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                if (this.mcThread == null) {
                    if (n == ACTIVATE_VIEW) {
                        this.createMasterControlThread();
                        this.requestObjList.add(object);
                        this.requestTypeList.add(n);
                        this.pendingRequest = true;
                    } else if (n == EMPTY_UNIVERSE) {
                        this.destroyUniverseThreads((VirtualUniverse)object);
                    } else {
                        this.requestObjList.add(object);
                        this.requestTypeList.add(n);
                        this.pendingRequest = true;
                    }
                } else {
                    this.requestObjList.add(object);
                    this.requestTypeList.add(n);
                    this.pendingRequest = true;
                }
            }
        }
        this.setWork();
    }

    boolean mcThreadDone() {
        Object object = mcThreadLock;
        synchronized (object) {
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                if (!this.pendingRequest) {
                    this.mcThread = null;
                    if (this.renderingAttributesStructure.updateThread != null) {
                        this.renderingAttributesStructure.updateThread.finish();
                        this.renderingAttributesStructure.updateThread = null;
                    }
                    this.renderingAttributesStructure = new RenderingAttributesStructure();
                    if (this.timerThread != null) {
                        this.timerThread.finish();
                        this.timerThread = null;
                    }
                    boolean bl = true;
                    return bl;
                }
                this.running = true;
                this.createMCThreads();
                boolean bl = false;
                return bl;
            }
        }
    }

    final int getRenderingAPI() {
        return this.renderingAPI;
    }

    final boolean isD3D() {
        return this.isD3DAPI;
    }

    long getTime() {
        Object object = this.timeLock;
        synchronized (object) {
            long l = this.time++;
            return l;
        }
    }

    void addBHNodeToFreelists(BHNode bHNode) {
        bHNode.parent = null;
        bHNode.mark = false;
        if (bHNode.nodeType == 1) {
            ((BHInternalNode)bHNode).lChild = null;
            ((BHInternalNode)bHNode).rChild = null;
            UnorderList unorderList = this.bhInternalFreeList;
            synchronized (unorderList) {
                this.bhInternalFreeList.add(bHNode);
            }
        }
        if (bHNode.nodeType == 2) {
            UnorderList unorderList = this.bhLeafFreeList;
            synchronized (unorderList) {
                ((BHLeafNode)bHNode).leafIF = null;
                this.bhLeafFreeList.add(bHNode);
            }
        }
    }

    BHNode getBHNode(int n) {
        if (n == 2) {
            UnorderList unorderList = this.bhLeafFreeList;
            synchronized (unorderList) {
                if (this.bhLeafFreeList.size() > 0) {
                    BHNode bHNode = (BHNode)this.bhLeafFreeList.removeLastElement();
                    return bHNode;
                }
                BHLeafNode bHLeafNode = new BHLeafNode();
                return bHLeafNode;
            }
        }
        if (n == 1) {
            UnorderList unorderList = this.bhInternalFreeList;
            synchronized (unorderList) {
                if (this.bhInternalFreeList.size() > 0) {
                    BHNode bHNode = (BHNode)this.bhInternalFreeList.removeLastElement();
                    return bHNode;
                }
                BHInternalNode bHInternalNode = new BHInternalNode();
                return bHInternalNode;
            }
        }
        return null;
    }

    final void addMessageToFreelists(J3dMessage j3dMessage) {
        this.messageFreeList.add(j3dMessage);
    }

    final J3dMessage getMessage() {
        UnorderList unorderList = this.messageFreeList;
        synchronized (unorderList) {
            J3dMessage j3dMessage = this.messageFreeList.size() > 0 ? (J3dMessage)this.messageFreeList.removeLastElement() : new J3dMessage();
            return j3dMessage;
        }
    }

    void processMessage(J3dMessage j3dMessage) {
        j3dMessage.time = this.getTime();
        Object object = this.structureLock;
        synchronized (object) {
            this.sendMessage(j3dMessage);
        }
        this.setWork();
    }

    void processMessage(J3dMessage[] j3dMessageArray) {
        long l = this.getTime();
        Object object = this.structureLock;
        synchronized (object) {
            int n = 0;
            while (n < j3dMessageArray.length) {
                j3dMessageArray[n].time = l;
                this.sendMessage(j3dMessageArray[n]);
                ++n;
            }
        }
        this.setWork();
    }

    void createMasterControlThread() {
        this.running = true;
        this.workToDo = false;
        this.state = 1;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    MasterControl.this.mcThread = new MasterControlThread(rootThreadGroup);
                    MasterControl.this.mcThread.setPriority(threadPriority);
                }
                return null;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    void sendMessage(J3dMessage var1_1) {
        var2_2 = var1_1;
        synchronized (var2_2) {
            block25: {
                block26: {
                    block23: {
                        block24: {
                            var3_3 = var1_1.universe;
                            var4_4 = var1_1.threads;
                            if ((var4_4 & 1024) != 0) {
                                this.renderingAttributesStructure.addMessage(var1_1);
                            }
                            if (var3_3 != null) {
                                if ((var4_4 & 64) != 0) {
                                    var3_3.geometryStructure.addMessage(var1_1);
                                }
                                if ((var4_4 & 8192) != 0) {
                                    var3_3.transformStructure.addMessage(var1_1);
                                }
                                if ((var4_4 & 256) != 0) {
                                    var3_3.behaviorStructure.addMessage(var1_1);
                                }
                                if ((var4_4 & 512) != 0) {
                                    var3_3.soundStructure.addMessage(var1_1);
                                }
                                if ((var4_4 & 4096) != 0) {
                                    var3_3.renderingEnvironmentStructure.addMessage(var1_1);
                                }
                            }
                            if ((var4_4 & 2) == 0) break block23;
                            if (var1_1.view == null || var1_1.view.soundScheduler == null) break block24;
                            var1_1.view.soundScheduler.addMessage(var1_1);
                            break block23;
                        }
                        var5_5 = this.views;
                        synchronized (var5_5) {
                            var6_6 = (View[])this.views.toArray(false);
                            var7_7 = this.views.arraySize() - 1;
                            if (var3_3 != null) ** GOTO lbl37
                            while (var7_7 >= 0) {
                                var6_6[var7_7--].soundScheduler.addMessage(var1_1);
                            }
                            break block23;
lbl-1000:
                            // 1 sources

                            {
                                if (var6_6[var7_7].universe == var3_3) {
                                    var6_6[var7_7].soundScheduler.addMessage(var1_1);
                                }
                                --var7_7;
lbl37:
                                // 2 sources

                                ** while (var7_7 >= 0)
                            }
lbl38:
                            // 1 sources

                        }
                    }
                    if ((var4_4 & 128) == 0) break block25;
                    if (var1_1.view == null || var1_1.view.renderBin == null) break block26;
                    var1_1.view.renderBin.addMessage(var1_1);
                    break block25;
                }
                var5_5 = this.views;
                synchronized (var5_5) {
                    var6_6 = (View[])this.views.toArray(false);
                    var7_7 = this.views.arraySize() - 1;
                    if (var3_3 != null) ** GOTO lbl60
                    while (var7_7 >= 0) {
                        var6_6[var7_7--].renderBin.addMessage(var1_1);
                    }
                    break block25;
lbl-1000:
                    // 1 sources

                    {
                        if (var6_6[var7_7].universe == var3_3) {
                            var6_6[var7_7].renderBin.addMessage(var1_1);
                        }
                        --var7_7;
lbl60:
                        // 2 sources

                        ** while (var7_7 >= 0)
                    }
lbl61:
                    // 1 sources

                }
            }
            if (var1_1.getRefcount() == 0) {
                var1_1.clear();
                this.addMessageToFreelists(var1_1);
            }
        }
    }

    void sendRunMessage(int n) {
        int n2;
        Object[] objectArray;
        UnorderList unorderList;
        long l = this.getTime();
        if ((n & 4) != 0) {
            unorderList = this.inputDeviceThreads;
            synchronized (unorderList) {
                objectArray = (InputDeviceScheduler[])this.inputDeviceThreads.toArray(false);
                n2 = this.inputDeviceThreads.size() - 1;
                while (n2 >= 0) {
                    if (((InputDeviceScheduler)objectArray[n2]).physicalEnv.activeViewRef > 0) {
                        ((InputDeviceScheduler)objectArray[n2]).getThreadData().lastUpdateTime = l;
                    }
                    --n2;
                }
                this.timerThread.addInputDeviceSchedCond();
            }
        }
        if ((n & 0x10) != 0) {
            unorderList = this.renderThreadData;
            synchronized (unorderList) {
                objectArray = (J3dThreadData[])this.renderThreadData.toArray(false);
                n2 = this.renderThreadData.arraySize() - 1;
                while (n2 >= 0) {
                    Object object = objectArray[n2--];
                    if (!((J3dThreadData)object).view.renderBinReady) continue;
                    ((J3dThreadData)object).lastUpdateTime = l;
                }
            }
        }
        this.setWork();
    }

    void sendRunMessage(long l, View view, int n) {
        long l2 = this.getTime();
        if ((n & 2) != 0) {
            if (view.soundScheduler != null) {
                view.soundScheduler.threadData.lastUpdateTime = l2;
            }
            this.timerThread.addSoundSchedCond(l2 + l);
        }
        this.setWork();
    }

    void sendRunMessage(View view, int n) {
        long l = this.getTime();
        if ((n & 0x10) != 0) {
            UnorderList unorderList = this.renderThreadData;
            synchronized (unorderList) {
                J3dThreadData[] j3dThreadDataArray = (J3dThreadData[])this.renderThreadData.toArray(false);
                int n2 = this.renderThreadData.arraySize() - 1;
                while (n2 >= 0) {
                    J3dThreadData j3dThreadData = j3dThreadDataArray[n2--];
                    if (j3dThreadData.view != view || !view.renderBinReady) continue;
                    j3dThreadData.lastUpdateTime = l;
                }
            }
        }
        this.setWork();
    }

    void sendRunMessage(VirtualUniverse virtualUniverse, int n) {
        int n2;
        Object[] objectArray;
        UnorderList unorderList;
        long l = this.getTime();
        if ((n & 1) != 0 && virtualUniverse.behaviorScheduler != null) {
            virtualUniverse.behaviorScheduler.getThreadData(null, null).lastUpdateTime = l;
        }
        if ((n & 0x100) != 0) {
            virtualUniverse.behaviorStructure.threadData.lastUpdateTime = l;
        }
        if ((n & 0x40) != 0) {
            virtualUniverse.geometryStructure.threadData.lastUpdateTime = l;
        }
        if ((n & 0x200) != 0) {
            virtualUniverse.soundStructure.threadData.lastUpdateTime = l;
        }
        if ((n & 2) != 0) {
            unorderList = this.views;
            synchronized (unorderList) {
                objectArray = (View[])this.views.toArray(false);
                n2 = this.views.arraySize() - 1;
                while (n2 >= 0) {
                    if (((View)objectArray[n2]).soundScheduler != null && ((View)objectArray[n2]).universe == virtualUniverse) {
                        ((View)objectArray[n2]).soundScheduler.threadData.lastUpdateTime = l;
                    }
                    --n2;
                }
            }
        }
        if ((n & 0x10) != 0) {
            unorderList = this.renderThreadData;
            synchronized (unorderList) {
                objectArray = (J3dThreadData[])this.renderThreadData.toArray(false);
                n2 = this.renderThreadData.arraySize() - 1;
                while (n2 >= 0) {
                    Object object = objectArray[n2--];
                    if (((J3dThreadData)object).view.universe != virtualUniverse || !((J3dThreadData)object).view.renderBinReady) continue;
                    ((J3dThreadData)object).lastUpdateTime = l;
                }
            }
        }
        this.setWork();
    }

    int numOfViews() {
        return this.views.size();
    }

    View getView(int n) {
        return (View)this.views.get(n);
    }

    boolean isRegistered(View view) {
        return this.views.contains(view);
    }

    private void updateTimeValues() {
        int n = 0;
        J3dThreadData j3dThreadData = null;
        J3dThreadData j3dThreadData2 = null;
        long l = this.currentTime;
        this.currentTime = this.getTime();
        J3dThreadData[] j3dThreadDataArray = (J3dThreadData[])this.stateWorkThreads.toArray(false);
        int n2 = this.stateWorkThreads.arraySize();
        while (n < this.lastTransformStructureThread) {
            j3dThreadData2 = j3dThreadDataArray[n++];
            if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                j3dThreadData = j3dThreadData2;
                j3dThreadData2.needsRun = true;
                j3dThreadData2.threadOpts = 2;
                j3dThreadData2.lastRunTime = this.currentTime;
                continue;
            }
            j3dThreadData2.needsRun = false;
        }
        if (j3dThreadData != null) {
            j3dThreadData.threadOpts = 1;
            j3dThreadData = null;
        }
        while (n < this.lastStructureUpdateThread) {
            j3dThreadData2 = j3dThreadDataArray[n++];
            if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                j3dThreadData = j3dThreadData2;
                j3dThreadData2.needsRun = true;
                j3dThreadData2.threadOpts = 2;
                j3dThreadData2.lastRunTime = this.currentTime;
                continue;
            }
            j3dThreadData2.needsRun = false;
        }
        if (j3dThreadData != null) {
            j3dThreadData.threadOpts = 1;
            j3dThreadData = null;
        }
        while (n < n2) {
            j3dThreadData2 = j3dThreadDataArray[n++];
            if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                j3dThreadData = j3dThreadData2;
                j3dThreadData2.needsRun = true;
                j3dThreadData2.threadOpts = 2;
                j3dThreadData2.lastRunTime = this.currentTime;
                continue;
            }
            j3dThreadData2.needsRun = false;
        }
        if (j3dThreadData != null) {
            j3dThreadData.threadOpts = 1;
            j3dThreadData = null;
        }
        j3dThreadDataArray = (J3dThreadData[])this.renderWorkThreads.toArray(false);
        n2 = this.renderWorkThreads.arraySize();
        View view = null;
        J3dThreadData j3dThreadData3 = null;
        ++this.waitTimestamp;
        n = 0;
        while (n < n2) {
            j3dThreadData2 = j3dThreadDataArray[n];
            if (j3dThreadData2.canvas == null) {
                ((Object[])j3dThreadData2.threadArgs)[3] = null;
            }
            if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                if (j3dThreadData2.thread.lastWaitTimestamp == this.waitTimestamp) {
                    ++this.waitTimestamp;
                    if (j3dThreadData2.view != view) {
                        view = j3dThreadData2.view;
                        j3dThreadData3.threadOpts = 17;
                        ((Object[])j3dThreadData3.threadArgs)[3] = j3dThreadData3.view;
                        j3dThreadData2.threadOpts = 42;
                    } else {
                        j3dThreadData3.threadOpts = (j3dThreadData3.threadOpts & 8) != 0 ? 41 : 1;
                        j3dThreadData2.threadOpts = 2;
                    }
                } else if (j3dThreadData2.view != view) {
                    view = j3dThreadData2.view;
                    if (j3dThreadData3 != null) {
                        j3dThreadData3.threadOpts = 17;
                        ((Object[])j3dThreadData3.threadArgs)[3] = j3dThreadData3.view;
                    }
                    j3dThreadData2.threadOpts = 42;
                } else {
                    j3dThreadData2.threadOpts = 2;
                }
                j3dThreadData2.thread.lastWaitTimestamp = this.waitTimestamp;
                j3dThreadData2.needsRun = true;
                j3dThreadData2.lastRunTime = this.currentTime;
                j3dThreadData3 = j3dThreadData2;
            } else {
                j3dThreadData2.needsRun = false;
            }
            ++n;
        }
        if (j3dThreadData3 != null) {
            j3dThreadData3.threadOpts = 17;
            ((Object[])j3dThreadData3.threadArgs)[3] = j3dThreadData3.view;
        }
        if (this.sleepTime > 0L) {
            this.sleepTime -= this.currentTime - l;
            if (this.sleepTime > 0L) {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void createUpdateThread(J3dStructure j3dStructure) {
        final J3dStructure j3dStructure2 = j3dStructure;
        if (j3dStructure2.updateThread == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        j3dStructure2.updateThread = new StructureUpdateThread(rootThreadGroup, j3dStructure2, j3dStructure2.threadType);
                        j3dStructure2.updateThread.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            j3dStructure2.updateThread.initialize();
            j3dStructure2.threadData.thread = j3dStructure2.updateThread;
            j3dStructure2.threadData.lastUpdateTime = Math.max(this.currentTime, j3dStructure2.threadData.lastUpdateTime);
        }
    }

    private void emptyMessageList(J3dStructure j3dStructure, View view) {
        if (j3dStructure != null) {
            if (view == null) {
                if (j3dStructure.threadData != null) {
                    j3dStructure.threadData.thread = null;
                }
                if (j3dStructure.updateThread != null) {
                    j3dStructure.updateThread.structure = null;
                }
                j3dStructure.updateThread = null;
            }
            boolean bl = false;
            if (view != null && view.universe != null) {
                int n = this.views.size() - 1;
                while (n >= 0) {
                    if (((View)this.views.get((int)n)).universe == view.universe) {
                        bl = true;
                        break;
                    }
                    --n;
                }
            }
            ArrayList arrayList = j3dStructure.messageList;
            synchronized (arrayList) {
                int n = j3dStructure.messageList.size();
                int n2 = n - 1;
                while (n2 >= 0) {
                    J3dMessage j3dMessage = (J3dMessage)j3dStructure.messageList.get(n2);
                    if (view == null || j3dMessage.view == view || j3dMessage.view == null && !bl) {
                        if (j3dMessage.type == 0) break;
                        j3dStructure.messageList.remove(n2);
                        j3dMessage.decRefcount();
                    }
                    --n2;
                }
            }
        }
    }

    private void destroyUpdateThread(J3dStructure j3dStructure) {
        if (j3dStructure.updateThread != null) {
            j3dStructure.updateThread.finish();
            j3dStructure.updateThread.structure = null;
            j3dStructure.updateThread = null;
        }
        j3dStructure.threadData.thread = null;
        ArrayList arrayList = j3dStructure.messageList;
        synchronized (arrayList) {
            int n = j3dStructure.messageList.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                J3dMessage j3dMessage = (J3dMessage)j3dStructure.messageList.get(n2);
                j3dStructure.messageList.remove(n2);
                j3dMessage.decRefcount();
                --n2;
            }
            j3dStructure.nMessage = 0;
            j3dStructure.msgList = null;
        }
    }

    private void registerView(View view) {
        final VirtualUniverse virtualUniverse = view.universe;
        if (this.views.contains(view) && this.regUniverseList.contains(virtualUniverse)) {
            return;
        }
        if (!this.running) {
            this.running = true;
            this.createMCThreads();
        }
        view.assignViewId();
        this.createUpdateThread(virtualUniverse.behaviorStructure);
        this.createUpdateThread(virtualUniverse.geometryStructure);
        this.createUpdateThread(virtualUniverse.soundStructure);
        this.createUpdateThread(virtualUniverse.renderingEnvironmentStructure);
        this.createUpdateThread(virtualUniverse.transformStructure);
        J3dThreadData j3dThreadData = null;
        if (virtualUniverse.behaviorScheduler == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        virtualUniverse.behaviorScheduler = new BehaviorScheduler(rootThreadGroup, virtualUniverse);
                        virtualUniverse.behaviorScheduler.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            virtualUniverse.behaviorScheduler.initialize();
            j3dThreadData = virtualUniverse.behaviorScheduler.getThreadData(null, null);
            j3dThreadData.thread = virtualUniverse.behaviorScheduler;
            j3dThreadData.threadType = 1;
            j3dThreadData.lastUpdateTime = Math.max(this.currentTime, j3dThreadData.lastUpdateTime);
        }
        this.createUpdateThread(view.renderBin);
        this.createUpdateThread(view.soundScheduler);
        if (view.physicalEnvironment != null) {
            view.physicalEnvironment.addUser(view);
        }
        this.evaluatePhysicalEnv(view);
        this.regUniverseList.addUnique(virtualUniverse);
        this.views.addUnique(view);
    }

    private void unregisterView(View view) {
        int n;
        Object object;
        Enumeration enumeration;
        if (!this.views.remove(view)) {
            view.active = false;
            return;
        }
        if (view.active) {
            this.viewDeactivate(view);
        }
        view.soundScheduler.updateThread.finish();
        view.renderBin.updateThread.finish();
        view.renderBin.removeAllRenderAtoms();
        view.cleanupViewId();
        VirtualUniverse virtualUniverse = view.universe;
        Object object2 = this.structureLock;
        synchronized (object2) {
            this.emptyMessageList(view.soundScheduler, view);
            this.emptyMessageList(view.renderBin, view);
            if (virtualUniverse.isEmpty()) {
                this.destroyUniverseThreads(virtualUniverse);
            } else {
                this.emptyMessageList(virtualUniverse.behaviorStructure, view);
                this.emptyMessageList(virtualUniverse.geometryStructure, view);
                this.emptyMessageList(virtualUniverse.soundStructure, view);
                this.emptyMessageList(virtualUniverse.renderingEnvironmentStructure, view);
                this.emptyMessageList(virtualUniverse.transformStructure, view);
            }
        }
        if (view.physicalEnvironment != null) {
            view.physicalEnvironment.removeUser(view);
        }
        UnorderList unorderList = new UnorderList(1, class$javax$media$j3d$PhysicalEnvironment == null ? (class$javax$media$j3d$PhysicalEnvironment = MasterControl.class$("javax.media.j3d.PhysicalEnvironment")) : class$javax$media$j3d$PhysicalEnvironment);
        Enumeration enumeration2 = PhysicalEnvironment.physicalEnvMap.keys();
        while (enumeration2.hasMoreElements()) {
            enumeration = (PhysicalEnvironment)enumeration2.nextElement();
            object = (InputDeviceScheduler)PhysicalEnvironment.physicalEnvMap.get(enumeration);
            n = ((PhysicalEnvironment)((Object)enumeration)).users.size() - 1;
            while (n >= 0) {
                if (this.views.contains((View)((PhysicalEnvironment)((Object)enumeration)).users.get(n))) break;
                --n;
            }
            if (n >= 0) continue;
            ((J3dThread)object).finish();
            ((PhysicalEnvironment)((Object)enumeration)).inputsched = null;
            unorderList.add(enumeration);
        }
        n = unorderList.size() - 1;
        while (n >= 0) {
            PhysicalEnvironment.physicalEnvMap.remove(unorderList.get(n));
            --n;
        }
        if (this.views.isEmpty()) {
            Object object3;
            enumeration = Screen3D.deviceRendererMap.elements();
            while (enumeration.hasMoreElements()) {
                object = (Renderer)enumeration.nextElement();
                this.runMonitor(6, null, null, null, (J3dThread)object);
                object3 = ((Renderer)object).onScreen;
                if (object3 != null && ((Screen3D)object3).renderer != null) {
                    this.runMonitor(6, null, null, null, ((Screen3D)object3).renderer);
                    ((Screen3D)object3).renderer = null;
                }
                if ((object3 = ((Renderer)object).offScreen) != null && ((Screen3D)object3).renderer != null) {
                    this.runMonitor(6, null, null, null, ((Screen3D)object3).renderer);
                    ((Screen3D)object3).renderer = null;
                }
                ((Renderer)object).onScreen = null;
                ((Renderer)object).offScreen = null;
            }
            object = Screen3D.deviceRendererMap.elements();
            while (object.hasMoreElements()) {
                object3 = (Renderer)object.nextElement();
                ((Renderer)object3).cleanup();
            }
        } else {
            enumeration = Screen3D.deviceRendererMap.elements();
            while (enumeration.hasMoreElements()) {
                object = (Renderer)enumeration.nextElement();
                ((J3dThread)object).cleanupView();
            }
        }
        this.freeMessageList.add(virtualUniverse);
        this.freeMessageList.add(view);
        this.evaluateAllCanvases();
        this.stateWorkThreads.clear();
        this.renderWorkThreads.clear();
        this.requestRenderWorkThreads.clear();
        view.reset();
        this.threadListsChanged = true;
    }

    void createMCThreads() {
        this.createUpdateThread(this.renderingAttributesStructure);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    MasterControl.this.timerThread = new TimerThread(rootThreadGroup);
                    MasterControl.this.timerThread.setPriority(threadPriority);
                }
                return null;
            }
        });
        this.timerThread.start();
    }

    private void destroyUniverseThreads(VirtualUniverse virtualUniverse) {
        if (this.regUniverseList.contains(virtualUniverse)) {
            this.destroyUpdateThread(virtualUniverse.behaviorStructure);
            this.destroyUpdateThread(virtualUniverse.geometryStructure);
            this.destroyUpdateThread(virtualUniverse.soundStructure);
            this.destroyUpdateThread(virtualUniverse.renderingEnvironmentStructure);
            this.destroyUpdateThread(virtualUniverse.transformStructure);
            virtualUniverse.behaviorScheduler.finish();
            virtualUniverse.behaviorScheduler.free();
            virtualUniverse.behaviorScheduler = null;
            virtualUniverse.initMCStructure();
            this.activeUniverseList.remove(virtualUniverse);
            this.regUniverseList.remove(virtualUniverse);
        } else {
            this.emptyMessageList(virtualUniverse.behaviorStructure, null);
            this.emptyMessageList(virtualUniverse.geometryStructure, null);
            this.emptyMessageList(virtualUniverse.soundStructure, null);
            this.emptyMessageList(virtualUniverse.renderingEnvironmentStructure, null);
            this.emptyMessageList(virtualUniverse.transformStructure, null);
        }
        if (this.regUniverseList.isEmpty() && this.views.isEmpty()) {
            if (this.renderingAttributesStructure.updateThread != null) {
                this.renderingAttributesStructure.updateThread.finish();
                this.renderingAttributesStructure.updateThread = null;
            }
            this.renderingAttributesStructure.messageList.clear();
            this.renderingAttributesStructure.objList = new ArrayList();
            this.renderingAttributesStructure = new RenderingAttributesStructure();
            if (this.timerThread != null) {
                this.timerThread.finish();
                this.timerThread = null;
            }
            this.deviceScreenMap.clear();
            this.messageFreeList.clear();
            this.bhLeafFreeList.clear();
            this.bhInternalFreeList.clear();
            this.mirrorObjects.clear();
            this.displayListIdFreeList.clear();
            this.texture2DIdFreeList.clear();
            this.texture3DIdFreeList.clear();
            this.canvasBitFreeList.clear();
            this.canvasBitCount = 0;
            this.renderOnceList.clear();
            this.timestampUpdateList.clear();
            Object object = this.transformFreeListLock;
            synchronized (object) {
                this.transformFreeList = new Transform3D[2];
                this.numFreeTransforms = 0;
            }
            this.defaultRenderMethod = null;
            this.text3DRenderMethod = null;
            this.vertexArrayRenderMethod = null;
            this.displayListRenderMethod = null;
            this.compressedGeometryRenderMethod = null;
            this.orientedShape3DRenderMethod = null;
            this.running = false;
        }
    }

    private void evaluateAllCanvases() {
        UnorderList unorderList = this.renderThreadData;
        synchronized (unorderList) {
            this.renderThreadData.clear();
            View[] viewArray = (View[])this.views.toArray(false);
            int n = this.views.size() - 1;
            while (n >= 0) {
                viewArray[n].getCanvasList(true);
                Screen3D[] screen3DArray = viewArray[n].getScreens();
                int n2 = screen3DArray.length - 1;
                while (n2 >= 0) {
                    screen3DArray[n2].canvasCount = 0;
                    --n2;
                }
                --n;
            }
            int n3 = this.views.size() - 1;
            while (n3 >= 0) {
                View view = viewArray[n3];
                Canvas3D[][] canvas3DArray = view.getCanvasList(false);
                if (view.active) {
                    int n4 = canvas3DArray.length - 1;
                    while (n4 >= 0) {
                        boolean bl = false;
                        int n5 = canvas3DArray[n4].length - 1;
                        while (n5 >= 0) {
                            Canvas3D canvas3D = canvas3DArray[n4][n5];
                            final Screen3D screen3D = canvas3D.screen;
                            if (canvas3D.active) {
                                Object object;
                                if (screen3D.canvasCount++ == 0 && screen3D.renderer == null) {
                                    object = (Renderer)Screen3D.deviceRendererMap.get(canvas3D.screen.graphicsDevice);
                                    if (object == null) {
                                        AccessController.doPrivileged(new PrivilegedAction(){

                                            public Object run() {
                                                ThreadGroup threadGroup = rootThreadGroup;
                                                synchronized (threadGroup) {
                                                    screen3D.renderer = new Renderer(rootThreadGroup);
                                                    screen3D.renderer.setPriority(threadPriority);
                                                }
                                                return null;
                                            }
                                        });
                                        screen3D.renderer.initialize();
                                        Screen3D.deviceRendererMap.put(screen3D.graphicsDevice, screen3D.renderer);
                                    } else {
                                        screen3D.renderer = object;
                                    }
                                }
                                if (canvas3D.offScreen) {
                                    screen3D.renderer.offScreen = screen3D;
                                } else {
                                    screen3D.renderer.onScreen = screen3D;
                                    if (!bl) {
                                        object = screen3D.renderer.getThreadData(view, null);
                                        this.renderThreadData.add(object);
                                        if (view.renderBinReady) {
                                            ((J3dThreadData)object).lastUpdateTime = Math.max(this.currentTime, ((J3dThreadData)object).lastUpdateTime);
                                        }
                                        bl = true;
                                    }
                                    object = screen3D.renderer.getThreadData(view, canvas3D);
                                    this.renderThreadData.add(object);
                                    if (view.renderBinReady) {
                                        ((J3dThreadData)object).lastUpdateTime = Math.max(this.currentTime, ((J3dThreadData)object).lastUpdateTime);
                                    }
                                }
                            }
                            --n5;
                        }
                        --n4;
                    }
                }
                --n3;
            }
        }
        this.threadListsChanged = true;
    }

    private void evaluatePhysicalEnv(View view) {
        final PhysicalEnvironment physicalEnvironment = view.physicalEnvironment;
        if (physicalEnvironment.inputsched == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        physicalEnvironment.inputsched = new InputDeviceScheduler(rootThreadGroup, physicalEnvironment);
                        physicalEnvironment.inputsched.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            physicalEnvironment.inputsched.start();
            PhysicalEnvironment.physicalEnvMap.put(physicalEnvironment, physicalEnvironment.inputsched);
        }
        this.threadListsChanged = true;
    }

    private final void addToStateThreads(J3dThreadData j3dThreadData) {
        if (j3dThreadData.thread.active) {
            this.stateWorkThreads.add(j3dThreadData);
        }
    }

    private void assignNewPrimaryView(VirtualUniverse virtualUniverse) {
        View view = virtualUniverse.getCurrentView();
        if (view != null) {
            view.primaryView = false;
        }
        View[] viewArray = (View[])this.views.toArray(false);
        int n = this.views.size();
        int n2 = 0;
        while (n2 < n) {
            View view2 = viewArray[n2];
            if (view2.active && view2.isRunning && virtualUniverse == view2.universe) {
                view2.primaryView = true;
                virtualUniverse.setCurrentView(view2);
                return;
            }
            ++n2;
        }
        virtualUniverse.setCurrentView(null);
    }

    RenderMethod getDefaultRenderMethod() {
        if (this.defaultRenderMethod == null) {
            this.defaultRenderMethod = new DefaultRenderMethod();
        }
        return this.defaultRenderMethod;
    }

    RenderMethod getText3DRenderMethod() {
        if (this.text3DRenderMethod == null) {
            this.text3DRenderMethod = new Text3DRenderMethod();
        }
        return this.text3DRenderMethod;
    }

    RenderMethod getVertexArrayRenderMethod() {
        if (this.vertexArrayRenderMethod == null) {
            this.vertexArrayRenderMethod = new VertexArrayRenderMethod();
        }
        return this.vertexArrayRenderMethod;
    }

    RenderMethod getDisplayListRenderMethod() {
        if (this.displayListRenderMethod == null) {
            this.displayListRenderMethod = new DisplayListRenderMethod();
        }
        return this.displayListRenderMethod;
    }

    RenderMethod getCompressedGeometryRenderMethod() {
        if (this.compressedGeometryRenderMethod == null) {
            this.compressedGeometryRenderMethod = new CompressedGeometryRenderMethod();
        }
        return this.compressedGeometryRenderMethod;
    }

    RenderMethod getOrientedShape3DRenderMethod() {
        if (this.orientedShape3DRenderMethod == null) {
            this.orientedShape3DRenderMethod = new OrientedShape3DRenderMethod();
        }
        return this.orientedShape3DRenderMethod;
    }

    private void viewActivate(View view) {
        VirtualUniverse virtualUniverse = view.universe;
        if (!this.views.contains(view) || !this.regUniverseList.contains(virtualUniverse)) {
            this.registerView(view);
        } else if (view.active) {
            this.evaluateAllCanvases();
            return;
        }
        if (virtualUniverse.activeViewCount == 0) {
            virtualUniverse.geometryStructure.resetConditionMet();
            virtualUniverse.behaviorStructure.resetConditionMet();
        }
        if (view.isRunning) {
            ++this.numActiveViews;
            ++virtualUniverse.activeViewCount;
            this.renderingAttributesStructure.updateThread.active = true;
            virtualUniverse.transformStructure.updateThread.active = true;
            virtualUniverse.geometryStructure.updateThread.active = true;
            virtualUniverse.soundStructure.updateThread.active = true;
            virtualUniverse.renderingEnvironmentStructure.updateThread.active = true;
        }
        virtualUniverse.behaviorScheduler.active = true;
        virtualUniverse.behaviorStructure.updateThread.active = true;
        this.activeUniverseList.addUnique(virtualUniverse);
        if (view.isRunning) {
            view.soundScheduler.activate();
            view.renderBin.updateThread.active = true;
        }
        view.active = true;
        if (view.physicalEnvironment.activeViewRef++ == 0) {
            view.physicalEnvironment.inputsched.activate();
        }
        if (virtualUniverse.getCurrentView() == null) {
            this.assignNewPrimaryView(virtualUniverse);
        }
        this.evaluateAllCanvases();
        view.inRenderThreadData = true;
        this.threadListsChanged = true;
        view.renderBin.reactivateView = true;
    }

    private void viewDeactivate(View view) {
        if (!this.views.contains(view) || !view.active) {
            view.active = false;
            this.evaluateAllCanvases();
            return;
        }
        VirtualUniverse virtualUniverse = view.universe;
        if (view.isRunning) {
            --this.numActiveViews;
            --virtualUniverse.activeViewCount;
        }
        if (this.numActiveViews == 0) {
            this.renderingAttributesStructure.updateThread.active = false;
        }
        if (virtualUniverse.activeViewCount == 0 && virtualUniverse.behaviorScheduler != null) {
            virtualUniverse.behaviorScheduler.deactivate();
            virtualUniverse.transformStructure.updateThread.active = false;
            virtualUniverse.geometryStructure.updateThread.active = false;
            virtualUniverse.behaviorStructure.updateThread.active = false;
            virtualUniverse.soundStructure.updateThread.active = false;
            virtualUniverse.renderingEnvironmentStructure.updateThread.active = false;
            this.activeUniverseList.remove(virtualUniverse);
        }
        view.soundScheduler.deactivate();
        view.renderBin.updateThread.active = false;
        view.active = false;
        if (--view.physicalEnvironment.activeViewRef == 0) {
            view.physicalEnvironment.inputsched.deactivate();
        }
        this.assignNewPrimaryView(virtualUniverse);
        this.evaluateAllCanvases();
        view.inRenderThreadData = false;
        this.threadListsChanged = true;
    }

    private void startView(View view) {
        if (!this.views.contains(view) || view.isRunning || !view.active) {
            view.isRunning = true;
            return;
        }
        ++this.numActiveViews;
        this.renderingAttributesStructure.updateThread.active = true;
        VirtualUniverse virtualUniverse = view.universe;
        ++virtualUniverse.activeViewCount;
        virtualUniverse.transformStructure.updateThread.active = true;
        virtualUniverse.geometryStructure.updateThread.active = true;
        virtualUniverse.soundStructure.updateThread.active = true;
        virtualUniverse.renderingEnvironmentStructure.updateThread.active = true;
        view.renderBin.updateThread.active = true;
        view.soundScheduler.activate();
        view.isRunning = true;
        if (virtualUniverse.getCurrentView() == null) {
            this.assignNewPrimaryView(virtualUniverse);
        }
        this.threadListsChanged = true;
    }

    private void stopView(View view) {
        if (!(this.views.contains(view) && view.isRunning && view.active)) {
            view.isRunning = false;
            return;
        }
        if (--this.numActiveViews == 0) {
            this.renderingAttributesStructure.updateThread.active = false;
        }
        VirtualUniverse virtualUniverse = view.universe;
        if (--virtualUniverse.activeViewCount == 0) {
            virtualUniverse.transformStructure.updateThread.active = false;
            virtualUniverse.geometryStructure.updateThread.active = false;
            virtualUniverse.renderingEnvironmentStructure.updateThread.active = false;
            virtualUniverse.soundStructure.updateThread.active = false;
        }
        view.renderBin.updateThread.active = false;
        view.soundScheduler.deactivate();
        view.isRunning = false;
        this.assignNewPrimaryView(virtualUniverse);
        this.threadListsChanged = true;
    }

    void addInputDeviceScheduler(InputDeviceScheduler inputDeviceScheduler) {
        UnorderList unorderList = this.inputDeviceThreads;
        synchronized (unorderList) {
            this.inputDeviceThreads.add(inputDeviceScheduler);
            if (this.inputDeviceThreads.size() == 1) {
                this.timerThread.addInputDeviceSchedCond();
            }
        }
        this.postRequest(INPUTDEVICE_CHANGE, null);
    }

    void removeInputDeviceScheduler(InputDeviceScheduler inputDeviceScheduler) {
        this.inputDeviceThreads.remove(inputDeviceScheduler);
        this.postRequest(INPUTDEVICE_CHANGE, null);
    }

    void addMirrorObject(ObjectUpdate objectUpdate) {
        this.mirrorObjects.add(objectUpdate);
    }

    void updateMirrorObjects() {
        ObjectUpdate[] objectUpdateArray = (ObjectUpdate[])this.mirrorObjects.toArray(false);
        int n = 0;
        while (n < this.mirrorObjects.arraySize()) {
            objectUpdateArray[n].updateObject();
            ++n;
        }
        this.mirrorObjects.clear();
    }

    private void updateWorkThreads() {
        J3dThreadData j3dThreadData;
        Canvas3D[][] canvas3DArray;
        Object object;
        View[] viewArray;
        this.stateWorkThreads.clear();
        this.renderWorkThreads.clear();
        this.requestRenderWorkThreads.clear();
        if (this.numActiveViews > 0) {
            this.addToStateThreads(this.renderingAttributesStructure.getUpdateThreadData());
        }
        VirtualUniverse[] virtualUniverseArray = (VirtualUniverse[])this.activeUniverseList.toArray(false);
        int n = this.activeUniverseList.arraySize();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.addToStateThreads(virtualUniverseArray[n2].transformStructure.getUpdateThreadData());
            --n2;
        }
        this.lastTransformStructureThread = this.stateWorkThreads.size();
        n2 = n - 1;
        while (n2 >= 0) {
            VirtualUniverse virtualUniverse = virtualUniverseArray[n2];
            this.addToStateThreads(virtualUniverse.geometryStructure.getUpdateThreadData());
            this.addToStateThreads(virtualUniverse.behaviorStructure.getUpdateThreadData());
            this.addToStateThreads(virtualUniverse.renderingEnvironmentStructure.getUpdateThreadData());
            this.addToStateThreads(virtualUniverse.soundStructure.getUpdateThreadData());
            --n2;
        }
        this.lastStructureUpdateThread = this.stateWorkThreads.size();
        n2 = n - 1;
        while (n2 >= 0) {
            this.addToStateThreads(virtualUniverseArray[n2].behaviorScheduler.getThreadData(null, null));
            --n2;
        }
        InputDeviceScheduler[] inputDeviceSchedulerArray = (InputDeviceScheduler[])this.inputDeviceThreads.toArray(true);
        n2 = this.inputDeviceThreads.size() - 1;
        while (n2 >= 0) {
            viewArray = inputDeviceSchedulerArray[n2].getThreadData();
            viewArray.thread.active = true;
            this.addToStateThreads((J3dThreadData)viewArray);
            --n2;
        }
        viewArray = (View[])this.views.toArray(false);
        n2 = this.views.size() - 1;
        while (n2 >= 0) {
            object = viewArray[n2];
            if (((View)object).active && ((View)object).isRunning) {
                int n3;
                this.addToStateThreads(((View)object).renderBin.getUpdateThreadData());
                this.addToStateThreads(((View)object).soundScheduler.getUpdateThreadData());
                canvas3DArray = ((View)object).getCanvasList(false);
                int n4 = ((View)object).getLongestScreenList();
                Object[] objectArray = null;
                int n5 = 0;
                while (n5 < n4) {
                    n3 = 0;
                    while (n3 < canvas3DArray.length) {
                        if (n5 < canvas3DArray[n3].length) {
                            Canvas3D canvas3D = canvas3DArray[n3][n5];
                            if (canvas3D.active && canvas3D.isRunningStatus && !canvas3D.offScreen && canvas3D.screen.renderer != null) {
                                j3dThreadData = canvas3D.screen.renderer.getThreadData((View)object, canvas3D);
                                this.renderWorkThreads.add(j3dThreadData);
                                objectArray = (Object[])j3dThreadData.threadArgs;
                                objectArray[0] = RENDER;
                                objectArray[1] = canvas3D;
                                objectArray[2] = object;
                            }
                        }
                        ++n3;
                    }
                    ++n5;
                }
                n3 = 0;
                while (n3 < canvas3DArray.length) {
                    int n6 = 0;
                    while (n6 < canvas3DArray[n3].length) {
                        Canvas3D canvas3D = canvas3DArray[n3][n6];
                        if (canvas3D.active && canvas3D.isRunningStatus && !canvas3D.offScreen && canvas3D.screen.renderer != null) {
                            j3dThreadData = canvas3D.screen.renderer.getThreadData((View)object, null);
                            this.renderWorkThreads.add(j3dThreadData);
                            objectArray = (Object[])j3dThreadData.threadArgs;
                            objectArray[0] = SWAP;
                            objectArray[1] = object;
                            objectArray[2] = canvas3DArray[n3];
                            break;
                        }
                        ++n6;
                    }
                    ++n3;
                }
            }
            --n2;
        }
        j3dThreadData = null;
        object = Screen3D.deviceRendererMap.elements();
        while (object.hasMoreElements()) {
            canvas3DArray = (Canvas3D[][])object.nextElement();
            j3dThreadData = canvas3DArray.getThreadData(null, null);
            this.requestRenderWorkThreads.add(j3dThreadData);
            j3dThreadData.threadOpts = 2;
            ((Object[])j3dThreadData.threadArgs)[0] = REQUESTRENDER;
        }
        if (j3dThreadData != null) {
            j3dThreadData.threadOpts |= 1;
        }
        this.threadListsChanged = false;
    }

    void dumpWorkThreads() {
        System.err.println("-----------------------------");
        System.err.println("MasterControl/dumpWorkThreads");
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            J3dThreadData[] j3dThreadDataArray;
            switch (n2) {
                case 0: {
                    j3dThreadDataArray = (J3dThreadData[])this.stateWorkThreads.toArray(false);
                    n = this.stateWorkThreads.arraySize();
                    break;
                }
                case 1: {
                    j3dThreadDataArray = (J3dThreadData[])this.renderWorkThreads.toArray(false);
                    n = this.renderWorkThreads.arraySize();
                    break;
                }
                default: {
                    j3dThreadDataArray = (J3dThreadData[])this.requestRenderWorkThreads.toArray(false);
                    n = this.requestRenderWorkThreads.arraySize();
                }
            }
            int n3 = 0;
            while (n3 < n) {
                J3dThreadData j3dThreadData = j3dThreadDataArray[n3];
                System.err.println("Thread " + n3 + ": " + j3dThreadData.thread);
                System.err.println("\tOps: " + j3dThreadData.threadOpts);
                if (j3dThreadData.threadArgs != null) {
                    Object[] objectArray = (Object[])j3dThreadData.threadArgs;
                    System.err.print("\tArgs: ");
                    int n4 = 0;
                    while (n4 < objectArray.length) {
                        System.err.print(objectArray[n4] + " ");
                        ++n4;
                    }
                }
                System.err.println("");
                ++n3;
            }
            ++n2;
        }
        System.err.println("-----------------------------");
    }

    final void setWork() {
        this.runMonitor(1, null, null, null, null);
    }

    final void setWorkForRequestRenderer() {
        this.runMonitor(5, null, null, null, null);
    }

    void doWork() {
        View[] viewArray;
        this.runMonitor(0, null, null, null, null);
        if (this.pendingRequest) {
            viewArray = this.requestObjList;
            synchronized (viewArray) {
                this.handlePendingRequest();
            }
        }
        if (!this.running) {
            return;
        }
        if (this.threadListsChanged) {
            this.updateWorkThreads();
        }
        this.updateTimeValues();
        viewArray = (View[])this.views.toArray(false);
        int n = this.views.size() - 1;
        while (n >= 0) {
            if (viewArray[n].active) {
                viewArray[n].updateViewCache();
            }
            --n;
        }
        this.runMonitor(2, this.stateWorkThreads, this.renderWorkThreads, this.requestRenderWorkThreads, null);
        if (this.renderOnceList.size() > 0) {
            this.clearRenderOnceList();
        }
        if (!this.running) {
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                int n2 = this.requestObjList.size() - 1;
                while (n2 >= 0) {
                    if (this.requestTypeList.get(n2) != FREE_DRAWING_SURFACE) {
                        this.requestObjList.remove(n2);
                        this.requestTypeList.remove(n2);
                    }
                    --n2;
                }
            }
        }
    }

    private void handlePendingRequest() {
        Object object;
        Object object2;
        Object[] objectArray = this.requestObjList.toArray(false);
        Integer[] integerArray = (Integer[])this.requestTypeList.toArray(false);
        int n = this.requestObjList.size();
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = integerArray[n2];
            object2 = objectArray[n2];
            if (n3 == RESET_CANVAS) {
                object = (Canvas3D)object2;
                ((Canvas3D)object).reset();
            } else if (n3 == ACTIVATE_VIEW) {
                this.viewActivate((View)object2);
            } else if (n3 == DEACTIVATE_VIEW) {
                this.viewDeactivate((View)object2);
            } else if (n3 == REEVALUATE_CANVAS) {
                this.evaluateAllCanvases();
            } else if (n3 == INPUTDEVICE_CHANGE) {
                this.inputDeviceThreads.clearMirror();
                this.threadListsChanged = true;
            } else if (n3 == START_VIEW) {
                this.startView((View)object2);
            } else if (n3 == STOP_VIEW) {
                object = (View)object2;
                if (++((View)object).stopViewCount > 4) {
                    ((View)object).stopViewCount = -1;
                    this.stopView((View)object);
                } else {
                    this.tempViewList.add(object);
                }
            } else if (n3 == UNREGISTER_VIEW) {
                this.unregisterView((View)object2);
            } else if (n3 == PHYSICAL_ENV_CHANGE) {
                this.evaluatePhysicalEnv((View)object2);
            } else if (n3 == EMPTY_UNIVERSE) {
                if (this.views.isEmpty()) {
                    this.destroyUniverseThreads((VirtualUniverse)object2);
                    this.threadListsChanged = true;
                }
            } else if (n3 == START_RENDERER) {
                ((Canvas3D)object2).isRunningStatus = true;
                this.threadListsChanged = true;
            } else if (n3 == STOP_RENDERER) {
                ((Canvas3D)object2).isRunningStatus = false;
                this.threadListsChanged = true;
            } else if (n3 == RENDER_ONCE) {
                object = (View)object2;
                this.startView((View)object);
                this.renderOnceList.add(object);
                this.sendRunMessage((View)object, 128);
                this.threadListsChanged = true;
            } else if (n3 == FREE_CONTEXT) {
                object = (Canvas3D)object2;
                if (((Canvas3D)object).screen != null && ((Canvas3D)object).screen.renderer != null) {
                    this.rendererCleanupArgs[1] = object;
                    this.runMonitor(6, null, null, null, ((Canvas3D)object).screen.renderer);
                    this.rendererCleanupArgs[1] = null;
                }
            } else if (n3 == FREE_DRAWING_SURFACE && jvm14) {
                DrawingSurfaceObjectAWT.freeResource(object2);
                this.evaluateAllCanvases();
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < n) {
            object2 = integerArray[n4];
            if (object2 == FREE_MESSAGE) {
                if (objectArray[n4] instanceof VirtualUniverse) {
                    object = (VirtualUniverse)objectArray[n4];
                    if (!this.regUniverseList.contains(object)) {
                        this.emptyMessageList(((VirtualUniverse)object).behaviorStructure, null);
                        this.emptyMessageList(((VirtualUniverse)object).geometryStructure, null);
                        this.emptyMessageList(((VirtualUniverse)object).soundStructure, null);
                        this.emptyMessageList(((VirtualUniverse)object).renderingEnvironmentStructure, null);
                    }
                } else if (objectArray[n4] instanceof View && !this.views.contains(object = (View)objectArray[n4])) {
                    this.emptyMessageList(((View)object).soundScheduler, (View)object);
                    this.emptyMessageList(((View)object).renderBin, (View)object);
                    if (!((View)object).resetUniverse) {
                        ((View)object).universe = null;
                    }
                }
            }
            ++n4;
        }
        this.requestObjList.clear();
        this.requestTypeList.clear();
        n = this.tempViewList.size();
        if (n > 0) {
            int n5;
            if (this.running) {
                n5 = 0;
                while (n5 < n) {
                    this.requestTypeList.add(STOP_VIEW);
                    this.requestObjList.add(this.tempViewList.get(n5));
                    ++n5;
                }
                this.setWork();
            } else {
                n5 = 0;
                while (n5 < n) {
                    object = (View)this.tempViewList.get(n5);
                    ((View)object).stopViewCount = -1;
                    ((View)object).isRunning = false;
                    ++n5;
                }
            }
            this.tempViewList.clear();
            this.pendingRequest = true;
        } else {
            this.pendingRequest = this.requestObjList.size() > 0;
        }
        n = this.freeMessageList.size();
        if (n > 0) {
            int n6 = 0;
            while (n6 < n) {
                this.requestTypeList.add(FREE_MESSAGE);
                this.requestObjList.add(this.freeMessageList.get(n6));
                ++n6;
            }
            this.pendingRequest = true;
            this.freeMessageList.clear();
        }
        if (!this.running && this.renderOnceList.size() > 0) {
            this.clearRenderOnceList();
        }
    }

    private void clearRenderOnceList() {
        int n = this.renderOnceList.size() - 1;
        while (n >= 0) {
            View view = (View)this.renderOnceList.get(n);
            view.renderOnceFinish = true;
            this.stopView(view);
            --n;
        }
        this.renderOnceList.clear();
        this.threadListsChanged = true;
    }

    /*
     * Unable to fully structure code
     */
    synchronized void runMonitor(int var1_1, UnorderList var2_2, UnorderList var3_3, UnorderList var4_4, J3dThread var5_5) {
        switch (var1_1) {
            case 2: {
                var6_6 = 0;
                var7_7 = 0;
                var8_8 = 0;
                var12_9 = (J3dThreadData[])var3_3.toArray(false);
                var13_10 = (J3dThreadData[])var2_2.toArray(false);
                var14_11 = (J3dThreadData[])var4_4.toArray(false);
                var15_12 = var3_3.arraySize();
                var16_13 = var2_2.arraySize();
                var17_14 = var4_4.arraySize();
                this.sleepTime = -1L;
                var10_15 = false;
                ** GOTO lbl126
                {
                    var11_17 = var12_9[var7_7++];
                    if (!var11_17.needsRun) ** GOTO lbl60
                    if ((var11_17.threadOpts & 8) == 0) ** GOTO lbl34
                    var9_16 = (View)((Object[])var11_17.threadArgs)[2];
                    var9_16.computeCycleTime();
                    if (!var9_16.isMinCycleTimeAchieve) {
                        if (this.sleepTime < 0L) {
                            this.sleepTime = var9_16.sleepTime;
                        } else if (this.sleepTime > var9_16.sleepTime) {
                            this.sleepTime = var9_16.sleepTime;
                        }
                        this.sendRunMessage(var9_16, 16);
                    } else {
                        this.sleepTime = 0L;
                        ++var9_16.frameNumber;
                        var9_16.startTime = System.currentTimeMillis();
                        if (var9_16.viewCache.vcDirtyMask != 0 && !var9_16.renderBin.orientedRAs.isEmpty() || var9_16.renderBin.cachedDirtyOrientedRAs != null && !var9_16.renderBin.cachedDirtyOrientedRAs.isEmpty()) {
                            var9_16.renderBin.updateOrientedRAs();
                            var9_16.viewCache.vcDirtyMask = 0;
                        }
lbl34:
                        // 4 sources

                        if (var11_17.view.isMinCycleTimeAchieve) {
                            if ((var11_17.threadOpts & 32) != 0) {
                                var9_16 = (View)((Object[])var11_17.threadArgs)[2];
                                var9_16.renderBin.lockGeometry();
                            }
                            ++this.renderPending;
                            if (this.cpuLimit == 1) {
                                var11_17.thread.args = (Object[])var11_17.threadArgs;
                                var11_17.thread.doWork(this.currentTime);
                            } else {
                                ++this.threadPending;
                                var11_17.thread.runMonitor(2, this.currentTime, (Object[])var11_17.threadArgs);
                            }
                            if ((var11_17.threadOpts & 16) != 0) {
                                var9_16 = (View)((Object[])var11_17.threadArgs)[3];
                                this.timestampUpdateList.add(var9_16);
                                var9_16.renderBin.releaseGeometry();
                            }
                            if (this.cpuLimit != 1 && (var11_17.threadOpts & 1) != 0) {
                                this.renderWaiting = true;
                            }
                            if (this.cpuLimit != 1 && this.cpuLimit == this.threadPending) {
                                this.state = 4;
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException var18_18) {
                                    System.err.println(var18_18);
                                }
                                this.state = 1;
                            }
                        }
                    }
lbl60:
                    // 7 sources

                    do {
                        if (!this.renderWaiting && var7_7 != var15_12) continue block23;
                        while (!this.stateWaiting && var6_6 != var16_13) {
                            var11_17 = var13_10[var6_6++];
                            if (!var11_17.needsRun) continue;
                            ++this.statePending;
                            if (this.cpuLimit == 1) {
                                var11_17.thread.args = (Object[])var11_17.threadArgs;
                                var11_17.thread.doWork(this.currentTime);
                            } else {
                                ++this.threadPending;
                                var11_17.thread.runMonitor(2, this.currentTime, (Object[])var11_17.threadArgs);
                            }
                            if (this.cpuLimit != 1 && (var11_17.threadOpts & 1) != 0) {
                                this.stateWaiting = true;
                            }
                            if (this.cpuLimit == 1 || this.cpuLimit != this.threadPending) continue;
                            this.state = 4;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException var18_20) {
                                System.err.println(var18_20);
                            }
                            this.state = 1;
                        }
                        if (!this.renderWaiting && var7_7 == var15_12) {
                            var8_8 = 0;
                            while (!this.renderWaiting && var8_8 != var17_14) {
                                var11_17 = var14_11[var8_8++];
                                ++this.renderPending;
                                if (this.cpuLimit == 1) {
                                    var11_17.thread.args = (Object[])var11_17.threadArgs;
                                    var11_17.thread.doWork(this.currentTime);
                                } else {
                                    ++this.threadPending;
                                    var11_17.thread.runMonitor(2, this.currentTime, (Object[])var11_17.threadArgs);
                                }
                                if (this.cpuLimit != 1 && (var11_17.threadOpts & 1) != 0) {
                                    this.renderWaiting = true;
                                }
                                if (this.cpuLimit == 1 || this.cpuLimit != this.threadPending) continue;
                                this.state = 4;
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException var18_21) {
                                    System.err.println(var18_21);
                                }
                                this.state = 1;
                            }
                        }
                        if (this.cpuLimit != 1 && (this.renderWaiting != false && var6_6 == var16_13 || this.stateWaiting != false && var7_7 == var15_12 || this.renderWaiting && this.stateWaiting)) {
                            if (!this.requestRenderWorkToDo) {
                                this.state = 3;
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException var18_22) {
                                    System.err.println(var18_22);
                                }
                                this.state = 1;
                            }
                            this.requestRenderWorkToDo = false;
                        }
                        if (var6_6 != var16_13 || var7_7 != var15_12 || var8_8 != var17_14 || this.threadPending != 0) continue;
                        var18_23 = this.timestampUpdateList.size() - 1;
                        while (var18_23 >= 0) {
                            var19_28 = (View)this.timestampUpdateList.get(var18_23);
                            var19_28.setFrameTimingValues();
                            var19_28.universe.behaviorStructure.incElapsedFrames();
                            --var18_23;
                        }
                        this.timestampUpdateList.clear();
                        this.updateMirrorObjects();
                        var10_15 = true;
lbl126:
                        // 3 sources

                    } while (!var10_15);
                }
                break;
            }
            case 3: {
                if (this.state != 5) {
                    --this.threadPending;
                    if (var5_5.type == 16) {
                        var18_24 = (View)var5_5.args[3];
                        if (var18_24 != null) {
                            var18_24.stopTime = System.currentTimeMillis();
                        }
                        if (--this.renderPending == 0) {
                            this.renderWaiting = false;
                        }
                    } else if (--this.statePending == 0) {
                        this.stateWaiting = false;
                    }
                    if (this.state != 4 && this.state != 3) break;
                    this.notify();
                    break;
                }
                this.notify();
                this.state = 1;
                break;
            }
            case 4: {
                while (this.threadPending != 0) {
                    this.state = 3;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var18_25) {
                        System.err.println(var18_25);
                    }
                }
                break;
            }
            case 0: {
                if (!this.workToDo) {
                    this.state = 0;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var18_26) {
                        System.err.println(var18_26);
                    }
                    this.state = 1;
                }
                this.workToDo = false;
                break;
            }
            case 1: {
                this.workToDo = true;
                if (this.state != 0) break;
                this.notify();
                break;
            }
            case 5: {
                this.requestRenderWorkToDo = true;
                if (this.state != 4 && this.state != 3 && this.state != 0) break;
                this.workToDo = true;
                this.notify();
                break;
            }
            case 6: {
                var5_5.runMonitor(2, this.currentTime, this.rendererCleanupArgs);
                this.state = 5;
                try {
                    this.wait();
                    break;
                }
                catch (InterruptedException var18_27) {
                    System.err.println(var18_27);
                }
            }
        }
    }

    void dumpmsg(J3dMessage j3dMessage) {
        System.out.println(this.mtype[j3dMessage.type]);
        if ((j3dMessage.threads & 1) != 0) {
            System.out.println("  BEHAVIOR_SCHEDULER");
        }
        if ((j3dMessage.threads & 2) != 0) {
            System.out.println("  SOUND_SCHEDULER");
        }
        if ((j3dMessage.threads & 4) != 0) {
            System.out.println("  INPUT_DEVICE_SCHEDULER");
        }
        if ((j3dMessage.threads & 0x10) != 0) {
            System.out.println("  RENDER_THREAD");
        }
        if ((j3dMessage.threads & 0x40) != 0) {
            System.out.println("  UPDATE_GEOMETRY");
        }
        if ((j3dMessage.threads & 0x80) != 0) {
            System.out.println("  UPDATE_RENDER");
        }
        if ((j3dMessage.threads & 0x100) != 0) {
            System.out.println("  UPDATE_BEHAVIOR");
        }
        if ((j3dMessage.threads & 0x200) != 0) {
            System.out.println("  UPDATE_SOUND");
        }
        if ((j3dMessage.threads & 0x400) != 0) {
            System.out.println("  UPDATE_RENDERING_ATTRIBUTES");
        }
        if ((j3dMessage.threads & 0x1000) != 0) {
            System.out.println("  UPDATE_RENDERING_ENVIRONMENT");
        }
        if ((j3dMessage.threads & 0x2000) != 0) {
            System.out.println("  UPDATE_TRANSFORM");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        mcThreadLock = new Object();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup;
                Thread thread = Thread.currentThread();
                threadPriority = thread.getPriority();
                rootThreadGroup = thread.getThreadGroup();
                while ((threadGroup = rootThreadGroup.getParent()) != null) {
                    rootThreadGroup = threadGroup;
                }
                rootThreadGroup = new ThreadGroup(rootThreadGroup, "Java3D");
                return null;
            }
        });
    }
}

