/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.MasterControl;
import javax.media.j3d.MultipleParentException;
import javax.media.j3d.PickShape;
import javax.media.j3d.Picking;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;

public class Locale {
    VirtualUniverse universe;
    HiResCoord hiRes;
    Vector branchGroups = new Vector();
    String nodeId = null;

    public Locale(VirtualUniverse virtualUniverse) {
        this.universe = virtualUniverse;
        this.universe.addLocale(this);
        this.hiRes = new HiResCoord();
        this.nodeId = virtualUniverse.getNodeId();
    }

    public Locale(VirtualUniverse virtualUniverse, int[] nArray, int[] nArray2, int[] nArray3) {
        this.universe = virtualUniverse;
        this.universe.addLocale(this);
        this.hiRes = new HiResCoord(nArray, nArray2, nArray3);
        this.nodeId = virtualUniverse.getNodeId();
    }

    public Locale(VirtualUniverse virtualUniverse, HiResCoord hiResCoord) {
        this.universe = virtualUniverse;
        this.universe.addLocale(this);
        this.hiRes = new HiResCoord(hiResCoord);
        this.nodeId = virtualUniverse.getNodeId();
    }

    public VirtualUniverse getVirtualUniverse() {
        return this.universe;
    }

    public void setHiRes(int[] nArray, int[] nArray2, int[] nArray3) {
        this.hiRes.setHiResCoord(nArray, nArray2, nArray3);
    }

    public void setHiRes(HiResCoord hiResCoord) {
        this.hiRes.setHiResCoord(hiResCoord);
    }

    public void getHiRes(HiResCoord hiResCoord) {
        this.hiRes.getHiResCoord(hiResCoord);
    }

    public void addBranchGraph(BranchGroup branchGroup) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        if (((BranchGroupRetained)branchGroup.retained).parent != null || branchGroup.isLive()) {
            throw new MultipleParentException(J3dI18N.getString("Locale0"));
        }
        this.universe.resetWaitMCFlag();
        Object object = this.universe.sceneGraphLock;
        synchronized (object) {
            this.doAddBranchGraph(branchGroup);
            this.universe.setLiveState.reset(this);
        }
        this.universe.waitForMC();
    }

    void doAddBranchGraph(BranchGroup branchGroup) {
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        branchGroupRetained.attachedToLocale = true;
        this.branchGroups.addElement(branchGroup);
        this.universe.setLiveState.reset(this);
        this.universe.setLiveState.currentTransforms[0] = new Transform3D[2];
        this.universe.setLiveState.currentTransforms[0][0] = new Transform3D();
        this.universe.setLiveState.currentTransforms[0][1] = new Transform3D();
        this.universe.setLiveState.currentTransformsIndex[0] = new int[2];
        this.universe.setLiveState.currentTransformsIndex[0][0] = 0;
        this.universe.setLiveState.currentTransformsIndex[0][1] = 0;
        this.universe.setLiveState.parentTransformGroups[0] = new ArrayList();
        branchGroupRetained.setLive(this.universe.setLiveState);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = this.universe.setLiveState.notifyThreads;
        j3dMessage.type = 0;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this.universe.setLiveState.nodeList.toArray();
        VirtualUniverse.mc.processMessage(j3dMessage);
        int n = 0;
        while (n < this.universe.setLiveState.behaviorNodes.size()) {
            BehaviorRetained behaviorRetained = (BehaviorRetained)this.universe.setLiveState.behaviorNodes.get(n);
            behaviorRetained.executeInitialize();
            ++n;
        }
        j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 256;
        j3dMessage.type = 49;
        j3dMessage.universe = this.universe;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    public void removeBranchGraph(BranchGroup branchGroup) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        if (!branchGroup.capabilities.get(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Locale1"));
        }
        this.universe.resetWaitMCFlag();
        Object object = this.universe.sceneGraphLock;
        synchronized (object) {
            this.doRemoveBranchGraph(branchGroup, null, 0);
            this.universe.setLiveState.reset(this);
        }
        this.universe.waitForMC();
    }

    void removeFromUniverse() {
        if (this.branchGroups.size() > 0) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                Object[] objectArray = this.branchGroups.toArray();
                int n = 0;
                while (n < objectArray.length) {
                    this.doRemoveBranchGraph((BranchGroup)objectArray[n], null, 0);
                    ++n;
                }
            }
            this.universe.waitForMC();
        }
        if (this.nodeId != null) {
            this.universe.nodeIdFreeList.addElement(this.nodeId);
            this.nodeId = null;
        }
        this.universe = null;
    }

    void doRemoveBranchGraph(BranchGroup branchGroup, J3dMessage[] j3dMessageArray, int n) {
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        branchGroupRetained.attachedToLocale = false;
        this.branchGroups.removeElement(branchGroup);
        this.universe.setLiveState.reset(this);
        branchGroupRetained.clearLive(this.universe.setLiveState);
        branchGroupRetained.setParent(null);
        branchGroupRetained.setLocale(null);
        J3dMessage j3dMessage = j3dMessageArray == null ? VirtualUniverse.mc.getMessage() : j3dMessageArray[n];
        j3dMessage.threads = this.universe.setLiveState.notifyThreads;
        j3dMessage.type = 1;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this.universe.setLiveState.nodeList.toArray();
        if (j3dMessageArray == null) {
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        if (this.universe.isEmpty()) {
            VirtualUniverse.mc.postRequest(MasterControl.EMPTY_UNIVERSE, this.universe);
        }
        this.universe.setLiveState.reset(null);
    }

    public void replaceBranchGraph(BranchGroup branchGroup, BranchGroup branchGroup2) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        if (!branchGroup.capabilities.get(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Locale1"));
        }
        if (((BranchGroupRetained)branchGroup2.retained).parent != null) {
            throw new MultipleParentException(J3dI18N.getString("Locale3"));
        }
        this.universe.resetWaitMCFlag();
        Object object = this.universe.sceneGraphLock;
        synchronized (object) {
            this.doReplaceBranchGraph(branchGroup, branchGroup2);
            this.universe.setLiveState.reset(this);
        }
        this.universe.waitForMC();
    }

    void doReplaceBranchGraph(BranchGroup branchGroup, BranchGroup branchGroup2) {
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        BranchGroupRetained branchGroupRetained2 = (BranchGroupRetained)branchGroup2.retained;
        this.branchGroups.removeElement(branchGroup);
        this.branchGroups.addElement(branchGroup2);
        branchGroupRetained2.attachedToLocale = true;
        branchGroupRetained.attachedToLocale = false;
        this.universe.setLiveState.reset(this);
        this.universe.setLiveState.currentTransforms[0] = new Transform3D[2];
        this.universe.setLiveState.currentTransforms[0][0] = new Transform3D();
        this.universe.setLiveState.currentTransforms[0][1] = new Transform3D();
        this.universe.setLiveState.currentTransformsIndex[0] = new int[2];
        this.universe.setLiveState.currentTransformsIndex[0][0] = 0;
        this.universe.setLiveState.currentTransformsIndex[0][1] = 0;
        this.universe.setLiveState.parentTransformGroups[0] = new ArrayList();
        branchGroupRetained2.setLive(this.universe.setLiveState);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = this.universe.setLiveState.notifyThreads;
        j3dMessage.type = 0;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this.universe.setLiveState.nodeList.toArray();
        VirtualUniverse.mc.processMessage(j3dMessage);
        Object[] objectArray = this.universe.setLiveState.behaviorNodes.toArray();
        this.universe.setLiveState.reset(this);
        branchGroupRetained.clearLive(this.universe.setLiveState);
        J3dMessage j3dMessage2 = VirtualUniverse.mc.getMessage();
        j3dMessage2.threads = this.universe.setLiveState.notifyThreads;
        j3dMessage2.type = 1;
        j3dMessage2.universe = this.universe;
        j3dMessage2.args[0] = this.universe.setLiveState.nodeList.toArray();
        VirtualUniverse.mc.processMessage(j3dMessage2);
        if (this.universe.isEmpty()) {
            VirtualUniverse.mc.postRequest(MasterControl.EMPTY_UNIVERSE, this.universe);
        }
        int n = 0;
        while (n < objectArray.length) {
            ((BehaviorRetained)objectArray[n]).executeInitialize();
            ++n;
        }
        j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 256;
        j3dMessage.type = 49;
        j3dMessage.universe = this.universe;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    public int numBranchGraphs() {
        return this.branchGroups.size();
    }

    public Enumeration getAllBranchGraphs() {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        return this.branchGroups.elements();
    }

    public SceneGraphPath[] pickAll(PickShape pickShape) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        return Picking.pickAll(this, pickShape);
    }

    public SceneGraphPath[] pickAllSorted(PickShape pickShape) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        return Picking.pickAllSorted(this, pickShape);
    }

    public SceneGraphPath pickClosest(PickShape pickShape) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        return Picking.pickClosest(this, pickShape);
    }

    public SceneGraphPath pickAny(PickShape pickShape) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        return Picking.pickAny(this, pickShape);
    }

    protected void finalize() {
        if (this.universe != null && this.nodeId != null) {
            this.universe.nodeIdFreeList.addElement(this.nodeId);
            this.nodeId = null;
        }
    }
}

