/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Canvas3D;
import javax.media.j3d.J3dThreadData;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

abstract class J3dThread
extends Thread {
    static final int BEHAVIOR_SCHEDULER = 1;
    static final int SOUND_SCHEDULER = 2;
    static final int INPUT_DEVICE_SCHEDULER = 4;
    static final int RENDER_THREAD = 16;
    static final int UPDATE_GEOMETRY = 64;
    static final int UPDATE_RENDER = 128;
    static final int UPDATE_BEHAVIOR = 256;
    static final int UPDATE_SOUND = 512;
    static final int UPDATE_RENDERING_ATTRIBUTES = 1024;
    static final int UPDATE_RENDERING_ENVIRONMENT = 4096;
    static final int UPDATE_TRANSFORM = 8192;
    static final int WORK_THREAD = 1;
    static final int UPDATE_THREAD = 2;
    static final int WAIT = 0;
    static final int NOTIFY_AND_WAIT = 1;
    static final int NOTIFY = 2;
    static final int RUN = 2;
    static final int STOP = 3;
    boolean active = false;
    private boolean running = true;
    private J3dThreadData[] data = null;
    private boolean started = false;
    long referenceTime;
    long lastWaitTimestamp = 0L;
    int type;
    int classification = 1;
    Object[] args = null;
    boolean userStop = false;
    boolean waiting = false;
    private static int numInstances = 0;
    private int instanceNum = -1;

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    abstract void doWork(long var1);

    J3dThread(ThreadGroup threadGroup) {
        super(threadGroup, "");
    }

    synchronized J3dThreadData getThreadData(View view, Canvas3D canvas3D) {
        J3dThreadData j3dThreadData;
        if (this.type != 16) {
            if (this.data == null) {
                this.data = new J3dThreadData[1];
                this.data[0] = new J3dThreadData();
                this.data[0].thread = this;
                this.data[0].threadType = this.type;
                this.data[0].view = null;
                this.data[0].canvas = null;
            }
            j3dThreadData = this.data[0];
        } else if (this.data == null) {
            this.data = new J3dThreadData[1];
            this.data[0] = new J3dThreadData();
            this.data[0].thread = this;
            this.data[0].threadType = this.type;
            this.data[0].view = view;
            this.data[0].canvas = canvas3D;
            this.data[0].threadArgs = new Object[4];
            j3dThreadData = this.data[0];
        } else {
            int n = 0;
            while (n < this.data.length) {
                if (this.data[n].view == view && this.data[n].canvas == canvas3D) break;
                ++n;
            }
            if (n == this.data.length) {
                J3dThreadData[] j3dThreadDataArray = new J3dThreadData[this.data.length + 1];
                int n2 = 0;
                while (n2 < this.data.length) {
                    j3dThreadDataArray[n2] = this.data[n2];
                    ++n2;
                }
                this.data = j3dThreadDataArray;
                this.data[n2] = new J3dThreadData();
                this.data[n2].thread = this;
                this.data[n2].threadType = this.type;
                this.data[n2].view = view;
                this.data[n2].canvas = canvas3D;
                this.data[n2].threadArgs = new Object[4];
                j3dThreadData = this.data[n2];
            } else {
                j3dThreadData = this.data[n];
                Object[] objectArray = (Object[])j3dThreadData.threadArgs;
                objectArray[0] = null;
                objectArray[1] = null;
                objectArray[2] = null;
                objectArray[3] = null;
            }
        }
        return j3dThreadData;
    }

    void initialize() {
        this.start();
        while (!this.started) {
            try {
                Thread.currentThread();
                Thread.sleep(1L, 0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void finish() {
        while (!this.waiting) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.runMonitor(3, 0L, null);
    }

    public void run() {
        this.runMonitor(0, 0L, null);
        while (this.running) {
            this.doWork(this.referenceTime);
            this.runMonitor(1, 0L, null);
        }
        this.shutdown();
    }

    synchronized void runMonitor(int n, long l, Object[] objectArray) {
        switch (n) {
            case 0: {
                try {
                    this.started = true;
                    this.waiting = true;
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println(interruptedException);
                }
                this.waiting = false;
                break;
            }
            case 1: {
                VirtualUniverse.mc.runMonitor(3, null, null, null, this);
                try {
                    this.waiting = true;
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println(interruptedException);
                }
                this.waiting = false;
                break;
            }
            case 2: {
                this.referenceTime = l;
                this.args = objectArray;
                this.notify();
                break;
            }
            case 3: {
                this.running = false;
                this.notify();
            }
        }
    }

    void cleanupView() {
        this.data = null;
    }

    void shutdown() {
    }

    void cleanup() {
        this.active = false;
        this.running = true;
        this.data = null;
        this.started = true;
        this.lastWaitTimestamp = 0L;
        this.classification = 1;
        this.args = null;
        this.userStop = false;
        this.referenceTime = 0L;
    }
}

