/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.IndexedGeometryStripArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

class IndexedTriangleFanArrayRetained
extends IndexedGeometryStripArrayRetained {
    IndexedTriangleFanArrayRetained() {
        this.geoType = 13;
    }

    boolean intersect(PickShape pickShape) {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        double[] dArray = new double[1];
        Bounds bounds = null;
        Point3d[] point3dArray = new Point3d[3];
        if (pickShape instanceof PickRay) {
            n2 = 1;
        } else if (pickShape instanceof PickSegment) {
            n2 = 2;
        } else if (pickShape instanceof PickBounds) {
            bounds = ((PickBounds)pickShape).bounds;
            if (bounds instanceof BoundingBox) {
                n2 = 4;
            } else if (bounds instanceof BoundingSphere) {
                n2 = 5;
            } else if (bounds instanceof BoundingPolytope) {
                n2 = 6;
            }
        } else {
            if (pickShape instanceof PickPoint) {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleFanArrayRetained0"));
            }
            if (pickShape instanceof PickCylinder) {
                n2 = 7;
            } else if (pickShape instanceof PickCone) {
                n2 = 8;
            } else {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        int n3 = 0;
        while (n3 < 3) {
            point3dArray[n3] = new Point3d();
            ++n3;
        }
        n3 = 0;
        while (n3 < this.stripIndexCounts.length) {
            int n4 = 0;
            while (n4 < 2) {
                super.getVertexData(this.indexCoord[n++], point3dArray[n4]);
                ++n4;
            }
            n4 = 2;
            while (n4 < this.stripIndexCounts[n3]) {
                super.getVertexData(this.indexCoord[n++], point3dArray[2]);
                switch (n2) {
                    case 1: {
                        if (!this.intersectRay(point3dArray, (PickRay)pickShape, dArray)) break;
                        return true;
                    }
                    case 2: {
                        if (!this.intersectSegment(point3dArray, ((PickSegment)pickShape).start, ((PickSegment)pickShape).end, dArray)) break;
                        return true;
                    }
                    case 4: {
                        if (!this.intersectBoundingBox(point3dArray, (BoundingBox)((PickBounds)pickShape).bounds)) break;
                        return true;
                    }
                    case 5: {
                        if (!this.intersectBoundingSphere(point3dArray, (BoundingSphere)((PickBounds)pickShape).bounds)) break;
                        return true;
                    }
                    case 6: {
                        if (!this.intersectBoundingPolytope(point3dArray, (BoundingPolytope)((PickBounds)pickShape).bounds)) break;
                        return true;
                    }
                    case 7: {
                        if (!this.intersectCylinder(point3dArray, (PickCylinder)pickShape, dArray)) break;
                        return true;
                    }
                    case 8: {
                        if (!this.intersectCone(point3dArray, (PickCone)pickShape, dArray)) break;
                        return true;
                    }
                }
                point3dArray[1].set((Tuple3d)point3dArray[2]);
                ++n4;
            }
            ++n3;
        }
        return n2 == 3;
    }

    boolean intersect(PickRay pickRay, double[] dArray, Point3d point3d) {
        int n = 0;
        double[] dArray2 = new double[1];
        boolean bl = false;
        Point3d[] point3dArray = new Point3d[3];
        Point3d point3d2 = new Point3d();
        dArray[0] = Double.MAX_VALUE;
        int n2 = 0;
        while (n2 < 3) {
            point3dArray[n2] = new Point3d();
            ++n2;
        }
        n2 = 0;
        while (n2 < this.stripIndexCounts.length) {
            int n3 = 0;
            while (n3 < 2) {
                super.getVertexData(this.indexCoord[n++], point3dArray[n3]);
                ++n3;
            }
            n3 = 2;
            while (n3 < this.stripIndexCounts[n2]) {
                super.getVertexData(this.indexCoord[n++], point3dArray[2]);
                if (this.intersectRay(point3dArray, pickRay, dArray2, point3d2)) {
                    bl = true;
                    if (dArray2[0] < dArray[0]) {
                        dArray[0] = dArray2[0];
                        point3d.x = point3d2.x;
                        point3d.y = point3d2.y;
                        point3d.z = point3d2.z;
                    }
                }
                point3dArray[1].set((Tuple3d)point3dArray[2]);
                ++n3;
            }
            ++n2;
        }
        return bl;
    }

    boolean intersect(Transform3D transform3D, Point3d[] point3dArray) {
        int n = 0;
        Point3d[] point3dArray2 = new Point3d[3];
        double[] dArray = new double[1];
        int n2 = 0;
        while (n2 < 3) {
            point3dArray2[n2] = new Point3d();
            ++n2;
        }
        n2 = 0;
        while (n2 < this.stripIndexCounts.length) {
            int n3 = 0;
            while (n3 < 2) {
                super.getVertexData(this.indexCoord[n++], point3dArray2[n3]);
                transform3D.transform(point3dArray2[n3], point3dArray2[n3]);
                ++n3;
            }
            n3 = 2;
            while (n3 < this.stripIndexCounts[n2]) {
                super.getVertexData(this.indexCoord[n++], point3dArray2[2]);
                transform3D.transform(point3dArray2[2], point3dArray2[2]);
                switch (point3dArray.length) {
                    case 1: {
                        if (!this.intersectTriPnt(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0])) break;
                        return true;
                    }
                    case 2: {
                        if (!this.intersectSegment(point3dArray2, point3dArray[0], point3dArray[1], dArray)) break;
                        return true;
                    }
                    case 3: {
                        if (!this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[1], point3dArray[2])) break;
                        return true;
                    }
                    case 4: {
                        if (this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[1], point3dArray[2])) {
                            return true;
                        }
                        if (!this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[2], point3dArray[3])) break;
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
                point3dArray2[1].set((Tuple3d)point3dArray2[2]);
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        int n = 0;
        Point3d[] point3dArray = new Point3d[3];
        int n2 = 0;
        while (n2 < 3) {
            point3dArray[n2] = new Point3d();
            ++n2;
        }
        n2 = 0;
        while (n2 < this.stripIndexCounts.length) {
            int n3 = 0;
            while (n3 < 2) {
                super.getVertexData(this.indexCoord[n++], point3dArray[n3]);
                transform3D.transform(point3dArray[n3], point3dArray[n3]);
                ++n3;
            }
            n3 = 2;
            while (n3 < this.stripIndexCounts[n2]) {
                super.getVertexData(this.indexCoord[n++], point3dArray[2]);
                transform3D.transform(point3dArray[2], point3dArray[2]);
                if (geometryRetained.intersect(transform3D2, point3dArray)) {
                    return true;
                }
                point3dArray[1].set((Tuple3d)point3dArray[2]);
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Bounds bounds) {
        int n = 0;
        int n2 = 0;
        Point3d[] point3dArray = new Point3d[3];
        int n3 = 0;
        while (n3 < 3) {
            point3dArray[n3] = new Point3d();
            ++n3;
        }
        if (bounds instanceof BoundingBox) {
            n2 = 1;
        } else if (bounds instanceof BoundingSphere) {
            n2 = 2;
        }
        n3 = 0;
        while (n3 < this.stripIndexCounts.length) {
            int n4 = 0;
            while (n4 < 2) {
                super.getVertexData(this.indexCoord[n++], point3dArray[n4]);
                transform3D.transform(point3dArray[n4], point3dArray[n4]);
                ++n4;
            }
            n4 = 2;
            while (n4 < this.stripIndexCounts[n3]) {
                super.getVertexData(this.indexCoord[n++], point3dArray[2]);
                transform3D.transform(point3dArray[2], point3dArray[2]);
                switch (n2) {
                    case 0: {
                        if (!this.intersectBoundingPolytope(point3dArray, (BoundingPolytope)bounds)) break;
                        return true;
                    }
                    case 1: {
                        if (!this.intersectBoundingBox(point3dArray, (BoundingBox)bounds)) break;
                        return true;
                    }
                    case 2: {
                        if (!this.intersectBoundingSphere(point3dArray, (BoundingSphere)bounds)) break;
                        return true;
                    }
                }
                point3dArray[1].set((Tuple3d)point3dArray[2]);
                ++n4;
            }
            ++n3;
        }
        return false;
    }
}

