/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineArrayRetained;
import javax.media.j3d.PointArrayRetained;
import javax.media.j3d.QuadArrayRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.TriangleArrayRetained;

abstract class IndexedGeometryArrayRetained
extends GeometryArrayRetained {
    int[] indexCoord;
    int[] indexColor;
    int[] indexNormal;
    Object[] indexTexCoord;
    int indexCount;
    int[] compileIndexCount;
    int[] compileIndexOffset;

    IndexedGeometryArrayRetained() {
    }

    void createIndexedGeometryArrayData(int n) {
        this.indexCount = n;
        if ((this.vertexFormat & 1) != 0) {
            this.indexCoord = new int[n];
        }
        if ((this.vertexFormat & 2) != 0) {
            this.indexNormal = new int[n];
        }
        if ((this.vertexFormat & 4) != 0) {
            this.indexColor = new int[n];
        }
        if ((this.vertexFormat & 0x20) != 0 || (this.vertexFormat & 0x40) != 0) {
            this.indexTexCoord = new Object[this.texCoordSetCount];
            int n2 = 0;
            while (n2 < this.texCoordSetCount) {
                this.indexTexCoord[n2] = new int[n];
                ++n2;
            }
        }
    }

    Object cloneNonIndexedGeometry() {
        GeometryArrayRetained geometryArrayRetained = null;
        switch (this.geoType) {
            case 11: {
                geometryArrayRetained = new LineArrayRetained();
                break;
            }
            case 10: {
                geometryArrayRetained = new PointArrayRetained();
                break;
            }
            case 8: {
                geometryArrayRetained = new QuadArrayRetained();
                break;
            }
            case 9: {
                geometryArrayRetained = new TriangleArrayRetained();
            }
        }
        geometryArrayRetained.createGeometryArrayData(this.indexCount, this.vertexFormat & 0xFFFFFF7F | 0x100, this.texCoordSetCount, this.texCoordSetMap);
        geometryArrayRetained.unIndexify(this);
        return geometryArrayRetained;
    }

    void execute(int n, RenderAtom renderAtom, boolean bl, boolean bl2, float f) {
        throw new RuntimeException(J3dI18N.getString("IndexedGeometryArrayRetained0"));
    }

    void updateD3Ddata(GeometryArrayRetained geometryArrayRetained) {
        int n = 0;
        int n2 = 0;
        IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)geometryArrayRetained;
        if ((indexedGeometryArrayRetained.vertexFormat & 4) != 0) {
            switch (indexedGeometryArrayRetained.geoType) {
                case 8: {
                    n = 4;
                    break;
                }
                case 9: {
                    n = 3;
                    break;
                }
                case 10: {
                    n = 1;
                    break;
                }
                case 11: {
                    n = 2;
                }
            }
            int n3 = indexedGeometryArrayRetained.indexCount / n;
            int n4 = 0;
            while (n4 < n3) {
                int n5;
                this.vertexData[n2++] = n;
                if ((indexedGeometryArrayRetained.isDirty & 4) != 0) {
                    n5 = indexedGeometryArrayRetained.indexColor[n4 * n] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset;
                    this.vertexData[n2] = indexedGeometryArrayRetained.vertexData[n5];
                    this.vertexData[n2 + 1] = indexedGeometryArrayRetained.vertexData[n5 + 1];
                    this.vertexData[n2 + 2] = indexedGeometryArrayRetained.vertexData[n5 + 2];
                    this.vertexData[n2 + 3] = indexedGeometryArrayRetained.vertexData[n5 + 3];
                }
                n2 += 4;
                int n6 = 0;
                while (n6 < n) {
                    if ((indexedGeometryArrayRetained.isDirty & 1) != 0) {
                        n5 = indexedGeometryArrayRetained.indexCoord[n4 * n + n6] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.coordinateOffset;
                        this.vertexData[n2] = indexedGeometryArrayRetained.vertexData[n5];
                        this.vertexData[n2 + 1] = indexedGeometryArrayRetained.vertexData[n5 + 1];
                        this.vertexData[n2 + 2] = indexedGeometryArrayRetained.vertexData[n5 + 2];
                    }
                    n2 += 3;
                    if ((indexedGeometryArrayRetained.isDirty & 2) != 0) {
                        if ((indexedGeometryArrayRetained.vertexFormat & 2) != 0) {
                            n5 = indexedGeometryArrayRetained.indexNormal[n4 * n + n6] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.normalOffset;
                            this.vertexData[n2] = indexedGeometryArrayRetained.vertexData[n5];
                            this.vertexData[n2 + 1] = indexedGeometryArrayRetained.vertexData[n5 + 1];
                            this.vertexData[n2 + 2] = indexedGeometryArrayRetained.vertexData[n5 + 2];
                        } else {
                            this.vertexData[n2] = 0.0f;
                            this.vertexData[n2 + 1] = 0.0f;
                            this.vertexData[n2 + 2] = 0.0f;
                        }
                    }
                    n2 += 3;
                    if ((indexedGeometryArrayRetained.isDirty & 8) != 0) {
                        int n7;
                        if ((indexedGeometryArrayRetained.vertexFormat & 0x60) != 0) {
                            n7 = 0;
                            while (n7 < indexedGeometryArrayRetained.texCoordSetCount) {
                                n5 = ((int[])indexedGeometryArrayRetained.indexTexCoord[n7])[n4 * n + n6] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.textureOffset;
                                this.vertexData[n2] = indexedGeometryArrayRetained.vertexData[n5];
                                this.vertexData[n2 + 1] = indexedGeometryArrayRetained.vertexData[n5 + 1];
                                n2 += 2;
                                ++n7;
                            }
                        } else {
                            n7 = 0;
                            while (n7 < indexedGeometryArrayRetained.texCoordSetCount) {
                                this.vertexData[n2] = 0.0f;
                                this.vertexData[n2 + 1] = 0.0f;
                                n2 += 2;
                                ++n7;
                            }
                        }
                    } else {
                        n2 += 2 * indexedGeometryArrayRetained.texCoordSetCount;
                    }
                    ++n6;
                }
                ++n4;
            }
        } else {
            this.vertexData[n2++] = indexedGeometryArrayRetained.vertexCount;
            int n8 = 0;
            while (n8 < indexedGeometryArrayRetained.vertexCount) {
                int n9;
                if ((indexedGeometryArrayRetained.isDirty & 1) != 0) {
                    n9 = indexedGeometryArrayRetained.indexCoord[n8] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.coordinateOffset;
                    this.vertexData[n2] = indexedGeometryArrayRetained.vertexData[n9];
                    this.vertexData[n2 + 1] = indexedGeometryArrayRetained.vertexData[n9 + 1];
                    this.vertexData[n2 + 2] = indexedGeometryArrayRetained.vertexData[n9 + 2];
                }
                n2 += 3;
                if ((indexedGeometryArrayRetained.isDirty & 2) != 0) {
                    if ((indexedGeometryArrayRetained.vertexFormat & 2) != 0) {
                        n9 = indexedGeometryArrayRetained.indexNormal[n8] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.normalOffset;
                        this.vertexData[n2] = indexedGeometryArrayRetained.vertexData[n9];
                        this.vertexData[n2 + 1] = indexedGeometryArrayRetained.vertexData[n9 + 1];
                        this.vertexData[n2 + 2] = indexedGeometryArrayRetained.vertexData[n9 + 2];
                    } else {
                        this.vertexData[n2] = 0.0f;
                        this.vertexData[n2 + 1] = 0.0f;
                        this.vertexData[n2 + 2] = 0.0f;
                    }
                }
                n2 += 3;
                if ((indexedGeometryArrayRetained.isDirty & 8) != 0) {
                    int n10;
                    if ((indexedGeometryArrayRetained.vertexFormat & 0x60) != 0) {
                        n10 = 0;
                        while (n10 < indexedGeometryArrayRetained.texCoordSetCount) {
                            n9 = ((int[])indexedGeometryArrayRetained.indexTexCoord[n10])[n8] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.textureOffset;
                            this.vertexData[n2] = indexedGeometryArrayRetained.vertexData[n9];
                            this.vertexData[n2 + 1] = indexedGeometryArrayRetained.vertexData[n9 + 1];
                            n2 += 2;
                            ++n10;
                        }
                    } else {
                        n10 = 0;
                        while (n10 < indexedGeometryArrayRetained.texCoordSetCount) {
                            this.vertexData[n2] = 0.0f;
                            this.vertexData[n2 + 1] = 0.0f;
                            n2 += 2;
                            ++n10;
                        }
                    }
                }
                ++n8;
            }
        }
    }

    int getIndexCount() {
        return this.indexCount;
    }

    final void setCoordinateIndex(int n, int n2) {
        this.geomLock.getLock();
        this.indexCoord[n] = n2;
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    final void setCoordinateIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        this.geomLock.getLock();
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            this.indexCoord[n4] = nArray[n3];
            ++n3;
            ++n4;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    final void setColorIndex(int n, int n2) {
        this.geomLock.getLock();
        this.indexColor[n] = n2;
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    final void setColorIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        this.geomLock.getLock();
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            this.indexColor[n4] = nArray[n3];
            ++n3;
            ++n4;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    final void setNormalIndex(int n, int n2) {
        this.geomLock.getLock();
        this.indexNormal[n] = n2;
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    final void setNormalIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        this.geomLock.getLock();
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            this.indexNormal[n4] = nArray[n3];
            ++n3;
            ++n4;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    final void setTextureCoordinateIndex(int n, int n2, int n3) {
        this.geomLock.getLock();
        int[] nArray = (int[])this.indexTexCoord[n];
        nArray[n2] = n3;
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    final void setTextureCoordinateIndices(int n, int n2, int[] nArray) {
        int n3 = nArray.length;
        int[] nArray2 = (int[])this.indexTexCoord[n];
        this.geomLock.getLock();
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            nArray2[n5] = nArray[n4];
            ++n4;
            ++n5;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    final int getCoordinateIndex(int n) {
        return this.indexCoord[n];
    }

    final void getCoordinateIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            nArray[n3] = this.indexCoord[n4];
            ++n3;
            ++n4;
        }
    }

    final int getColorIndex(int n) {
        return this.indexColor[n];
    }

    final void getColorIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            nArray[n3] = this.indexColor[n4];
            ++n3;
            ++n4;
        }
    }

    final int getNormalIndex(int n) {
        return this.indexNormal[n];
    }

    final void getNormalIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            nArray[n3] = this.indexNormal[n4];
            ++n3;
            ++n4;
        }
    }

    final int getTextureCoordinateIndex(int n, int n2) {
        return ((int[])this.indexTexCoord[n])[n2];
    }

    final void getTextureCoordinateIndices(int n, int n2, int[] nArray) {
        int n3 = nArray.length;
        int[] nArray2 = (int[])this.indexTexCoord[n];
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            nArray[n4] = nArray2[n5];
            ++n4;
            ++n5;
        }
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n = arrayList.size();
        int[] nArray = null;
        this.indexCount = 0;
        int n2 = 0;
        while (n2 < n) {
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)arrayList.get(n2);
            this.indexCount += indexedGeometryArrayRetained.indexCount;
            ++n2;
        }
        this.compileIndexCount = new int[n];
        this.compileIndexOffset = new int[n];
        this.indexCoord = new int[this.indexCount];
        if ((this.vertexFormat & 4) != 0) {
            this.indexColor = new int[this.indexCount];
        }
        if ((this.vertexFormat & 2) != 0) {
            this.indexNormal = new int[this.indexCount];
        }
        if ((this.vertexFormat & 0x60) != 0) {
            this.indexTexCoord = new Object[1];
            this.indexTexCoord[0] = new int[this.indexCount];
            nArray = (int[])this.indexTexCoord[0];
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6;
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)arrayList.get(n5);
            this.compileIndexCount[n5] = n6 = indexedGeometryArrayRetained.indexCount;
            int n7 = 0;
            while (n7 < n6) {
                this.indexCoord[n7 + n4] = indexedGeometryArrayRetained.indexCoord[n7] + n3;
                if ((this.vertexFormat & 4) != 0) {
                    this.indexColor[n7 + n4] = indexedGeometryArrayRetained.indexColor[n7] + n3;
                }
                if ((this.vertexFormat & 2) != 0) {
                    this.indexNormal[n7 + n4] = indexedGeometryArrayRetained.indexNormal[n7] + n3;
                }
                if ((this.vertexFormat & 0x60) != 0) {
                    nArray[n7 + n4] = ((int[])indexedGeometryArrayRetained.indexTexCoord[0])[n7] + n3;
                }
                ++n7;
            }
            this.compileIndexOffset[n5] = n4;
            n3 += indexedGeometryArrayRetained.vertexCount;
            n4 += n6;
            ++n5;
        }
        super.mergeGeometryArrays(arrayList);
    }

    boolean isWriteStatic() {
        return super.isWriteStatic() && !this.source.capabilities.get(10) && !this.source.capabilities.get(12) && !this.source.capabilities.get(14) && !this.source.capabilities.get(16);
    }

    int getIndexCount(int n) {
        return this.compileIndexCount[n];
    }
}

