/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;

class HashedUnorderList
implements Cloneable,
Serializable {
    transient Object[] elementData;
    HashMap map;
    transient Object[] cloneData;
    transient int cloneSize;
    transient boolean isDirty = true;
    Class componentType;
    int size;
    static /* synthetic */ Class class$java$lang$Object;

    HashedUnorderList(int n, Class clazz) {
        this.componentType = clazz;
        this.elementData = (Object[])Array.newInstance(clazz, n);
        this.map = new HashMap();
    }

    HashedUnorderList(Class clazz) {
        this(10, clazz);
    }

    HashedUnorderList(int n) {
        this(n, class$java$lang$Object == null ? (class$java$lang$Object = HashedUnorderList.class$("java.lang.Object")) : class$java$lang$Object);
    }

    HashedUnorderList() {
        this(10, class$java$lang$Object == null ? (class$java$lang$Object = HashedUnorderList.class$("java.lang.Object")) : class$java$lang$Object);
    }

    final int size() {
        return this.size;
    }

    final int arraySize() {
        return this.cloneSize;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final synchronized boolean contains(Object object) {
        boolean bl = this.map.containsKey(object);
        return bl;
    }

    final synchronized boolean addUnique(Object object) {
        if (!this.contains(object)) {
            this.add(object);
            return true;
        }
        return false;
    }

    final synchronized int indexOf(Object object) {
        LinkedList linkedList = (LinkedList)this.map.get(object);
        if (linkedList != null) {
            return (Integer)linkedList.getLast();
        }
        return -1;
    }

    protected final synchronized Object clone() {
        try {
            HashedUnorderList hashedUnorderList = (HashedUnorderList)super.clone();
            hashedUnorderList.elementData = (Object[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(this.elementData, 0, hashedUnorderList.elementData, 0, this.size);
            hashedUnorderList.map = (HashMap)this.map.clone();
            this.isDirty = true;
            return hashedUnorderList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    final synchronized Object[] toArray(boolean bl) {
        if (bl) {
            if (this.isDirty) {
                if (this.cloneData == null || this.cloneData.length < this.size) {
                    this.cloneData = (Object[])Array.newInstance(this.componentType, this.size);
                }
                System.arraycopy(this.elementData, 0, this.cloneData, 0, this.size);
                this.cloneSize = this.size;
                this.isDirty = false;
            }
            return this.cloneData;
        }
        this.cloneSize = this.size;
        return this.elementData;
    }

    final synchronized Object[] toArray() {
        return this.toArray(true);
    }

    final Object[] toArray(Object object) {
        int n = this.indexOf(object);
        if (n < 0) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        int n2 = this.size - n;
        Object[] objectArray = (Object[])Array.newInstance(this.componentType, n2);
        System.arraycopy(this.elementData, n, objectArray, 0, n2);
        return objectArray;
    }

    final synchronized void trimToSize() {
        if (this.elementData.length > this.size) {
            Object[] objectArray = this.elementData;
            this.elementData = (Object[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
    }

    final synchronized Object get(int n) {
        return this.elementData[n];
    }

    final synchronized void set(int n, Object object) {
        LinkedList<Integer> linkedList = (LinkedList<Integer>)this.map.get(this.elementData[n]);
        if (linkedList.size() == 1) {
            this.map.remove(this.elementData[n]);
        } else {
            linkedList.remove(new Integer(n));
        }
        linkedList = (LinkedList)this.map.get(object);
        if (linkedList == null) {
            linkedList = new LinkedList<Integer>();
            this.map.put(object, linkedList);
        }
        linkedList.addFirst(new Integer(n));
        this.elementData[n] = object;
        this.isDirty = true;
    }

    final synchronized void add(Object object) {
        Object object2;
        if (this.elementData.length == this.size) {
            object2 = this.elementData;
            this.elementData = (Object[])Array.newInstance(this.componentType, this.size << 1);
            System.arraycopy(object2, 0, this.elementData, 0, this.size);
        }
        if ((object2 = (LinkedList)this.map.get(object)) == null) {
            object2 = new LinkedList();
            this.map.put(object, object2);
        }
        object2.addFirst(new Integer(this.size));
        this.elementData[this.size++] = object;
        this.isDirty = true;
    }

    final synchronized void remove(int n) {
        LinkedList linkedList = (LinkedList)this.map.get(this.elementData[n]);
        if (linkedList.size() == 1) {
            this.map.remove(this.elementData[n]);
        } else {
            linkedList.remove(new Integer(n));
        }
        this.elementData[n] = this.elementData[--this.size];
        this.updateIndex(this.size, n);
        this.elementData[this.size] = null;
        this.isDirty = true;
    }

    final synchronized Object removeLastElement() {
        Object object;
        LinkedList linkedList;
        if ((linkedList = (LinkedList)this.map.get(object = this.elementData[--this.size])).size() == 1) {
            this.map.remove(object);
        } else {
            linkedList.remove(new Integer(this.size));
        }
        this.elementData[this.size] = null;
        this.isDirty = true;
        return object;
    }

    final synchronized boolean remove(Object object) {
        --this.size;
        LinkedList linkedList = (LinkedList)this.map.get(object);
        if (linkedList != null) {
            this.elementData[((Integer)linkedList.getFirst()).intValue()] = this.elementData[this.size];
            this.updateIndex(this.size, (Integer)linkedList.getFirst());
            this.elementData[this.size] = null;
            if (linkedList.size() == 1) {
                this.map.remove(object);
            } else {
                linkedList.removeFirst();
            }
            this.isDirty = true;
            return true;
        }
        ++this.size;
        return false;
    }

    private void updateIndex(int n, int n2) {
        LinkedList linkedList = (LinkedList)this.map.get(this.elementData[n]);
        linkedList.remove(new Integer(n));
        linkedList.addFirst(new Integer(n2));
    }

    final synchronized void clear() {
        int n = this.size - 1;
        while (n >= 0) {
            this.elementData[n] = null;
            --n;
        }
        this.map.clear();
        this.size = 0;
        this.isDirty = true;
    }

    final synchronized void clearMirror() {
        if (this.cloneData != null) {
            int n = this.cloneData.length - 1;
            while (n >= 0) {
                this.cloneData[n] = null;
                --n;
            }
        }
        this.cloneSize = 0;
        this.isDirty = true;
    }

    final Class getComponentType() {
        return this.componentType;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("Size = " + this.size + "\n[");
        int n = this.size - 1;
        int n2 = 0;
        while (n2 < this.size) {
            Object object = this.elementData[n2];
            if (object != null) {
                stringBuffer.append(this.elementData[n2].toString());
            } else {
                stringBuffer.append("NULL");
            }
            if (n2 != n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        int n = 0;
        while (n < this.size) {
            objectOutputStream.writeObject(this.elementData[n]);
            ++n;
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elementData = (Object[])Array.newInstance(this.componentType, n);
        int n2 = 0;
        while (n2 < this.size) {
            this.elementData[n2] = objectInputStream.readObject();
            ++n2;
        }
    }

    private void printList(String string, Object object) {
        System.out.println(string + " " + object);
        LinkedList linkedList = (LinkedList)this.map.get(object);
        if (linkedList == null) {
            System.out.println("null");
        } else {
            ListIterator listIterator = linkedList.listIterator(0);
            while (listIterator.hasNext()) {
                System.out.print((Integer)listIterator.next() + " ");
            }
            System.out.println();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

