/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CompileState;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.ContainsNodesList;
import javax.media.j3d.FogRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.MultipleParentException;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrderedGroupRetained;
import javax.media.j3d.OrderedPathList;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;

class GroupRetained
extends NodeRetained
implements BHLeafInterface {
    Vector children = new Vector(5);
    Bounds collisionBound = null;
    Locale locale = null;
    ArrayList lights = new ArrayList(1);
    ArrayList fogs = new ArrayList(0);
    ArrayList modelClips = new ArrayList(0);
    ArrayList altAppearances = new ArrayList(0);
    boolean collisionTarget = false;
    ArrayList childrenContainsNodesList = new ArrayList();
    ArrayList childrenSwitchLinks = new ArrayList(1);
    OrderedPathList orderedPaths = null;
    ArrayList inOrderedGroups = null;
    BoundingBox collisionVwcBounds;
    ArrayList mirrorGroup;
    HashKey key;
    GroupRetained sourceNode;
    BHLeafNode bhLeafNode = null;
    SwitchRetained closestSwitchParent = null;
    int closestSwitchIndex = -1;
    int switchIndexCount = 0;
    boolean isRoot = false;
    int scopingRefCount = 0;
    Vector compiledChildrenList = null;
    boolean isInClearLive = false;

    GroupRetained() {
        this.nodeType = 23;
        this.localBounds = new BoundingSphere();
        ((BoundingSphere)this.localBounds).setRadius(-1.0);
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds == null ? null : (Bounds)bounds.clone();
        if (this.source.isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8256;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    Bounds getCollisionBounds() {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    void setChild(Node node, int n) {
        this.checkValidChild(node, "GroupRetained0");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doSetChild(node, n);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doSetChild(node, n);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
    }

    void doSetChild(Node node, int n) {
        J3dMessage[] j3dMessageArray = null;
        int n2 = 0;
        int n3 = 0;
        if (this instanceof SwitchRetained || this instanceof SharedGroupRetained) {
            this.replaceChildrenSwitchData(n);
        }
        NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
        if (this.source.isLive()) {
            if (nodeRetained != null) {
                n2 += 2;
                n3 = 2;
            }
            if (node != null) {
                n2 += 2;
                if (this instanceof OrderedGroupRetained) {
                    ++n2;
                }
            }
            j3dMessageArray = new J3dMessage[n2];
            int n4 = 0;
            while (n4 < n2) {
                j3dMessageArray[n4] = VirtualUniverse.mc.getMessage();
                ++n4;
            }
        }
        if (nodeRetained != null) {
            nodeRetained.setParent(null);
            this.checkClearLive(nodeRetained, j3dMessageArray, 0, n);
        }
        if (node == null) {
            this.children.setElementAt(null, n);
            if (j3dMessageArray != null) {
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            }
            return;
        }
        NodeRetained nodeRetained2 = (NodeRetained)node.retained;
        nodeRetained2.setParent(this);
        this.children.setElementAt(nodeRetained2, n);
        if (this instanceof OrderedGroupRetained && this.source.isLive()) {
            OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)this;
            nodeRetained2.orderedId = orderedGroupRetained.getOrderedChildId();
            J3dMessage j3dMessage = j3dMessageArray[n3++];
            j3dMessage.threads = 4224;
            j3dMessage.type = 32;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = nodeRetained2.orderedId;
        }
        this.checkSetLive(nodeRetained2, j3dMessageArray, n3, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)nodeRetained2).isNew = true;
        }
        if (j3dMessageArray != null) {
            VirtualUniverse.mc.processMessage(j3dMessageArray);
        }
    }

    void insertChild(Node node, int n) {
        this.checkValidChild(node, "GroupRetained1");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doInsertChild(node, n);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doInsertChild(node, n);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
    }

    void doInsertChild(Node node, int n) {
        if (this instanceof SwitchRetained || this instanceof SharedGroupRetained) {
            this.insertChildrenSwitchData(n);
        }
        int n2 = n;
        while (n2 < this.children.size()) {
            NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n2);
            if (nodeRetained != null) {
                ++nodeRetained.childIndex;
            }
            ++n2;
        }
        if (node == null) {
            this.children.insertElementAt(null, n);
            return;
        }
        NodeRetained nodeRetained = (NodeRetained)node.retained;
        nodeRetained.setParent(this);
        this.children.insertElementAt(nodeRetained, n);
        if (this instanceof OrderedGroupRetained && this.source.isLive()) {
            OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)this;
            nodeRetained.orderedId = orderedGroupRetained.getOrderedChildId();
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 4224;
            j3dMessage.type = 32;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = nodeRetained.orderedId;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        this.checkSetLive(nodeRetained, null, 0, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)nodeRetained).isNew = true;
        }
    }

    void removeChild(int n) {
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doRemoveChild(n, null, 0);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doRemoveChild(n, null, 0);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
    }

    void doRemoveChild(int n, J3dMessage[] j3dMessageArray, int n2) {
        NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
        int n3 = n;
        while (n3 < this.children.size()) {
            NodeRetained nodeRetained2 = (NodeRetained)this.children.elementAt(n3);
            if (nodeRetained2 != null) {
                --nodeRetained2.childIndex;
            }
            ++n3;
        }
        if (nodeRetained != null) {
            nodeRetained.setParent(null);
            this.checkClearLive(nodeRetained, j3dMessageArray, n2, n);
        }
        this.children.removeElementAt(n);
        if (this instanceof SwitchRetained || this instanceof SharedGroupRetained) {
            this.removeChildrenSwitchData(n);
        }
        if (this.nodeType == 18) {
            SwitchRetained switchRetained = (SwitchRetained)this;
            switchRetained.setWhichChild(switchRetained.whichChild, true);
        }
    }

    Node getChild(int n) {
        SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.elementAt(n);
        if (sceneGraphObjectRetained == null) {
            return null;
        }
        return (Node)sceneGraphObjectRetained.source;
    }

    Enumeration getAllChildren() {
        Vector<SceneGraphObject> vector = new Vector<SceneGraphObject>(this.children.size());
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)enumeration.nextElement();
            if (sceneGraphObjectRetained == null) {
                vector.addElement(null);
                continue;
            }
            vector.addElement(sceneGraphObjectRetained.source);
        }
        return vector.elements();
    }

    void checkValidChild(Node node, String string) {
        if (node != null && (node instanceof BranchGroup && ((BranchGroupRetained)node.retained).attachedToLocale || ((NodeRetained)node.retained).parent != null)) {
            throw new MultipleParentException(J3dI18N.getString(string));
        }
    }

    void addChild(Node node) {
        this.checkValidChild(node, "GroupRetained2");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doAddChild(node, null, 0);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doAddChild(node, null, 0);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
    }

    void doAddChild(Node node, J3dMessage[] j3dMessageArray, int n) {
        if (this instanceof SwitchRetained || this instanceof SharedGroupRetained) {
            this.appendChildrenSwitchData();
        }
        if (node == null) {
            this.children.addElement(null);
            return;
        }
        NodeRetained nodeRetained = (NodeRetained)node.retained;
        nodeRetained.setParent(this);
        this.children.addElement(nodeRetained);
        if (this instanceof OrderedGroupRetained && this.source.isLive()) {
            J3dMessage j3dMessage;
            OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)this;
            nodeRetained.orderedId = orderedGroupRetained.getOrderedChildId();
            if (j3dMessageArray == null) {
                j3dMessage = VirtualUniverse.mc.getMessage();
            } else {
                j3dMessage = j3dMessageArray[n];
                ++n;
            }
            j3dMessage.threads = 4224;
            j3dMessage.type = 32;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(this.children.size() - 1);
            j3dMessage.args[2] = nodeRetained.orderedId;
            if (j3dMessageArray == null) {
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
        this.checkSetLive(nodeRetained, j3dMessageArray, n, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)nodeRetained).isNew = true;
        }
    }

    void moveTo(BranchGroup branchGroup) {
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doMoveTo(branchGroup);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doMoveTo(branchGroup);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
    }

    void doMoveTo(BranchGroup branchGroup) {
        J3dMessage[] j3dMessageArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (branchGroup != null) {
            BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
            GroupRetained groupRetained = (GroupRetained)branchGroupRetained.parent;
            if (groupRetained != null) {
                if (groupRetained.source.isLive()) {
                    n = 2;
                    n3 = 2;
                } else {
                    n = 0;
                    n3 = 0;
                }
            } else {
                n = 1;
                n3 = 1;
            }
            if (this.source.isLive()) {
                n += 2;
                if (this instanceof OrderedGroupRetained) {
                    ++n;
                }
            }
            j3dMessageArray = new J3dMessage[n];
            int n4 = 0;
            while (n4 < n) {
                j3dMessageArray[n4] = VirtualUniverse.mc.getMessage();
                ++n4;
            }
            if (groupRetained == null) {
                if (branchGroupRetained.locale != null) {
                    branchGroupRetained.locale.doRemoveBranchGraph(branchGroup, j3dMessageArray, n2);
                }
            } else {
                groupRetained.doRemoveChild(groupRetained.children.indexOf(branchGroupRetained), j3dMessageArray, n2);
            }
        }
        this.doAddChild(branchGroup, j3dMessageArray, n3);
        if (n > 0) {
            VirtualUniverse.mc.processMessage(j3dMessageArray);
        }
    }

    void replaceChildrenSwitchData(int n) {
        ContainsNodesList containsNodesList = (ContainsNodesList)this.childrenContainsNodesList.get(n);
        containsNodesList.clearListAndClearContainsNodes();
        this.childrenContainsNodesList.set(n, new ContainsNodesList());
        ArrayList arrayList = (ArrayList)this.childrenSwitchLinks.get(n);
        arrayList.clear();
        this.childrenSwitchLinks.set(n, new ArrayList(1));
    }

    void insertChildrenSwitchData(int n) {
        this.childrenContainsNodesList.add(n, new ContainsNodesList());
        this.childrenSwitchLinks.add(n, new ArrayList(1));
    }

    void appendChildrenSwitchData() {
        this.childrenContainsNodesList.add(new ContainsNodesList());
        this.childrenSwitchLinks.add(new ArrayList(1));
    }

    void removeChildrenSwitchData(int n) {
        ContainsNodesList containsNodesList = (ContainsNodesList)this.childrenContainsNodesList.get(n);
        containsNodesList.clearListAndClearContainsNodes();
        this.childrenContainsNodesList.remove(n);
        ArrayList arrayList = (ArrayList)this.childrenSwitchLinks.get(n);
        arrayList.clear();
        this.childrenSwitchLinks.remove(n);
    }

    int numChildren() {
        return this.children.size();
    }

    void removeLight(LightRetained lightRetained) {
        int n = this.lights.indexOf(lightRetained);
        if (n >= 0) {
            this.lights.remove(n);
        }
    }

    void addAllNodesForScopedLight(int n, LightRetained[] lightRetainedArray, ArrayList arrayList, HashKey hashKey) {
        int n2 = 0;
        while (n2 < n) {
            this.addLight(lightRetainedArray[n2]);
            ++n2;
        }
        if (this.source.isLive() || this.isInSetLive()) {
            int n3 = this.children.size() - 1;
            while (n3 >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n3);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        ((GroupRetained)nodeRetained).addAllNodesForScopedLight(n, lightRetainedArray, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        int n4 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.addAllNodesForScopedLight(n, lightRetainedArray, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n4;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    }
                }
                --n3;
            }
        }
    }

    void removeAllNodesForScopedLight(int n, LightRetained[] lightRetainedArray, ArrayList arrayList, HashKey hashKey) {
        int n2 = 0;
        while (n2 < n) {
            this.removeLight(lightRetainedArray[n2]);
            ++n2;
        }
        if (this.source.isLive() && !this.isInClearLive) {
            int n3 = this.children.size() - 1;
            while (n3 >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n3);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && nodeRetained.source.isLive() && !((GroupRetained)nodeRetained).isInClearLive) {
                        ((GroupRetained)nodeRetained).removeAllNodesForScopedLight(n, lightRetainedArray, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                        int n4 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.removeAllNodesForScopedLight(n, lightRetainedArray, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n4;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    }
                }
                --n3;
            }
        }
    }

    void addAllNodesForScopedFog(FogRetained fogRetained, ArrayList arrayList, HashKey hashKey) {
        this.addFog(fogRetained);
        if (this.source.isLive() || this.isInSetLive()) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        ((GroupRetained)nodeRetained).addAllNodesForScopedFog(fogRetained, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.addAllNodesForScopedFog(fogRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void removeAllNodesForScopedFog(FogRetained fogRetained, ArrayList arrayList, HashKey hashKey) {
        this.removeFog(fogRetained);
        if (this.source.isLive() && !this.isInClearLive) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && nodeRetained.source.isLive() && !((GroupRetained)nodeRetained).isInClearLive) {
                        ((GroupRetained)nodeRetained).removeAllNodesForScopedFog(fogRetained, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.removeAllNodesForScopedFog(fogRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void addAllNodesForScopedModelClip(ModelClipRetained modelClipRetained, ArrayList arrayList, HashKey hashKey) {
        this.addModelClip(modelClipRetained);
        if (this.source.isLive() || this.isInSetLive()) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        ((GroupRetained)nodeRetained).addAllNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.addAllNodesForScopedModelClip(modelClipRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void removeAllNodesForScopedModelClip(ModelClipRetained modelClipRetained, ArrayList arrayList, HashKey hashKey) {
        this.removeModelClip(modelClipRetained);
        if (this.source.isLive() && !this.isInClearLive) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && nodeRetained.source.isLive() && !((GroupRetained)nodeRetained).isInClearLive) {
                        ((GroupRetained)nodeRetained).removeAllNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.removeAllNodesForScopedModelClip(modelClipRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void addAllNodesForScopedAltApp(AlternateAppearanceRetained alternateAppearanceRetained, ArrayList arrayList, HashKey hashKey) {
        this.addAltApp(alternateAppearanceRetained);
        if (this.source.isLive() || this.isInSetLive()) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        ((GroupRetained)nodeRetained).addAllNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.addAllNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void removeAllNodesForScopedAltApp(AlternateAppearanceRetained alternateAppearanceRetained, ArrayList arrayList, HashKey hashKey) {
        this.removeAltApp(alternateAppearanceRetained);
        if (this.source.isLive() && !this.isInClearLive) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && nodeRetained.source.isLive() && !((GroupRetained)nodeRetained).isInClearLive) {
                        ((GroupRetained)nodeRetained).removeAllNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.removeAllNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorShape3D(arrayList, hashKey);
                    }
                }
                --n;
            }
        }
    }

    synchronized void setScope() {
        ++this.scopingRefCount;
    }

    synchronized void removeScope() {
        --this.scopingRefCount;
    }

    synchronized boolean usedInScoping() {
        return this.scopingRefCount > 0;
    }

    void addLight(LightRetained lightRetained) {
        this.lights.add(lightRetained);
    }

    void addFog(FogRetained fogRetained) {
        this.fogs.add(fogRetained);
    }

    void addModelClip(ModelClipRetained modelClipRetained) {
        this.modelClips.add(modelClipRetained);
    }

    void addAltApp(AlternateAppearanceRetained alternateAppearanceRetained) {
        this.altAppearances.add(alternateAppearanceRetained);
    }

    void removeFog(FogRetained fogRetained) {
        int n = this.fogs.indexOf(fogRetained);
        if (n >= 0) {
            this.fogs.remove(n);
        }
    }

    void removeModelClip(ModelClipRetained modelClipRetained) {
        int n = this.modelClips.indexOf(modelClipRetained);
        if (n >= 0) {
            this.modelClips.remove(n);
        }
    }

    void removeAltApp(AlternateAppearanceRetained alternateAppearanceRetained) {
        int n = this.altAppearances.indexOf(alternateAppearanceRetained);
        if (n >= 0) {
            this.altAppearances.remove(n);
        }
    }

    void updatePickable(HashKey[] hashKeyArray, boolean[] blArray) {
        NodeRetained nodeRetained;
        int n = this.children.size() - 1;
        super.updatePickable(hashKeyArray, blArray);
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            nodeRetained = (NodeRetained)this.children.elementAt(n2);
            if (nodeRetained != null) {
                nodeRetained.updatePickable(hashKeyArray, (boolean[])blArray.clone());
            }
            ++n2;
        }
        nodeRetained = (NodeRetained)this.children.elementAt(n2);
        if (nodeRetained != null) {
            nodeRetained.updatePickable(hashKeyArray, blArray);
        }
    }

    void updateCollidable(HashKey[] hashKeyArray, boolean[] blArray) {
        NodeRetained nodeRetained;
        int n = this.children.size() - 1;
        super.updateCollidable(hashKeyArray, blArray);
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            nodeRetained = (NodeRetained)this.children.elementAt(n2);
            if (nodeRetained != null) {
                nodeRetained.updateCollidable(hashKeyArray, (boolean[])blArray.clone());
            }
            ++n2;
        }
        nodeRetained = (NodeRetained)this.children.elementAt(n2);
        if (nodeRetained != null) {
            nodeRetained.updateCollidable(hashKeyArray, blArray);
        }
    }

    void setAlternateCollisionTarget(boolean bl) {
        if (this.collisionTarget == bl) {
            return;
        }
        this.collisionTarget = bl;
        if (this.source.isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 64;
            j3dMessage.universe = this.universe;
            if (bl) {
                TransformGroupRetained transformGroupRetained;
                this.createMirrorGroup();
                if (this.nodeType == 24) {
                    transformGroupRetained = (TransformGroupRetained)this;
                    transformGroupRetained.updateTargets(null, this.mirrorGroup);
                }
                if (this.parentTransformGroups != null) {
                    int n = 0;
                    while (n < this.parentTransformGroups.length) {
                        int n2 = 0;
                        while (n2 < this.parentTransformGroups[n].size()) {
                            transformGroupRetained = (TransformGroupRetained)this.parentTransformGroups[n].get(n2);
                            transformGroupRetained.updateTargets(null, this.mirrorGroup);
                            ++n2;
                        }
                        ++n;
                    }
                }
                j3dMessage.type = 0;
                j3dMessage.args[0] = this.mirrorGroup.toArray();
            } else {
                TransformGroupRetained transformGroupRetained;
                if (this.nodeType == 24) {
                    transformGroupRetained = (TransformGroupRetained)this;
                    transformGroupRetained.updateTargets(this.mirrorGroup, null);
                }
                if (this.parentTransformGroups != null) {
                    int n = 0;
                    while (n < this.parentTransformGroups.length) {
                        int n3 = 0;
                        while (n3 < this.parentTransformGroups[n].size()) {
                            transformGroupRetained = (TransformGroupRetained)this.parentTransformGroups[n].get(n3);
                            transformGroupRetained.updateTargets(this.mirrorGroup, null);
                            ++n3;
                        }
                        ++n;
                    }
                }
                j3dMessage.type = 1;
                j3dMessage.args[0] = this.mirrorGroup.toArray();
                this.mirrorGroup = null;
            }
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    boolean getAlternateCollisionTarget() {
        return this.collisionTarget;
    }

    void checkSetLive(NodeRetained nodeRetained, J3dMessage[] j3dMessageArray, int n, NodeRetained nodeRetained2) {
        this.checkSetLive(nodeRetained, this.localToVworldKeys, this.inSharedGroup, j3dMessageArray, n, nodeRetained2);
    }

    void checkSetLive(NodeRetained nodeRetained, HashKey[] hashKeyArray, boolean bl, J3dMessage[] j3dMessageArray, int n, NodeRetained nodeRetained2) {
        SceneGraphObject sceneGraphObject = this.source;
        ArrayList[] arrayListArray = null;
        ArrayList[] arrayListArray2 = null;
        Object var17_10 = null;
        Transform3D[][] transform3DArray = null;
        int[][] nArray = null;
        if (sceneGraphObject.isLive()) {
            Cloneable cloneable;
            int[] nArray2;
            boolean[] blArray;
            Object object;
            TransformGroupRetained transformGroupRetained;
            int n2;
            SetLiveState setLiveState = this.universe.setLiveState;
            setLiveState.reset(this.locale);
            setLiveState.refCount = this.refCount;
            setLiveState.inSharedGroup = bl;
            setLiveState.inBackgroundGroup = this.inBackgroundGroup;
            setLiveState.geometryBackground = this.geometryBackground;
            setLiveState.keys = hashKeyArray;
            transform3DArray = setLiveState.currentTransforms;
            nArray = setLiveState.currentTransformsIndex;
            if (this.nodeType == 24) {
                setLiveState.currentTransforms = ((TransformGroupRetained)this).childLocalToVworld;
                setLiveState.currentTransformsIndex = ((TransformGroupRetained)this).childLocalToVworldIndex;
                n2 = 0;
                while (n2 < this.parentTransformGroups.length) {
                    this.parentTransformGroups[n2].add(this);
                    ++n2;
                }
                setLiveState.parentTransformGroups = this.parentTransformGroups;
                if (setLiveState.inSharedGroup) {
                    arrayListArray = new ArrayList[setLiveState.keys.length];
                    arrayListArray2 = new ArrayList[setLiveState.keys.length];
                } else {
                    arrayListArray = new ArrayList[1];
                    arrayListArray2 = new ArrayList[1];
                }
                n2 = 0;
                while (n2 < arrayListArray.length) {
                    arrayListArray[n2] = new ArrayList();
                    arrayListArray2[n2] = new ArrayList();
                    ++n2;
                }
                setLiveState.transformTargets = arrayListArray;
                setLiveState.transformBLTargets = arrayListArray2;
                setLiveState.transformTargetThreads = 0;
                setLiveState.childTransformLinks = ((TransformGroupRetained)this).childTransformLinks;
                setLiveState.parentTransformLink = this;
            } else {
                setLiveState.currentTransforms = this.localToVworld;
                setLiveState.currentTransformsIndex = this.localToVworldIndex;
                if (this.parentTransformGroups != null) {
                    if (setLiveState.inSharedGroup) {
                        arrayListArray = new ArrayList[setLiveState.keys.length];
                        arrayListArray2 = new ArrayList[setLiveState.keys.length];
                    } else {
                        arrayListArray = new ArrayList[1];
                        arrayListArray2 = new ArrayList[1];
                    }
                    n2 = 0;
                    while (n2 < arrayListArray.length) {
                        arrayListArray[n2] = new ArrayList();
                        arrayListArray2[n2] = new ArrayList();
                        ++n2;
                    }
                    setLiveState.transformTargets = arrayListArray;
                    setLiveState.transformBLTargets = arrayListArray2;
                    setLiveState.transformTargetThreads = 0;
                }
                setLiveState.parentTransformGroups = this.parentTransformGroups;
                if (this.nodeType == 22) {
                    setLiveState.childTransformLinks = ((SharedGroupRetained)this).childTransformLinks;
                    setLiveState.parentTransformLink = this;
                } else {
                    setLiveState.parentTransformLink = this.parentTransformLink;
                    if (this.parentTransformLink != null) {
                        if (this.parentTransformLink instanceof TransformGroupRetained) {
                            transformGroupRetained = (TransformGroupRetained)this.parentTransformLink;
                            setLiveState.childTransformLinks = transformGroupRetained.childTransformLinks;
                        } else {
                            object = (SharedGroupRetained)this.parentTransformLink;
                            setLiveState.childTransformLinks = ((SharedGroupRetained)object).childTransformLinks;
                        }
                    }
                }
            }
            setLiveState.inOrderedGroups.clear();
            setLiveState.orderedPaths.clearPaths();
            if (nodeRetained2 != null) {
                setLiveState.inOrderedGroups.addAll(((LinkRetained)nodeRetained2).inOrderedGroups);
                setLiveState.orderedPaths.addClonedPaths(((LinkRetained)nodeRetained2).orderedPaths);
            } else {
                setLiveState.inOrderedGroups.addAll(this.inOrderedGroups);
                setLiveState.orderedPaths.addClonedPaths(this.orderedPaths);
            }
            if (this instanceof OrderedGroupRetained) {
                object = (OrderedGroupRetained)this;
                setLiveState.orderedPaths.addElementToPaths((OrderedGroupRetained)object, nodeRetained.orderedId);
                setLiveState.inOrderedGroups = new ArrayList();
                n2 = 0;
                while (n2 < this.inOrderedGroups.size()) {
                    setLiveState.inOrderedGroups.add(Boolean.TRUE);
                    ++n2;
                }
            }
            if (this.fogs.size() > 0) {
                setLiveState.fogs = this.fogs;
            }
            if (this.altAppearances.size() > 0) {
                setLiveState.altAppearances = this.altAppearances;
            }
            if (this.lights.size() > 0) {
                setLiveState.lights = this.lights;
            }
            if (this.modelClips.size() > 0) {
                setLiveState.modelClips = this.modelClips;
            }
            setLiveState.branchGroupPaths = this.branchGroupPaths;
            if (!this.inSharedGroup) {
                object = new boolean[1];
                blArray = new boolean[1];
                nArray2 = new int[1];
            } else {
                object = new boolean[this.localToVworldKeys.length];
                blArray = new boolean[this.localToVworldKeys.length];
                nArray2 = new int[this.localToVworldKeys.length];
            }
            this.findPickableFlags((boolean[])object);
            super.updatePickable(null, (boolean[])object);
            setLiveState.pickable = (boolean[])object;
            this.findCollidableFlags(blArray);
            super.updateCollidable(null, blArray);
            setLiveState.collidable = blArray;
            this.findTransformLevels(nArray2);
            setLiveState.transformLevels = nArray2;
            if (this.inSharedGroup) {
                setLiveState.switchLevels = new int[this.localToVworldKeys.length];
                setLiveState.closestSwitchParents = new SwitchRetained[this.localToVworldKeys.length];
                setLiveState.closestSwitchIndices = new int[this.localToVworldKeys.length];
                n2 = 0;
                while (n2 < this.localToVworldKeys.length) {
                    setLiveState.switchLevels[n2] = -1;
                    setLiveState.closestSwitchParents[n2] = null;
                    setLiveState.closestSwitchIndices[n2] = -1;
                    ++n2;
                }
            }
            this.resetSwitchStates(setLiveState, this, nodeRetained, nodeRetained2);
            nodeRetained.setLive(setLiveState);
            if (this.parentSwitchLink != null) {
                if (this.parentSwitchLink instanceof SwitchRetained) {
                    ((SwitchRetained)this.parentSwitchLink).traverseSwitchParent();
                } else if (this.parentSwitchLink instanceof SharedGroupRetained) {
                    ((SharedGroupRetained)this.parentSwitchLink).traverseSwitchParent();
                }
            }
            setLiveState.currentTransforms = transform3DArray;
            setLiveState.currentTransformsIndex = nArray;
            if (this.nodeType == 24) {
                n2 = 0;
                while (n2 < this.parentTransformGroups.length) {
                    int n3 = this.parentTransformGroups[n2].size() - 1;
                    this.parentTransformGroups[n2].remove(n3);
                    ++n2;
                }
                transformGroupRetained = (TransformGroupRetained)this;
                n2 = 0;
                while (n2 < setLiveState.transformTargets.length) {
                    transformGroupRetained.updateTargets(null, setLiveState.transformTargets[n2], null, setLiveState.transformBLTargets[n2], setLiveState.transformTargetThreads);
                    ++n2;
                }
            }
            if (this.parentTransformGroups != null) {
                n2 = 0;
                while (n2 < this.parentTransformGroups.length) {
                    cloneable = this.parentTransformGroups[n2];
                    int n4 = 0;
                    while (n4 < ((ArrayList)cloneable).size()) {
                        transformGroupRetained = (TransformGroupRetained)((ArrayList)cloneable).get(n4);
                        transformGroupRetained.updateTargets(null, setLiveState.transformTargets[n2], null, setLiveState.transformBLTargets[n2], setLiveState.transformTargetThreads);
                        ++n4;
                    }
                    ++n2;
                }
            }
            J3dMessage j3dMessage = j3dMessageArray == null ? VirtualUniverse.mc.getMessage() : j3dMessageArray[n++];
            j3dMessage.threads = setLiveState.notifyThreads;
            j3dMessage.type = 0;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = setLiveState.nodeList.toArray();
            if (j3dMessageArray == null) {
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
            n2 = 0;
            while (n2 < setLiveState.behaviorNodes.size()) {
                cloneable = (BehaviorRetained)setLiveState.behaviorNodes.get(n2);
                ((BehaviorRetained)cloneable).executeInitialize();
                ++n2;
            }
            setLiveState.behaviorNodes.clear();
            j3dMessage = j3dMessageArray == null ? VirtualUniverse.mc.getMessage() : j3dMessageArray[n++];
            j3dMessage.threads = 256;
            j3dMessage.type = 49;
            j3dMessage.universe = this.universe;
            if (j3dMessageArray == null) {
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
            if (this.nodeType == 18) {
                cloneable = (SwitchRetained)this;
                ((SwitchRetained)cloneable).setWhichChild(((SwitchRetained)cloneable).whichChild, true);
            }
            setLiveState.fogs = null;
            setLiveState.lights = null;
            setLiveState.modelClips = null;
            setLiveState.altAppearances = null;
            if (this instanceof OrderedGroupRetained) {
                setLiveState.orderedPaths.removeLastElementFromPaths();
            }
        }
    }

    void checkClearLive(NodeRetained nodeRetained, J3dMessage[] j3dMessageArray, int n, int n2) {
        this.checkClearLive(nodeRetained, this.localToVworldKeys, this.inSharedGroup, j3dMessageArray, n, n2);
    }

    void checkClearLive(NodeRetained nodeRetained, HashKey[] hashKeyArray, boolean bl, J3dMessage[] j3dMessageArray, int n, int n2) {
        SceneGraphObject sceneGraphObject = this.source;
        if (sceneGraphObject.isLive()) {
            TransformGroupRetained transformGroupRetained;
            SetLiveState setLiveState = this.universe.setLiveState;
            setLiveState.reset(this.locale);
            setLiveState.refCount = this.refCount;
            setLiveState.inSharedGroup = bl;
            setLiveState.inBackgroundGroup = this.inBackgroundGroup;
            setLiveState.keys = hashKeyArray;
            setLiveState.fogs = this.fogs;
            setLiveState.lights = this.lights;
            setLiveState.altAppearances = this.altAppearances;
            setLiveState.modelClips = this.modelClips;
            if (this instanceof OrderedGroupRetained) {
                setLiveState.ogList.add(this);
                setLiveState.ogChildIdList.add(new Integer(n2));
            }
            if (this.parentTransformGroups != null || this instanceof TransformGroupRetained) {
                setLiveState.transformTargets = new ArrayList[1];
                setLiveState.transformBLTargets = new ArrayList[1];
                setLiveState.transformTargets[0] = new ArrayList(1);
                setLiveState.transformBLTargets[0] = new ArrayList(1);
            }
            this.findContainsNodesList(setLiveState, this, nodeRetained);
            nodeRetained.clearLive(setLiveState);
            if (this instanceof TransformGroupRetained) {
                transformGroupRetained = (TransformGroupRetained)this;
                transformGroupRetained.updateTargets(setLiveState.nodeList, null, setLiveState.transformBLTargets[0], null, 0);
                transformGroupRetained.updateTargets(setLiveState.transformTargets[0], null);
            }
            if (this.parentTransformGroups != null) {
                int n3 = 0;
                while (n3 < this.parentTransformGroups.length) {
                    ArrayList arrayList = this.parentTransformGroups[n3];
                    int n4 = arrayList.size() - 1;
                    while (n4 >= 0) {
                        transformGroupRetained = (TransformGroupRetained)arrayList.get(n4);
                        transformGroupRetained.updateTargets(setLiveState.nodeList, null, setLiveState.transformBLTargets[0], null, 0);
                        transformGroupRetained.updateTargets(setLiveState.transformTargets[0], null);
                        --n4;
                    }
                    ++n3;
                }
            }
            J3dMessage j3dMessage = j3dMessageArray == null ? VirtualUniverse.mc.getMessage() : j3dMessageArray[n++];
            j3dMessage.threads = 4224;
            j3dMessage.type = 33;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = setLiveState.ogList.toArray();
            j3dMessage.args[1] = setLiveState.ogChildIdList.toArray();
            if (j3dMessageArray == null) {
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
            j3dMessage = j3dMessageArray == null ? VirtualUniverse.mc.getMessage() : j3dMessageArray[n++];
            j3dMessage.threads = setLiveState.notifyThreads;
            j3dMessage.type = 1;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = setLiveState.nodeList.toArray();
            if (j3dMessageArray == null) {
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
            setLiveState.reset(this.locale);
        }
    }

    synchronized void updateLocalToVworld() {
        int n = this.children.size() - 1;
        while (n >= 0) {
            NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
            if (nodeRetained != null) {
                nodeRetained.updateLocalToVworld();
            }
            --n;
        }
    }

    void setAuxData(SetLiveState setLiveState, int n, int n2) {
        if (this.source.capabilities.get(13) || this.source.capabilities.get(14)) {
            if (this.orderedPaths == null) {
                this.orderedPaths = new OrderedPathList();
                this.inOrderedGroups = new ArrayList();
            }
            if (!this.inSharedGroup) {
                this.orderedPaths.addClonedPath(0, setLiveState.orderedPaths.getPath(0));
                this.inOrderedGroups.add(0, setLiveState.inOrderedGroups.get(0));
            } else {
                this.orderedPaths.addClonedPath(n2, setLiveState.orderedPaths.getPath(n));
                this.inOrderedGroups.add(n2, setLiveState.inOrderedGroups.get(n));
            }
        }
    }

    void setLive(SetLiveState setLiveState) {
        this.doSetLive(setLiveState);
        super.markAsLive();
    }

    void doSetLive(SetLiveState setLiveState) {
        int n;
        GroupRetained groupRetained;
        ArrayList<Boolean> arrayList;
        int n2;
        int n3 = -1;
        ArrayList arrayList2 = null;
        J3dMessage[] j3dMessageArray = null;
        BoundingSphere boundingSphere = new BoundingSphere();
        super.doSetLive(setLiveState);
        this.locale = setLiveState.locale;
        int n4 = this.children.size();
        boolean bl = setLiveState.fogs != null || this.fogs.size() > 0 || setLiveState.lights != null || this.lights.size() > 0 || setLiveState.modelClips != null || this.modelClips.size() > 0 || setLiveState.altAppearances != null || this.altAppearances.size() > 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        if (bl) {
            if (setLiveState.fogs != null) {
                n5 = setLiveState.fogs.size();
            } else if (this.fogs.size() > 0) {
                setLiveState.fogs = new ArrayList();
            }
            if (setLiveState.lights != null) {
                n6 = setLiveState.lights.size();
            } else if (this.lights.size() > 0) {
                setLiveState.lights = new ArrayList();
            }
            if (setLiveState.modelClips != null) {
                n7 = setLiveState.modelClips.size();
            } else if (this.modelClips.size() > 0) {
                setLiveState.modelClips = new ArrayList();
            }
            if (setLiveState.altAppearances != null) {
                n8 = setLiveState.altAppearances.size();
            } else if (this.altAppearances.size() > 0) {
                setLiveState.altAppearances = new ArrayList();
            }
            n10 = n6;
            n9 = n5;
            n11 = n7;
            n12 = n8;
            n2 = 0;
            while (n2 < this.fogs.size()) {
                setLiveState.fogs.add(this.fogs.get(n2));
                ++n2;
            }
            if (setLiveState.fogs != null) {
                n9 = setLiveState.fogs.size();
            }
            n2 = 0;
            while (n2 < this.lights.size()) {
                setLiveState.lights.add(this.lights.get(n2));
                ++n2;
            }
            if (setLiveState.lights != null) {
                n10 = setLiveState.lights.size();
            }
            n2 = 0;
            while (n2 < this.modelClips.size()) {
                setLiveState.modelClips.add(this.modelClips.get(n2));
                ++n2;
            }
            if (setLiveState.modelClips != null) {
                n11 = setLiveState.modelClips.size();
            }
            n2 = 0;
            while (n2 < this.altAppearances.size()) {
                setLiveState.altAppearances.add(this.altAppearances.get(n2));
                ++n2;
            }
            if (setLiveState.altAppearances != null) {
                n12 = setLiveState.altAppearances.size();
            }
            n2 = 0;
            while (n2 < n5) {
                this.fogs.add(setLiveState.fogs.get(n2));
                ++n2;
            }
            n2 = 0;
            while (n2 < n6) {
                this.lights.add(setLiveState.lights.get(n2));
                ++n2;
            }
            n2 = 0;
            while (n2 < n7) {
                this.modelClips.add(setLiveState.modelClips.get(n2));
                ++n2;
            }
            n2 = 0;
            while (n2 < n8) {
                this.altAppearances.add(setLiveState.altAppearances.get(n2));
                ++n2;
            }
        }
        if (this instanceof SwitchRetained) {
            ((SwitchRetained)this).processSharedVwcBounds(setLiveState);
        }
        if (this instanceof OrderedGroupRetained) {
            arrayList2 = setLiveState.inOrderedGroups;
            arrayList = new ArrayList<Boolean>();
            n2 = 0;
            while (n2 < setLiveState.inOrderedGroups.size()) {
                arrayList.add(Boolean.TRUE);
                ++n2;
            }
            setLiveState.inOrderedGroups = arrayList;
            if (this.refCount == setLiveState.refCount) {
                j3dMessageArray = new J3dMessage[n4];
                n2 = 0;
                while (n2 < n4) {
                    j3dMessageArray[n2] = VirtualUniverse.mc.getMessage();
                    ++n2;
                }
            }
        }
        arrayList = setLiveState.branchGroupPaths;
        boolean[] blArray = (boolean[])setLiveState.pickable.clone();
        boolean[] blArray2 = (boolean[])setLiveState.collidable.clone();
        boolean[] blArray3 = new boolean[blArray.length];
        boolean[] blArray4 = new boolean[blArray2.length];
        int n13 = this.lights.size();
        int n14 = this.fogs.size();
        int n15 = this.modelClips.size();
        int n16 = this.altAppearances.size();
        n2 = 0;
        while (n2 < n4) {
            int n17;
            if (this instanceof SwitchRetained) {
                groupRetained = (SwitchRetained)this;
                setLiveState.childSwitchLinks = (ArrayList)groupRetained.childrenSwitchLinks.get(n2);
                setLiveState.containsNodesList = (ContainsNodesList)groupRetained.childrenContainsNodesList.get(n2);
                n = 0;
                while (n < setLiveState.switchLevels.length) {
                    setLiveState.closestSwitchIndices[n] = this.switchIndexCount;
                    setLiveState.closestSwitchParents[n] = groupRetained;
                    ++n;
                }
                ++this.switchIndexCount;
            } else if (this instanceof SharedGroupRetained) {
                groupRetained = (SharedGroupRetained)this;
                setLiveState.childSwitchLinks = (ArrayList)groupRetained.childrenSwitchLinks.get(n2);
                setLiveState.containsNodesList = (ContainsNodesList)groupRetained.childrenContainsNodesList.get(n2);
            }
            NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n2);
            if (this instanceof OrderedGroupRetained) {
                groupRetained = (OrderedGroupRetained)this;
                if (this.refCount == setLiveState.refCount) {
                    nodeRetained.orderedId = ((OrderedGroupRetained)groupRetained).getOrderedChildId();
                    j3dMessageArray[n2].threads = 4224;
                    j3dMessageArray[n2].type = 32;
                    j3dMessageArray[n2].universe = this.universe;
                    j3dMessageArray[n2].args[0] = this;
                    j3dMessageArray[n2].args[1] = new Integer(n2);
                    j3dMessageArray[n2].args[2] = nodeRetained.orderedId;
                }
                setLiveState.orderedPaths.addElementToPaths((OrderedGroupRetained)groupRetained, nodeRetained.orderedId);
            }
            System.arraycopy(blArray, 0, blArray3, 0, blArray.length);
            System.arraycopy(blArray2, 0, blArray4, 0, blArray2.length);
            setLiveState.pickable = blArray3;
            setLiveState.collidable = blArray4;
            setLiveState.branchGroupPaths = arrayList;
            if (n13 < this.lights.size()) {
                if (setLiveState.lights == null) {
                    setLiveState.lights = new ArrayList();
                }
                n17 = n13;
                while (n17 < this.lights.size()) {
                    setLiveState.lights.add(this.lights.get(n17));
                    ++n10;
                    ++n17;
                }
                n13 = this.lights.size();
                bl = true;
            }
            if (n14 < this.fogs.size()) {
                if (setLiveState.fogs == null) {
                    setLiveState.fogs = new ArrayList();
                }
                n17 = n14;
                while (n17 < this.fogs.size()) {
                    setLiveState.fogs.add(this.fogs.get(n17));
                    ++n9;
                    ++n17;
                }
                n14 = this.fogs.size();
                bl = true;
            }
            if (n15 < this.modelClips.size()) {
                if (setLiveState.modelClips == null) {
                    setLiveState.modelClips = new ArrayList();
                }
                n17 = n15;
                while (n17 < this.modelClips.size()) {
                    setLiveState.modelClips.add(this.modelClips.get(n17));
                    ++n11;
                    ++n17;
                }
                n15 = this.modelClips.size();
                bl = true;
            }
            if (n16 < this.altAppearances.size()) {
                if (setLiveState.altAppearances == null) {
                    setLiveState.altAppearances = new ArrayList();
                }
                n17 = n16;
                while (n17 < this.altAppearances.size()) {
                    setLiveState.altAppearances.add(this.altAppearances.get(n17));
                    ++n12;
                    ++n17;
                }
                n16 = this.altAppearances.size();
                bl = true;
            }
            if (nodeRetained != null) {
                nodeRetained.setLive(setLiveState);
            }
            if (this instanceof OrderedGroupRetained) {
                setLiveState.orderedPaths.removeLastElementFromPaths();
            }
            ++n2;
        }
        if (this instanceof OrderedGroupRetained) {
            if (j3dMessageArray != null) {
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            }
            setLiveState.inOrderedGroups = arrayList2;
        }
        if (bl) {
            n2 = n5;
            while (n2 < n9) {
                setLiveState.fogs.remove(n5);
                ++n2;
            }
            n2 = n7;
            while (n2 < n11) {
                setLiveState.modelClips.remove(n7);
                ++n2;
            }
            n2 = n6;
            while (n2 < n10) {
                setLiveState.lights.remove(n6);
                ++n2;
            }
            n2 = n8;
            while (n2 < n12) {
                setLiveState.altAppearances.remove(n8);
                ++n2;
            }
        }
        if (this.collisionTarget) {
            Bounds bounds;
            if (this.mirrorGroup == null) {
                this.mirrorGroup = new ArrayList();
            }
            Bounds bounds2 = bounds = this.collisionBound != null ? this.collisionBound : this.getEffectiveBounds();
            if (this.inSharedGroup) {
                n2 = 0;
                while (n2 < setLiveState.keys.length) {
                    groupRetained = new GroupRetained();
                    groupRetained.key = setLiveState.keys[n2];
                    groupRetained.localToVworld = new Transform3D[1][];
                    groupRetained.localToVworldIndex = new int[1][];
                    n = setLiveState.keys[n2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    if (n < 0) {
                        System.out.println("GroupRetained : Can't find hashKey");
                    }
                    groupRetained.localToVworld[0] = this.localToVworld[n];
                    groupRetained.localToVworldIndex[0] = this.localToVworldIndex[n];
                    groupRetained.collisionVwcBounds = new BoundingBox();
                    groupRetained.collisionVwcBounds.transform(bounds, groupRetained.getCurrentLocalToVworld(0));
                    groupRetained.sourceNode = this;
                    groupRetained.locale = this.locale;
                    this.mirrorGroup.add(groupRetained);
                    setLiveState.transformTargets[n2].add(groupRetained);
                    setLiveState.nodeList.add(groupRetained);
                    ++n2;
                }
            } else {
                groupRetained = new GroupRetained();
                groupRetained.localToVworld = new Transform3D[1][];
                groupRetained.localToVworldIndex = new int[1][];
                groupRetained.localToVworld[0] = this.localToVworld[0];
                groupRetained.localToVworldIndex[0] = this.localToVworldIndex[0];
                groupRetained.collisionVwcBounds = new BoundingBox();
                groupRetained.collisionVwcBounds.transform(bounds, groupRetained.getCurrentLocalToVworld(0));
                groupRetained.sourceNode = this;
                groupRetained.locale = this.locale;
                this.mirrorGroup.add(groupRetained);
                setLiveState.transformTargets[0].add(groupRetained);
                setLiveState.nodeList.add(groupRetained);
            }
        }
    }

    void computeCombineBounds(Bounds bounds) {
        if (this.boundsAutoCompute) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    nodeRetained.computeCombineBounds(bounds);
                }
                --n;
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            BoundingSphere boundingSphere = new BoundingSphere();
            boundingSphere.setRadius(-1.0);
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    nodeRetained.computeCombineBounds(boundingSphere);
                }
                --n;
            }
            return boundingSphere;
        }
        return super.getBounds();
    }

    Bounds getEffectiveBounds() {
        if (this.boundsAutoCompute) {
            return this.getBounds();
        }
        return super.getEffectiveBounds();
    }

    boolean isStaticChildren() {
        return !this.source.getCapability(12) && !this.source.getCapability(13);
    }

    boolean isStatic() {
        return super.isStatic() && this.isStaticChildren();
    }

    void setCompiled() {
        super.setCompiled();
        int n = this.children.size() - 1;
        while (n >= 0) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(n);
            if (sceneGraphObjectRetained != null) {
                sceneGraphObjectRetained.setCompiled();
            }
            --n;
        }
    }

    void traverse(boolean bl, int n) {
        if (!bl) {
            super.traverse(true, n);
            if (this.source.getCapability(12)) {
                System.out.print(" (r)");
            } else if (this.isStatic()) {
                System.out.print(" (s)");
            } else if (this.source.getCapability(13)) {
                System.out.print(" (w)");
            }
        }
        ++n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(n2);
            if (sceneGraphObjectRetained != null) {
                sceneGraphObjectRetained.traverse(false, n);
            }
            ++n2;
        }
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        if (compileState.switchLevel >= 0 && (!this.boundsAutoCompute || this.source.getCapability(10) || this.source.getCapability(4) || this.source.getCapability(13))) {
            compileState.switchVwcBoundsSharable = false;
        }
        this.mergeFlag = 1;
        if (!this.isStatic()) {
            compileState.keepTG = true;
            this.mergeFlag = 0;
        }
        if (this.isRoot || this.usedInScoping() || this.parent instanceof SwitchRetained) {
            this.mergeFlag = 0;
        }
        this.compiledChildrenList = new Vector();
        int n = 0;
        while (n < this.children.size()) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(n);
            if (sceneGraphObjectRetained != null) {
                sceneGraphObjectRetained.compile(compileState);
            }
            ++n;
        }
    }

    void merge(CompileState compileState) {
        GroupRetained groupRetained = null;
        if (this.mergeFlag != 2) {
            if (this.mergeFlag == 0) {
                super.merge(compileState);
                groupRetained = compileState.parentGroup;
                compileState.parentGroup = this;
            }
            int n = 0;
            while (n < this.children.size()) {
                SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(n);
                if (sceneGraphObjectRetained != null) {
                    sceneGraphObjectRetained.merge(compileState);
                }
                ++n;
            }
            if (compileState.parentGroup == this) {
                this.children = this.compiledChildrenList;
                compileState.doShapeMerge();
                this.compiledChildrenList = null;
                compileState.parentGroup = groupRetained;
            } else {
                this.children.clear();
            }
            this.mergeFlag = 2;
        } else if (compileState.parentGroup != null) {
            compileState.parentGroup.compiledChildrenList.add(this);
            this.parent = compileState.parentGroup;
        }
    }

    void clearLive(SetLiveState setLiveState) {
        NodeRetained nodeRetained;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        this.isInClearLive = true;
        if (setLiveState.fogs != null || this.fogs.size() > 0 || setLiveState.lights != null || this.lights.size() > 0 || setLiveState.altAppearances != null || this.altAppearances.size() > 0 || setLiveState.modelClips != null || this.modelClips.size() > 0) {
            if (setLiveState.fogs != null) {
                n7 = setLiveState.fogs.size();
                n5 = 0;
                while (n5 < n7) {
                    ((AbstractCollection)this.fogs).remove(setLiveState.fogs.get(n5));
                    ++n5;
                }
            } else if (this.fogs.size() > 0) {
                setLiveState.fogs = new ArrayList();
            }
            if (setLiveState.lights != null) {
                n6 = setLiveState.lights.size();
                n5 = 0;
                while (n5 < n6) {
                    ((AbstractCollection)this.lights).remove(setLiveState.lights.get(n5));
                    ++n5;
                }
            } else if (this.lights.size() > 0) {
                setLiveState.lights = new ArrayList();
            }
            if (setLiveState.modelClips != null) {
                n8 = setLiveState.modelClips.size();
                n5 = 0;
                while (n5 < n8) {
                    ((AbstractCollection)this.modelClips).remove(setLiveState.modelClips.get(n5));
                    ++n5;
                }
            } else if (this.modelClips.size() > 0) {
                setLiveState.modelClips = new ArrayList();
            }
            if (setLiveState.altAppearances != null) {
                n9 = setLiveState.altAppearances.size();
                n5 = 0;
                while (n5 < n9) {
                    ((AbstractCollection)this.altAppearances).remove(setLiveState.altAppearances.get(n5));
                    ++n5;
                }
            } else if (this.altAppearances.size() > 0) {
                setLiveState.altAppearances = new ArrayList();
            }
            n4 = this.lights.size();
            n5 = 0;
            while (n5 < n4) {
                setLiveState.lights.add(this.lights.get(n5));
                ++n5;
            }
            n3 = this.fogs.size();
            n5 = 0;
            while (n5 < n3) {
                setLiveState.fogs.add(this.fogs.get(n5));
                ++n5;
            }
            n2 = this.modelClips.size();
            n5 = 0;
            while (n5 < n2) {
                setLiveState.modelClips.add(this.modelClips.get(n5));
                ++n5;
            }
            int n10 = this.altAppearances.size();
            n5 = 0;
            while (n5 < n10) {
                setLiveState.altAppearances.add(this.altAppearances.get(n5));
                ++n5;
            }
            n = this.children.size();
            n5 = n - 1;
            while (n5 >= 0) {
                nodeRetained = (NodeRetained)this.children.elementAt(n5);
                if (nodeRetained != null) {
                    nodeRetained.clearLive(setLiveState);
                    if (this instanceof OrderedGroupRetained && this.refCount == setLiveState.refCount) {
                        setLiveState.ogList.add(this);
                        setLiveState.ogChildIdList.add(new Integer(n5));
                    }
                }
                --n5;
            }
            n5 = n7 + n3 - 1;
            while (n5 >= n7) {
                setLiveState.fogs.remove(n7);
                --n5;
            }
            n5 = n8 + n2 - 1;
            while (n5 >= n8) {
                setLiveState.modelClips.remove(n8);
                --n5;
            }
            n5 = n6 + n4 - 1;
            while (n5 >= n6) {
                setLiveState.lights.remove(n6);
                --n5;
            }
            n5 = n9 + n10 - 1;
            while (n5 >= n9) {
                setLiveState.altAppearances.remove(n9);
                --n5;
            }
        } else {
            n = this.children.size();
            n5 = n - 1;
            while (n5 >= 0) {
                nodeRetained = (NodeRetained)this.children.elementAt(n5);
                if (nodeRetained != null) {
                    nodeRetained.clearLive(setLiveState);
                }
                if (this instanceof OrderedGroupRetained && this.refCount == setLiveState.refCount) {
                    setLiveState.ogList.add(this);
                    setLiveState.ogChildIdList.add(new Integer(n5));
                }
                --n5;
            }
        }
        if (this.collisionTarget) {
            if (this.inSharedGroup) {
                n5 = setLiveState.keys.length - 1;
                while (n5 >= 0) {
                    HashKey hashKey = setLiveState.keys[n5];
                    n2 = this.mirrorGroup.size() - 1;
                    if (n2 >= 0) {
                        GroupRetained groupRetained = (GroupRetained)this.mirrorGroup.get(n2);
                        if (groupRetained.key.equals((Object)hashKey)) {
                            setLiveState.nodeList.add(this.mirrorGroup.remove(n2));
                        }
                    }
                    --n5;
                }
            } else {
                setLiveState.nodeList.add(this.mirrorGroup.remove(0));
            }
        }
        this.closestSwitchParent = null;
        this.closestSwitchIndex = -1;
        if (this.orderedPaths != null) {
            if (this.inSharedGroup) {
                n4 = setLiveState.keys.length - 1;
                while (n4 >= 0) {
                    n3 = setLiveState.keys[n4].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    this.orderedPaths.removePath(n3);
                    this.inOrderedGroups.remove(n3);
                    --n4;
                }
            } else {
                this.orderedPaths.removePath(0);
                this.inOrderedGroups.remove(0);
            }
        }
        super.clearLive(setLiveState);
        this.isInClearLive = false;
    }

    public BoundingBox computeBoundingHull() {
        return this.collisionVwcBounds;
    }

    public boolean isEnable() {
        return GroupRetained.isNodeSwitchOn(this.sourceNode, this.key);
    }

    public boolean isEnable(int n) {
        return GroupRetained.isNodeSwitchOn(this.sourceNode, this.key);
    }

    public Locale getLocale2() {
        return this.locale;
    }

    static boolean isNodeSwitchOn(NodeRetained nodeRetained, HashKey hashKey) {
        NodeRetained nodeRetained2 = null;
        if (hashKey != null) {
            hashKey = new HashKey(hashKey);
        }
        Object object = nodeRetained.universe.sceneGraphLock;
        synchronized (object) {
            do {
                if (nodeRetained instanceof SwitchRetained && nodeRetained2 != null && !GroupRetained.validSwitchChild((SwitchRetained)nodeRetained, nodeRetained2)) {
                    boolean bl = false;
                    return bl;
                }
                nodeRetained2 = nodeRetained;
                if (nodeRetained instanceof SharedGroupRetained) {
                    String string = hashKey.getLastNodeId();
                    Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                    int n = vector.size() - 1;
                    while (n >= 0) {
                        NodeRetained nodeRetained3 = (NodeRetained)vector.elementAt(n);
                        if (nodeRetained3.nodeId.equals(string)) {
                            nodeRetained = nodeRetained3;
                            break;
                        }
                        --n;
                    }
                    if (nodeRetained != nodeRetained2) continue;
                    boolean bl = false;
                    return bl;
                }
                nodeRetained = nodeRetained.parent;
            } while (nodeRetained != null);
        }
        return true;
    }

    static boolean validSwitchChild(SwitchRetained switchRetained, NodeRetained nodeRetained) {
        int n = switchRetained.whichChild;
        if (n == -1) {
            return false;
        }
        if (n == -2) {
            return true;
        }
        Vector vector = switchRetained.children;
        if (n >= 0) {
            return vector.elementAt(n) == nodeRetained;
        }
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            if (switchRetained.childMask.get(n2) && vector.elementAt(n2) == nodeRetained) {
                return true;
            }
            --n2;
        }
        return false;
    }

    void createMirrorGroup() {
        Bounds bounds;
        this.mirrorGroup = new ArrayList();
        Bounds bounds2 = bounds = this.collisionBound != null ? this.collisionBound : this.getEffectiveBounds();
        if (this.inSharedGroup) {
            int n = 0;
            while (n < this.localToVworldKeys.length) {
                GroupRetained groupRetained = new GroupRetained();
                groupRetained.key = this.localToVworldKeys[n];
                groupRetained.localToVworld = new Transform3D[1][];
                groupRetained.localToVworldIndex = new int[1][];
                groupRetained.localToVworld[0] = this.localToVworld[n];
                groupRetained.localToVworldIndex[0] = this.localToVworldIndex[n];
                groupRetained.collisionVwcBounds = new BoundingBox();
                groupRetained.collisionVwcBounds.transform(bounds, groupRetained.getCurrentLocalToVworld());
                groupRetained.sourceNode = this;
                groupRetained.locale = this.locale;
                this.mirrorGroup.add(groupRetained);
                ++n;
            }
        } else {
            GroupRetained groupRetained = new GroupRetained();
            groupRetained.localToVworld = new Transform3D[1][];
            groupRetained.localToVworldIndex = new int[1][];
            groupRetained.localToVworld[0] = this.localToVworld[0];
            groupRetained.localToVworldIndex[0] = this.localToVworldIndex[0];
            groupRetained.collisionVwcBounds = new BoundingBox();
            groupRetained.collisionVwcBounds.transform(bounds, groupRetained.getCurrentLocalToVworld());
            groupRetained.sourceNode = this;
            groupRetained.locale = this.locale;
            this.mirrorGroup.add(groupRetained);
        }
    }

    void setBoundsAutoCompute(boolean bl) {
        if (bl != this.boundsAutoCompute) {
            super.setBoundsAutoCompute(bl);
            if (!bl) {
                this.localBounds = this.getEffectiveBounds();
            }
            if (this.source.isLive() && this.collisionBound == null && bl && this.mirrorGroup != null) {
                J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                j3dMessage.type = 34;
                j3dMessage.threads = 8256;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = this;
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
    }

    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute && this.collisionBound == null && this.mirrorGroup != null) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8256;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void resetSwitchStates(SetLiveState setLiveState, GroupRetained groupRetained, NodeRetained nodeRetained, NodeRetained nodeRetained2) {
        int n;
        int n2;
        NodeRetained nodeRetained3;
        NodeRetained nodeRetained4;
        int n3 = -1;
        if (!this.inSharedGroup) {
            nodeRetained4 = nodeRetained2 == null ? nodeRetained : nodeRetained2;
            nodeRetained3 = groupRetained;
            while (nodeRetained3 != null) {
                if (nodeRetained3 instanceof SwitchRetained) {
                    setLiveState.switchLevels[0] = setLiveState.switchLevels[0] + 1;
                    if (setLiveState.closestSwitchParents[0] == null) {
                        setLiveState.closestSwitchParents[0] = (SwitchRetained)nodeRetained3;
                        ++((SwitchRetained)nodeRetained3).switchIndexCount;
                    }
                    if (n3 == -1) {
                        n3 = nodeRetained3.children.indexOf(nodeRetained4);
                    }
                } else if (nodeRetained3 instanceof SharedGroupRetained && n3 == -1) {
                    n3 = nodeRetained3.children.indexOf(nodeRetained4);
                }
                nodeRetained4 = nodeRetained3;
                nodeRetained3 = nodeRetained4.parent;
            }
        } else {
            n2 = 0;
            while (n2 < this.localToVworldKeys.length) {
                nodeRetained4 = nodeRetained2 == null ? nodeRetained : nodeRetained2;
                nodeRetained3 = groupRetained;
                HashKey hashKey = new HashKey(this.localToVworldKeys[n2]);
                while (nodeRetained3 != null) {
                    if (nodeRetained3 instanceof SwitchRetained) {
                        int n4 = n2;
                        setLiveState.switchLevels[n4] = setLiveState.switchLevels[n4] + 1;
                        if (setLiveState.closestSwitchParents[n2] == null) {
                            setLiveState.closestSwitchParents[n2] = (SwitchRetained)nodeRetained3;
                            ++this.switchIndexCount;
                        }
                        if (n3 == -1) {
                            n3 = nodeRetained3.children.indexOf(nodeRetained4);
                        }
                    } else if (nodeRetained3 instanceof SharedGroupRetained) {
                        String string = hashKey.getLastNodeId();
                        Vector vector = ((SharedGroupRetained)nodeRetained3).parents;
                        if (n3 == -1) {
                            n3 = nodeRetained3.children.indexOf(nodeRetained4);
                        }
                        n = 0;
                        while (n < vector.size()) {
                            NodeRetained nodeRetained5 = (NodeRetained)vector.elementAt(n);
                            if (nodeRetained5.nodeId.equals(string)) {
                                nodeRetained3 = nodeRetained5;
                                break;
                            }
                            ++n;
                        }
                    }
                    nodeRetained4 = nodeRetained3;
                    nodeRetained3 = nodeRetained4.parent;
                }
                ++n2;
            }
        }
        if (this.nodeType == 18) {
            nodeRetained4 = nodeRetained2 == null ? nodeRetained : nodeRetained2;
            n2 = groupRetained.children.indexOf(nodeRetained4);
            setLiveState.childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(n2);
            setLiveState.parentSwitchLink = this;
            ContainsNodesList containsNodesList = (ContainsNodesList)this.childrenContainsNodesList.get(n2);
            if (setLiveState.inSharedGroup) {
                n = 0;
                while (n < setLiveState.keys.length) {
                    ContainsNodes containsNodes = new ContainsNodes(setLiveState.keys[n]);
                    containsNodesList.addContainsNodes(containsNodes);
                    ++n;
                }
            } else {
                ContainsNodes containsNodes = new ContainsNodes(null);
                containsNodesList.addContainsNodes(containsNodes);
            }
            setLiveState.containsNodesList = containsNodesList;
        } else if (this.nodeType == 22) {
            nodeRetained4 = nodeRetained2 == null ? nodeRetained : nodeRetained2;
            n2 = groupRetained.children.indexOf(nodeRetained4);
            setLiveState.childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(n2);
            setLiveState.parentSwitchLink = this;
            ContainsNodesList containsNodesList = (ContainsNodesList)this.childrenContainsNodesList.get(n2);
            if (setLiveState.inSharedGroup) {
                n = 0;
                while (n < setLiveState.keys.length) {
                    ContainsNodes containsNodes = setLiveState.switchLevels[n] >= 0 ? new ContainsNodes(setLiveState.keys[n]) : null;
                    containsNodesList.addContainsNodes(containsNodes);
                    ++n;
                }
            } else {
                ContainsNodes containsNodes = setLiveState.switchLevels[0] >= 0 ? new ContainsNodes(null) : null;
                containsNodesList.addContainsNodes(containsNodes);
            }
            setLiveState.containsNodesList = containsNodesList;
        } else {
            setLiveState.parentSwitchLink = this.parentSwitchLink;
            if (this.parentSwitchLink != null) {
                nodeRetained4 = nodeRetained;
                nodeRetained3 = groupRetained;
                while (nodeRetained3 != this.parentSwitchLink) {
                    nodeRetained4 = nodeRetained3;
                    nodeRetained3 = nodeRetained4.parent;
                }
                n2 = nodeRetained3.children.indexOf(nodeRetained4);
                setLiveState.childSwitchLinks = (ArrayList)this.parentSwitchLink.childrenSwitchLinks.get(n2);
                setLiveState.containsNodesList = (ContainsNodesList)this.parentSwitchLink.childrenContainsNodesList.get(n3);
            }
        }
    }

    void findContainsNodesList(SetLiveState setLiveState, NodeRetained nodeRetained, NodeRetained nodeRetained2) {
        if (this.nodeType != 18 && nodeRetained2.nodeType != 18 && nodeRetained2.nodeType != 22) {
            while (nodeRetained != null) {
                if (nodeRetained.nodeType == 18 || nodeRetained.nodeType == 22) {
                    int n = ((GroupRetained)nodeRetained).children.indexOf(nodeRetained2);
                    GroupRetained groupRetained = (GroupRetained)nodeRetained;
                    ContainsNodesList containsNodesList = (ContainsNodesList)((GroupRetained)nodeRetained).childrenContainsNodesList.get(n);
                    setLiveState.containsNodesList = (ContainsNodesList)((GroupRetained)nodeRetained).childrenContainsNodesList.get(n);
                    break;
                }
                nodeRetained2 = nodeRetained;
                nodeRetained = nodeRetained2.parent;
            }
        }
    }
}

