/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.Distance;
import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CompileState;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GeometryStripArrayRetained;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickConeRay;
import javax.media.j3d.PickConeSegment;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickCylinderRay;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point2d;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point4d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

abstract class GeometryArrayRetained
extends GeometryRetained {
    int vertexFormat;
    int c4fAllocated = 0;
    int vertexCount;
    int validVertexCount;
    float[] vertexData;
    float[][] mvertexData;
    int stride;
    int texCoordStride;
    int coordinateOffset;
    int normalOffset;
    int colorOffset;
    int textureOffset;
    float[] lastAlpha = new float[1];
    float lastScreenAlpha = -1.0f;
    int colorChanged = 0;
    boolean alphaChanged = false;
    final float byteToFloatScale = 0.003921569f;
    final float FloatToByteScale = 255.0f;
    boolean inUpdater = false;
    ArrayList gaList = new ArrayList(1);
    static final int targetThreads = 192;
    Point4d tP4d = new Point4d();
    float[] floatRefCoords = null;
    double[] doubleRefCoords = null;
    Point3d[] p3dRefCoords = null;
    Point3f[] p3fRefCoords = null;
    int initialCoordIndex = 0;
    private int initialColorIndex = 0;
    private int initialNormalIndex = 0;
    private int[] initialTexCoordIndex = null;
    int initialVertexIndex = 0;
    float[] floatRefColors = null;
    byte[] byteRefColors = null;
    Color3f[] c3fRefColors = null;
    Color4f[] c4fRefColors = null;
    Color3b[] c3bRefColors = null;
    Color4b[] c4bRefColors = null;
    int vertexType = 0;
    static final int PF = 1;
    static final int PD = 2;
    static final int P3F = 4;
    static final int P3D = 8;
    static final int VERTEX_DEFINED = 15;
    static final int CF = 16;
    static final int CUB = 32;
    static final int C3F = 64;
    static final int C4F = 128;
    static final int C3UB = 256;
    static final int C4UB = 512;
    static final int COLOR_DEFINED = 1008;
    static final int NF = 1024;
    static final int N3F = 2048;
    static final int NORMAL_DEFINED = 3072;
    static final int TF = 4096;
    static final int T2F = 8192;
    static final int T3F = 16384;
    static final int TEXCOORD_DEFINED = 28672;
    static final double EPSILON = 1.0E-6;
    float[] floatRefNormals = null;
    Vector3f[] v3fRefNormals = null;
    Object[] refTexCoords = null;
    TexCoord2f[] t2fRefTexCoords = null;
    TexCoord3f[] t3fRefTexCoords = null;
    float[] interLeavedVertexData = null;
    float[] mirrorFloatRefCoords = null;
    double[] mirrorDoubleRefCoords = null;
    float[] mirrorFloatRefNormals = null;
    float[] mirrorFloatRefTexCoords = null;
    Object[] mirrorRefTexCoords = null;
    float[][] mirrorFloatRefColors = new float[1][];
    byte[][] mirrorUnsignedByteRefColors = new byte[1][];
    float[][] mirrorInterleavedColorPointer = null;
    int mirrorVertexAllocated = 0;
    int mirrorColorAllocated = 0;
    boolean mirrorTexCoordAllocated = false;
    boolean mirrorNormalAllocated = false;
    static final int COORDINATE_CHANGED = 1;
    static final int NORMAL_CHANGED = 2;
    static final int COLOR_CHANGED = 4;
    static final int TEXTURE_CHANGED = 8;
    static final int BOUNDS_CHANGED = 16;
    static final int[] defaultTexCoordSetMap = new int[]{0};
    int texCoordSetCount = 0;
    int[] texCoordSetMap = null;
    int[] texCoordSetMapOffset = null;
    static final int D3DCOLORDIRTY = 1;
    static final int D3DCOORDDIRTY = 16;
    static final int D3DNOTLIVE = 256;
    long d3dColorArray;
    int d3dColorArrayLen;
    int d3dDirtyFlag;
    long d3dCoordinateArray;
    int d3dCoordinateArrayLen;
    int resourceCreationMask = 0;
    int[] renderMolPerDlist = new int[5];
    long[] timeStampPerDlist = new long[5];
    int dlistId = -1;
    Integer dlistObj = null;
    static final int DLIST_CREATE_CHANGED = 1;
    ArrayList morphUniverseList = new ArrayList();
    ArrayList morphUserLists = new ArrayList();
    int[] geoOffset;
    int[] compileVcount;
    boolean isCompiled = false;

    GeometryArrayRetained() {
    }

    native int build(int var1);

    native void freeD3DArray();

    void GeometryArrayRetained() {
        this.d3dDirtyFlag = 17;
        if (!this.getInImmCtx()) {
            this.d3dDirtyFlag |= 0x100;
        }
        this.lastAlpha[0] = 1.0f;
    }

    void setLive(boolean bl, int n) {
        this.d3dDirtyFlag = 17;
        this.isEditable = !this.isWriteStatic();
        super.doSetLive(bl, n);
        super.markAsLive();
        if (this.refCount > 1) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 1024;
            j3dMessage.type = 50;
            j3dMessage.universe = null;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(1);
            VirtualUniverse.mc.processMessage(j3dMessage);
        } else if (this instanceof IndexedGeometryArrayRetained) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 1024;
            j3dMessage.type = 17;
            j3dMessage.universe = null;
            j3dMessage.args[0] = null;
            j3dMessage.args[1] = this;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void clearLive(int n) {
        super.clearLive(n);
        if (this.refCount <= 0) {
            this.d3dDirtyFlag = 273;
            if (VirtualUniverse.mc.isD3D()) {
                this.freeD3DArray();
            }
        }
    }

    void computeBoundingBox() {
        if ((this.vertexFormat & 0x80) == 0) {
            this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        } else if ((this.vertexFormat & 0x100) != 0) {
            this.computeBoundingBox(this.initialCoordIndex, this.interLeavedVertexData);
        } else if ((this.vertexType & 1) != 0) {
            this.computeBoundingBox(this.floatRefCoords);
        } else if ((this.vertexType & 4) != 0) {
            this.computeBoundingBox(this.p3fRefCoords);
        } else if ((this.vertexType & 8) != 0) {
            this.computeBoundingBox(this.p3dRefCoords);
        } else if ((this.vertexType & 2) != 0) {
            this.computeBoundingBox(this.doubleRefCoords);
        }
    }

    void computeBoundingBox(int n, float[] fArray) {
        double d;
        double d2;
        double d3;
        int n2 = n * this.stride + this.coordinateOffset;
        double d4 = d3 = (double)fArray[n2];
        double d5 = d2 = (double)fArray[n2 + 1];
        double d6 = d = (double)fArray[n2 + 2];
        n2 += this.stride;
        int n3 = 1;
        while (n3 < this.validVertexCount) {
            if ((double)fArray[n2] > d3) {
                d3 = fArray[n2];
            }
            if ((double)fArray[n2] < d4) {
                d4 = fArray[n2];
            }
            if ((double)fArray[n2 + 1] > d2) {
                d2 = fArray[n2 + 1];
            }
            if ((double)fArray[n2 + 1] < d5) {
                d5 = fArray[n2 + 1];
            }
            if ((double)fArray[n2 + 2] > d) {
                d = fArray[n2 + 2];
            }
            if ((double)fArray[n2 + 2] < d6) {
                d6 = fArray[n2 + 2];
            }
            n2 += this.stride;
            ++n3;
        }
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
        }
    }

    void computeBoundingBox(float[] fArray) {
        double d;
        double d2;
        double d3;
        int n = this.initialCoordIndex;
        int n2 = 3 * this.validVertexCount;
        double d4 = d3 = (double)fArray[n++];
        double d5 = d2 = (double)fArray[n++];
        double d6 = d = (double)fArray[n++];
        int n3 = n2 - 1;
        while (n3 > n) {
            int n4 = n3 - 1;
            int n5 = n3 - 2;
            if ((double)fArray[n3] > d3) {
                d3 = fArray[n3];
            }
            if ((double)fArray[n3] < d4) {
                d4 = fArray[n3];
            }
            if ((double)fArray[n4] > d2) {
                d2 = fArray[n4];
            }
            if ((double)fArray[n4] < d5) {
                d5 = fArray[n4];
            }
            if ((double)fArray[n5] > d) {
                d = fArray[n5];
            }
            if ((double)fArray[n5] < d6) {
                d6 = fArray[n5];
            }
            n3 -= 3;
        }
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
        }
    }

    void computeBoundingBox(double[] dArray) {
        double d;
        double d2;
        double d3;
        int n = this.initialCoordIndex;
        int n2 = 3 * this.validVertexCount;
        double d4 = d3 = dArray[n++];
        double d5 = d2 = dArray[n++];
        double d6 = d = dArray[n++];
        int n3 = n2 - 1;
        while (n3 > n) {
            int n4 = n3 - 1;
            int n5 = n3 - 2;
            if (dArray[n3] > d3) {
                d3 = dArray[n3];
            }
            if (dArray[n3] < d4) {
                d4 = dArray[n3];
            }
            if (dArray[n4] > d2) {
                d2 = dArray[n4];
            }
            if (dArray[n4] < d5) {
                d5 = dArray[n4];
            }
            if (dArray[n5] > d) {
                d = dArray[n5];
            }
            if (dArray[n5] < d6) {
                d6 = dArray[n5];
            }
            n3 -= 3;
        }
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
        }
    }

    void computeBoundingBox(Point3f[] point3fArray) {
        double d;
        double d2;
        double d3;
        double d4 = d3 = (double)point3fArray[this.initialCoordIndex].x;
        double d5 = d2 = (double)point3fArray[this.initialCoordIndex].y;
        double d6 = d = (double)point3fArray[this.initialCoordIndex].z;
        int n = this.initialCoordIndex + 1;
        while (n < this.validVertexCount) {
            Point3f point3f = point3fArray[n];
            if ((double)point3f.x > d3) {
                d3 = point3f.x;
            }
            if ((double)point3f.x < d4) {
                d4 = point3f.x;
            }
            if ((double)point3f.y > d2) {
                d2 = point3f.y;
            }
            if ((double)point3f.y < d5) {
                d5 = point3f.y;
            }
            if ((double)point3f.z > d) {
                d = point3f.z;
            }
            if ((double)point3f.z < d6) {
                d6 = point3f.z;
            }
            ++n;
        }
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
        }
    }

    void computeBoundingBox(Point3d[] point3dArray) {
        double d;
        double d2;
        double d3;
        double d4 = d3 = point3dArray[this.initialCoordIndex].x;
        double d5 = d2 = point3dArray[this.initialCoordIndex].y;
        double d6 = d = point3dArray[this.initialCoordIndex].z;
        int n = this.initialCoordIndex + 1;
        while (n < this.validVertexCount) {
            Point3d point3d = point3dArray[n];
            if (point3d.x > d3) {
                d3 = point3d.x;
            }
            if (point3d.x < d4) {
                d4 = point3d.x;
            }
            if (point3d.y > d2) {
                d2 = point3d.y;
            }
            if (point3d.y < d5) {
                d5 = point3d.y;
            }
            if (point3d.z > d) {
                d = point3d.z;
            }
            if (point3d.z < d6) {
                d6 = point3d.z;
            }
            ++n;
        }
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
        }
    }

    synchronized void update() {
        GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)this.mirrorGeometry;
        if (this instanceof IndexedGeometryArrayRetained && this.mirrorGeometry == null) {
            this.geomLock.getLock();
            this.mirrorGeometry = (GeometryArrayRetained)((IndexedGeometryArrayRetained)this).cloneNonIndexedGeometry();
            this.geomLock.unLock();
        }
    }

    void setupMirrorVertexPointer(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                if (this.floatRefCoords == null) {
                    if ((this.vertexType & 0xF) == 1) {
                        this.vertexType &= 0xFFFFFFFE;
                    }
                } else {
                    this.vertexType |= 1;
                }
                this.mirrorFloatRefCoords = this.floatRefCoords;
                this.mirrorVertexAllocated &= 0xFFFFFFFE;
                break;
            }
            case 2: {
                if (this.doubleRefCoords == null) {
                    if ((this.vertexType & 0xF) == 1) {
                        this.mirrorDoubleRefCoords = null;
                        this.mirrorVertexAllocated &= 0xFFFFFFFD;
                        this.vertexType &= 0xFFFFFFFD;
                    }
                    this.vertexType &= 0xFFFFFFFD;
                    break;
                }
                this.vertexType |= 2;
                this.mirrorDoubleRefCoords = this.doubleRefCoords;
                if (VirtualUniverse.mc.isD3D()) {
                    this.mirrorFloatRefCoords = new float[this.vertexCount * 3];
                    int n3 = 0;
                    while (n3 < this.mirrorFloatRefCoords.length) {
                        this.mirrorFloatRefCoords[n3] = (float)this.doubleRefCoords[n3];
                        ++n3;
                    }
                }
                this.mirrorVertexAllocated &= 0xFFFFFFFD;
                break;
            }
            case 4: {
                if (this.p3fRefCoords == null) {
                    this.vertexType &= 0xFFFFFFFB;
                    break;
                }
                this.vertexType |= 4;
                if ((this.mirrorVertexAllocated & 1) == 0) {
                    this.mirrorFloatRefCoords = new float[this.vertexCount * 3];
                    this.mirrorVertexAllocated |= 1;
                }
                int n4 = 0;
                while (n4 < this.vertexCount) {
                    this.mirrorFloatRefCoords[n2++] = this.p3fRefCoords[n4].x;
                    this.mirrorFloatRefCoords[n2++] = this.p3fRefCoords[n4].y;
                    this.mirrorFloatRefCoords[n2++] = this.p3fRefCoords[n4].z;
                    ++n4;
                }
                break;
            }
            case 8: {
                if (this.p3dRefCoords == null) {
                    this.vertexType &= 0xFFFFFFF7;
                    break;
                }
                this.vertexType |= 8;
                if ((this.mirrorVertexAllocated & 2) == 0) {
                    if (VirtualUniverse.mc.isD3D()) {
                        this.mirrorFloatRefCoords = new float[this.vertexCount * 3];
                    } else {
                        this.mirrorDoubleRefCoords = new double[this.vertexCount * 3];
                    }
                    this.mirrorVertexAllocated |= 2;
                }
                if (VirtualUniverse.mc.isD3D()) {
                    int n5 = 0;
                    while (n5 < this.vertexCount) {
                        this.mirrorFloatRefCoords[n2++] = (float)this.p3dRefCoords[n5].x;
                        this.mirrorFloatRefCoords[n2++] = (float)this.p3dRefCoords[n5].y;
                        this.mirrorFloatRefCoords[n2++] = (float)this.p3dRefCoords[n5].z;
                        ++n5;
                    }
                } else {
                    int n6 = 0;
                    while (n6 < this.vertexCount) {
                        this.mirrorDoubleRefCoords[n2++] = this.p3dRefCoords[n6].x;
                        this.mirrorDoubleRefCoords[n2++] = this.p3dRefCoords[n6].y;
                        this.mirrorDoubleRefCoords[n2++] = this.p3dRefCoords[n6].z;
                        ++n6;
                    }
                }
                break;
            }
        }
    }

    void setupMirrorInterleavedColorPointer(boolean bl) {
        if (bl || this.c4fAllocated != 0) {
            int n = (this.vertexFormat & 8) != 0 ? this.stride * this.vertexCount : (this.stride + 1) * this.vertexCount;
            if (this.mirrorInterleavedColorPointer == null) {
                this.mirrorInterleavedColorPointer = new float[1][n];
            }
            int n2 = this.colorOffset;
            int n3 = 0;
            if ((this.vertexFormat & 8) != 0) {
                int n4 = 0;
                while (n4 < this.vertexCount) {
                    System.arraycopy(this.interLeavedVertexData, n2, this.mirrorInterleavedColorPointer[0], n3, 4);
                    n3 += 4;
                    n2 += this.stride;
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < this.vertexCount) {
                    System.arraycopy(this.interLeavedVertexData, n2, this.mirrorInterleavedColorPointer[0], n3, 3);
                    this.mirrorInterleavedColorPointer[0][n3 + 3] = 1.0f;
                    n3 += 4;
                    n2 += this.stride;
                    ++n5;
                }
            }
            this.c4fAllocated = 8;
        }
    }

    void setupMirrorColorPointer(int n, boolean bl) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (this.c4fAllocated == 0 && !bl) {
            n2 = 3;
        } else {
            if (bl && this.c4fAllocated == 0 && (this.vertexFormat & 8) == 0) {
                this.mirrorColorAllocated = 0;
            }
            this.c4fAllocated = 8;
            n2 = 4;
        }
        switch (n) {
            case 16: {
                if (this.floatRefColors == null) {
                    if (this.c4fAllocated == 0 & !bl && (this.vertexType & 0x3F0) == 16) {
                        this.mirrorFloatRefColors[0] = null;
                        this.mirrorColorAllocated &= 0xFFFFFFEF;
                    }
                    this.vertexType &= 0xFFFFFFEF;
                    return;
                }
                this.vertexType |= 0x10;
                if (this.c4fAllocated == 0 & !bl) {
                    this.mirrorFloatRefColors[0] = this.floatRefColors;
                    this.mirrorColorAllocated &= 0xFFFFFFEF;
                    break;
                }
                if ((this.mirrorColorAllocated & 0x10) == 0) {
                    this.mirrorFloatRefColors[0] = new float[4 * this.vertexCount];
                    this.mirrorColorAllocated |= 0x10;
                }
                if ((this.vertexFormat & 8) == 0) {
                    n3 = 0;
                    n4 = 0;
                    int n5 = 0;
                    while (n5 < this.vertexCount) {
                        System.arraycopy(this.floatRefColors, n3, this.mirrorFloatRefColors[0], n4, 3);
                        this.mirrorFloatRefColors[0][n4 + 3] = 1.0f;
                        n4 += 4;
                        n3 += 3;
                        ++n5;
                    }
                } else {
                    int n6 = 0;
                    while (n6 < this.vertexCount) {
                        System.arraycopy(this.floatRefColors, n3, this.mirrorFloatRefColors[0], n3, 4);
                        n3 += 4;
                        ++n6;
                    }
                }
                break;
            }
            case 32: {
                if (this.byteRefColors == null) {
                    if (this.c4fAllocated == 0 & !bl && (this.vertexType & 0x3F0) == 32) {
                        this.mirrorUnsignedByteRefColors[0] = null;
                        this.mirrorColorAllocated &= 0xFFFFFFDF;
                    }
                    this.vertexType &= 0xFFFFFFDF;
                    return;
                }
                this.vertexType |= 0x20;
                if (this.c4fAllocated == 0 && !bl) {
                    this.mirrorUnsignedByteRefColors[0] = this.byteRefColors;
                    this.mirrorColorAllocated &= 0xFFFFFFDF;
                    break;
                }
                if ((this.mirrorColorAllocated & 0x20) == 0) {
                    this.mirrorUnsignedByteRefColors[0] = new byte[4 * this.vertexCount];
                    this.mirrorColorAllocated |= 0x20;
                }
                if ((this.vertexFormat & 8) == 0) {
                    int n7 = 0;
                    while (n7 < this.vertexCount) {
                        System.arraycopy(this.byteRefColors, n3, this.mirrorUnsignedByteRefColors[0], n4, 3);
                        this.mirrorUnsignedByteRefColors[0][n4 + 3] = -1;
                        n3 += 3;
                        n4 += 4;
                        ++n7;
                    }
                } else {
                    int n8 = 0;
                    while (n8 < this.vertexCount) {
                        System.arraycopy(this.byteRefColors, n3, this.mirrorUnsignedByteRefColors[0], n3, 4);
                        n3 += 4;
                        ++n8;
                    }
                }
                break;
            }
            case 64: {
                if (this.c3fRefColors == null) {
                    this.vertexType &= 0xFFFFFFBF;
                    return;
                }
                this.vertexType |= 0x40;
                if ((this.mirrorColorAllocated & 0x10) == 0) {
                    this.mirrorFloatRefColors[0] = new float[this.vertexCount * n2];
                    this.mirrorColorAllocated |= 0x10;
                }
                if ((this.c4fAllocated & 8) == 0) {
                    int n9 = 0;
                    while (n9 < this.vertexCount) {
                        this.mirrorFloatRefColors[0][n4] = this.c3fRefColors[n9].x;
                        this.mirrorFloatRefColors[0][n4 + 1] = this.c3fRefColors[n9].y;
                        this.mirrorFloatRefColors[0][n4 + 2] = this.c3fRefColors[n9].z;
                        n4 += n2;
                        ++n9;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < this.vertexCount) {
                        this.mirrorFloatRefColors[0][n4] = this.c3fRefColors[n10].x;
                        this.mirrorFloatRefColors[0][n4 + 1] = this.c3fRefColors[n10].y;
                        this.mirrorFloatRefColors[0][n4 + 2] = this.c3fRefColors[n10].z;
                        this.mirrorFloatRefColors[0][n4 + 3] = 1.0f;
                        n4 += n2;
                        ++n10;
                    }
                }
                break;
            }
            case 128: {
                if (this.c4fRefColors == null) {
                    this.vertexType &= 0xFFFFFF7F;
                    return;
                }
                this.vertexType |= 0x80;
                if ((this.mirrorColorAllocated & 0x10) == 0) {
                    this.mirrorFloatRefColors[0] = new float[this.vertexCount << 2];
                    this.mirrorColorAllocated |= 0x10;
                }
                int n11 = 0;
                while (n11 < this.vertexCount) {
                    this.mirrorFloatRefColors[0][n4++] = this.c4fRefColors[n11].x;
                    this.mirrorFloatRefColors[0][n4++] = this.c4fRefColors[n11].y;
                    this.mirrorFloatRefColors[0][n4++] = this.c4fRefColors[n11].z;
                    this.mirrorFloatRefColors[0][n4++] = this.c4fRefColors[n11].w;
                    ++n11;
                }
                break;
            }
            case 256: {
                if (this.c3bRefColors == null) {
                    this.vertexType &= 0xFFFFFEFF;
                    return;
                }
                this.vertexType |= 0x100;
                if ((this.mirrorColorAllocated & 0x20) == 0) {
                    this.mirrorUnsignedByteRefColors[0] = new byte[this.vertexCount * n2];
                    this.mirrorColorAllocated |= 0x20;
                }
                if ((this.c4fAllocated & 8) == 0) {
                    int n12 = 0;
                    while (n12 < this.vertexCount) {
                        this.mirrorUnsignedByteRefColors[0][n4] = this.c3bRefColors[n12].x;
                        this.mirrorUnsignedByteRefColors[0][n4 + 1] = this.c3bRefColors[n12].y;
                        this.mirrorUnsignedByteRefColors[0][n4 + 2] = this.c3bRefColors[n12].z;
                        n4 += n2;
                        ++n12;
                    }
                } else {
                    int n13 = 0;
                    while (n13 < this.vertexCount) {
                        this.mirrorUnsignedByteRefColors[0][n4] = this.c3bRefColors[n13].x;
                        this.mirrorUnsignedByteRefColors[0][n4 + 1] = this.c3bRefColors[n13].y;
                        this.mirrorUnsignedByteRefColors[0][n4 + 2] = this.c3bRefColors[n13].z;
                        this.mirrorUnsignedByteRefColors[0][n4 + 3] = -1;
                        n4 += n2;
                        ++n13;
                    }
                }
                break;
            }
            case 512: {
                if (this.c4bRefColors == null) {
                    this.vertexType &= 0xFFFFFDFF;
                    return;
                }
                this.vertexType |= 0x200;
                if ((this.mirrorColorAllocated & 0x20) == 0) {
                    this.mirrorUnsignedByteRefColors[0] = new byte[this.vertexCount << 2];
                    this.mirrorColorAllocated |= 0x20;
                }
                int n14 = 0;
                while (n14 < this.vertexCount) {
                    this.mirrorUnsignedByteRefColors[0][n4++] = this.c4bRefColors[n14].x;
                    this.mirrorUnsignedByteRefColors[0][n4++] = this.c4bRefColors[n14].y;
                    this.mirrorUnsignedByteRefColors[0][n4++] = this.c4bRefColors[n14].z;
                    this.mirrorUnsignedByteRefColors[0][n4++] = this.c4bRefColors[n14].w;
                    ++n14;
                }
                break;
            }
        }
        this.colorChanged = 65535;
    }

    void setupMirrorNormalPointer(int n) {
        int n2 = 0;
        switch (n) {
            case 1024: {
                if (this.floatRefNormals == null) {
                    if ((this.vertexType & 0xC00) == 1024) {
                        this.vertexType &= 0xFFFFFBFF;
                    }
                } else {
                    this.vertexType |= 0x400;
                }
                this.mirrorFloatRefNormals = this.floatRefNormals;
                this.mirrorNormalAllocated = false;
                break;
            }
            case 2048: {
                if (this.v3fRefNormals == null) {
                    if ((this.vertexType & 0xC00) == 2048) {
                        this.vertexType &= 0xFFFFF7FF;
                    }
                    return;
                }
                this.vertexType |= 0x800;
                if (!this.mirrorNormalAllocated) {
                    this.mirrorFloatRefNormals = new float[this.vertexCount * 3];
                    this.mirrorNormalAllocated = true;
                }
                int n3 = 0;
                while (n3 < this.vertexCount) {
                    this.mirrorFloatRefNormals[n2++] = this.v3fRefNormals[n3].x;
                    this.mirrorFloatRefNormals[n2++] = this.v3fRefNormals[n3].y;
                    this.mirrorFloatRefNormals[n2++] = this.v3fRefNormals[n3].z;
                    ++n3;
                }
                break;
            }
        }
    }

    void setupMirrorTexCoordPointer(int n) {
        int n2 = 0;
        while (n2 < this.texCoordSetCount) {
            this.setupMirrorTexCoordPointer(n2, n);
            ++n2;
        }
    }

    void setupMirrorTexCoordPointer(int n, int n2) {
        int n3 = 0;
        if (this.mirrorRefTexCoords == null) {
            this.mirrorRefTexCoords = new Object[this.texCoordSetCount];
        }
        switch (n2) {
            case 4096: {
                if (this.refTexCoords[n] == null) {
                    if ((this.vertexType & 0x7000) == 4096) {
                        this.vertexType &= 0xFFFFEFFF;
                    }
                } else {
                    this.vertexType |= 0x1000;
                }
                this.mirrorRefTexCoords[n] = this.refTexCoords[n];
                this.mirrorTexCoordAllocated = false;
                break;
            }
            case 8192: {
                this.t2fRefTexCoords = (TexCoord2f[])this.refTexCoords[n];
                if (this.t2fRefTexCoords == null) {
                    if ((this.vertexType & 0x7000) == 8192) {
                        this.vertexType &= 0xFFFFDFFF;
                    }
                    return;
                }
                this.vertexType |= 0x2000;
                this.mirrorFloatRefTexCoords = (float[])this.mirrorRefTexCoords[n];
                if (this.mirrorFloatRefTexCoords != null) {
                    if (this.mirrorFloatRefTexCoords.length < this.vertexCount * 2) {
                        this.mirrorFloatRefTexCoords = new float[this.vertexCount * 2];
                        this.mirrorRefTexCoords[n] = this.mirrorFloatRefTexCoords;
                    }
                } else {
                    this.mirrorFloatRefTexCoords = new float[this.vertexCount * 2];
                    this.mirrorRefTexCoords[n] = this.mirrorFloatRefTexCoords;
                }
                int n4 = 0;
                while (n4 < this.vertexCount) {
                    this.mirrorFloatRefTexCoords[n3++] = this.t2fRefTexCoords[n4].x;
                    this.mirrorFloatRefTexCoords[n3++] = this.t2fRefTexCoords[n4].y;
                    ++n4;
                }
                this.mirrorTexCoordAllocated = true;
                break;
            }
            case 16384: {
                this.t3fRefTexCoords = (TexCoord3f[])this.refTexCoords[n];
                if (this.t3fRefTexCoords == null) {
                    if ((this.vertexType & 0x7000) == 16384) {
                        this.vertexType &= 0xFFFFBFFF;
                    }
                    return;
                }
                this.vertexType |= 0x4000;
                this.mirrorFloatRefTexCoords = (float[])this.mirrorRefTexCoords[n];
                if (this.mirrorFloatRefTexCoords != null) {
                    if (this.mirrorFloatRefTexCoords.length < this.vertexCount * 3) {
                        this.mirrorFloatRefTexCoords = new float[this.vertexCount * 3];
                        this.mirrorRefTexCoords[n] = this.mirrorFloatRefTexCoords;
                    }
                } else {
                    this.mirrorFloatRefTexCoords = new float[this.vertexCount * 3];
                    this.mirrorRefTexCoords[n] = this.mirrorFloatRefTexCoords;
                }
                int n5 = 0;
                while (n5 < this.vertexCount) {
                    this.mirrorFloatRefTexCoords[n3++] = this.t3fRefTexCoords[n5].x;
                    this.mirrorFloatRefTexCoords[n3++] = this.t3fRefTexCoords[n5].y;
                    this.mirrorFloatRefTexCoords[n3++] = this.t3fRefTexCoords[n5].z;
                    ++n5;
                }
                this.mirrorTexCoordAllocated = true;
                break;
            }
        }
    }

    void createGeometryArrayData(int n, int n2) {
        if ((n2 & 0x60) != 0) {
            this.createGeometryArrayData(n, n2, 1, defaultTexCoordSetMap);
        } else {
            this.createGeometryArrayData(n, n2, 0, null);
        }
    }

    void createGeometryArrayData(int n, int n2, int n3, int[] nArray) {
        this.vertexFormat = n2;
        this.vertexCount = n;
        this.validVertexCount = n;
        this.texCoordSetCount = n3;
        this.texCoordSetMap = nArray;
        this.stride = this.stride();
        this.texCoordSetMapOffset = this.texCoordSetMapOffset();
        this.textureOffset = 0;
        this.colorOffset = this.colorOffset();
        this.normalOffset = this.normalOffset();
        this.coordinateOffset = this.coordinateOffset();
        if ((n2 & 0x80) == 0) {
            this.vertexData = new float[this.vertexCount * this.stride];
        } else {
            this.vertexData = null;
            if ((n2 & 0x60) != 0) {
                this.refTexCoords = new Object[n3];
            }
        }
        if ((n2 & 0x60) != 0) {
            this.initialTexCoordIndex = new int[n3];
        }
        this.noAlpha = (n2 & 8) == 0;
        this.lastAlpha[0] = 1.0f;
    }

    native void execute(int var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7, int var8, int var9, int var10, int var11, int[] var12, int var13, int[] var14, int[] var15, float[] var16, int var17, int var18);

    native void executeInterLeaved(int var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7, int var8, int var9, int var10, int var11, int var12, int var13, float[] var14, float[] var15, int var16, int[] var17, int var18, int[] var19, int[] var20, int var21, int var22);

    native void executeVA(int var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, int var6, int var7, boolean var8, boolean var9, boolean var10, boolean var11, boolean var12, boolean var13, int var14, float[] var15, double[] var16, int var17, float[] var18, byte[] var19, int var20, float[] var21, int var22, int var23, int[] var24, int[] var25, int[] var26, int var27, Object[] var28);

    native void executeVA(int var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int[] var12, float[] var13, float[] var14, byte[] var15, float[] var16, float[] var17, float[] var18, float[] var19, float[] var20, float[] var21, float[] var22, float[] var23, float[] var24, int var25, int var26, int[] var27, int var28, int[] var29, int var30, int var31);

    native void setVertexFormat(int var1, boolean var2, boolean var3);

    native void disableGlobalAlpha(int var1, int var2, boolean var3, boolean var4);

    native void setGlobalAlpha(int var1, float var2);

    void setVertexFormat(boolean bl, boolean bl2) {
        this.setVertexFormat(this.vertexFormat, bl, bl2);
    }

    void disableGlobalAlpha(int n, boolean bl, boolean bl2) {
        this.disableGlobalAlpha(n, this.vertexFormat, bl, bl2);
    }

    float[] updateAlphaInFloatRefColors(Canvas3D canvas3D, int n, float f) {
        int n2;
        Object object;
        if (canvas3D.supportGlobalAlpha()) {
            this.setGlobalAlpha(canvas3D.ctx, f);
            return this.mirrorFloatRefColors[0];
        }
        if (((this.vertexFormat | this.c4fAllocated) & 8) == 0) {
            return this.mirrorFloatRefColors[0];
        }
        if ((double)f <= 1.0E-6) {
            f = 1.0E-6f;
        }
        if (this.lastAlpha == null) {
            this.lastAlpha = new float[n + 1];
            this.lastAlpha[n] = 1.0f;
        } else if (this.lastAlpha.length <= n) {
            object = new float[n + 1];
            n2 = 0;
            while (n2 < this.lastAlpha.length) {
                object[n2] = this.lastAlpha[n2];
                ++n2;
            }
            this.lastAlpha = object;
            this.lastAlpha[n] = 1.0f;
        }
        if (this.mirrorFloatRefColors.length <= n) {
            object = new float[n + 1][];
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.mirrorFloatRefColors.length) {
                object[n4] = (float)this.mirrorFloatRefColors[n4];
                if ((double)Math.abs(this.lastAlpha[n4] - f) < 1.0E-6) {
                    n3 = n4;
                }
                ++n4;
            }
            float[] fArray = new float[4 * this.vertexCount];
            object[n] = (float)fArray;
            float[] fArray2 = fArray;
            if (n3 >= 0) {
                System.arraycopy(object[n3], 0, fArray2, 0, 4 * this.vertexCount);
                this.lastAlpha[n] = this.lastAlpha[n3];
            } else {
                float f2 = f / this.lastAlpha[0];
                float f3 = object[0];
                int n5 = 0;
                int n6 = 0;
                while (n5 < this.vertexCount) {
                    System.arraycopy(f3, n6, fArray2, n6, 3);
                    fArray2[n6 + 3] = f3[n6 + 3] * f2;
                    ++n5;
                    n6 += 4;
                }
                this.lastAlpha[n] = this.lastAlpha[0];
            }
            this.mirrorFloatRefColors = (float[][])object;
            this.colorChanged &= ~(1 << n);
            this.d3dDirtyFlag |= 1;
            return fArray2;
        }
        if ((this.colorChanged & 1 << n) == 0) {
            if ((double)Math.abs(this.lastAlpha[n] - f) < 1.0E-6) {
                return this.mirrorFloatRefColors[n];
            }
            float f4 = f / this.lastAlpha[n];
            float[] fArray = this.mirrorFloatRefColors[n];
            int n7 = 0;
            int n8 = 0;
            while (n7 < this.vertexCount) {
                fArray[n8 + 3] = fArray[n8 + 3] * f4;
                ++n7;
                n8 += 4;
            }
        } else if (n == 0) {
            object = this.mirrorFloatRefColors[n];
            n2 = 0;
            int n9 = 0;
            while (n2 < this.vertexCount) {
                object[n9 + 3] = object[n9 + 3] * f;
                ++n2;
                n9 += 4;
            }
        } else {
            float f5 = (this.colorChanged & 1) == 0 ? f / this.lastAlpha[0] : f;
            float[] fArray = this.mirrorFloatRefColors[0];
            float[] fArray3 = this.mirrorFloatRefColors[n];
            int n10 = 0;
            int n11 = 0;
            while (n10 < this.vertexCount) {
                System.arraycopy(fArray, n11, fArray3, n11, 3);
                fArray3[n11 + 3] = fArray[n11 + 3] * f5;
                ++n10;
                n11 += 4;
            }
        }
        this.lastAlpha[n] = f;
        this.colorChanged &= ~(1 << n);
        this.d3dDirtyFlag |= 1;
        return this.mirrorFloatRefColors[n];
    }

    byte[] updateAlphaInByteRefColors(Canvas3D canvas3D, int n, float f) {
        int n2;
        Object object;
        if (canvas3D.supportGlobalAlpha()) {
            this.setGlobalAlpha(canvas3D.ctx, f);
            return this.mirrorUnsignedByteRefColors[0];
        }
        if (this.lastAlpha == null) {
            this.lastAlpha = new float[n + 1];
            this.lastAlpha[n] = -1.0f;
        } else if (this.lastAlpha.length <= n) {
            object = new float[n + 1];
            n2 = 0;
            while (n2 < this.lastAlpha.length) {
                object[n2] = this.lastAlpha[n2];
                ++n2;
            }
            this.lastAlpha = object;
            this.lastAlpha[n] = -1.0f;
        }
        if (this.mirrorUnsignedByteRefColors.length <= n) {
            object = new byte[n + 1][];
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.mirrorUnsignedByteRefColors.length) {
                object[n4] = (float)this.mirrorUnsignedByteRefColors[n4];
                if ((double)Math.abs(this.lastAlpha[n4] - f) < 1.0E-6) {
                    n3 = n4;
                }
                ++n4;
            }
            byte[] byArray = new byte[4 * this.vertexCount];
            object[n] = (float)byArray;
            byte[] byArray2 = byArray;
            if (n3 >= 0) {
                System.arraycopy(object[n3], 0, byArray2, 0, 4 * this.vertexCount);
                this.lastAlpha[n] = this.lastAlpha[n3];
            } else {
                float f2 = f / this.lastAlpha[0];
                float f3 = object[0];
                int n5 = 0;
                int n6 = 0;
                while (n5 < this.vertexCount) {
                    System.arraycopy(f3, n6, byArray2, n6, 3);
                    byArray2[n6 + 3] = (byte)((float)f3[n6 + 3] * f2);
                    ++n5;
                    n6 += 4;
                }
                this.lastAlpha[n] = this.lastAlpha[0];
            }
            this.mirrorUnsignedByteRefColors = (byte[][])object;
            this.colorChanged &= ~(1 << n);
            this.d3dDirtyFlag |= 1;
            return byArray2;
        }
        if ((this.colorChanged & 1 << n) == 0) {
            if ((double)Math.abs(this.lastAlpha[n] - f) < 1.0E-6) {
                return this.mirrorUnsignedByteRefColors[n];
            }
            float f4 = f / this.lastAlpha[n];
            byte[] byArray = this.mirrorUnsignedByteRefColors[n];
            int n7 = 0;
            int n8 = 0;
            while (n7 < this.vertexCount) {
                byArray[n8 + 3] = (byte)((float)byArray[n8 + 3] * f4);
                ++n7;
                n8 += 4;
            }
        } else if (n == 0) {
            object = this.mirrorUnsignedByteRefColors[n];
            n2 = 0;
            int n9 = 0;
            while (n2 < this.vertexCount) {
                object[n9 + 3] = (byte)((float)object[n9 + 3] * f);
                ++n2;
                n9 += 4;
            }
        } else {
            float f5 = (this.colorChanged & 1) == 0 ? f / this.lastAlpha[0] : f;
            byte[] byArray = this.mirrorUnsignedByteRefColors[0];
            byte[] byArray3 = this.mirrorUnsignedByteRefColors[n];
            int n10 = 0;
            int n11 = 0;
            while (n10 < this.vertexCount) {
                System.arraycopy(byArray, n11, byArray3, n11, 3);
                byArray3[n11 + 3] = (byte)((float)byArray[n11 + 3] * f5);
                ++n10;
                n11 += 4;
            }
        }
        this.lastAlpha[n] = f;
        this.colorChanged &= ~(1 << n);
        this.d3dDirtyFlag |= 1;
        return this.mirrorUnsignedByteRefColors[n];
    }

    float[] updateAlphaInVertexData(Canvas3D canvas3D, int n, float f) {
        int n2;
        Object object;
        if (canvas3D.supportGlobalAlpha()) {
            this.setGlobalAlpha(canvas3D.ctx, f);
            return this.vertexData;
        }
        if ((this.vertexFormat & 4) == 0) {
            return this.vertexData;
        }
        if ((double)f <= 1.0E-6) {
            f = 1.0E-6f;
        }
        if (this.lastAlpha == null) {
            this.lastAlpha = new float[n + 1];
            this.lastAlpha[n] = 1.0f;
        } else if (this.lastAlpha.length <= n) {
            object = new float[n + 1];
            n2 = 0;
            while (n2 < this.lastAlpha.length) {
                object[n2] = this.lastAlpha[n2];
                ++n2;
            }
            this.lastAlpha = object;
            this.lastAlpha[n] = 1.0f;
        }
        if (this.mvertexData == null || this.mvertexData.length <= n) {
            object = new float[n + 1][];
            int n3 = -1;
            if (this.mvertexData != null) {
                int n4 = 0;
                while (n4 < this.mvertexData.length) {
                    object[n4] = (float)this.mvertexData[n4];
                    if ((double)Math.abs(this.lastAlpha[n4] - f) < 1.0E-6) {
                        n3 = n4;
                    }
                    ++n4;
                }
            }
            if (object[0] == null) {
                object[n] = (float)this.vertexData;
            }
            if (n > 0) {
                object[n] = (float)new float[this.stride * this.vertexCount];
            }
            float f2 = object[n];
            if (n3 >= 0) {
                System.arraycopy(object[n3], 0, f2, 0, this.stride * this.vertexCount);
                this.lastAlpha[n] = this.lastAlpha[n3];
            } else {
                float f3 = f / this.lastAlpha[0];
                float f4 = object[0];
                if (n > 0) {
                    System.arraycopy(object[n3], 0, f2, 0, this.stride * this.vertexCount);
                }
                int n5 = 0;
                int n6 = this.colorOffset;
                while (n5 < this.vertexCount) {
                    f2[n6 + 3] = f4[n6 + 3] * f3;
                    ++n5;
                    n6 += this.stride;
                }
                this.lastAlpha[n] = f;
            }
            this.mvertexData = (float[][])object;
            this.d3dDirtyFlag |= 1;
            this.colorChanged &= ~(1 << n);
            return f2;
        }
        if ((this.colorChanged & 1 << n) == 0) {
            if ((double)Math.abs(this.lastAlpha[n] - f) < 1.0E-6) {
                return this.mvertexData[n];
            }
            float f5 = f / this.lastAlpha[n];
            float[] fArray = this.mvertexData[n];
            int n7 = 0;
            int n8 = this.colorOffset;
            while (n7 < this.vertexCount) {
                fArray[n8 + 3] = fArray[n8 + 3] * f5;
                ++n7;
                n8 += this.stride;
            }
        } else if (n == 0) {
            object = this.mvertexData[n];
            n2 = 0;
            int n9 = this.colorOffset;
            while (n2 < this.vertexCount) {
                object[n9 + 3] = object[n9 + 3] * f;
                ++n2;
                n9 += this.stride;
            }
        } else {
            float f6 = (this.colorChanged & 1) == 0 ? f / this.lastAlpha[0] : f;
            float[] fArray = this.mvertexData[0];
            float[] fArray2 = this.mvertexData[n];
            int n10 = 0;
            int n11 = this.colorOffset;
            while (n10 < this.vertexCount) {
                System.arraycopy(fArray, n11, fArray2, n11, 3);
                fArray2[n11 + 3] = fArray[n11 + 3] * f6;
                ++n10;
                n11 += this.stride;
            }
        }
        this.lastAlpha[n] = f;
        this.colorChanged &= ~(1 << n);
        this.d3dDirtyFlag |= 1;
        return this.mvertexData[n];
    }

    float[] updateAlphaInInterLeavedData(Canvas3D canvas3D, int n, float f) {
        int n2;
        Object object;
        if (canvas3D.supportGlobalAlpha()) {
            this.setGlobalAlpha(canvas3D.ctx, f);
            return null;
        }
        if (((this.vertexFormat | this.c4fAllocated) & 4) == 0) {
            return this.mirrorInterleavedColorPointer[0];
        }
        int n3 = this.initialColorIndex << 2;
        if ((double)f <= 1.0E-6) {
            f = 1.0E-6f;
        }
        if (this.lastAlpha == null) {
            this.lastAlpha = new float[n + 1];
            this.lastAlpha[n] = 1.0f;
        } else if (this.lastAlpha.length <= n) {
            object = new float[n + 1];
            n2 = 0;
            while (n2 < this.lastAlpha.length) {
                object[n2] = this.lastAlpha[n2];
                ++n2;
            }
            this.lastAlpha = object;
            this.lastAlpha[n] = 1.0f;
        }
        if (this.mirrorInterleavedColorPointer.length <= n) {
            object = new float[n + 1][];
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.mirrorInterleavedColorPointer.length) {
                object[n5] = (float)this.mirrorInterleavedColorPointer[n5];
                if ((double)Math.abs(this.lastAlpha[n5] - f) < 1.0E-6) {
                    n4 = n5;
                }
                ++n5;
            }
            float[] fArray = new float[this.stride * this.vertexCount];
            object[n] = (float)fArray;
            float[] fArray2 = fArray;
            if (n4 >= 0) {
                System.arraycopy(object[n4], 0, fArray2, 0, this.stride * this.vertexCount);
                this.lastAlpha[n] = this.lastAlpha[n4];
            } else {
                float f2 = f / this.lastAlpha[0];
                float f3 = object[0];
                int n6 = n3;
                while (n6 < n3 + (this.vertexCount << 2)) {
                    fArray2[n6 + 3] = f3[n6 + 3] * f2;
                    n6 += 4;
                }
                this.lastAlpha[n] = f;
            }
            this.mirrorInterleavedColorPointer = (float[][])object;
            this.colorChanged &= ~(1 << n);
            this.d3dDirtyFlag |= 1;
            return fArray2;
        }
        if ((this.colorChanged & 1 << n) == 0) {
            if ((double)Math.abs(this.lastAlpha[n] - f) < 1.0E-6) {
                return this.mirrorInterleavedColorPointer[n];
            }
            float f4 = f / this.lastAlpha[n];
            float[] fArray = this.mirrorInterleavedColorPointer[n];
            int n7 = n3 = this.initialColorIndex << 2;
            while (n7 < n3 + (this.vertexCount << 2)) {
                fArray[n7 + 3] = fArray[n7 + 3] * f4;
                n7 += 4;
            }
        } else if (n == 0) {
            object = this.mirrorInterleavedColorPointer[n];
            n2 = n3;
            while (n2 < n3 + (this.vertexCount << 2)) {
                object[n2 + 3] = object[n2 + 3] * f;
                n2 += 4;
            }
        } else {
            float f5 = (this.colorChanged & 1) == 0 ? f / this.lastAlpha[0] : f;
            float[] fArray = this.mirrorInterleavedColorPointer[0];
            float[] fArray3 = this.mirrorInterleavedColorPointer[n];
            int n8 = n3;
            while (n8 < n3 + (this.vertexCount << 2)) {
                System.arraycopy(fArray, n8, fArray3, n8, 3);
                fArray3[n8 + 3] = fArray[n8 + 3] * f5;
                n8 += 4;
            }
        }
        this.lastAlpha[n] = f;
        this.colorChanged &= ~(1 << n);
        this.d3dDirtyFlag |= 1;
        return this.mirrorInterleavedColorPointer[n];
    }

    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, int n, boolean bl4, int[] nArray, int n2) {
        if ((this.vertexFormat & 0x80) == 0) {
            float[] fArray;
            int n3;
            GeometryArrayRetained geometryArrayRetained = this;
            synchronized (geometryArrayRetained) {
                n3 = this.d3dDirtyFlag;
                if (bl2 && !bl4) {
                    fArray = this.updateAlphaInVertexData(canvas3D, n, f);
                    if (f != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f;
                        n3 |= 1;
                    }
                } else {
                    fArray = this.vertexData;
                    if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n3 |= 1;
                    }
                }
            }
            this.clearDirtyFlag();
            this.execute(canvas3D.ctx, this, this.geoType, bl, bl2, bl3, bl4, this.initialVertexIndex, this instanceof GeometryStripArrayRetained ? this.vertexCount : this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, nArray, fArray, n2, n3);
        } else if ((this.vertexFormat & 0x100) != 0) {
            int n4;
            float[] fArray = null;
            GeometryArrayRetained geometryArrayRetained = this;
            synchronized (geometryArrayRetained) {
                n4 = this.d3dDirtyFlag;
                if (bl2 && !bl4) {
                    fArray = this.updateAlphaInInterLeavedData(canvas3D, n, f);
                    if (f != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f;
                        n4 |= 1;
                    }
                } else if (this.lastScreenAlpha != -1.0f) {
                    this.lastScreenAlpha = -1.0f;
                    n4 |= 1;
                }
            }
            this.clearDirtyFlag();
            this.executeInterLeaved(canvas3D.ctx, this, this.geoType, bl, bl2, bl3, bl4, this instanceof GeometryStripArrayRetained ? this.vertexCount : this.validVertexCount, this.vertexFormat, this.initialCoordIndex, (this.vertexFormat & 4) != 0 ? this.initialColorIndex : 0, (this.vertexFormat & 2) != 0 ? this.initialNormalIndex : 0, (this.vertexFormat & 0x60) != 0 ? this.initialTexCoordIndex[0] : 0, fArray, this.interLeavedVertexData, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, nArray, n2, n4);
        } else {
            if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x60) != 0 && (this.vertexType & 0x7000) == 0) {
                return;
            }
            if (!VirtualUniverse.mc.isD3D()) {
                byte[] byArray = null;
                float[] fArray = null;
                if ((this.vertexType & 0xD0) != 0) {
                    GeometryArrayRetained geometryArrayRetained = this;
                    synchronized (geometryArrayRetained) {
                        fArray = bl2 && !bl4 ? this.updateAlphaInFloatRefColors(canvas3D, n, f) : this.mirrorFloatRefColors[0];
                    }
                }
                if ((this.vertexType & 0x320) != 0) {
                    GeometryArrayRetained geometryArrayRetained = this;
                    synchronized (geometryArrayRetained) {
                        byArray = bl2 && !bl4 ? this.updateAlphaInByteRefColors(canvas3D, n, f) : this.mirrorUnsignedByteRefColors[0];
                    }
                }
                this.executeVA(canvas3D.ctx, this, this.geoType, bl, bl3, this.validVertexCount, this.vertexFormat | this.c4fAllocated, (this.vertexType & 5) != 0, (this.vertexType & 0xA) != 0, (this.vertexType & 0xD0) != 0, (this.vertexType & 0x320) != 0, (this.vertexType & 0xC00) != 0, (this.vertexType & 0x7000) != 0, this.initialCoordIndex, this.mirrorFloatRefCoords, this.mirrorDoubleRefCoords, this.initialColorIndex, fArray, byArray, this.initialNormalIndex, this.mirrorFloatRefNormals, n2, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, nArray, this.initialTexCoordIndex, this.texCoordStride, this.mirrorRefTexCoords);
            } else {
                int n5;
                boolean bl5;
                int n6;
                boolean bl6 = (this.vertexType & 0xD0) != 0;
                float[] fArray = null;
                byte[] byArray = null;
                if (bl6) {
                    GeometryArrayRetained geometryArrayRetained = this;
                    synchronized (geometryArrayRetained) {
                        n6 = this.d3dDirtyFlag;
                        if (bl2 && !bl4) {
                            fArray = this.updateAlphaInFloatRefColors(canvas3D, n, f);
                            if (f != this.lastScreenAlpha) {
                                this.lastScreenAlpha = f;
                                n6 |= 1;
                            }
                        } else {
                            fArray = this.mirrorFloatRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                n6 |= 1;
                            }
                        }
                    }
                }
                GeometryArrayRetained geometryArrayRetained = this;
                synchronized (geometryArrayRetained) {
                    n6 = this.d3dDirtyFlag;
                    if (bl2 && !bl4) {
                        byArray = this.updateAlphaInByteRefColors(canvas3D, n, f);
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n6 |= 1;
                        }
                    } else {
                        byArray = this.mirrorUnsignedByteRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n6 |= 1;
                        }
                    }
                }
                this.clearDirtyFlag();
                if (this.mirrorRefTexCoords == null) {
                    bl5 = false;
                    n5 = 0;
                } else {
                    bl5 = true;
                    n5 = this.mirrorRefTexCoords.length;
                }
                this.executeVA(canvas3D.ctx, this, this.geoType, bl, bl3, bl4, this instanceof GeometryStripArrayRetained ? this.vertexCount : this.validVertexCount, this.vertexFormat | this.c4fAllocated, this.initialCoordIndex, (this.vertexFormat & 4) != 0 ? this.initialColorIndex : 0, (this.vertexFormat & 2) != 0 ? this.initialNormalIndex : 0, this.initialTexCoordIndex, this.mirrorFloatRefCoords, fArray, byArray, this.mirrorFloatRefNormals, bl5 && n5 > 0 ? (float[])this.mirrorRefTexCoords[0] : null, bl5 && n5 > 1 ? (float[])this.mirrorRefTexCoords[1] : null, bl5 && n5 > 2 ? (float[])this.mirrorRefTexCoords[2] : null, bl5 && n5 > 3 ? (float[])this.mirrorRefTexCoords[3] : null, bl5 && n5 > 4 ? (float[])this.mirrorRefTexCoords[4] : null, bl5 && n5 > 5 ? (float[])this.mirrorRefTexCoords[5] : null, bl5 && n5 > 6 ? (float[])this.mirrorRefTexCoords[6] : null, bl5 && n5 > 7 ? (float[])this.mirrorRefTexCoords[7] : null, this.texCoordStride, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, nArray, n2, n6);
            }
        }
    }

    native void buildGA(int var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, float var6, boolean var7, int var8, int var9, int var10, int var11, int[] var12, int var13, int[] var14, double[] var15, double[] var16, float[] var17);

    void buildGA(int n, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, Transform3D transform3D, Transform3D transform3D2) {
        if ((this.vertexFormat & 0x80) == 0) {
            this.buildGA(n, this, this.geoType, bl, bl2, f, bl3, this.initialVertexIndex, this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, transform3D == null ? null : transform3D.mat, transform3D2 == null ? null : transform3D2.mat, this.vertexData);
        }
    }

    void unIndexify(IndexedGeometryArrayRetained indexedGeometryArrayRetained) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float[] fArray = null;
        if ((indexedGeometryArrayRetained.vertexFormat & 0x80) == 0 || (indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryArrayRetained.vertexFormat & 0x80) == 0) {
                fArray = indexedGeometryArrayRetained.vertexData;
                if ((indexedGeometryArrayRetained.vertexFormat & 4) != 0) {
                    n3 = 4;
                }
            } else if ((indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
                fArray = indexedGeometryArrayRetained.interLeavedVertexData;
                if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                    n3 = 4;
                } else if ((indexedGeometryArrayRetained.vertexFormat & 4) != 0) {
                    n3 = 3;
                }
            }
            int n4 = 0;
            while (n4 < indexedGeometryArrayRetained.indexCount) {
                n = n4 * this.stride;
                if ((this.vertexFormat & 2) != 0) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexNormal[n4] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.normalOffset, this.vertexData, n + this.normalOffset, 3);
                }
                if (n3 == 4) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexColor[n4] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset, this.vertexData, n + this.colorOffset, n3);
                } else if (n3 == 3) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexColor[n4] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset, this.vertexData, n + this.colorOffset, n3);
                    this.vertexData[n + this.colorOffset + 3] = 1.0f;
                }
                if ((this.vertexFormat & 0x60) != 0) {
                    int n5 = n + this.textureOffset;
                    int n6 = 0;
                    while (n6 < this.texCoordSetCount) {
                        System.arraycopy(fArray, ((int[])indexedGeometryArrayRetained.indexTexCoord[n6])[n4] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.textureOffset, this.vertexData, n5, this.texCoordStride);
                        ++n6;
                        n5 += this.texCoordStride;
                    }
                }
                if ((this.vertexFormat & 1) != 0) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexCoord[n4] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.coordinateOffset, this.vertexData, n + this.coordinateOffset, 3);
                }
                ++n4;
            }
        } else {
            int n7;
            int n8;
            if ((this.vertexFormat & 2) != 0) {
                n = this.normalOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0xC00) {
                    case 1024: {
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            System.arraycopy(indexedGeometryArrayRetained.floatRefNormals, indexedGeometryArrayRetained.indexNormal[n8] * 3, this.vertexData, n, 3);
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                    case 2048: {
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            n7 = indexedGeometryArrayRetained.indexNormal[n8];
                            this.vertexData[n] = indexedGeometryArrayRetained.v3fRefNormals[n7].x;
                            this.vertexData[n + 1] = indexedGeometryArrayRetained.v3fRefNormals[n7].y;
                            this.vertexData[n + 2] = indexedGeometryArrayRetained.v3fRefNormals[n7].z;
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n = this.colorOffset;
                int n9 = 3;
                if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                    n9 = 4;
                }
                switch (indexedGeometryArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                                System.arraycopy(indexedGeometryArrayRetained.floatRefColors, indexedGeometryArrayRetained.indexColor[n8] * n9, this.vertexData, n, 4);
                            } else {
                                System.arraycopy(indexedGeometryArrayRetained.floatRefColors, indexedGeometryArrayRetained.indexColor[n8] * n9, this.vertexData, n, 3);
                                this.vertexData[n + 3] = 1.0f;
                            }
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                    case 32: {
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            n7 = indexedGeometryArrayRetained.indexColor[n8] * n9;
                            this.vertexData[n] = (float)(indexedGeometryArrayRetained.byteRefColors[n7] & 0xFF) * 0.003921569f;
                            this.vertexData[n + 1] = (float)(indexedGeometryArrayRetained.byteRefColors[n7 + 1] & 0xFF) * 0.003921569f;
                            this.vertexData[n + 2] = (float)(indexedGeometryArrayRetained.byteRefColors[n7 + 2] & 0xFF) * 0.003921569f;
                            this.vertexData[n + 3] = (indexedGeometryArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryArrayRetained.byteRefColors[n7 + 3] & 0xFF) * 0.003921569f : 1.0f;
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                    case 64: {
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            n7 = indexedGeometryArrayRetained.indexColor[n8];
                            this.vertexData[n] = indexedGeometryArrayRetained.c3fRefColors[n7].x;
                            this.vertexData[n + 1] = indexedGeometryArrayRetained.c3fRefColors[n7].y;
                            this.vertexData[n + 2] = indexedGeometryArrayRetained.c3fRefColors[n7].z;
                            this.vertexData[n + 3] = 1.0f;
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                    case 128: {
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            n7 = indexedGeometryArrayRetained.indexColor[n8];
                            this.vertexData[n] = indexedGeometryArrayRetained.c4fRefColors[n7].x;
                            this.vertexData[n + 1] = indexedGeometryArrayRetained.c4fRefColors[n7].y;
                            this.vertexData[n + 2] = indexedGeometryArrayRetained.c4fRefColors[n7].z;
                            this.vertexData[n + 3] = indexedGeometryArrayRetained.c4fRefColors[n7].w;
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                    case 256: {
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            n7 = indexedGeometryArrayRetained.indexColor[n8];
                            this.vertexData[n] = (float)(indexedGeometryArrayRetained.c3bRefColors[n7].x & 0xFF) * 0.003921569f;
                            this.vertexData[n + 1] = (float)(indexedGeometryArrayRetained.c3bRefColors[n7].y & 0xFF) * 0.003921569f;
                            this.vertexData[n + 2] = (float)(indexedGeometryArrayRetained.c3bRefColors[n7].z & 0xFF) * 0.003921569f;
                            this.vertexData[n + 3] = 1.0f;
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                    case 512: {
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            n7 = indexedGeometryArrayRetained.indexColor[n8];
                            this.vertexData[n] = (float)(indexedGeometryArrayRetained.c4bRefColors[n7].x & 0xFF) * 0.003921569f;
                            this.vertexData[n + 1] = (float)(indexedGeometryArrayRetained.c4bRefColors[n7].y & 0xFF) * 0.003921569f;
                            this.vertexData[n + 2] = (float)(indexedGeometryArrayRetained.c4bRefColors[n7].z & 0xFF) * 0.003921569f;
                            this.vertexData[n + 3] = (float)(indexedGeometryArrayRetained.c4bRefColors[n7].w & 0xFF) * 0.003921569f;
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x60) != 0) {
                n = this.textureOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0x7000) {
                    case 4096: {
                        int n10;
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            n10 = 0;
                            n2 = n;
                            while (n10 < this.texCoordSetCount) {
                                System.arraycopy(indexedGeometryArrayRetained.refTexCoords[n10], ((int[])indexedGeometryArrayRetained.indexTexCoord[n10])[n8] * this.texCoordStride, this.vertexData, n2, this.texCoordStride);
                                n2 += this.texCoordStride;
                                ++n10;
                            }
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                    case 8192: {
                        int n10;
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            n10 = 0;
                            n2 = n;
                            while (n10 < this.texCoordSetCount) {
                                n7 = ((int[])indexedGeometryArrayRetained.indexTexCoord[n10])[n8];
                                this.vertexData[n2] = ((TexCoord2f[])indexedGeometryArrayRetained.refTexCoords[n10])[n7].x;
                                this.vertexData[n2 + 1] = ((TexCoord2f[])indexedGeometryArrayRetained.refTexCoords[n10])[n7].y;
                                n2 += this.texCoordStride;
                                ++n10;
                            }
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                    case 16384: {
                        int n10;
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            n10 = 0;
                            n2 = n;
                            while (n10 < this.texCoordSetCount) {
                                n7 = ((int[])indexedGeometryArrayRetained.indexTexCoord[n10])[n8];
                                this.vertexData[n2] = ((TexCoord3f[])indexedGeometryArrayRetained.refTexCoords[n10])[n7].x;
                                this.vertexData[n2 + 1] = ((TexCoord3f[])indexedGeometryArrayRetained.refTexCoords[n10])[n7].y;
                                this.vertexData[n2 + 2] = ((TexCoord3f[])indexedGeometryArrayRetained.refTexCoords[n10])[n7].z;
                                n2 += this.texCoordStride;
                                ++n10;
                            }
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n = this.coordinateOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0xF) {
                    case 1: {
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            System.arraycopy(indexedGeometryArrayRetained.floatRefCoords, indexedGeometryArrayRetained.indexCoord[n8] * 3, this.vertexData, n, 3);
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                    case 2: {
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            n7 = indexedGeometryArrayRetained.indexCoord[n8] * 3;
                            this.vertexData[n] = (float)indexedGeometryArrayRetained.doubleRefCoords[n7];
                            this.vertexData[n + 1] = (float)indexedGeometryArrayRetained.doubleRefCoords[n7 + 1];
                            this.vertexData[n + 2] = (float)indexedGeometryArrayRetained.doubleRefCoords[n7 + 2];
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                    case 4: {
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            n7 = indexedGeometryArrayRetained.indexCoord[n8];
                            this.vertexData[n] = indexedGeometryArrayRetained.p3fRefCoords[n7].x;
                            this.vertexData[n + 1] = indexedGeometryArrayRetained.p3fRefCoords[n7].y;
                            this.vertexData[n + 2] = indexedGeometryArrayRetained.p3fRefCoords[n7].z;
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                    case 8: {
                        n8 = 0;
                        while (n8 < indexedGeometryArrayRetained.indexCount) {
                            n7 = indexedGeometryArrayRetained.indexCoord[n8];
                            this.vertexData[n] = (float)indexedGeometryArrayRetained.p3dRefCoords[n7].x;
                            this.vertexData[n + 1] = (float)indexedGeometryArrayRetained.p3dRefCoords[n7].y;
                            this.vertexData[n + 2] = (float)indexedGeometryArrayRetained.p3dRefCoords[n7].z;
                            n += this.stride;
                            ++n8;
                        }
                        break;
                    }
                }
            }
        }
    }

    int stride() {
        int n = 0;
        if ((this.vertexFormat & 1) != 0) {
            n += 3;
        }
        if ((this.vertexFormat & 2) != 0) {
            n += 3;
        }
        if ((this.vertexFormat & 4) != 0) {
            n = (this.vertexFormat & 0x80) == 0 ? (n += 4) : ((this.vertexFormat & 8) == 0 ? (n += 3) : (n += 4));
        }
        if ((this.vertexFormat & 0x60) != 0) {
            this.texCoordStride = 2;
            if ((this.vertexFormat & 0x40) != 0) {
                this.texCoordStride = 3;
            }
            n += this.texCoordStride * this.texCoordSetCount;
        }
        return n;
    }

    int[] texCoordSetMapOffset() {
        if (this.texCoordSetMap == null) {
            return null;
        }
        this.texCoordSetMapOffset = new int[this.texCoordSetMap.length];
        int n = 0;
        while (n < this.texCoordSetMap.length) {
            this.texCoordSetMapOffset[n] = this.texCoordSetMap[n] == -1 ? -1 : this.texCoordSetMap[n] * this.texCoordStride;
            ++n;
        }
        return this.texCoordSetMapOffset;
    }

    int colorOffset() {
        int n = this.textureOffset;
        if ((this.vertexFormat & 0x20) != 0) {
            n += 2 * this.texCoordSetCount;
        } else if ((this.vertexFormat & 0x40) != 0) {
            n += 3 * this.texCoordSetCount;
        }
        return n;
    }

    int normalOffset() {
        int n = this.colorOffset;
        if ((this.vertexFormat & 4) != 0) {
            n = (this.vertexFormat & 0x80) == 0 ? (n += 4) : ((this.vertexFormat & 8) == 0 ? (n += 3) : (n += 4));
        }
        return n;
    }

    int coordinateOffset() {
        int n = this.normalOffset;
        if ((this.vertexFormat & 2) != 0) {
            n += 3;
        }
        return n;
    }

    int getVertexCount() {
        return this.vertexCount;
    }

    int getVertexFormat() {
        return this.vertexFormat;
    }

    void sendDataChangedMessage(boolean bl) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source != null && this.source.isLive()) {
                Cloneable cloneable;
                int n;
                int n2;
                int n3;
                int n4;
                int n5 = 128;
                if (this instanceof IndexedGeometryArrayRetained) {
                    n5 |= 0x400;
                }
                ArrayList arrayList = this.universeList;
                synchronized (arrayList) {
                    n4 = this.universeList.size();
                }
                ArrayList arrayList2 = this.morphUniverseList;
                synchronized (arrayList2) {
                    n3 = this.morphUniverseList.size();
                }
                J3dMessage[] j3dMessageArray = new J3dMessage[n4];
                int n6 = 0;
                ArrayList arrayList3 = this.universeList;
                synchronized (arrayList3) {
                    n2 = 0;
                    while (n2 < n4) {
                        Shape3DRetained shape3DRetained;
                        this.gaList.clear();
                        ArrayList arrayList4 = (ArrayList)this.userLists.get(n2);
                        n = 0;
                        while (n < arrayList4.size()) {
                            shape3DRetained = (Shape3DRetained)arrayList4.get(n);
                            cloneable = (LeafRetained)shape3DRetained.sourceNode;
                            if (bl && ((NodeRetained)cloneable).boundsAutoCompute) {
                                ((LeafRetained)cloneable).boundsDirty = true;
                            }
                            ++n;
                        }
                        n = 0;
                        while (n < arrayList4.size()) {
                            shape3DRetained = (Shape3DRetained)arrayList4.get(n);
                            cloneable = (LeafRetained)shape3DRetained.sourceNode;
                            if (((LeafRetained)cloneable).boundsDirty) {
                                ((LeafRetained)cloneable).updateBounds();
                                ((LeafRetained)cloneable).boundsDirty = false;
                            }
                            this.gaList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                            ++n;
                        }
                        j3dMessageArray[n6] = VirtualUniverse.mc.getMessage();
                        j3dMessageArray[n6].type = 17;
                        j3dMessageArray[n6].threads = n5;
                        j3dMessageArray[n6].args[0] = this.gaList.toArray();
                        j3dMessageArray[n6].args[1] = this;
                        j3dMessageArray[n6].universe = (VirtualUniverse)this.universeList.get(n2);
                        ++n2;
                        ++n6;
                    }
                    VirtualUniverse.mc.processMessage(j3dMessageArray);
                }
                if (n3 > 0) {
                    cloneable = this.morphUniverseList;
                    synchronized (cloneable) {
                        n2 = 0;
                        while (n2 < n3) {
                            ArrayList arrayList5 = (ArrayList)this.morphUserLists.get(n2);
                            n = 0;
                            while (n < arrayList5.size()) {
                                MorphRetained morphRetained = (MorphRetained)arrayList5.get(n);
                                morphRetained.updateMorphedGeometryArray(this);
                                ++n;
                            }
                            ++n2;
                            ++n6;
                        }
                    }
                }
            }
        }
    }

    void setCoordinate(int n, float[] fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        this.vertexData[n2] = fArray[0];
        this.vertexData[n2 + 1] = fArray[1];
        this.vertexData[n2 + 2] = fArray[2];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        this.geomLock.unLock();
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int n, double[] dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        this.vertexData[n2] = (float)dArray[0];
        this.vertexData[n2 + 1] = (float)dArray[1];
        this.vertexData[n2 + 2] = (float)dArray[2];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        this.geomLock.unLock();
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int n, Point3f point3f) {
        int n2 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        this.vertexData[n2] = point3f.x;
        this.vertexData[n2 + 1] = point3f.y;
        this.vertexData[n2 + 2] = point3f.z;
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        this.geomLock.unLock();
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int n, Point3d point3d) {
        int n2 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        this.vertexData[n2] = (float)point3d.x;
        this.vertexData[n2 + 1] = (float)point3d.y;
        this.vertexData[n2 + 2] = (float)point3d.z;
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        this.geomLock.unLock();
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, float[] fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = fArray.length;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = fArray[n4];
            this.vertexData[n5 + 1] = fArray[n4 + 1];
            this.vertexData[n5 + 2] = fArray[n4 + 2];
            n4 += 3;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        this.geomLock.unLock();
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, double[] dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = dArray.length;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = (float)dArray[n4];
            this.vertexData[n5 + 1] = (float)dArray[n4 + 1];
            this.vertexData[n5 + 2] = (float)dArray[n4 + 2];
            n4 += 3;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        this.geomLock.unLock();
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, Point3f[] point3fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = point3fArray.length;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = point3fArray[n4].x;
            this.vertexData[n5 + 1] = point3fArray[n4].y;
            this.vertexData[n5 + 2] = point3fArray[n4].z;
            ++n4;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        this.geomLock.unLock();
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, Point3d[] point3dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = point3dArray.length;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = (float)point3dArray[n4].x;
            this.vertexData[n5 + 1] = (float)point3dArray[n4].y;
            this.vertexData[n5 + 2] = (float)point3dArray[n4].z;
            ++n4;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        this.geomLock.unLock();
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, float[] fArray, int n2, int n3) {
        int n4 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        int n5 = n2 * 3;
        int n6 = n4;
        while (n5 < (n2 + n3) * 3) {
            this.vertexData[n6] = fArray[n5];
            this.vertexData[n6 + 1] = fArray[n5 + 1];
            this.vertexData[n6 + 2] = fArray[n5 + 2];
            n5 += 3;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        this.geomLock.unLock();
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, double[] dArray, int n2, int n3) {
        int n4 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        int n5 = n2 * 3;
        int n6 = n4;
        while (n5 < (n2 + n3) * 3) {
            this.vertexData[n6] = (float)dArray[n5];
            this.vertexData[n6 + 1] = (float)dArray[n5 + 1];
            this.vertexData[n6 + 2] = (float)dArray[n5 + 2];
            n5 += 3;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        this.geomLock.unLock();
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, Point3f[] point3fArray, int n2, int n3) {
        int n4 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = point3fArray[n5].x;
            this.vertexData[n6 + 1] = point3fArray[n5].y;
            this.vertexData[n6 + 2] = point3fArray[n5].z;
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        this.geomLock.unLock();
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, Point3d[] point3dArray, int n2, int n3) {
        int n4 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = (float)point3dArray[n5].x;
            this.vertexData[n6 + 1] = (float)point3dArray[n5].y;
            this.vertexData[n6 + 2] = (float)point3dArray[n5].z;
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        this.geomLock.unLock();
        this.sendDataChangedMessage(true);
    }

    void setColor(int n, float[] fArray) {
        int n2 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.vertexData[n2] = fArray[0];
        this.vertexData[n2 + 1] = fArray[1];
        this.vertexData[n2 + 2] = fArray[2];
        if ((this.vertexFormat & 8) != 0) {
            this.vertexData[n2 + 3] = fArray[3];
        } else {
            this.lastAlpha[0] = 1.0f;
            this.vertexData[n2 + 3] = 1.0f;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n, byte[] byArray) {
        int n2 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.vertexData[n2] = (float)(byArray[0] & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 1] = (float)(byArray[1] & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 2] = (float)(byArray[2] & 0xFF) * 0.003921569f;
        if ((this.vertexFormat & 8) != 0) {
            this.vertexData[n2 + 3] = (float)(byArray[3] & 0xFF) * 0.003921569f;
        } else {
            this.lastAlpha[0] = 1.0f;
            this.vertexData[n2 + 3] = 1.0f;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n, Color3f color3f) {
        int n2 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.vertexData[n2] = color3f.x;
        this.vertexData[n2 + 1] = color3f.y;
        this.vertexData[n2 + 2] = color3f.z;
        this.lastAlpha[0] = 1.0f;
        this.vertexData[n2 + 3] = 1.0f;
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n, Color4f color4f) {
        int n2 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.vertexData[n2] = color4f.x;
        this.vertexData[n2 + 1] = color4f.y;
        this.vertexData[n2 + 2] = color4f.z;
        this.vertexData[n2 + 3] = color4f.w;
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n, Color3b color3b) {
        int n2 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.vertexData[n2] = (float)(color3b.x & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 1] = (float)(color3b.y & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 2] = (float)(color3b.z & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 3] = this.lastAlpha[0];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n, Color4b color4b) {
        int n2 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.vertexData[n2] = (float)(color4b.x * 255) * 0.003921569f;
        this.vertexData[n2 + 1] = (float)(color4b.y * 255) * 0.003921569f;
        this.vertexData[n2 + 2] = (float)(color4b.z * 255) * 0.003921569f;
        this.vertexData[n2 + 3] = (float)(color4b.w & 0xFF) * 0.003921569f;
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, float[] fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = fArray.length;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n4 = 0;
            int n5 = n2;
            while (n4 < n3) {
                this.vertexData[n5] = fArray[n4];
                this.vertexData[n5 + 1] = fArray[n4 + 1];
                this.vertexData[n5 + 2] = fArray[n4 + 2];
                this.vertexData[n5 + 3] = fArray[n4 + 3];
                n4 += 4;
                n5 += this.stride;
            }
        } else {
            int n6 = 0;
            int n7 = n2;
            while (n6 < n3) {
                this.vertexData[n7] = fArray[n6];
                this.vertexData[n7 + 1] = fArray[n6 + 1];
                this.vertexData[n7 + 2] = fArray[n6 + 2];
                this.vertexData[n7 + 3] = this.lastAlpha[0];
                n6 += 3;
                n7 += this.stride;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, byte[] byArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = byArray.length;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n4 = 0;
            int n5 = n2;
            while (n4 < n3) {
                this.vertexData[n5] = (float)(byArray[n4] & 0xFF) * 0.003921569f;
                this.vertexData[n5 + 1] = (float)(byArray[n4 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n5 + 2] = (float)(byArray[n4 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n5 + 3] = (float)(byArray[n4 + 3] & 0xFF) * 0.003921569f;
                n4 += 4;
                n5 += this.stride;
            }
        } else {
            int n6 = 0;
            int n7 = n2;
            while (n6 < n3) {
                this.vertexData[n7] = (float)(byArray[n6] & 0xFF) * 0.003921569f;
                this.vertexData[n7 + 1] = (float)(byArray[n6 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n7 + 2] = (float)(byArray[n6 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n7 + 3] = this.lastAlpha[0];
                n6 += 3;
                n7 += this.stride;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color3f[] color3fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color3fArray.length;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = color3fArray[n4].x;
            this.vertexData[n5 + 1] = color3fArray[n4].y;
            this.vertexData[n5 + 2] = color3fArray[n4].z;
            this.vertexData[n5 + 3] = this.lastAlpha[0];
            ++n4;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color4f[] color4fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color4fArray.length;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = color4fArray[n4].x;
            this.vertexData[n5 + 1] = color4fArray[n4].y;
            this.vertexData[n5 + 2] = color4fArray[n4].z;
            this.vertexData[n5 + 3] = color4fArray[n4].w;
            ++n4;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color3b[] color3bArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color3bArray.length;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = (float)(color3bArray[n4].x & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 1] = (float)(color3bArray[n4].y & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 2] = (float)(color3bArray[n4].z & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 3] = this.lastAlpha[0];
            ++n4;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color4b[] color4bArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color4bArray.length;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = (float)(color4bArray[n4].x & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 1] = (float)(color4bArray[n4].y & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 2] = (float)(color4bArray[n4].z & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 3] = (float)(color4bArray[n4].w & 0xFF) * 0.003921569f;
            ++n4;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, float[] fArray, int n2, int n3) {
        int n4 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n5 = n2 * 4;
            int n6 = n4;
            while (n5 < (n2 + n3) * 4) {
                this.vertexData[n6] = fArray[n5];
                this.vertexData[n6 + 1] = fArray[n5 + 1];
                this.vertexData[n6 + 2] = fArray[n5 + 2];
                this.vertexData[n6 + 3] = fArray[n5 + 3];
                n5 += 4;
                n6 += this.stride;
            }
        } else {
            int n7 = n2 * 3;
            int n8 = n4;
            while (n7 < (n2 + n3) * 3) {
                this.vertexData[n8] = fArray[n7];
                this.vertexData[n8 + 1] = fArray[n7 + 1];
                this.vertexData[n8 + 2] = fArray[n7 + 2];
                this.vertexData[n8 + 3] = this.lastAlpha[0];
                n7 += 3;
                n8 += this.stride;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, byte[] byArray, int n2, int n3) {
        int n4 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n5 = n2 * 4;
            int n6 = n4;
            while (n5 < (n2 + n3) * 4) {
                this.vertexData[n6] = (float)(byArray[n5] & 0xFF) * 0.003921569f;
                this.vertexData[n6 + 1] = (float)(byArray[n5 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n6 + 2] = (float)(byArray[n5 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n6 + 3] = (float)(byArray[n5 + 3] & 0xFF) * 0.003921569f;
                n5 += 4;
                n6 += this.stride;
            }
        } else {
            int n7 = n2 * 3;
            int n8 = n4;
            while (n7 < (n2 + n3) * 3) {
                this.vertexData[n8] = (float)(byArray[n7] & 0xFF) * 0.003921569f;
                this.vertexData[n8 + 1] = (float)(byArray[n7 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n8 + 2] = (float)(byArray[n7 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n8 + 3] = this.lastAlpha[0];
                n7 += 3;
                n8 += this.stride;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color3f[] color3fArray, int n2, int n3) {
        int n4 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = color3fArray[n5].x;
            this.vertexData[n6 + 1] = color3fArray[n5].y;
            this.vertexData[n6 + 2] = color3fArray[n5].z;
            this.vertexData[n6 + 3] = this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color4f[] color4fArray, int n2, int n3) {
        int n4 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = color4fArray[n5].x;
            this.vertexData[n6 + 1] = color4fArray[n5].y;
            this.vertexData[n6 + 2] = color4fArray[n5].z;
            this.vertexData[n6 + 3] = color4fArray[n5].w;
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color3b[] color3bArray, int n2, int n3) {
        int n4 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = (float)(color3bArray[n5].x & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 1] = (float)(color3bArray[n5].y & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 2] = (float)(color3bArray[n5].z & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 3] = this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color4b[] color4bArray, int n2, int n3) {
        int n4 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = (float)(color4bArray[n5].x & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 1] = (float)(color4bArray[n5].y & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 2] = (float)(color4bArray[n5].z & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 3] = (float)(color4bArray[n5].w & 0xFF) * 0.003921569f;
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormal(int n, float[] fArray) {
        int n2 = this.stride * n + this.normalOffset;
        this.geomLock.getLock();
        this.vertexData[n2] = fArray[0];
        this.vertexData[n2 + 1] = fArray[1];
        this.vertexData[n2 + 2] = fArray[2];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormal(int n, Vector3f vector3f) {
        int n2 = this.stride * n + this.normalOffset;
        this.geomLock.getLock();
        this.vertexData[n2] = vector3f.x;
        this.vertexData[n2 + 1] = vector3f.y;
        this.vertexData[n2 + 2] = vector3f.z;
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormals(int n, float[] fArray) {
        int n2 = this.stride * n + this.normalOffset;
        int n3 = fArray.length;
        this.geomLock.getLock();
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = fArray[n4];
            this.vertexData[n5 + 1] = fArray[n4 + 1];
            this.vertexData[n5 + 2] = fArray[n4 + 2];
            n4 += 3;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormals(int n, Vector3f[] vector3fArray) {
        int n2 = this.stride * n + this.normalOffset;
        int n3 = vector3fArray.length;
        this.geomLock.getLock();
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = vector3fArray[n4].x;
            this.vertexData[n5 + 1] = vector3fArray[n4].y;
            this.vertexData[n5 + 2] = vector3fArray[n4].z;
            ++n4;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormals(int n, float[] fArray, int n2, int n3) {
        int n4 = this.stride * n + this.normalOffset;
        this.geomLock.getLock();
        int n5 = n2 * 3;
        int n6 = n4;
        while (n5 < (n2 + n3) * 3) {
            this.vertexData[n6] = fArray[n5];
            this.vertexData[n6 + 1] = fArray[n5 + 1];
            this.vertexData[n6 + 2] = fArray[n5 + 2];
            n5 += 3;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormals(int n, Vector3f[] vector3fArray, int n2, int n3) {
        int n4 = this.stride * n + this.normalOffset;
        this.geomLock.getLock();
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = vector3fArray[n5].x;
            this.vertexData[n6 + 1] = vector3fArray[n5].y;
            this.vertexData[n6 + 2] = vector3fArray[n5].z;
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n, int n2, float[] fArray, int n3, int n4) {
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x60) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        this.geomLock.getLock();
        if ((this.vertexFormat & 0x40) != 0) {
            int n6 = n3 * 3;
            int n7 = n5;
            int n8 = 0;
            while (n8 < n4) {
                this.vertexData[n7] = fArray[n6++];
                this.vertexData[n7 + 1] = fArray[n6++];
                this.vertexData[n7 + 2] = fArray[n6++];
                n7 += this.stride;
                ++n8;
            }
        } else {
            int n9 = n3 * 2;
            int n10 = n5;
            int n11 = 0;
            while (n11 < n4) {
                this.vertexData[n10] = fArray[n9++];
                this.vertexData[n10 + 1] = fArray[n9++];
                n10 += this.stride;
                ++n11;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n, int n2, Point2f[] point2fArray, int n3, int n4) {
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x60) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        this.geomLock.getLock();
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = point2fArray[n6].x;
            this.vertexData[n7 + 1] = point2fArray[n6].y;
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n, int n2, Point3f[] point3fArray, int n3, int n4) {
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x60) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        this.geomLock.getLock();
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = point3fArray[n6].x;
            this.vertexData[n7 + 1] = point3fArray[n6].y;
            this.vertexData[n7 + 2] = point3fArray[n6].z;
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n, int n2, TexCoord2f[] texCoord2fArray, int n3, int n4) {
        this.geomLock.getLock();
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x60) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = texCoord2fArray[n6].x;
            this.vertexData[n7 + 1] = texCoord2fArray[n6].y;
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n, int n2, TexCoord3f[] texCoord3fArray, int n3, int n4) {
        this.geomLock.getLock();
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x60) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = texCoord3fArray[n6].x;
            this.vertexData[n7 + 1] = texCoord3fArray[n6].y;
            this.vertexData[n7 + 2] = texCoord3fArray[n6].z;
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void getCoordinate(int n, float[] fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        fArray[0] = this.vertexData[n2];
        fArray[1] = this.vertexData[n2 + 1];
        fArray[2] = this.vertexData[n2 + 2];
    }

    void getCoordinate(int n, double[] dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        dArray[0] = this.vertexData[n2];
        dArray[1] = this.vertexData[n2 + 1];
        dArray[2] = this.vertexData[n2 + 2];
    }

    void getCoordinate(int n, Point3f point3f) {
        int n2 = this.stride * n + this.coordinateOffset;
        point3f.x = this.vertexData[n2];
        point3f.y = this.vertexData[n2 + 1];
        point3f.z = this.vertexData[n2 + 2];
    }

    void getCoordinate(int n, Point3d point3d) {
        int n2 = this.stride * n + this.coordinateOffset;
        point3d.x = this.vertexData[n2];
        point3d.y = this.vertexData[n2 + 1];
        point3d.z = this.vertexData[n2 + 2];
    }

    void getCoordinates(int n, float[] fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            fArray[n4] = this.vertexData[n5];
            fArray[n4 + 1] = this.vertexData[n5 + 1];
            fArray[n4 + 2] = this.vertexData[n5 + 2];
            n4 += 3;
            n5 += this.stride;
        }
    }

    void getCoordinates(int n, double[] dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = dArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            dArray[n4] = this.vertexData[n5];
            dArray[n4 + 1] = this.vertexData[n5 + 1];
            dArray[n4 + 2] = this.vertexData[n5 + 2];
            n4 += 3;
            n5 += this.stride;
        }
    }

    void getCoordinates(int n, Point3f[] point3fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = point3fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            point3fArray[n4].x = this.vertexData[n5];
            point3fArray[n4].y = this.vertexData[n5 + 1];
            point3fArray[n4].z = this.vertexData[n5 + 2];
            ++n4;
            n5 += this.stride;
        }
    }

    void getCoordinates(int n, Point3d[] point3dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = point3dArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            point3dArray[n4].x = this.vertexData[n5];
            point3dArray[n4].y = this.vertexData[n5 + 1];
            point3dArray[n4].z = this.vertexData[n5 + 2];
            ++n4;
            n5 += this.stride;
        }
    }

    void getColor(int n, float[] fArray) {
        int n2 = this.stride * n + this.colorOffset;
        fArray[0] = this.vertexData[n2];
        fArray[1] = this.vertexData[n2 + 1];
        fArray[2] = this.vertexData[n2 + 2];
        if ((this.vertexFormat & 8) != 0) {
            fArray[3] = this.vertexData[n2 + 3] / this.lastAlpha[0];
        }
    }

    void getColor(int n, byte[] byArray) {
        int n2 = this.stride * n + this.colorOffset;
        byArray[0] = (byte)(this.vertexData[n2] * 255.0f);
        byArray[1] = (byte)(this.vertexData[n2 + 1] * 255.0f);
        byArray[2] = (byte)(this.vertexData[n2 + 2] * 255.0f);
        if ((this.vertexFormat & 8) != 0) {
            byArray[3] = (byte)(this.vertexData[n2 + 3] / this.lastAlpha[0] * 255.0f);
        }
    }

    void getColor(int n, Color3f color3f) {
        int n2 = this.stride * n + this.colorOffset;
        color3f.x = this.vertexData[n2];
        color3f.y = this.vertexData[n2 + 1];
        color3f.z = this.vertexData[n2 + 2];
    }

    void getColor(int n, Color4f color4f) {
        int n2 = this.stride * n + this.colorOffset;
        color4f.x = this.vertexData[n2];
        color4f.y = this.vertexData[n2 + 1];
        color4f.z = this.vertexData[n2 + 2];
        color4f.w = this.vertexData[n2 + 3] / this.lastAlpha[0];
    }

    void getColor(int n, Color3b color3b) {
        int n2 = this.stride * n + this.colorOffset;
        color3b.x = (byte)(this.vertexData[n2] * 255.0f);
        color3b.y = (byte)(this.vertexData[n2 + 1] * 255.0f);
        color3b.z = (byte)(this.vertexData[n2 + 2] * 255.0f);
    }

    void getColor(int n, Color4b color4b) {
        int n2 = this.stride * n + this.colorOffset;
        color4b.x = (byte)(this.vertexData[n2] * 255.0f);
        color4b.y = (byte)(this.vertexData[n2 + 1] * 255.0f);
        color4b.z = (byte)(this.vertexData[n2 + 2] * 255.0f);
        color4b.w = (byte)(this.vertexData[n2 + 3] / this.lastAlpha[0] * 255.0f);
    }

    void getColors(int n, float[] fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = fArray.length;
        float f = 1.0f / this.lastAlpha[0];
        if ((this.vertexFormat & 8) != 0) {
            int n4 = 0;
            int n5 = n2;
            while (n4 < n3) {
                fArray[n4] = this.vertexData[n5];
                fArray[n4 + 1] = this.vertexData[n5 + 1];
                fArray[n4 + 2] = this.vertexData[n5 + 2];
                fArray[n4 + 3] = this.vertexData[n5 + 3] * f;
                n4 += 4;
                n5 += this.stride;
            }
        } else {
            int n6 = 0;
            int n7 = n2;
            while (n6 < n3) {
                fArray[n6] = this.vertexData[n7];
                fArray[n6 + 1] = this.vertexData[n7 + 1];
                fArray[n6 + 2] = this.vertexData[n7 + 2];
                n6 += 3;
                n7 += this.stride;
            }
        }
    }

    void getColors(int n, byte[] byArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = byArray.length;
        float f = 1.0f / this.lastAlpha[0];
        if ((this.vertexFormat & 8) != 0) {
            int n4 = 0;
            int n5 = n2;
            while (n4 < n3) {
                byArray[n4] = (byte)(this.vertexData[n5] * 255.0f);
                byArray[n4 + 1] = (byte)(this.vertexData[n5 + 1] * 255.0f);
                byArray[n4 + 2] = (byte)(this.vertexData[n5 + 2] * 255.0f);
                byArray[n4 + 3] = (byte)(this.vertexData[n5 + 3] * f * 255.0f);
                n4 += 4;
                n5 += this.stride;
            }
        } else {
            int n6 = 0;
            int n7 = n2;
            while (n6 < n3) {
                byArray[n6] = (byte)(this.vertexData[n7] * 255.0f);
                byArray[n6 + 1] = (byte)(this.vertexData[n7 + 1] * 255.0f);
                byArray[n6 + 2] = (byte)(this.vertexData[n7 + 2] * 255.0f);
                n6 += 3;
                n7 += this.stride;
            }
        }
    }

    void getColors(int n, Color3f[] color3fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color3fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            color3fArray[n4].x = this.vertexData[n5];
            color3fArray[n4].y = this.vertexData[n5 + 1];
            color3fArray[n4].z = this.vertexData[n5 + 2];
            ++n4;
            n5 += this.stride;
        }
    }

    void getColors(int n, Color4f[] color4fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color4fArray.length;
        float f = 1.0f / this.lastAlpha[0];
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            color4fArray[n4].x = this.vertexData[n5];
            color4fArray[n4].y = this.vertexData[n5 + 1];
            color4fArray[n4].z = this.vertexData[n5 + 2];
            color4fArray[n4].w = this.vertexData[n5 + 3] * f;
            ++n4;
            n5 += this.stride;
        }
    }

    void getColors(int n, Color3b[] color3bArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color3bArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            color3bArray[n4].x = (byte)(this.vertexData[n5] * 255.0f);
            color3bArray[n4].y = (byte)(this.vertexData[n5 + 1] * 255.0f);
            color3bArray[n4].z = (byte)(this.vertexData[n5 + 2] * 255.0f);
            ++n4;
            n5 += this.stride;
        }
    }

    void getColors(int n, Color4b[] color4bArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color4bArray.length;
        float f = 1.0f / this.lastAlpha[0];
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            color4bArray[n4].x = (byte)(this.vertexData[n5] * 255.0f);
            color4bArray[n4].y = (byte)(this.vertexData[n5 + 1] * 255.0f);
            color4bArray[n4].z = (byte)(this.vertexData[n5 + 2] * 255.0f);
            color4bArray[n4].w = (byte)(this.vertexData[n5 + 3] * f * 255.0f);
            ++n4;
            n5 += this.stride;
        }
    }

    void getNormal(int n, float[] fArray) {
        int n2 = this.stride * n + this.normalOffset;
        fArray[0] = this.vertexData[n2];
        fArray[1] = this.vertexData[n2 + 1];
        fArray[2] = this.vertexData[n2 + 2];
    }

    void getNormal(int n, Vector3f vector3f) {
        int n2 = this.stride * n + this.normalOffset;
        vector3f.x = this.vertexData[n2];
        vector3f.y = this.vertexData[n2 + 1];
        vector3f.z = this.vertexData[n2 + 2];
    }

    void getNormals(int n, float[] fArray) {
        int n2 = this.stride * n + this.normalOffset;
        int n3 = fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            fArray[n4] = this.vertexData[n5];
            fArray[n4 + 1] = this.vertexData[n5 + 1];
            fArray[n4 + 2] = this.vertexData[n5 + 2];
            n4 += 3;
            n5 += this.stride;
        }
    }

    void getNormals(int n, Vector3f[] vector3fArray) {
        int n2 = this.stride * n + this.normalOffset;
        int n3 = vector3fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            vector3fArray[n4].x = this.vertexData[n5];
            vector3fArray[n4].y = this.vertexData[n5 + 1];
            vector3fArray[n4].z = this.vertexData[n5 + 2];
            ++n4;
            n5 += this.stride;
        }
    }

    void getTextureCoordinate(int n, int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        fArray[0] = this.vertexData[n3];
        fArray[1] = this.vertexData[n3 + 1];
        if ((this.vertexFormat & 0x40) != 0) {
            fArray[2] = this.vertexData[n3 + 2];
        }
    }

    void getTextureCoordinate(int n, int n2, TexCoord2f texCoord2f) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        texCoord2f.x = this.vertexData[n3];
        texCoord2f.y = this.vertexData[n3 + 1];
    }

    void getTextureCoordinate(int n, int n2, TexCoord3f texCoord3f) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        texCoord3f.x = this.vertexData[n3];
        texCoord3f.y = this.vertexData[n3 + 1];
        texCoord3f.z = this.vertexData[n3 + 2];
    }

    void getTextureCoordinates(int n, int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = fArray.length;
        if ((this.vertexFormat & 0x40) != 0) {
            int n5 = 0;
            int n6 = n3;
            while (n5 < n4) {
                fArray[n5] = this.vertexData[n6];
                fArray[n5 + 1] = this.vertexData[n6 + 1];
                fArray[n5 + 2] = this.vertexData[n6 + 2];
                n5 += 3;
                n6 += this.stride;
            }
        } else {
            int n7 = 0;
            int n8 = n3;
            while (n7 < n4) {
                fArray[n7] = this.vertexData[n8];
                fArray[n7 + 1] = this.vertexData[n8 + 1];
                n7 += 2;
                n8 += this.stride;
            }
        }
    }

    void getTextureCoordinates(int n, int n2, TexCoord2f[] texCoord2fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = texCoord2fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            texCoord2fArray[n5].x = this.vertexData[n6];
            texCoord2fArray[n5].y = this.vertexData[n6 + 1];
            ++n5;
            n6 += this.stride;
        }
    }

    void getTextureCoordinates(int n, int n2, TexCoord3f[] texCoord3fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = texCoord3fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            texCoord3fArray[n5].x = this.vertexData[n6];
            texCoord3fArray[n5].y = this.vertexData[n6 + 1];
            texCoord3fArray[n5].z = this.vertexData[n6 + 2];
            ++n5;
            n6 += this.stride;
        }
    }

    void getTextureCoordinates(int n, int n2, Point2f[] point2fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = point2fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            point2fArray[n5].x = this.vertexData[n6];
            point2fArray[n5].y = this.vertexData[n6 + 1];
            ++n5;
            n6 += this.stride;
        }
    }

    void getTextureCoordinates(int n, int n2, Point3f[] point3fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = point3fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            point3fArray[n5].x = this.vertexData[n6];
            point3fArray[n5].y = this.vertexData[n6 + 1];
            point3fArray[n5].z = this.vertexData[n6 + 2];
            ++n5;
            n6 += this.stride;
        }
    }

    void updateData(GeometryUpdater geometryUpdater) {
        this.geomLock.getLock();
        this.inUpdater = true;
        geometryUpdater.updateData((Geometry)this.source);
        this.inUpdater = false;
        if (!(this instanceof IndexedGeometryArrayRetained)) {
            if ((this.vertexFormat & 0x100) != 0) {
                this.setupMirrorInterleavedColorPointer(false);
            } else {
                this.setupMirrorVertexPointer(this.vertexType & 0xF);
                this.setupMirrorColorPointer(this.vertexType & 0x3F0, false);
                this.setupMirrorNormalPointer(this.vertexType & 0xC00);
                this.setupMirrorTexCoordPointer(this.vertexType & 0x7000);
            }
        }
        this.d3dDirtyFlag |= 0x10;
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.geomLock.unLock();
        if (this.source != null && this.source.isLive()) {
            this.computeBoundingBox();
            this.sendDataChangedMessage(true);
        }
    }

    boolean intersectBoundingBox(Point3d[] point3dArray, BoundingBox boundingBox) {
        int[] nArray = new int[6];
        int n = 0;
        while (n < 6) {
            nArray[n] = 0;
            ++n;
        }
        n = 0;
        while (n < point3dArray.length) {
            if (point3dArray[n].x >= boundingBox.lower.x && point3dArray[n].x <= boundingBox.upper.x && point3dArray[n].y >= boundingBox.lower.y && point3dArray[n].y <= boundingBox.upper.y && point3dArray[n].z >= boundingBox.lower.z && point3dArray[n].z <= boundingBox.upper.z) {
                return true;
            }
            if (point3dArray[n].x < boundingBox.lower.x) {
                nArray[0] = nArray[0] + 1;
            }
            if (point3dArray[n].y < boundingBox.lower.y) {
                nArray[1] = nArray[1] + 1;
            }
            if (point3dArray[n].z < boundingBox.lower.z) {
                nArray[2] = nArray[2] + 1;
            }
            if (point3dArray[n].x > boundingBox.upper.x) {
                nArray[3] = nArray[3] + 1;
            }
            if (point3dArray[n].y > boundingBox.upper.y) {
                nArray[4] = nArray[4] + 1;
            }
            if (point3dArray[n].z > boundingBox.upper.z) {
                nArray[5] = nArray[5] + 1;
            }
            ++n;
        }
        if (nArray[0] == point3dArray.length || nArray[1] == point3dArray.length || nArray[2] == point3dArray.length || nArray[3] == point3dArray.length || nArray[4] == point3dArray.length || nArray[5] == point3dArray.length) {
            return false;
        }
        Point3d[] point3dArray2 = new Point3d[4];
        n = 0;
        while (n < 4) {
            point3dArray2[n] = new Point3d();
            ++n;
        }
        point3dArray2[0].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[1].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[3].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[1].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[2].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[3].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[1].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[3].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[1].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[3].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[1].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[3].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[1].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[3].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
        return this.intersectPolygon(point3dArray2, point3dArray);
    }

    boolean intersectBoundingSphere(Point3d[] point3dArray, BoundingSphere boundingSphere) {
        Vector3d vector3d = new Vector3d();
        int n = 0;
        while (n < point3dArray.length) {
            vector3d.x = point3dArray[n].x - boundingSphere.center.x;
            vector3d.y = point3dArray[n].y - boundingSphere.center.y;
            vector3d.z = point3dArray[n].z - boundingSphere.center.z;
            if (vector3d.length() <= boundingSphere.radius) {
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < point3dArray.length) {
            boolean bl = n < point3dArray.length - 1 ? this.edgeIntersectSphere(boundingSphere, point3dArray[n], point3dArray[n + 1]) : this.edgeIntersectSphere(boundingSphere, point3dArray[n], point3dArray[0]);
            if (bl) {
                return true;
            }
            ++n;
        }
        if (point3dArray.length < 3) {
            return false;
        }
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        Point3d point3d = new Point3d();
        n = 0;
        while (n < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d2.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d2.z = point3dArray[n + 1].z - point3dArray[n++].z;
            if (vector3d2.length() > 0.0) break;
        }
        int n2 = n;
        while (n2 < point3dArray.length - 1) {
            vector3d3.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d3.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d3.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d3.length() > 0.0) break;
            ++n2;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d4.cross(vector3d2, vector3d3);
        double d = vector3d4.lengthSquared();
        if (d == 0.0) {
            return false;
        }
        vector3d5.x = point3dArray[0].x - boundingSphere.center.x;
        vector3d5.y = point3dArray[0].y - boundingSphere.center.y;
        vector3d5.z = point3dArray[0].z - boundingSphere.center.z;
        double d2 = vector3d4.dot(vector3d5);
        double d3 = Math.sqrt(d2 * d2 / d);
        if (d3 > boundingSphere.radius) {
            return false;
        }
        double d4 = d2 / d;
        point3d.x = boundingSphere.center.x + d4 * vector3d4.x;
        point3d.y = boundingSphere.center.y + d4 * vector3d4.y;
        point3d.z = boundingSphere.center.z + d4 * vector3d4.z;
        return this.pointIntersectPolygon2D(vector3d4, point3dArray, point3d);
    }

    boolean intersectBoundingPolytope(Point3d[] point3dArray, BoundingPolytope boundingPolytope) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        double d = -1.0;
        if (point3dArray.length == 2) {
            return boundingPolytope.intersect(point3dArray[0], point3dArray[1], this.tP4d);
        }
        if (bl) {
            System.out.println("The value of the input vertices are: ");
            int n6 = 0;
            while (n6 < point3dArray.length) {
                System.out.println("The " + n6 + " th vertex is: " + point3dArray[n6]);
                ++n6;
            }
            System.out.println("The value of the input bounding Polytope's planes =");
            n5 = 0;
            while (n5 < boundingPolytope.planes.length) {
                System.out.println("The " + n5 + " th plane is: " + boundingPolytope.planes[n5]);
                ++n5;
            }
        }
        double[] dArray = new double[]{0.8, 0.9, 1.1, 1.2};
        n5 = 1;
        boolean bl2 = false;
        if (bl2) {
            n4 = 0;
            while (n4 < point3dArray.length) {
                n3 = 0;
                while (n3 < boundingPolytope.planes.length) {
                    if (!(boundingPolytope.planes[n3].x * point3dArray[n4].x + boundingPolytope.planes[n3].y * point3dArray[n4].y + boundingPolytope.planes[n3].z * point3dArray[n4].z <= d * boundingPolytope.planes[n3].w)) {
                        n5 = 0;
                        break;
                    }
                    n5 = 1;
                    ++n3;
                }
                if (n5 != 0) {
                    return true;
                }
                ++n4;
            }
        }
        n4 = boundingPolytope.planes.length + 2 + point3dArray.length + 1;
        n3 = 1 + point3dArray.length;
        double[][] dArray2 = new double[n3][n4];
        int n7 = 0;
        while (n7 < boundingPolytope.planes.length) {
            n2 = 0;
            while (n2 < point3dArray.length) {
                dArray2[n2][n7] = -1.0 * (boundingPolytope.planes[n7].x * point3dArray[n2].x + boundingPolytope.planes[n7].y * point3dArray[n2].y + boundingPolytope.planes[n7].z * point3dArray[n2].z);
                ++n2;
            }
            ++n7;
        }
        n2 = 0;
        while (n2 < point3dArray.length) {
            dArray2[n2][boundingPolytope.planes.length] = -1.0;
            dArray2[n2][boundingPolytope.planes.length + 1] = 1.0;
            n = 0;
            while (n < point3dArray.length) {
                dArray2[n2][n + boundingPolytope.planes.length + 2] = n2 == n ? 1.0 : 0.0;
                dArray2[n2][n4 - 1] = dArray[n2];
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < boundingPolytope.planes.length) {
            dArray2[n3 - 1][n] = d * boundingPolytope.planes[n].w;
            ++n;
        }
        dArray2[n3 - 1][boundingPolytope.planes.length] = 1.0;
        dArray2[n3 - 1][boundingPolytope.planes.length + 1] = -1.0;
        int n8 = 0;
        while (n8 < point3dArray.length) {
            dArray2[n3 - 1][boundingPolytope.planes.length + 2 + n8] = 0.0;
            ++n8;
        }
        if (bl) {
            System.out.println("The value of the problem tableau is: ");
            int n9 = 0;
            while (n9 < dArray2.length) {
                int n10 = 0;
                while (n10 < dArray2[0].length) {
                    System.out.print(dArray2[n9][n10] + "  ");
                    ++n10;
                }
                System.out.println();
                ++n9;
            }
        }
        double d2 = this.generalStandardSimplexSolver(dArray2, Double.NEGATIVE_INFINITY);
        if (bl) {
            System.out.println("The value returned by the general standard simplex = " + d2);
        }
        return d2 != Double.POSITIVE_INFINITY;
    }

    double generalStandardSimplexSolver(double[][] dArray, double d) {
        boolean bl = false;
        int n = dArray.length;
        int n2 = dArray[0].length;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            System.out.println("The number of rows is : " + n);
            System.out.println("The number of columns is : " + n2);
        }
        while (!bl2) {
            double d2;
            if (bl) {
                System.out.println("input problem tableau is:");
                int n3 = 0;
                while (n3 < n) {
                    int n4 = 0;
                    while (n4 < n2) {
                        System.out.println("kth, jth value is:" + n3 + " " + n4 + " : " + dArray[n3][n4]);
                        ++n4;
                    }
                    ++n3;
                }
            }
            int n5 = 0;
            double d3 = 0.0;
            int n6 = -1;
            while (n5 < n2 - 1) {
                d2 = dArray[n - 1][n5];
                if (d2 < d3) {
                    d3 = d2;
                    n6 = n5;
                }
                ++n5;
            }
            if (n6 == -1) {
                bl2 = true;
            }
            if (bl2) continue;
            double d4 = Double.POSITIVE_INFINITY;
            double d5 = 0.0;
            int n7 = -1;
            n5 = 0;
            while (n5 < n - 1) {
                d2 = dArray[n5][n6];
                double d6 = dArray[n5][n2 - 1];
                if (d2 == 0.0) {
                    if (bl) {
                        System.out.println("Division by zero has occurred");
                        System.out.println("Within the linear program solver");
                        System.out.println("Ignoring the zero as a potential pivot");
                    }
                } else if (d2 < 0.0 || d6 < 0.0) {
                    if (bl) {
                        System.out.println("Ignoring cases where element is negative");
                        System.out.println("The value of element is: " + d2);
                        System.out.println("The value of end Element is: " + d6);
                    }
                } else {
                    d5 = d6 / d2;
                    if (bl) {
                        System.out.println("The value of element is: " + d2);
                        System.out.println("The value of endElement is: " + d6);
                        System.out.println("The value of ratio is: " + d5);
                        System.out.println("The value of prevRatio is: " + d4);
                        System.out.println("Value of ratio <= prevRatio is :" + (d5 <= d4));
                    }
                    if (d5 <= d4) {
                        if (bl) {
                            System.out.println("updating prevRatio with ratio");
                        }
                        d4 = d5;
                        n7 = n5;
                    }
                }
                ++n5;
            }
            if (n7 == -1) {
                if (bl) {
                    System.out.println("UNABLE TO FIND SOLUTION");
                    System.out.println("The system is infeasable or unbounded");
                }
                return Double.POSITIVE_INFINITY;
            }
            double d7 = dArray[n7][n6];
            if (bl) {
                System.out.println("The value of row index is: " + n7);
                System.out.println("The value of col index is: " + n6);
                System.out.println("The value of pivotValue is: " + d7);
            }
            n5 = 0;
            while (n5 < n2) {
                dArray[n7][n5] = dArray[n7][n5] / d7;
                ++n5;
            }
            n5 = 0;
            while (n5 < n) {
                if (n5 != n7) {
                    double d8 = dArray[n5][n6];
                    int n8 = 0;
                    while (n8 < n2) {
                        dArray[n5][n8] = dArray[n5][n8] - d8 * dArray[n7][n8];
                        ++n8;
                    }
                }
                ++n5;
            }
        }
        return dArray[n - 1][n2 - 1];
    }

    boolean edgeIntersectSphere(BoundingSphere boundingSphere, Point3d point3d, Point3d point3d2) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = boundingSphere.center.x - point3d.x;
        vector3d2.y = boundingSphere.center.y - point3d.y;
        vector3d2.z = boundingSphere.center.z - point3d.z;
        double d = vector3d.dot(vector3d2);
        if (d < 0.0) {
            return false;
        }
        double d2 = vector3d.lengthSquared();
        double d3 = d * d / d2;
        if (d3 < d2) {
            return false;
        }
        double d4 = boundingSphere.radius * boundingSphere.radius;
        double d5 = vector3d2.lengthSquared();
        return d5 - d3 <= d4;
    }

    double det2D(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        return (point2d3.x - point2d.x) * (point2d.y - point2d2.y) + (point2d.y - point2d3.y) * (point2d.x - point2d2.x);
    }

    boolean pointIntersectPolygon2D(Vector3d vector3d, Point3d[] point3dArray, Point3d point3d) {
        Point2d[] point2dArray = new Point2d[point3dArray.length];
        Point2d point2d = new Point2d();
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        int n = d > d2 ? 0 : 1;
        if (n == 0) {
            if (d < d3) {
                n = 2;
            }
        } else if (n == 1 && d2 < d3) {
            n = 2;
        }
        int n2 = 0;
        while (n2 < point3dArray.length) {
            point2dArray[n2] = new Point2d();
            switch (n) {
                case 0: {
                    point2dArray[n2].x = point3dArray[n2].y;
                    point2dArray[n2].y = point3dArray[n2].z;
                    break;
                }
                case 1: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].z;
                    break;
                }
                case 2: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].y;
                }
            }
            ++n2;
        }
        switch (n) {
            case 0: {
                point2d.x = point3d.y;
                point2d.y = point3d.z;
                break;
            }
            case 1: {
                point2d.x = point3d.x;
                point2d.y = point3d.z;
                break;
            }
            case 2: {
                point2d.x = point3d.x;
                point2d.y = point3d.y;
            }
        }
        int n3 = 0;
        while (n3 < point3dArray.length) {
            if (n3 < point3dArray.length - 1) {
                if (!(this.det2D(point2dArray[n3], point2dArray[n3 + 1], point2d) > 0.0)) {
                    return false;
                }
            } else if (!(this.det2D(point2dArray[n3], point2dArray[0], point2d) > 0.0)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    boolean edgeIntersectPlane(Vector3d vector3d, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        vector3d2.set((Tuple3d)point3d);
        double d = vector3d.dot(vector3d2);
        vector3d3.x = point3d3.x - point3d2.x;
        vector3d3.y = point3d3.y - point3d2.y;
        vector3d3.z = point3d3.z - point3d2.z;
        double d2 = vector3d.dot(vector3d3);
        if (d2 == 0.0) {
            return false;
        }
        vector3d2.set((Tuple3d)point3d2);
        double d3 = (d - vector3d.dot(vector3d2)) / d2;
        if (d3 < 0.0 || d3 > 1.0) {
            return false;
        }
        point3d4.x = point3d2.x + d3 * vector3d3.x;
        point3d4.y = point3d2.y + d3 * vector3d3.y;
        point3d4.z = point3d2.z + d3 * vector3d3.z;
        return true;
    }

    boolean edgeIntersectPolygon2D(Vector3d vector3d, Point3d[] point3dArray, Point3d[] point3dArray2) {
        Point2d[] point2dArray = new Point2d[point3dArray.length];
        Point2d[] point2dArray2 = new Point2d[2];
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        int n = d > d2 ? 0 : 1;
        if (n == 0) {
            if (d < d3) {
                n = 2;
            }
        } else if (n == 1 && d2 < d3) {
            n = 2;
        }
        int n2 = 0;
        while (n2 < point3dArray.length) {
            point2dArray[n2] = new Point2d();
            switch (n) {
                case 0: {
                    point2dArray[n2].x = point3dArray[n2].y;
                    point2dArray[n2].y = point3dArray[n2].z;
                    break;
                }
                case 1: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].z;
                    break;
                }
                case 2: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].y;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 2) {
            point2dArray2[n2] = new Point2d();
            switch (n) {
                case 0: {
                    point2dArray2[n2].x = point3dArray2[n2].y;
                    point2dArray2[n2].y = point3dArray2[n2].z;
                    break;
                }
                case 1: {
                    point2dArray2[n2].x = point3dArray2[n2].x;
                    point2dArray2[n2].y = point3dArray2[n2].z;
                    break;
                }
                case 2: {
                    point2dArray2[n2].x = point3dArray2[n2].x;
                    point2dArray2[n2].y = point3dArray2[n2].y;
                }
            }
            ++n2;
        }
        boolean[][] blArray = new boolean[2][point3dArray.length];
        int n3 = 0;
        while (n3 < point3dArray.length) {
            n2 = 0;
            while (n2 < 2) {
                blArray[n2][n3] = n3 < point3dArray.length - 1 ? this.det2D(point2dArray[n3], point2dArray[n3 + 1], point2dArray2[n2]) < 0.0 : this.det2D(point2dArray[n3], point2dArray[0], point2dArray2[n2]) < 0.0;
                ++n2;
            }
            if (!blArray[0][n3] && !blArray[1][n3]) {
                return false;
            }
            ++n3;
        }
        boolean bl = true;
        n2 = 0;
        while (n2 < point3dArray.length) {
            if (!blArray[0][n2]) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            return true;
        }
        bl = true;
        n2 = 0;
        while (n2 < point3dArray.length) {
            if (!blArray[1][n2]) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            return true;
        }
        int n4 = 0;
        n2 = 0;
        while (n2 < point3dArray.length) {
            if (this.det2D(point2dArray2[0], point2dArray2[1], point2dArray[n2]) < 0.0) {
                ++n4;
            }
            ++n2;
        }
        return n4 != 0 && n4 != point3dArray.length;
    }

    double getCompValue(Point3d point3d, int n) {
        switch (n) {
            case 0: {
                return point3d.x;
            }
            case 1: {
                return point3d.y;
            }
        }
        return point3d.z;
    }

    double getCompValue(Point3d point3d, Point3d point3d2, int n) {
        switch (n) {
            case 0: {
                return point3d.x - point3d2.x;
            }
            case 1: {
                return point3d.y - point3d2.y;
            }
        }
        return point3d.z - point3d2.z;
    }

    boolean pointInTri(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, int n, int n2) {
        double d = this.getCompValue(point3d3, point3d2, n2);
        double d2 = -this.getCompValue(point3d3, point3d2, n);
        double d3 = -d * this.getCompValue(point3d2, n) - d2 * this.getCompValue(point3d2, n2);
        double d4 = d * this.getCompValue(point3d, n) + d2 * this.getCompValue(point3d, n2) + d3;
        d = this.getCompValue(point3d4, point3d3, n2);
        d2 = -this.getCompValue(point3d4, point3d3, n);
        d3 = -d * this.getCompValue(point3d3, n) - d2 * this.getCompValue(point3d3, n2);
        double d5 = d * this.getCompValue(point3d, n) + d2 * this.getCompValue(point3d, n2) + d3;
        d = this.getCompValue(point3d2, point3d4, n2);
        d2 = -this.getCompValue(point3d2, point3d4, n);
        d3 = -d * this.getCompValue(point3d4, n) - d2 * this.getCompValue(point3d4, n2);
        double d6 = d * this.getCompValue(point3d, n) + d2 * this.getCompValue(point3d, n2) + d3;
        return d4 * d5 > 0.0 && d4 * d6 > 0.0;
    }

    boolean edgeAgainstEdge(Point3d point3d, Point3d point3d2, Point3d point3d3, double d, double d2, int n, int n2) {
        double d3 = this.getCompValue(point3d2, point3d3, n);
        double d4 = this.getCompValue(point3d2, point3d3, n2);
        double d5 = this.getCompValue(point3d, point3d2, n);
        double d6 = this.getCompValue(point3d, point3d2, n2);
        double d7 = d2 * d3 - d * d4;
        double d8 = d4 * d5 - d3 * d6;
        if (d7 > 0.0 && d8 >= 0.0 && d8 <= d7 || d7 < 0.0 && d8 <= 0.0 && d8 >= d7) {
            double d9 = d * d6 - d2 * d5;
            if (d7 > 0.0 ? d9 >= 0.0 && d9 <= d7 : d9 <= 0.0 && d9 >= d7) {
                return true;
            }
        }
        return false;
    }

    boolean edgeAgainstTriEdges(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, int n, int n2) {
        double d;
        double d2 = this.getCompValue(point3d2, point3d, n);
        if (this.edgeAgainstEdge(point3d, point3d3, point3d4, d2, d = this.getCompValue(point3d2, point3d, n2), n, n2)) {
            return true;
        }
        if (this.edgeAgainstEdge(point3d, point3d4, point3d5, d2, d, n, n2)) {
            return true;
        }
        return this.edgeAgainstEdge(point3d, point3d5, point3d3, d2, d, n, n2);
    }

    boolean coplanarTriTri(Vector3d vector3d, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, Point3d point3d6) {
        int n;
        int n2;
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        if (d > d2) {
            if (d > d3) {
                n2 = 1;
                n = 2;
            } else {
                n2 = 0;
                n = 1;
            }
        } else if (d3 > d2) {
            n2 = 0;
            n = 1;
        } else {
            n2 = 0;
            n = 2;
        }
        if (this.edgeAgainstTriEdges(point3d, point3d2, point3d4, point3d5, point3d6, n2, n)) {
            return true;
        }
        if (this.edgeAgainstTriEdges(point3d2, point3d3, point3d4, point3d5, point3d6, n2, n)) {
            return true;
        }
        if (this.edgeAgainstTriEdges(point3d3, point3d, point3d4, point3d5, point3d6, n2, n)) {
            return true;
        }
        if (this.pointInTri(point3d, point3d4, point3d5, point3d6, n2, n)) {
            return true;
        }
        return this.pointInTri(point3d4, point3d, point3d2, point3d3, n2, n);
    }

    boolean intersectTriPnt(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        int n;
        int n2;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = point3d3.x - point3d.x;
        vector3d2.y = point3d3.y - point3d.y;
        vector3d2.z = point3d3.z - point3d.z;
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3d);
        double d = -vector3d3.dot(vector3d4);
        vector3d4.set((Tuple3d)point3d4);
        double d2 = vector3d3.dot(vector3d4) + d;
        if (Math.abs(d2) < 1.0E-6) {
            d2 = 0.0;
        }
        if (d2 != 0.0) {
            return false;
        }
        double d3 = Math.abs(vector3d3.x);
        double d4 = Math.abs(vector3d3.y);
        double d5 = Math.abs(vector3d3.z);
        if (d3 > d4) {
            if (d3 > d5) {
                n2 = 1;
                n = 2;
            } else {
                n2 = 0;
                n = 1;
            }
        } else if (d5 > d4) {
            n2 = 0;
            n = 1;
        } else {
            n2 = 0;
            n = 2;
        }
        return this.pointInTri(point3d4, point3d, point3d2, point3d3, n2, n);
    }

    boolean intersectTriTri(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, Point3d point3d6) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = point3d3.x - point3d.x;
        vector3d2.y = point3d3.y - point3d.y;
        vector3d2.z = point3d3.z - point3d.z;
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d5.set((Tuple3d)point3d);
        double d7 = -vector3d3.dot(vector3d5);
        vector3d5.set((Tuple3d)point3d4);
        double d8 = vector3d3.dot(vector3d5) + d7;
        vector3d5.set((Tuple3d)point3d5);
        double d9 = vector3d3.dot(vector3d5) + d7;
        vector3d5.set((Tuple3d)point3d6);
        double d10 = vector3d3.dot(vector3d5) + d7;
        if (Math.abs(d8) < 1.0E-6) {
            d8 = 0.0;
        }
        if (Math.abs(d9) < 1.0E-6) {
            d9 = 0.0;
        }
        if (Math.abs(d10) < 1.0E-6) {
            d10 = 0.0;
        }
        double d11 = d8 * d9;
        double d12 = d8 * d10;
        if (d11 > 0.0 && d12 > 0.0) {
            return false;
        }
        vector3d.x = point3d5.x - point3d4.x;
        vector3d.y = point3d5.y - point3d4.y;
        vector3d.z = point3d5.z - point3d4.z;
        vector3d2.x = point3d6.x - point3d4.x;
        vector3d2.y = point3d6.y - point3d4.y;
        vector3d2.z = point3d6.z - point3d4.z;
        vector3d4.cross(vector3d, vector3d2);
        if (vector3d4.length() == 0.0) {
            return false;
        }
        vector3d5.set((Tuple3d)point3d4);
        double d13 = -vector3d4.dot(vector3d5);
        vector3d5.set((Tuple3d)point3d);
        double d14 = vector3d4.dot(vector3d5) + d13;
        vector3d5.set((Tuple3d)point3d2);
        double d15 = vector3d4.dot(vector3d5) + d13;
        vector3d5.set((Tuple3d)point3d3);
        double d16 = vector3d4.dot(vector3d5) + d13;
        if (Math.abs(d14) < 1.0E-6) {
            d14 = 0.0;
        }
        if (Math.abs(d15) < 1.0E-6) {
            d15 = 0.0;
        }
        if (Math.abs(d16) < 1.0E-6) {
            d16 = 0.0;
        }
        double d17 = d14 * d15;
        double d18 = d14 * d16;
        if (d17 > 0.0 && d18 > 0.0) {
            return false;
        }
        vector3d5.cross(vector3d3, vector3d4);
        double d19 = Math.abs(vector3d5.x);
        int n = 0;
        double d20 = Math.abs(vector3d5.y);
        double d21 = Math.abs(vector3d5.z);
        if (d20 > d19) {
            d19 = d20;
            n = 1;
        }
        if (d21 > d19) {
            d19 = d21;
            n = 2;
        }
        switch (n) {
            case 0: {
                d = point3d.x;
                d2 = point3d2.x;
                d3 = point3d3.x;
                d4 = point3d4.x;
                d5 = point3d5.x;
                d6 = point3d6.x;
                break;
            }
            case 1: {
                d = point3d.y;
                d2 = point3d2.y;
                d3 = point3d3.y;
                d4 = point3d4.y;
                d5 = point3d5.y;
                d6 = point3d6.y;
                break;
            }
            case 2: {
                d = point3d.z;
                d2 = point3d2.z;
                d3 = point3d3.z;
                d4 = point3d4.z;
                d5 = point3d5.z;
                d6 = point3d6.z;
            }
        }
        double d22 = 0.0;
        double d23 = 0.0;
        double d24 = 0.0;
        double d25 = 0.0;
        double d26 = 0.0;
        if (d17 > 0.0) {
            d22 = d3;
            d23 = (d - d3) * d16;
            d24 = (d2 - d3) * d16;
            d25 = d16 - d14;
            d26 = d16 - d15;
        } else if (d18 > 0.0) {
            d22 = d2;
            d23 = (d - d2) * d15;
            d24 = (d3 - d2) * d15;
            d25 = d15 - d14;
            d26 = d15 - d16;
        } else if (d15 * d16 > 0.0 || d14 != 0.0) {
            d22 = d;
            d23 = (d2 - d) * d14;
            d24 = (d3 - d) * d14;
            d25 = d14 - d15;
            d26 = d14 - d16;
        } else if (d15 != 0.0) {
            d22 = d2;
            d23 = (d - d2) * d15;
            d24 = (d3 - d2) * d15;
            d25 = d15 - d14;
            d26 = d15 - d16;
        } else if (d16 != 0.0) {
            d22 = d3;
            d23 = (d - d3) * d16;
            d24 = (d2 - d3) * d16;
            d25 = d16 - d14;
            d26 = d16 - d15;
        } else {
            return this.coplanarTriTri(vector3d3, point3d, point3d2, point3d3, point3d4, point3d5, point3d6);
        }
        double d27 = 0.0;
        double d28 = 0.0;
        double d29 = 0.0;
        double d30 = 0.0;
        double d31 = 0.0;
        if (d11 > 0.0) {
            d27 = d6;
            d28 = (d4 - d6) * d10;
            d29 = (d5 - d6) * d10;
            d30 = d10 - d8;
            d31 = d10 - d9;
        } else if (d12 > 0.0) {
            d27 = d5;
            d28 = (d4 - d5) * d9;
            d29 = (d6 - d5) * d9;
            d30 = d9 - d8;
            d31 = d9 - d10;
        } else if (d9 * d10 > 0.0 || d8 != 0.0) {
            d27 = d4;
            d28 = (d5 - d4) * d8;
            d29 = (d6 - d4) * d8;
            d30 = d8 - d9;
            d31 = d8 - d10;
        } else if (d9 != 0.0) {
            d27 = d5;
            d28 = (d4 - d5) * d9;
            d29 = (d6 - d5) * d9;
            d30 = d9 - d8;
            d31 = d9 - d10;
        } else if (d10 != 0.0) {
            d27 = d6;
            d28 = (d4 - d6) * d10;
            d29 = (d5 - d6) * d10;
            d30 = d10 - d8;
            d31 = d10 - d9;
        } else {
            return this.coplanarTriTri(vector3d4, point3d, point3d2, point3d3, point3d4, point3d5, point3d6);
        }
        double d32 = d25 * d26;
        double d33 = d30 * d31;
        double d34 = d32 * d33;
        double d35 = d22 * d34;
        double d36 = d35 + d23 * d26 * d33;
        double d37 = d35 + d24 * d25 * d33;
        d35 = d27 * d34;
        double d38 = d35 + d28 * d31 * d32;
        double d39 = d35 + d29 * d30 * d32;
        if (d36 > d37) {
            d35 = d36;
            d36 = d37;
            d37 = d35;
        }
        if (d38 > d39) {
            d35 = d38;
            d38 = d39;
            d39 = d35;
        }
        return !(d37 < d38) && !(d39 < d36);
    }

    boolean intersectPolygon(Point3d[] point3dArray, Point3d[] point3dArray2) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        int n = 0;
        while (n < point3dArray.length - 1) {
            vector3d.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d.z = point3dArray[n + 1].z - point3dArray[n++].z;
            if (vector3d.length() > 0.0) break;
        }
        int n2 = n;
        while (n2 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
            ++n2;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        n2 = 0;
        Point3d[] point3dArray3 = new Point3d[]{new Point3d(), new Point3d()};
        n = 0;
        while (n < point3dArray2.length) {
            boolean bl = n < point3dArray2.length - 1 ? this.edgeIntersectPlane(vector3d3, point3dArray[0], point3dArray2[n], point3dArray2[n + 1], point3dArray3[n2]) : this.edgeIntersectPlane(vector3d3, point3dArray[0], point3dArray2[n], point3dArray2[0], point3dArray3[n2]);
            if (bl && ++n2 > 1) break;
            ++n;
        }
        if (n2 == 0) {
            return false;
        }
        if (point3dArray2.length < 3) {
            return this.pointIntersectPolygon2D(vector3d3, point3dArray, point3dArray3[0]);
        }
        return this.edgeIntersectPolygon2D(vector3d3, point3dArray, point3dArray3);
    }

    boolean intersectRay(Point3d[] point3dArray, PickRay pickRay, double[] dArray) {
        return this.intersectRay(point3dArray, pickRay, dArray, null);
    }

    boolean intersectRay(Point3d[] point3dArray, PickRay pickRay, double[] dArray, Point3d point3d) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        Vector3d vector3d4 = new Vector3d();
        double d2 = 0.0;
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[4];
        int n = 0;
        while (n < point3dArray.length - 1) {
            vector3d.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d.z = point3dArray[n + 1].z - point3dArray[n++].z;
            if (vector3d.length() > 0.0) break;
        }
        int n2 = n;
        while (n2 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
            ++n2;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3dArray[0]);
        d = vector3d3.dot(vector3d4);
        d2 = vector3d3.dot(pickRay.direction);
        if (d2 == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)pickRay.origin);
        dArray[0] = (d - vector3d3.dot(vector3d4)) / d2;
        if (dArray[0] < 0.0) {
            return false;
        }
        if (point3d == null) {
            point3d = new Point3d();
        }
        point3d.x = pickRay.origin.x + pickRay.direction.x * dArray[0];
        point3d.y = pickRay.origin.y + pickRay.direction.y * dArray[0];
        point3d.z = pickRay.origin.z + pickRay.direction.z * dArray[0];
        double d3 = Math.abs(vector3d3.x);
        double d4 = Math.abs(vector3d3.y);
        double d5 = Math.abs(vector3d3.z);
        int n3 = d3 > d4 ? 0 : 1;
        if (n3 == 0) {
            if (d3 < d5) {
                n3 = 2;
            }
        } else if (n3 == 1 && d4 < d5) {
            n3 = 2;
        }
        n = 0;
        while (n < point3dArray.length) {
            switch (n3) {
                case 0: {
                    dArray2[n] = point3dArray[n].y - point3d.y;
                    dArray3[n] = point3dArray[n].z - point3d.z;
                    break;
                }
                case 1: {
                    dArray2[n] = point3dArray[n].x - point3d.x;
                    dArray3[n] = point3dArray[n].z - point3d.z;
                    break;
                }
                case 2: {
                    dArray2[n] = point3dArray[n].x - point3d.x;
                    dArray3[n] = point3dArray[n].y - point3d.y;
                }
            }
            ++n;
        }
        int n4 = 0;
        int n5 = dArray3[0] < 0.0 ? -1 : 1;
        n = 0;
        while (n < point3dArray.length) {
            int n6;
            n2 = n + 1;
            if (n2 == point3dArray.length) {
                n2 = 0;
            }
            if (n5 != (n6 = dArray3[n2] < 0.0 ? -1 : 1)) {
                double d6;
                if (dArray2[n] > 0.0 && dArray2[n2] > 0.0) {
                    ++n4;
                } else if ((dArray2[n] > 0.0 || dArray2[n2] > 0.0) && (d6 = dArray2[n] - dArray3[n] * (dArray2[n2] - dArray2[n]) / (dArray3[n2] - dArray3[n])) > 0.0) {
                    ++n4;
                }
                n5 = n6;
            }
            ++n;
        }
        if (n4 % 2 == 1) {
            dArray[0] = dArray[0] * pickRay.direction.length();
            return true;
        }
        return false;
    }

    boolean intersectSegment(Point3d[] point3dArray, Point3d point3d, Point3d point3d2, double[] dArray) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        double d2 = 0.0;
        Point3d point3d3 = new Point3d();
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[4];
        int n = 0;
        while (n < point3dArray.length - 1) {
            vector3d.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d.z = point3dArray[n + 1].z - point3dArray[n++].z;
            if (vector3d.length() > 0.0) break;
        }
        int n2 = n;
        while (n2 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
            ++n2;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3dArray[0]);
        d = vector3d3.dot(vector3d4);
        vector3d5.x = point3d2.x - point3d.x;
        vector3d5.y = point3d2.y - point3d.y;
        vector3d5.z = point3d2.z - point3d.z;
        d2 = vector3d3.dot(vector3d5);
        if (d2 == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3d);
        dArray[0] = (d - vector3d3.dot(vector3d4)) / d2;
        if (dArray[0] < 0.0 || dArray[0] > 1.0) {
            return false;
        }
        point3d3.x = point3d.x + vector3d5.x * dArray[0];
        point3d3.y = point3d.y + vector3d5.y * dArray[0];
        point3d3.z = point3d.z + vector3d5.z * dArray[0];
        double d3 = Math.abs(vector3d3.x);
        double d4 = Math.abs(vector3d3.y);
        double d5 = Math.abs(vector3d3.z);
        int n3 = d3 > d4 ? 0 : 1;
        if (n3 == 0) {
            if (d3 < d5) {
                n3 = 2;
            }
        } else if (n3 == 1 && d4 < d5) {
            n3 = 2;
        }
        n = 0;
        while (n < point3dArray.length) {
            switch (n3) {
                case 0: {
                    dArray2[n] = point3dArray[n].y - point3d3.y;
                    dArray3[n] = point3dArray[n].z - point3d3.z;
                    break;
                }
                case 1: {
                    dArray2[n] = point3dArray[n].x - point3d3.x;
                    dArray3[n] = point3dArray[n].z - point3d3.z;
                    break;
                }
                case 2: {
                    dArray2[n] = point3dArray[n].x - point3d3.x;
                    dArray3[n] = point3dArray[n].y - point3d3.y;
                }
            }
            ++n;
        }
        int n4 = 0;
        int n5 = dArray3[0] < 0.0 ? -1 : 1;
        n = 0;
        while (n < point3dArray.length) {
            int n6;
            n2 = n + 1;
            if (n2 == point3dArray.length) {
                n2 = 0;
            }
            if (n5 != (n6 = dArray3[n2] < 0.0 ? -1 : 1)) {
                double d6;
                if (dArray2[n] > 0.0 && dArray2[n2] > 0.0) {
                    ++n4;
                } else if ((dArray2[n] > 0.0 || dArray2[n2] > 0.0) && (d6 = dArray2[n] - dArray3[n] * (dArray2[n2] - dArray2[n]) / (dArray3[n2] - dArray3[n])) > 0.0) {
                    ++n4;
                }
                n5 = n6;
            }
            ++n;
        }
        if (n4 % 2 == 1) {
            dArray[0] = dArray[0] * vector3d5.length();
            return true;
        }
        return false;
    }

    boolean inside(Point3d[] point3dArray, PickPoint pickPoint, int n) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        Vector3d vector3d4 = new Vector3d();
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < point3dArray.length - 1) {
            vector3d.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d.z = point3dArray[n2 + 1].z - point3dArray[n2++].z;
            if (vector3d.length() > 0.0) break;
        }
        int n3 = n2;
        while (n3 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n3 + 1].x - point3dArray[n3].x;
            vector3d2.y = point3dArray[n3 + 1].y - point3dArray[n3].y;
            vector3d2.z = point3dArray[n3 + 1].z - point3dArray[n3].z;
            if (vector3d2.length() > 0.0) break;
            ++n3;
        }
        if (n3 == point3dArray.length - 1) {
            return false;
        }
        if (n == 1) {
            vector3d3.cross(vector3d, vector3d2);
        } else {
            vector3d3.cross(vector3d2, vector3d);
        }
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3dArray[0]);
        d = vector3d3.dot(vector3d4);
        vector3d4.set((Tuple3d)pickPoint.location);
        return !(d - vector3d3.dot(vector3d4) > 0.0);
    }

    boolean intersectPntAndPnt(Point3d point3d, Point3d point3d2) {
        return point3d.x == point3d2.x && point3d.y == point3d2.y && point3d.z == point3d2.z;
    }

    boolean intersectPntAndRay(Point3d point3d, Point3d point3d2, Vector3d vector3d, double[] dArray) {
        double d;
        int n = 0;
        if (vector3d.x != 0.0) {
            n = 0;
            dArray[0] = (point3d.x - point3d2.x) / vector3d.x;
        } else if (vector3d.y != 0.0) {
            if (point3d.x != point3d2.x) {
                return false;
            }
            n = 1;
            dArray[0] = (point3d.y - point3d2.y) / vector3d.y;
        } else if (vector3d.z != 0.0) {
            if (point3d.x != point3d2.x || point3d.y != point3d2.y) {
                return false;
            }
            n = 2;
            dArray[0] = (point3d.z - point3d2.z) / vector3d.z;
        } else {
            return false;
        }
        if (dArray[0] < 0.0) {
            return false;
        }
        if (n == 0 && (point3d.y < (d = point3d2.y + dArray[0] * vector3d.y) - 1.0E-6 || point3d.y > d + 1.0E-6)) {
            return false;
        }
        return n >= 2 || !(point3d.z < (d = point3d2.z + dArray[0] * vector3d.z) - 1.0E-6) && !(point3d.z > d + 1.0E-6);
    }

    boolean intersectLineAndRay(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, double[] dArray) {
        return this.intersectLineAndRay(point3d, point3d2, point3d3, vector3d, dArray, null);
    }

    boolean intersectLineAndRay(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, double[] dArray, Point3d point3d4) {
        Vector3d vector3d2 = new Vector3d(point3d2.x - point3d.x, point3d2.y - point3d.y, point3d2.z - point3d.z);
        double d = vector3d2.x;
        double d2 = -vector3d.y;
        double d3 = vector3d2.y;
        double d4 = -vector3d.x;
        double d5 = d * d2 - d3 * d4;
        if (d5 == 0.0) {
            return false;
        }
        double d6 = 1.0 / d5;
        double d7 = d6 * d2;
        double d8 = d6 * -d4;
        double d9 = d6 * -d3;
        double d10 = d6 * d;
        d6 = point3d3.x - point3d.x;
        double d11 = point3d3.y - point3d.y;
        double d12 = d7 * d6 + d8 * d11;
        double d13 = d9 * d6 + d10 * d11;
        if (d13 < 0.0) {
            return false;
        }
        if (d12 < 0.0 || d12 > 1.0) {
            return false;
        }
        d6 = point3d3.z + d13 * vector3d.z;
        d11 = point3d.z + d12 * vector3d2.z;
        if (d6 < d11 - 1.0E-6 || d6 > d11 + 1.0E-6) {
            return false;
        }
        dArray[0] = d13;
        if (point3d4 != null) {
            point3d4.x = point3d3.x + vector3d.x * dArray[0];
            point3d4.y = point3d3.y + vector3d.y * dArray[0];
            point3d4.z = point3d3.z + vector3d.z * dArray[0];
        }
        return true;
    }

    boolean intersectCylinder(Point3d[] point3dArray, PickCylinder pickCylinder, double[] dArray) {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        pickCylinder.getOrigin(point3d);
        pickCylinder.getDirection(vector3d);
        double d = pickCylinder.getRadius();
        if (pickCylinder instanceof PickCylinderSegment) {
            ((PickCylinderSegment)pickCylinder).getEnd(point3d2);
        }
        if (point3dArray.length > 2 && (pickCylinder instanceof PickCylinderRay ? this.intersectRay(point3dArray, new PickRay(point3d, vector3d), dArray) : this.intersectSegment(point3dArray, point3d, point3d2, dArray))) {
            return true;
        }
        int n = 0;
        while (n < point3dArray.length - 1) {
            double d2 = pickCylinder instanceof PickCylinderSegment ? Distance.segmentToSegment((Point3d)point3d, (Point3d)point3d2, (Point3d)point3dArray[n], (Point3d)point3dArray[n + 1], (Point3d)point3d3, (Point3d)point3d4, null) : Distance.rayToSegment((Point3d)point3d, (Vector3d)vector3d, (Point3d)point3dArray[n], (Point3d)point3dArray[n + 1], (Point3d)point3d3, (Point3d)point3d4, null);
            if (d2 <= d * d) {
                vector3d2.sub((Tuple3d)point3d3, (Tuple3d)point3d);
                dArray[0] = vector3d2.length();
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean intersectCone(Point3d[] point3dArray, PickCone pickCone, double[] dArray) {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d3 = new Vector3d();
        pickCone.getOrigin(point3d);
        pickCone.getDirection(vector3d);
        if (pickCone instanceof PickConeSegment) {
            ((PickConeSegment)pickCone).getEnd(point3d2);
        }
        if (point3dArray.length > 2 && (pickCone instanceof PickConeRay ? this.intersectRay(point3dArray, new PickRay(point3d, vector3d), dArray) : this.intersectSegment(point3dArray, point3d, point3d2, dArray))) {
            return true;
        }
        int n = 0;
        while (n < point3dArray.length - 1) {
            double d = pickCone instanceof PickConeSegment ? Distance.segmentToSegment((Point3d)point3d, (Point3d)point3d2, (Point3d)point3dArray[n], (Point3d)point3dArray[n + 1], (Point3d)point3d3, (Point3d)point3d4, null) : Distance.rayToSegment((Point3d)point3d, (Vector3d)vector3d, (Point3d)point3dArray[n], (Point3d)point3dArray[n + 1], (Point3d)point3d3, (Point3d)point3d4, null);
            vector3d2.sub((Tuple3d)point3d3, (Tuple3d)point3d);
            double d2 = vector3d2.length();
            double d3 = Math.tan(pickCone.getSpreadAngle()) * d2;
            if (d <= d3 * d3) {
                dArray[0] = d2;
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean intersectCylinder(Point3d point3d, PickCylinder pickCylinder, double[] dArray) {
        double d;
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        pickCylinder.getOrigin(point3d2);
        pickCylinder.getDirection(vector3d);
        double d2 = pickCylinder.getRadius();
        if (pickCylinder instanceof PickCylinderSegment) {
            ((PickCylinderSegment)pickCylinder).getEnd(point3d3);
            d = Distance.pointToSegment((Point3d)point3d, (Point3d)point3d2, (Point3d)point3d3, (Point3d)point3d4, null);
        } else {
            d = Distance.pointToRay((Point3d)point3d, (Point3d)point3d2, (Vector3d)vector3d, (Point3d)point3d4, null);
        }
        if (d <= d2 * d2) {
            vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
            dArray[0] = vector3d2.length();
            return true;
        }
        return false;
    }

    boolean intersectCone(Point3d point3d, PickCone pickCone, double[] dArray) {
        double d;
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        pickCone.getOrigin(point3d2);
        pickCone.getDirection(vector3d);
        if (pickCone instanceof PickConeSegment) {
            ((PickConeSegment)pickCone).getEnd(point3d3);
            d = Distance.pointToSegment((Point3d)point3d, (Point3d)point3d2, (Point3d)point3d3, (Point3d)point3d4, null);
        } else {
            d = Distance.pointToRay((Point3d)point3d, (Point3d)point3d2, (Vector3d)vector3d, (Point3d)point3d4, null);
        }
        vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
        double d2 = vector3d2.length();
        double d3 = Math.tan(pickCone.getSpreadAngle()) * d2;
        if (d <= d3 * d3) {
            dArray[0] = d2;
            return true;
        }
        return false;
    }

    void setCoordRefFloat(float[] fArray) {
        if (fArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 1) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (fArray.length < 3 * this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        this.floatRefCoords = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFFFFE) : (this.vertexType |= 1);
        } else {
            this.setupMirrorVertexPointer(1);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            if (fArray == null) {
                this.geoBounds.setLower(-1.0, -1.0, -1.0);
                this.geoBounds.setUpper(1.0, 1.0, 1.0);
            } else {
                this.computeBoundingBox(fArray);
            }
            this.sendDataChangedMessage(true);
        }
    }

    float[] getCoordRefFloat() {
        return this.floatRefCoords;
    }

    void setCoordRefDouble(double[] dArray) {
        if (dArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 2) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (dArray.length < 3 * this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        this.doubleRefCoords = dArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = dArray == null ? (this.vertexType &= 0xFFFFFFFD) : (this.vertexType |= 2);
        } else {
            this.setupMirrorVertexPointer(2);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            if (dArray == null) {
                this.geoBounds.setLower(-1.0, -1.0, -1.0);
                this.geoBounds.setUpper(1.0, 1.0, 1.0);
            } else {
                this.computeBoundingBox(dArray);
            }
            this.sendDataChangedMessage(true);
        }
    }

    double[] getCoordRefDouble() {
        return this.doubleRefCoords;
    }

    void setCoordRef3f(Point3f[] point3fArray) {
        if (point3fArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 4) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (point3fArray.length < this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        this.p3fRefCoords = point3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = point3fArray == null ? (this.vertexType &= 0xFFFFFFFB) : (this.vertexType |= 4);
        } else {
            this.setupMirrorVertexPointer(4);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            if (point3fArray == null) {
                this.geoBounds.setLower(-1.0, -1.0, -1.0);
                this.geoBounds.setUpper(1.0, 1.0, 1.0);
            } else {
                this.computeBoundingBox(point3fArray);
            }
            this.sendDataChangedMessage(true);
        }
    }

    Point3f[] getCoordRef3f() {
        return this.p3fRefCoords;
    }

    void setCoordRef3d(Point3d[] point3dArray) {
        if (point3dArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 8) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (point3dArray.length < this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        this.p3dRefCoords = point3dArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = point3dArray == null ? (this.vertexType &= 0xFFFFFFF7) : (this.vertexType |= 8);
        } else {
            this.setupMirrorVertexPointer(8);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            if (point3dArray == null) {
                this.geoBounds.setLower(-1.0, -1.0, -1.0);
                this.geoBounds.setUpper(1.0, 1.0, 1.0);
            } else {
                this.computeBoundingBox(point3dArray);
            }
            this.sendDataChangedMessage(true);
        }
    }

    Point3d[] getCoordRef3d() {
        return this.p3dRefCoords;
    }

    void setColorRefFloat(float[] fArray) {
        if (fArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 16) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0xC) == 4 ? fArray.length < 3 * this.vertexCount : (this.vertexFormat & 0xC) == 12 && fArray.length < 4 * this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.floatRefColors = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFFFEF) : (this.vertexType |= 0x10);
        } else {
            this.setupMirrorColorPointer(16, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getColorRefFloat() {
        return this.floatRefColors;
    }

    void setColorRefByte(byte[] byArray) {
        if (byArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 32) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0xC) == 4 ? byArray.length < 3 * this.vertexCount : (this.vertexFormat & 0xC) == 12 && byArray.length < 4 * this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.byteRefColors = byArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = byArray == null ? (this.vertexType &= 0xFFFFFFDF) : (this.vertexType |= 0x20);
        } else {
            this.setupMirrorColorPointer(32, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    byte[] getColorRefByte() {
        return this.byteRefColors;
    }

    void setColorRef3f(Color3f[] color3fArray) {
        if (color3fArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 64) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
            }
            if (color3fArray.length < this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.c3fRefColors = color3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = color3fArray == null ? (this.vertexType &= 0xFFFFFFBF) : (this.vertexType |= 0x40);
        } else {
            this.setupMirrorColorPointer(64, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Color3f[] getColorRef3f() {
        return this.c3fRefColors;
    }

    void setColorRef4f(Color4f[] color4fArray) {
        if (color4fArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 128) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0xC) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
            }
            if (color4fArray.length < this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.c4fRefColors = color4fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = color4fArray == null ? (this.vertexType &= 0xFFFFFF7F) : (this.vertexType |= 0x80);
        } else {
            this.setupMirrorColorPointer(128, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Color4f[] getColorRef4f() {
        return this.c4fRefColors;
    }

    void setColorRef3b(Color3b[] color3bArray) {
        if (color3bArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 256) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
            }
            if (color3bArray.length < this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.c3bRefColors = color3bArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = color3bArray == null ? (this.vertexType &= 0xFFFFFEFF) : (this.vertexType |= 0x100);
        } else {
            this.setupMirrorColorPointer(256, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Color3b[] getColorRef3b() {
        return this.c3bRefColors;
    }

    void setColorRef4b(Color4b[] color4bArray) {
        if (color4bArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 512) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0xC) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
            }
            if (color4bArray.length < this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.c4bRefColors = color4bArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = color4bArray == null ? (this.vertexType &= 0xFFFFFDFF) : (this.vertexType |= 0x200);
        } else {
            this.setupMirrorColorPointer(512, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Color4b[] getColorRef4b() {
        return this.c4bRefColors;
    }

    void setNormalRefFloat(float[] fArray) {
        if (fArray != null) {
            if ((this.vertexType & 0xC00) != 0 && (this.vertexType & 0xC00) != 1024) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (fArray.length < 3 * this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.floatRefNormals = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFFBFF) : (this.vertexType |= 0x400);
        } else {
            this.setupMirrorNormalPointer(1024);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getNormalRefFloat() {
        return this.floatRefNormals;
    }

    void setNormalRef3f(Vector3f[] vector3fArray) {
        if (vector3fArray != null) {
            if ((this.vertexType & 0xC00) != 0 && (this.vertexType & 0xC00) != 2048) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (vector3fArray.length < this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.v3fRefNormals = vector3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = vector3fArray == null ? (this.vertexType &= 0xFFFFF7FF) : (this.vertexType |= 0x800);
        } else {
            this.setupMirrorNormalPointer(2048);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Vector3f[] getNormalRef3f() {
        return this.v3fRefNormals;
    }

    void setTexCoordRefFloat(int n, float[] fArray) {
        if (fArray != null) {
            if ((this.vertexType & 0x7000) != 0 && (this.vertexType & 0x7000) != 4096) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0x20) != 0 ? fArray.length < 2 * this.vertexCount : (this.vertexFormat & 0x40) != 0 && fArray.length < 3 * this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.refTexCoords[n] = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFEFFF) : (this.vertexType |= 0x1000);
        } else {
            this.setupMirrorTexCoordPointer(n, 4096);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getTexCoordRefFloat(int n) {
        return (float[])this.refTexCoords[n];
    }

    void setTexCoordRef2f(int n, TexCoord2f[] texCoord2fArray) {
        if (texCoord2fArray != null) {
            if ((this.vertexType & 0x7000) != 0 && (this.vertexType & 0x7000) != 8192) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0x20) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
            }
            if (texCoord2fArray.length < this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.refTexCoords[n] = texCoord2fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = texCoord2fArray == null ? (this.vertexType &= 0xFFFFDFFF) : (this.vertexType |= 0x2000);
        } else {
            this.setupMirrorTexCoordPointer(8192);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    TexCoord2f[] getTexCoordRef2f(int n) {
        return (TexCoord2f[])this.refTexCoords[n];
    }

    void setTexCoordRef3f(int n, TexCoord3f[] texCoord3fArray) {
        if (texCoord3fArray != null) {
            if ((this.vertexType & 0x7000) != 0 && (this.vertexType & 0x7000) != 16384) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0x40) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
            }
            if (texCoord3fArray.length < this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.refTexCoords[n] = texCoord3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.vertexType = texCoord3fArray == null ? (this.vertexType &= 0xFFFFBFFF) : (this.vertexType |= 0x4000);
        } else {
            this.setupMirrorTexCoordPointer(16384);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    TexCoord3f[] getTexCoordRef3f(int n) {
        return (TexCoord3f[])this.refTexCoords[n];
    }

    void setInterleavedVertices(float[] fArray) {
        if (fArray != null && fArray.length < this.stride * this.vertexCount) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
        }
        this.geomLock.getLock();
        this.colorChanged = 65535;
        this.interLeavedVertexData = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained) {
            this.setupMirrorInterleavedColorPointer(false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.computeBoundingBox(this.initialCoordIndex, this.interLeavedVertexData);
            this.sendDataChangedMessage(true);
        }
    }

    float[] getInterleavedVertices() {
        return this.interLeavedVertexData;
    }

    void setValidVertexCount(int n) {
        if (this.initialVertexIndex + n > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray100"));
        }
        if (this.initialCoordIndex + n > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray104"));
        }
        if (this.initialColorIndex + n > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray101"));
        }
        if (this.initialNormalIndex + n > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray102"));
        }
        int n2 = 0;
        while (n2 < this.texCoordSetCount) {
            if (this.initialTexCoordIndex[n2] + n > this.vertexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray103"));
            }
            ++n2;
        }
        this.geomLock.getLock();
        this.validVertexCount = n;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.computeBoundingBox();
            this.sendDataChangedMessage(true);
        }
    }

    int getValidVertexCount() {
        return this.validVertexCount;
    }

    void setInitialVertexIndex(int n) {
        if (n + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray100"));
        }
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 0x10;
        this.d3dDirtyFlag |= 1;
        this.initialVertexIndex = n;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.computeBoundingBox();
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialVertexIndex() {
        return this.initialVertexIndex;
    }

    void setInitialCoordIndex(int n) {
        if (n + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray104"));
        }
        this.geomLock.getLock();
        this.initialCoordIndex = n;
        this.d3dDirtyFlag |= 0x10;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.computeBoundingBox();
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialCoordIndex() {
        return this.initialCoordIndex;
    }

    void setInitialColorIndex(int n) {
        if (n + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray101"));
        }
        this.geomLock.getLock();
        this.d3dDirtyFlag |= 1;
        this.colorChanged = 65535;
        this.initialColorIndex = n;
        this.geomLock.unLock();
    }

    int getInitialColorIndex() {
        return this.initialColorIndex;
    }

    void setInitialNormalIndex(int n) {
        if (n + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray102"));
        }
        this.geomLock.getLock();
        this.initialNormalIndex = n;
        this.geomLock.unLock();
    }

    int getInitialNormalIndex() {
        return this.initialNormalIndex;
    }

    void setInitialTexCoordIndex(int n, int n2) {
        if (n2 + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray103"));
        }
        this.geomLock.getLock();
        this.initialTexCoordIndex[n] = n2;
        this.geomLock.unLock();
    }

    int getInitialTexCoordIndex(int n) {
        return this.initialTexCoordIndex[n];
    }

    int getTexCoordSetCount() {
        return this.texCoordSetCount;
    }

    int getTexCoordSetMapLength() {
        if (this.texCoordSetMap != null) {
            return this.texCoordSetMap.length;
        }
        return 0;
    }

    void getTexCoordSetMap(int[] nArray) {
        if (this.texCoordSetMap != null) {
            int n = 0;
            while (n < this.texCoordSetMap.length) {
                nArray[n] = this.texCoordSetMap[n];
                ++n;
            }
        }
    }

    final void clearDirtyFlag() {
        boolean bl;
        boolean bl2 = bl = !this.geomLock.lockOwned;
        if (bl) {
            this.geomLock.getLock();
        }
        this.d3dDirtyFlag &= 0x100;
        if (bl) {
            this.geomLock.unLock();
        }
    }

    protected void finalize() {
        if (VirtualUniverse.mc.isD3D()) {
            this.freeD3DArray();
        }
    }

    void freeDlistId() {
        VirtualUniverse.mc.freeDisplayListId(this.dlistObj);
        this.dlistId = -1;
    }

    void assignDlistId() {
        if (this.dlistId == -1) {
            this.dlistObj = VirtualUniverse.mc.getDisplayListId();
            this.dlistId = this.dlistObj;
        }
    }

    void incrDlistRefCount(int n) {
        int n2 = this.getIndex(n);
        int[] nArray = null;
        int[] nArray2 = this.renderMolPerDlist;
        synchronized (nArray2) {
            if (n2 >= this.renderMolPerDlist.length) {
                nArray = new int[n2 * 2];
                int n3 = 0;
                while (n3 < this.renderMolPerDlist.length) {
                    nArray[n3] = this.renderMolPerDlist[n3];
                    ++n3;
                }
                this.renderMolPerDlist = nArray;
                this.renderMolPerDlist[n2] = 1;
            } else {
                int n4 = n2;
                this.renderMolPerDlist[n4] = this.renderMolPerDlist[n4] + 1;
            }
        }
    }

    int decrDlistRefCount(int n) {
        int n2 = this.getIndex(n);
        int[] nArray = this.renderMolPerDlist;
        synchronized (nArray) {
            int n3 = n2;
            this.renderMolPerDlist[n3] = this.renderMolPerDlist[n3] - 1;
            int n4 = this.renderMolPerDlist[n2];
            return n4;
        }
    }

    void setDlistTimeStamp(int n, long l) {
        int n2 = this.getIndex(n);
        if (n2 >= this.timeStampPerDlist.length) {
            long[] lArray = new long[n2 * 2];
            int n3 = 0;
            while (n3 < this.timeStampPerDlist.length) {
                lArray[n3] = this.timeStampPerDlist[n3];
                ++n3;
            }
            this.timeStampPerDlist = lArray;
        }
        this.timeStampPerDlist[n2] = l;
    }

    long getDlistTimeStamp(int n) {
        int n2 = this.getIndex(n);
        if (n2 >= this.timeStampPerDlist.length) {
            this.setDlistTimeStamp(n, 0L);
        }
        return this.timeStampPerDlist[n2];
    }

    int getIndex(int n) {
        int n2 = 0;
        while (n > 0) {
            ++n2;
            n >>= 1;
        }
        return n2;
    }

    boolean isWriteStatic() {
        return !this.source.capabilities.get(1) && !this.source.capabilities.get(3) && !this.source.capabilities.get(5) && !this.source.capabilities.get(7) && !this.source.capabilities.get(20) && !this.source.capabilities.get(19);
    }

    void setCompiled(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        this.geoOffset = new int[n];
        this.compileVcount = new int[n];
        int n3 = 0;
        int n4 = 0;
        n3 = 0;
        this.isCompiled = true;
        if (n > 0) {
            this.source = ((SceneGraphObjectRetained)arrayList.get((int)0)).source;
        }
        int n5 = 0;
        while (n5 < n) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)arrayList.get(n5);
            ((GeometryArray)geometryArrayRetained.source).retained = this;
            this.compileVcount[n5] = geometryArrayRetained.getValidVertexCount();
            n3 += geometryArrayRetained.getValidVertexCount();
            this.geoOffset[n5] = n2;
            n2 += geometryArrayRetained.stride() * this.compileVcount[n5];
            n4 = geometryArrayRetained.getVertexFormat();
            ++n5;
        }
        this.createGeometryArrayData(n3, n4);
        this.validVertexCount = n3;
        this.mergeGeometryArrays(arrayList);
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n = 0;
        if ((this.vertexFormat & 0x60) != 0) {
            this.texCoordSetCount = 1;
            this.texCoordSetMap = new int[1];
            this.texCoordSetMap[0] = 1;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)arrayList.get(n2);
            float[] fArray = geometryArrayRetained.vertexData;
            int n3 = geometryArrayRetained.validVertexCount * this.stride;
            int n4 = geometryArrayRetained.initialVertexIndex * this.stride;
            System.arraycopy(fArray, n4, this.vertexData, n, n3);
            n += n3;
            this.geoBounds.combine(geometryArrayRetained.geoBounds);
            ++n2;
        }
    }

    boolean isMergeable() {
        if ((this.vertexFormat & 0x80) != 0) {
            return false;
        }
        if (!this.isStatic()) {
            return false;
        }
        if ((this.vertexFormat & 0x60) != 0 && (this.texCoordSetCount > 1 || this.texCoordSetMap != null && this.texCoordSetMap.length > 1)) {
            return false;
        }
        return !this.source.capabilities.get(18);
    }

    boolean isTextureGeometryMergeable(GeometryArrayRetained geometryArrayRetained) {
        if ((this.vertexFormat & 0x60) != 0) {
            if (this.texCoordSetCount != geometryArrayRetained.texCoordSetCount) {
                return false;
            }
            if (this.texCoordSetMap != null && geometryArrayRetained.texCoordSetMap != null) {
                if (this.texCoordSetMap.length != geometryArrayRetained.texCoordSetMap.length) {
                    return false;
                }
                int n = 0;
                while (n < this.texCoordSetMap.length) {
                    if (this.texCoordSetMap[n] != geometryArrayRetained.texCoordSetMap[n]) {
                        return false;
                    }
                    ++n;
                }
            } else if (this.texCoordSetMap != geometryArrayRetained.texCoordSetMap) {
                return false;
            }
        }
        return true;
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        if (compileState.switchLevel >= 0 && this.source.capabilities.get(1)) {
            compileState.switchVwcBoundsSharable = false;
        }
        if ((this.vertexFormat & 2) != 0) {
            compileState.needNormalsTransform = true;
        }
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        if (this.geoBounds != null) {
            this.geoBounds.transform(transformGroupRetained.transform);
        }
    }

    void addMorphUser(MorphRetained morphRetained) {
        ArrayList arrayList = this.morphUniverseList;
        synchronized (arrayList) {
            if (this.morphUniverseList.contains(morphRetained.universe)) {
                int n = this.morphUniverseList.indexOf(morphRetained.universe);
                ArrayList arrayList2 = (ArrayList)this.morphUserLists.get(n);
                arrayList2.add(morphRetained);
            } else {
                this.morphUniverseList.add(morphRetained.universe);
                ArrayList<MorphRetained> arrayList3 = new ArrayList<MorphRetained>();
                arrayList3.add(morphRetained);
                this.morphUserLists.add(arrayList3);
            }
        }
    }

    void removeMorphUser(MorphRetained morphRetained) {
        ArrayList arrayList = this.morphUniverseList;
        synchronized (arrayList) {
            int n = this.morphUniverseList.indexOf(morphRetained.universe);
            ArrayList arrayList2 = (ArrayList)this.morphUserLists.get(n);
            arrayList2.remove(arrayList2.indexOf(morphRetained));
            if (arrayList2.size() == 0) {
                this.morphUserLists.remove(n);
                this.morphUniverseList.remove(n);
            }
        }
    }

    void updateMirrorGeometry() {
        this.geomLock.getLock();
        if (this instanceof IndexedGeometryArrayRetained) {
            this.mirrorGeometry = (GeometryRetained)((IndexedGeometryArrayRetained)this).cloneNonIndexedGeometry();
        }
        this.geomLock.unLock();
    }

    void getVertexData(int n, Point3d point3d) {
        if ((this.vertexFormat & 0x80) == 0) {
            int n2 = this.stride * n + this.coordinateOffset;
            point3d.x = this.vertexData[n2];
            point3d.y = this.vertexData[n2 + 1];
            point3d.z = this.vertexData[n2 + 2];
        } else if ((this.vertexFormat & 0x100) != 0) {
            int n3 = this.stride * n + this.coordinateOffset;
            point3d.x = this.interLeavedVertexData[n3];
            point3d.y = this.interLeavedVertexData[n3 + 1];
            point3d.z = this.interLeavedVertexData[n3 + 2];
        } else {
            switch (this.vertexType & 0xF) {
                case 1: {
                    int n4 = n * 3;
                    point3d.x = this.floatRefCoords[n4];
                    point3d.y = this.floatRefCoords[n4 + 1];
                    point3d.z = this.floatRefCoords[n4 + 2];
                    break;
                }
                case 2: {
                    int n5 = n * 3;
                    point3d.x = this.doubleRefCoords[n5];
                    point3d.y = this.doubleRefCoords[n5 + 1];
                    point3d.z = this.doubleRefCoords[n5 + 2];
                    break;
                }
                case 4: {
                    point3d.x = this.p3fRefCoords[n].x;
                    point3d.y = this.p3fRefCoords[n].y;
                    point3d.z = this.p3fRefCoords[n].z;
                    break;
                }
                case 8: {
                    point3d.x = this.p3dRefCoords[n].x;
                    point3d.y = this.p3dRefCoords[n].y;
                    point3d.z = this.p3dRefCoords[n].z;
                }
            }
        }
    }
}

