/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public abstract class GeometryArray
extends Geometry {
    public static final int ALLOW_COORDINATE_READ = 0;
    public static final int ALLOW_COORDINATE_WRITE = 1;
    public static final int ALLOW_COLOR_READ = 2;
    public static final int ALLOW_COLOR_WRITE = 3;
    public static final int ALLOW_NORMAL_READ = 4;
    public static final int ALLOW_NORMAL_WRITE = 5;
    public static final int ALLOW_TEXCOORD_READ = 6;
    public static final int ALLOW_TEXCOORD_WRITE = 7;
    public static final int ALLOW_COUNT_READ = 8;
    public static final int ALLOW_COUNT_WRITE = 20;
    public static final int ALLOW_FORMAT_READ = 17;
    public static final int ALLOW_REF_DATA_READ = 18;
    public static final int ALLOW_REF_DATA_WRITE = 19;
    public static final int COORDINATES = 1;
    public static final int NORMALS = 2;
    static final int COLOR = 4;
    static final int WITH_ALPHA = 8;
    public static final int COLOR_3 = 4;
    public static final int COLOR_4 = 12;
    public static final int TEXTURE_COORDINATE_2 = 32;
    public static final int TEXTURE_COORDINATE_3 = 64;
    static final int TEXTURE_COORDINATE = 96;
    public static final int BY_REFERENCE = 128;
    public static final int INTERLEAVED = 256;
    private TexCoord2f[] texCoord2fArray = null;
    private TexCoord3f[] texCoord3fArray = null;
    private TexCoord2f texCoord2fScratch = null;
    private TexCoord3f texCoord3fScratch = null;

    GeometryArray() {
    }

    public GeometryArray(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray96"));
        }
        if ((n2 & 1) == 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray0"));
        }
        if ((n2 & 0x100) != 0 && (n2 & 0x80) == 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray80"));
        }
        if ((n2 & 0x20) != 0) {
            this.texCoord2fArray = new TexCoord2f[1];
            this.texCoord2fScratch = new TexCoord2f();
        } else if ((n2 & 0x40) != 0) {
            this.texCoord3fArray = new TexCoord3f[1];
            this.texCoord3fScratch = new TexCoord3f();
        }
        ((GeometryArrayRetained)this.retained).createGeometryArrayData(n, n2);
    }

    public GeometryArray(int n, int n2, int n3, int[] nArray) {
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray96"));
        }
        if ((n2 & 1) == 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray0"));
        }
        if ((n2 & 0x100) != 0 && (n2 & 0x80) == 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray80"));
        }
        if ((n2 & 0x60) != 0) {
            if (nArray == null) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray106"));
            }
            if (n3 == 0) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray107"));
            }
            int n4 = 0;
            while (n4 < nArray.length) {
                if (nArray[n4] >= n3) {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray108"));
                }
                ++n4;
            }
            if ((n2 & 0x20) != 0) {
                this.texCoord2fArray = new TexCoord2f[1];
                this.texCoord2fScratch = new TexCoord2f();
            } else if ((n2 & 0x40) != 0) {
                this.texCoord3fArray = new TexCoord3f[1];
                this.texCoord3fScratch = new TexCoord3f();
            }
        }
        ((GeometryArrayRetained)this.retained).createGeometryArrayData(n, n2, n3, nArray);
    }

    public int getVertexCount() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray1"));
        }
        return ((GeometryArrayRetained)this.retained).getVertexCount();
    }

    public int getVertexFormat() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray2"));
        }
        return ((GeometryArrayRetained)this.retained).getVertexFormat();
    }

    public int getTexCoordSetCount() {
        return ((GeometryArrayRetained)this.retained).getTexCoordSetCount();
    }

    public int getTexCoordSetMapLength() {
        return ((GeometryArrayRetained)this.retained).getTexCoordSetMapLength();
    }

    public void getTexCoordSetMap(int[] nArray) {
        ((GeometryArrayRetained)this.retained).getTexCoordSetMap(nArray);
    }

    public void updateData(GeometryUpdater geometryUpdater) {
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) != 0 && this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray81"));
        }
        ((GeometryArrayRetained)this.retained).updateData(geometryUpdater);
    }

    public void setValidVertexCount(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray88"));
        }
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray96"));
        }
        ((GeometryArrayRetained)this.retained).setValidVertexCount(n);
        ((GeometryArrayRetained)this.retained).setValidVertexCount(n);
    }

    public int getValidVertexCount() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray89"));
        }
        return ((GeometryArrayRetained)this.retained).getValidVertexCount();
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)nodeComponent.retained;
        GeometryArrayRetained geometryArrayRetained2 = (GeometryArrayRetained)this.retained;
        int n = geometryArrayRetained.getVertexFormat();
        if ((n & 0x80) == 0) {
            System.arraycopy(geometryArrayRetained.vertexData, 0, geometryArrayRetained2.vertexData, 0, geometryArrayRetained.vertexData.length);
            geometryArrayRetained2.setInitialVertexIndex(geometryArrayRetained.getInitialVertexIndex());
        } else {
            geometryArrayRetained2.setInitialCoordIndex(geometryArrayRetained.getInitialCoordIndex());
            geometryArrayRetained2.setInitialColorIndex(geometryArrayRetained.getInitialColorIndex());
            geometryArrayRetained2.setInitialNormalIndex(geometryArrayRetained.getInitialNormalIndex());
            int n2 = geometryArrayRetained.getTexCoordSetCount();
            int n3 = 0;
            while (n3 < n2) {
                geometryArrayRetained2.setInitialTexCoordIndex(n3, geometryArrayRetained.getInitialTexCoordIndex(n3));
                ++n3;
            }
            if ((n & 0x100) == 0) {
                int n4;
                geometryArrayRetained2.setCoordRefFloat(geometryArrayRetained.getCoordRefFloat());
                geometryArrayRetained2.setCoordRefDouble(geometryArrayRetained.getCoordRefDouble());
                geometryArrayRetained2.setCoordRef3f(geometryArrayRetained.getCoordRef3f());
                geometryArrayRetained2.setCoordRef3d(geometryArrayRetained.getCoordRef3d());
                geometryArrayRetained2.setColorRefFloat(geometryArrayRetained.getColorRefFloat());
                geometryArrayRetained2.setColorRefByte(geometryArrayRetained.getColorRefByte());
                if ((n & 8) == 0) {
                    geometryArrayRetained2.setColorRef3f(geometryArrayRetained.getColorRef3f());
                    geometryArrayRetained2.setColorRef3b(geometryArrayRetained.getColorRef3b());
                } else {
                    geometryArrayRetained2.setColorRef4f(geometryArrayRetained.getColorRef4f());
                    geometryArrayRetained2.setColorRef4b(geometryArrayRetained.getColorRef4b());
                }
                geometryArrayRetained2.setNormalRefFloat(geometryArrayRetained.getNormalRefFloat());
                geometryArrayRetained2.setNormalRef3f(geometryArrayRetained.getNormalRef3f());
                int n5 = 0;
                while (n5 < n2) {
                    geometryArrayRetained2.setTexCoordRefFloat(n5, geometryArrayRetained.getTexCoordRefFloat(n5));
                    ++n5;
                }
                if ((n & 0x40) == 0) {
                    n4 = 0;
                    while (n4 < n2) {
                        geometryArrayRetained2.setTexCoordRef2f(n4, geometryArrayRetained.getTexCoordRef2f(n4));
                        ++n4;
                    }
                }
                if ((n & 0x20) == 0) {
                    n4 = 0;
                    while (n4 < n2) {
                        geometryArrayRetained2.setTexCoordRef3f(n4, geometryArrayRetained.getTexCoordRef3f(n4));
                        ++n4;
                    }
                }
            } else {
                geometryArrayRetained2.setInterleavedVertices(geometryArrayRetained.getInterleavedVertices());
            }
        }
    }

    public void setInitialVertexIndex(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray105"));
        }
        ((GeometryArrayRetained)this.retained).setInitialVertexIndex(n);
    }

    public int getInitialVertexIndex() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialVertexIndex();
    }

    public void setCoordinate(int n, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray3"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinate(n, fArray);
    }

    public void setCoordinate(int n, double[] dArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray3"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinate(n, dArray);
    }

    public void setCoordinate(int n, Point3f point3f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray3"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinate(n, point3f);
    }

    public void setCoordinate(int n, Point3d point3d) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray3"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinate(n, point3d);
    }

    public void setCoordinates(int n, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n, fArray);
    }

    public void setCoordinates(int n, double[] dArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n, dArray);
    }

    public void setCoordinates(int n, Point3f[] point3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n, point3fArray);
    }

    public void setCoordinates(int n, Point3d[] point3dArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n, point3dArray);
    }

    public void setCoordinates(int n, float[] fArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n, fArray, n2, n3);
    }

    public void setCoordinates(int n, double[] dArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n, dArray, n2, n3);
    }

    public void setCoordinates(int n, Point3f[] point3fArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n, point3fArray, n2, n3);
    }

    public void setCoordinates(int n, Point3d[] point3dArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray7"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).setCoordinates(n, point3dArray, n2, n3);
    }

    public void setColor(int n, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColor(n, fArray);
    }

    public void setColor(int n, byte[] byArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColor(n, byArray);
    }

    public void setColor(int n, Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColor(n, color3f);
    }

    public void setColor(int n, Color4f color4f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColor(n, color4f);
    }

    public void setColor(int n, Color3b color3b) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColor(n, color3b);
    }

    public void setColor(int n, Color4b color4b) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray15"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColor(n, color4b);
    }

    public void setColors(int n, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n, fArray);
    }

    public void setColors(int n, byte[] byArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n, byArray);
    }

    public void setColors(int n, Color3f[] color3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n, color3fArray);
    }

    public void setColors(int n, Color4f[] color4fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n, color4fArray);
    }

    public void setColors(int n, Color3b[] color3bArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n, color3bArray);
    }

    public void setColors(int n, Color4b[] color4bArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n, color4bArray);
    }

    public void setColors(int n, float[] fArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n, fArray, n2, n3);
    }

    public void setColors(int n, byte[] byArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n, byArray, n2, n3);
    }

    public void setColors(int n, Color3f[] color3fArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n4 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n, color3fArray, n2, n3);
    }

    public void setColors(int n, Color4f[] color4fArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n4 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n, color4fArray, n2, n3);
    }

    public void setColors(int n, Color3b[] color3bArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n4 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n, color3bArray, n2, n3);
    }

    public void setColors(int n, Color4b[] color4bArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray21"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n4 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColors(n, color4bArray, n2, n3);
    }

    public void setNormal(int n, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray33"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormal(n, fArray);
    }

    public void setNormal(int n, Vector3f vector3f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray33"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormal(n, vector3f);
    }

    public void setNormals(int n, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray35"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormals(n, fArray);
    }

    public void setNormals(int n, Vector3f[] vector3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray35"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormals(n, vector3fArray);
    }

    public void setNormals(int n, float[] fArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray35"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormals(n, fArray, n2, n3);
    }

    public void setNormals(int n, Vector3f[] vector3fArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray35"));
        }
        int n4 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n4 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n4 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).setNormals(n, vector3fArray, n2, n3);
    }

    public void setTextureCoordinate(int n, float[] fArray) {
        this.setTextureCoordinate(0, n, fArray);
    }

    public void setTextureCoordinate(int n, int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray39"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n, n2, fArray, 0, 1);
    }

    public void setTextureCoordinate(int n, Point2f point2f) {
        this.texCoord2fScratch.set((Tuple2f)point2f);
        this.setTextureCoordinate(0, n, this.texCoord2fScratch);
    }

    public void setTextureCoordinate(int n, int n2, TexCoord2f texCoord2f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray39"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x40) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        this.texCoord2fArray[0] = texCoord2f;
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n, n2, this.texCoord2fArray, 0, 1);
    }

    public void setTextureCoordinate(int n, Point3f point3f) {
        this.texCoord3fScratch.set((Tuple3f)point3f);
        this.setTextureCoordinate(0, n, this.texCoord3fScratch);
    }

    public void setTextureCoordinate(int n, int n2, TexCoord3f texCoord3f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray39"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x20) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        this.texCoord3fArray[0] = texCoord3f;
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n, n2, this.texCoord3fArray, 0, 1);
    }

    public void setTextureCoordinates(int n, float[] fArray) {
        this.setTextureCoordinates(0, n, fArray);
    }

    public void setTextureCoordinates(int n, int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x20) != 0) {
            ((GeometryArrayRetained)this.retained).setTextureCoordinates(n, n2, fArray, 0, fArray.length / 2);
        } else {
            ((GeometryArrayRetained)this.retained).setTextureCoordinates(n, n2, fArray, 0, fArray.length / 3);
        }
    }

    public void setTextureCoordinates(int n, Point2f[] point2fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(0, n, point2fArray, 0, point2fArray.length);
    }

    public void setTextureCoordinates(int n, int n2, TexCoord2f[] texCoord2fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x40) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n, n2, texCoord2fArray, 0, texCoord2fArray.length);
    }

    public void setTextureCoordinates(int n, Point3f[] point3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(0, n, point3fArray, 0, point3fArray.length);
    }

    public void setTextureCoordinates(int n, int n2, TexCoord3f[] texCoord3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x20) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n, n2, texCoord3fArray, 0, texCoord3fArray.length);
    }

    public void setTextureCoordinates(int n, float[] fArray, int n2, int n3) {
        this.setTextureCoordinates(0, n, fArray, n2, n3);
    }

    public void setTextureCoordinates(int n, int n2, float[] fArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n, n2, fArray, n3, n4);
    }

    public void setTextureCoordinates(int n, Point2f[] point2fArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(0, n, point2fArray, n2, n3);
    }

    public void setTextureCoordinates(int n, int n2, TexCoord2f[] texCoord2fArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x40) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n, n2, texCoord2fArray, n3, n4);
    }

    public void setTextureCoordinates(int n, Point3f[] point3fArray, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(0, n, point3fArray, n2, n3);
    }

    public void setTextureCoordinates(int n, int n2, TexCoord3f[] texCoord3fArray, int n3, int n4) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray42"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x20) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x40) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray110"));
        }
        ((GeometryArrayRetained)this.retained).setTextureCoordinates(n, n2, texCoord3fArray, n3, n4);
    }

    public void getCoordinate(int n, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray48"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinate(n, fArray);
    }

    public void getCoordinate(int n, double[] dArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray48"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinate(n, dArray);
    }

    public void getCoordinate(int n, Point3f point3f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray48"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinate(n, point3f);
    }

    public void getCoordinate(int n, Point3d point3d) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray48"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinate(n, point3d);
    }

    public void getCoordinates(int n, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray52"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinates(n, fArray);
    }

    public void getCoordinates(int n, double[] dArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray52"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinates(n, dArray);
    }

    public void getCoordinates(int n, Point3f[] point3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray52"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinates(n, point3fArray);
    }

    public void getCoordinates(int n, Point3d[] point3dArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray52"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        ((GeometryArrayRetained)this.retained).getCoordinates(n, point3dArray);
    }

    public void getColor(int n, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).getColor(n, fArray);
    }

    public void getColor(int n, byte[] byArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).getColor(n, byArray);
    }

    public void getColor(int n, Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).getColor(n, color3f);
    }

    public void getColor(int n, Color4f color4f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).getColor(n, color4f);
    }

    public void getColor(int n, Color3b color3b) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).getColor(n, color3b);
    }

    public void getColor(int n, Color4b color4b) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray56"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).getColor(n, color4b);
    }

    public void getColors(int n, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).getColors(n, fArray);
    }

    public void getColors(int n, byte[] byArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        ((GeometryArrayRetained)this.retained).getColors(n, byArray);
    }

    public void getColors(int n, Color3f[] color3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).getColors(n, color3fArray);
    }

    public void getColors(int n, Color4f[] color4fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).getColors(n, color4fArray);
    }

    public void getColors(int n, Color3b[] color3bArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).getColors(n, color3bArray);
    }

    public void getColors(int n, Color4b[] color4bArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray62"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 4) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray76"));
        }
        if ((n2 & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).getColors(n, color4bArray);
    }

    public void getNormal(int n, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray68"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).getNormal(n, fArray);
    }

    public void getNormal(int n, Vector3f vector3f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray68"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).getNormal(n, vector3f);
    }

    public void getNormals(int n, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray70"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).getNormals(n, fArray);
    }

    public void getNormals(int n, Vector3f[] vector3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray70"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 2) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray77"));
        }
        ((GeometryArrayRetained)this.retained).getNormals(n, vector3fArray);
    }

    public void getTextureCoordinate(int n, float[] fArray) {
        this.getTextureCoordinate(0, n, fArray);
    }

    public void getTextureCoordinate(int n, int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray72"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 0x60) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinate(n, n2, fArray);
    }

    public void getTextureCoordinate(int n, Point2f point2f) {
        this.getTextureCoordinate(0, n, this.texCoord2fArray[0]);
        point2f.set((Tuple2f)this.texCoord2fArray[0]);
    }

    public void getTextureCoordinate(int n, int n2, TexCoord2f texCoord2f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray72"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 0x60) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x40) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinate(n, n2, texCoord2f);
    }

    public void getTextureCoordinate(int n, Point3f point3f) {
        this.getTextureCoordinate(0, n, this.texCoord3fArray[0]);
        point3f.set((Tuple3f)this.texCoord3fArray[0]);
    }

    public void getTextureCoordinate(int n, int n2, TexCoord3f texCoord3f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray72"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 0x60) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x20) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinate(n, n2, texCoord3f);
    }

    public void getTextureCoordinates(int n, float[] fArray) {
        this.getTextureCoordinates(0, n, fArray);
    }

    public void getTextureCoordinates(int n, int n2, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 0x60) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(n, n2, fArray);
    }

    public void getTextureCoordinates(int n, Point2f[] point2fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 0x60) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(0, n, point2fArray);
    }

    public void getTextureCoordinates(int n, int n2, TexCoord2f[] texCoord2fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 0x60) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x40) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(n, n2, texCoord2fArray);
    }

    public void getTextureCoordinates(int n, Point3f[] point3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n2 & 0x60) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(0, n, point3fArray);
    }

    public void getTextureCoordinates(int n, int n2, TexCoord3f[] texCoord3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray75"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((n3 & 0x60) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        if ((((GeometryArrayRetained)this.retained).vertexFormat & 0x20) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).getTextureCoordinates(n, n2, texCoord3fArray);
    }

    public void setInitialCoordIndex(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        ((GeometryArrayRetained)this.retained).setInitialCoordIndex(n);
    }

    public int getInitialCoordIndex() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialCoordIndex();
    }

    public void setInitialColorIndex(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        ((GeometryArrayRetained)this.retained).setInitialColorIndex(n);
    }

    public int getInitialColorIndex() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialColorIndex();
    }

    public void setInitialNormalIndex(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        ((GeometryArrayRetained)this.retained).setInitialNormalIndex(n);
    }

    public int getInitialNormalIndex() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialNormalIndex();
    }

    public void setInitialTexCoordIndex(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray90"));
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray97"));
        }
        int n3 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n3 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        ((GeometryArrayRetained)this.retained).setInitialTexCoordIndex(n, n2);
    }

    public int getInitialTexCoordIndex(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray91"));
        }
        return ((GeometryArrayRetained)this.retained).getInitialTexCoordIndex(n);
    }

    public void setCoordRefFloat(float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRefFloat(fArray);
    }

    public float[] getCoordRefFloat() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRefFloat();
    }

    public void setCoordRefDouble(double[] dArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRefDouble(dArray);
    }

    public double[] getCoordRefDouble() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRefDouble();
    }

    public void setCoordRef3f(Point3f[] point3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRef3f(point3fArray);
    }

    public Point3f[] getCoordRef3f() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRef3f();
    }

    public void setCoordRef3d(Point3d[] point3dArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setCoordRef3d(point3dArray);
    }

    public Point3d[] getCoordRef3d() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getCoordRef3d();
    }

    public void setColorRefFloat(float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setColorRefFloat(fArray);
    }

    public float[] getColorRefFloat() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRefFloat();
    }

    public void setColorRefByte(byte[] byArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setColorRefByte(byArray);
    }

    public byte[] getColorRefByte() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRefByte();
    }

    public void setColorRef3f(Color3f[] color3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((n & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColorRef3f(color3fArray);
    }

    public Color3f[] getColorRef3f() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRef3f();
    }

    public void setColorRef4f(Color4f[] color4fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((n & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColorRef4f(color4fArray);
    }

    public Color4f[] getColorRef4f() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRef4f();
    }

    public void setColorRef3b(Color3b[] color3bArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((n & 8) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
        }
        ((GeometryArrayRetained)this.retained).setColorRef3b(color3bArray);
    }

    public Color3b[] getColorRef3b() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRef3b();
    }

    public void setColorRef4b(Color4b[] color4bArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((n & 8) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
        }
        ((GeometryArrayRetained)this.retained).setColorRef4b(color4bArray);
    }

    public Color4b[] getColorRef4b() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getColorRef4b();
    }

    public void setNormalRefFloat(float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setNormalRefFloat(fArray);
    }

    public float[] getNormalRefFloat() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getNormalRefFloat();
    }

    public void setNormalRef3f(Vector3f[] vector3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setNormalRef3f(vector3fArray);
    }

    public Vector3f[] getNormalRef3f() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getNormalRef3f();
    }

    public void setTexCoordRefFloat(int n, float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        ((GeometryArrayRetained)this.retained).setTexCoordRefFloat(n, fArray);
    }

    public float[] getTexCoordRefFloat(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getTexCoordRefFloat(n);
    }

    public void setTexCoordRef2f(int n, TexCoord2f[] texCoord2fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((n2 & 0x40) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
        }
        ((GeometryArrayRetained)this.retained).setTexCoordRef2f(n, texCoord2fArray);
    }

    public TexCoord2f[] getTexCoordRef2f(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getTexCoordRef2f(n);
    }

    public void setTexCoordRef3f(int n, TexCoord3f[] texCoord3fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        if ((n2 & 0x20) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
        }
        ((GeometryArrayRetained)this.retained).setTexCoordRef3f(n, texCoord3fArray);
    }

    public TexCoord3f[] getTexCoordRef3f(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n2 = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n2 & 0x80) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray83"));
        }
        if ((n2 & 0x100) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray84"));
        }
        return ((GeometryArrayRetained)this.retained).getTexCoordRef3f(n);
    }

    public void setInterleavedVertices(float[] fArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x100) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray85"));
        }
        ((GeometryArrayRetained)this.retained).setInterleavedVertices(fArray);
    }

    public float[] getInterleavedVertices() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int n = ((GeometryArrayRetained)this.retained).vertexFormat;
        if ((n & 0x100) == 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray85"));
        }
        return ((GeometryArrayRetained)this.retained).getInterleavedVertices();
    }
}

