/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.VirtualUniverse;

class EventCatcher
implements ComponentListener,
FocusListener,
KeyListener,
MouseListener,
MouseMotionListener,
WindowListener {
    Canvas3D canvas;
    static final boolean DEBUG = false;
    boolean stopped = false;
    boolean componentEvents = false;
    boolean focusEvents = false;
    boolean keyEvents = false;
    boolean mouseEvents = false;
    boolean mouseMotionEvents = false;
    boolean mouseListenerAdded = false;

    EventCatcher(Canvas3D canvas3D) {
        this.canvas = canvas3D;
        if (VirtualUniverse.mc.isD3D()) {
            this.enableComponentEvents();
            this.enableKeyEvents();
        }
    }

    void enableComponentEvents() {
        if (!this.componentEvents) {
            this.canvas.addComponentListener(this);
            this.componentEvents = true;
        }
    }

    void enableFocusEvents() {
        if (!this.focusEvents) {
            this.canvas.addFocusListener(this);
            this.focusEvents = true;
        }
    }

    void enableKeyEvents() {
        if (!this.keyEvents) {
            this.canvas.addKeyListener(this);
            this.keyEvents = true;
            if (!this.mouseListenerAdded) {
                this.canvas.addMouseListener(this);
                this.mouseListenerAdded = true;
            }
        }
    }

    void enableMouseEvents() {
        if (!this.mouseEvents) {
            this.mouseEvents = true;
            if (!this.mouseListenerAdded) {
                this.canvas.addMouseListener(this);
                this.mouseListenerAdded = true;
            }
        }
    }

    void enableMouseMotionEvents() {
        if (!this.mouseMotionEvents) {
            this.canvas.addMouseMotionListener(this);
            this.mouseMotionEvents = true;
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this.canvas) {
            this.canvas.sendEventToBehaviorScheduler(componentEvent);
            this.canvas.visible = true;
            if (VirtualUniverse.mc.isD3D()) {
                this.canvas.notifyD3DPeer(1);
            }
            this.canvas.evaluateActive();
            this.repaint();
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.canvas.sendEventToBehaviorScheduler(componentEvent);
        this.canvas.visible = false;
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.canvas.sendEventToBehaviorScheduler(componentEvent);
        if (VirtualUniverse.mc.isD3D()) {
            this.canvas.notifyD3DPeer(1);
        }
        this.repaint();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.canvas.sendEventToBehaviorScheduler(componentEvent);
        this.canvas.visible = true;
        this.canvas.evaluateActive();
        this.repaint();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.canvas.sendEventToBehaviorScheduler(focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.canvas.sendEventToBehaviorScheduler(focusEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.canvas.sendEventToBehaviorScheduler(keyEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.canvas.sendEventToBehaviorScheduler(keyEvent);
        if (VirtualUniverse.mc.isD3D() && keyEvent.isAltDown() && keyEvent.getKeyCode() == 10) {
            this.canvas.notifyD3DPeer(2);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.canvas.sendEventToBehaviorScheduler(keyEvent);
        this.stopped = !this.stopped;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.keyEvents && VirtualUniverse.mc.getRenderingAPI() != 0) {
            this.canvas.requestFocus();
        }
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.keyEvents && VirtualUniverse.mc.getRenderingAPI() == 0) {
            this.canvas.requestFocus();
        }
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.canvas.sendEventToBehaviorScheduler(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.canvas.sendEventToBehaviorScheduler(mouseEvent);
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.windowOpened(windowEvent);
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.canvas.sendEventToBehaviorScheduler(windowEvent);
        this.canvas.visible = false;
        this.canvas.evaluateActive();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.canvas.sendEventToBehaviorScheduler(windowEvent);
        this.canvas.visible = false;
        this.canvas.evaluateActive();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.canvas.sendEventToBehaviorScheduler(windowEvent);
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.canvas.sendEventToBehaviorScheduler(windowEvent);
        this.canvas.visible = true;
        if (this.canvas.view != null) {
            this.canvas.view.sendEventToSoundScheduler(windowEvent);
        }
        this.canvas.evaluateActive();
        this.repaint();
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.canvas.sendEventToBehaviorScheduler(windowEvent);
        this.canvas.visible = false;
        if (this.canvas.view != null) {
            this.canvas.view.sendEventToSoundScheduler(windowEvent);
        }
        this.canvas.evaluateActive();
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.canvas.sendEventToBehaviorScheduler(windowEvent);
        this.canvas.visible = true;
        this.canvas.evaluateActive();
        this.repaint();
    }

    void repaint() {
        if (this.canvas.view != null) {
            this.canvas.view.repaint();
        }
    }

    void reset() {
        this.focusEvents = false;
        this.keyEvents = false;
        this.componentEvents = false;
        this.mouseEvents = false;
        this.mouseMotionEvents = false;
        this.mouseListenerAdded = false;
        this.stopped = false;
    }
}

