/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.RenderMethod;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.Transform3D;

class DisplayListRenderMethod
implements RenderMethod {
    final int bufferSize = 128;
    int[] buffer = new int[128];

    DisplayListRenderMethod() {
    }

    native void callDisplayLists(int var1, int[] var2);

    public void update(RenderMolecule renderMolecule) {
    }

    public void render(RenderMolecule renderMolecule, Canvas3D canvas3D) {
        if (renderMolecule.doInfinite || renderMolecule.vwcBounds.intersect(canvas3D.viewFrustum)) {
            canvas3D.callDisplayList(canvas3D.ctx, renderMolecule.displayListId, renderMolecule.isNonUniformScale);
        }
    }

    public void render(RenderMolecule renderMolecule, Canvas3D canvas3D, int n) {
        this.render(renderMolecule, canvas3D);
    }

    /*
     * Unable to fully structure code
     */
    public void renderSeparateDlists(RenderMolecule var1_1, Canvas3D var2_2) {
        block7: {
            var3_3 = var1_1.separateDlistRenderAtomList;
            if (!var1_1.doInfinite) ** GOTO lbl19
            while (var3_3 != null) {
                var2_2.callDisplayList(var2_2.ctx, ((GeometryArrayRetained)var3_3.geometry).dlistId, var1_1.isNonUniformScale);
                var3_3 = var3_3.next;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                if (var2_2.ra == var3_3.renderAtom) {
                    if (var2_2.raIsVisible) {
                        var2_2.callDisplayList(var2_2.ctx, ((GeometryArrayRetained)var3_3.geometry).dlistId, var1_1.isNonUniformScale);
                    }
                } else {
                    if (var3_3.renderAtom.localeVwcBounds.intersect(var2_2.viewFrustum)) {
                        var2_2.raIsVisible = true;
                        var2_2.callDisplayList(var2_2.ctx, ((GeometryArrayRetained)var3_3.geometry).dlistId, var1_1.isNonUniformScale);
                    } else {
                        var2_2.raIsVisible = false;
                    }
                    var2_2.ra = var3_3.renderAtom;
                }
                var3_3 = var3_3.next;
lbl19:
                // 2 sources

                ** while (var3_3 != null)
            }
        }
    }

    void buildDisplayList(RenderMolecule renderMolecule, Canvas3D canvas3D) {
        boolean bl = renderMolecule.useAlpha;
        if (renderMolecule.primaryRenderAtomList != null) {
            canvas3D.newDisplayList(canvas3D.ctx, renderMolecule.displayListId);
            RenderAtomListInfo renderAtomListInfo = renderMolecule.primaryRenderAtomList;
            while (renderAtomListInfo != null) {
                Transform3D transform3D;
                Transform3D transform3D2;
                GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)renderAtomListInfo.geometry;
                if (renderAtomListInfo.renderAtom.geometryAtom.source.staticTransform == null) {
                    transform3D2 = null;
                    transform3D = null;
                } else {
                    transform3D2 = renderAtomListInfo.renderAtom.geometryAtom.source.staticTransform.transform;
                    transform3D = (geometryArrayRetained.vertexFormat & 2) != 0 ? renderAtomListInfo.renderAtom.geometryAtom.source.staticTransform.getNormalTransform() : null;
                }
                if (geometryArrayRetained instanceof IndexedGeometryArrayRetained) {
                    ((GeometryArrayRetained)geometryArrayRetained.mirrorGeometry).buildGA(canvas3D.ctx, renderAtomListInfo.renderAtom, false, bl && (geometryArrayRetained.vertexFormat & 4) != 0, renderMolecule.alpha, renderMolecule.textureBin.attributeBin.ignoreVertexColors, transform3D2, transform3D);
                } else {
                    geometryArrayRetained.buildGA(canvas3D.ctx, renderAtomListInfo.renderAtom, false, bl && (geometryArrayRetained.vertexFormat & 4) != 0, renderMolecule.alpha, renderMolecule.textureBin.attributeBin.ignoreVertexColors, transform3D2, transform3D);
                }
                renderAtomListInfo = renderAtomListInfo.next;
            }
            canvas3D.endDisplayList(canvas3D.ctx);
        }
    }

    void buildIndividualDisplayList(RenderAtomListInfo renderAtomListInfo, Canvas3D canvas3D, int n) {
        GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)renderAtomListInfo.geometry;
        canvas3D.newDisplayList(n, geometryArrayRetained.dlistId);
        if (geometryArrayRetained instanceof IndexedGeometryArrayRetained) {
            ((GeometryArrayRetained)geometryArrayRetained.mirrorGeometry).buildGA(n, renderAtomListInfo.renderAtom, false, false, 1.0f, false, null, null);
        } else {
            geometryArrayRetained.buildGA(n, renderAtomListInfo.renderAtom, false, false, 1.0f, false, null, null);
        }
        canvas3D.endDisplayList(n);
        if (canvas3D.useSharedCtx) {
            geometryArrayRetained.setDlistTimeStamp(canvas3D.screen.renderer.rendererBit, canvas3D.screen.renderer.sharedCtxTimeStamp);
        } else {
            geometryArrayRetained.setDlistTimeStamp(canvas3D.canvasBit, canvas3D.ctxTimeStamp);
        }
    }
}

