/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CompileState;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.VirtualUniverse;

class BranchGroupRetained
extends GroupRetained {
    boolean isDirty = false;
    boolean isNew = false;
    boolean attachedToLocale = false;

    BranchGroupRetained() {
        this.nodeType = 19;
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }

    Locale getLocale() {
        return this.locale;
    }

    void detach() {
        if (this.universe != null) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                if (this.source.isLive()) {
                    this.notifySceneGraphChanged(true);
                }
                this.do_detach();
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.do_detach();
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
    }

    void do_detach() {
        if (this.attachedToLocale) {
            this.locale.doRemoveBranchGraph((BranchGroup)this.source, null, 0);
        } else if (this.parent != null) {
            GroupRetained groupRetained = (GroupRetained)this.parent;
            groupRetained.doRemoveChild(groupRetained.children.indexOf(this), null, 0);
        }
    }

    void setLive(SetLiveState setLiveState) {
        int n = setLiveState.branchGroupPaths.size();
        ArrayList<BranchGroupRetained[]> arrayList = new ArrayList<BranchGroupRetained[]>(n);
        int n2 = 0;
        while (n2 < n) {
            BranchGroupRetained[] branchGroupRetainedArray = (BranchGroupRetained[])setLiveState.branchGroupPaths.get(n2);
            BranchGroupRetained[] branchGroupRetainedArray2 = new BranchGroupRetained[branchGroupRetainedArray.length + 1];
            System.arraycopy(branchGroupRetainedArray, 0, branchGroupRetainedArray2, 0, branchGroupRetainedArray.length);
            branchGroupRetainedArray2[branchGroupRetainedArray.length] = this;
            arrayList.add(branchGroupRetainedArray2);
            ++n2;
        }
        setLiveState.branchGroupPaths = arrayList;
        super.doSetLive(setLiveState);
        super.markAsLive();
    }

    void compile() {
        if (this.source.isCompiled() || VirtualUniverse.mc.disableCompile) {
            return;
        }
        CompileState compileState = new CompileState();
        this.isRoot = true;
        this.compile(compileState);
        this.merge(compileState);
    }

    void compile(CompileState compileState) {
        if (this.mergeFlag == 2) {
            compileState.keepTG = true;
            return;
        }
        super.compile(compileState);
        this.mergeFlag = 0;
    }
}

