/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Behavior;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.J3dThread;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCriteriaEnumerator;

class BehaviorScheduler
extends J3dThread {
    VirtualUniverse univ = null;
    UnorderList processList;
    UnorderList billBoardProcessList;
    UnorderList scheduleList;
    BehaviorStructure behaviorStructure;
    int stopCount = -1;
    long lastStartTime;
    long lastStopTime;
    Object intervalTimeLock = new Object();
    private static int numInstances = 0;
    private int instanceNum = -1;

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    BehaviorScheduler(ThreadGroup threadGroup, VirtualUniverse virtualUniverse) {
        super(threadGroup);
        this.setName("J3D-BehaviorScheduler-" + this.getInstanceNum());
        this.univ = virtualUniverse;
        this.behaviorStructure = virtualUniverse.behaviorStructure;
        this.scheduleList = this.behaviorStructure.scheduleList;
        this.processList = this.behaviorStructure.processList;
        this.billBoardProcessList = this.behaviorStructure.billBoardProcessList;
        this.type = 1;
    }

    void stopBehaviorScheduler(long[] lArray) {
        this.stopCount = 2;
        VirtualUniverse.mc.sendRunMessage(this.univ, 1);
        while (!this.userStop) {
            try {
                Thread.currentThread();
                Thread.sleep(10L, 0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Object object = this.intervalTimeLock;
        synchronized (object) {
            lArray[0] = this.lastStartTime;
            lArray[1] = this.lastStopTime;
        }
    }

    void startBehaviorScheduler() {
        Object object = this.intervalTimeLock;
        synchronized (object) {
            this.stopCount = -1;
            this.userStop = false;
            VirtualUniverse.mc.setWork();
        }
    }

    void deactivate() {
        this.active = false;
        if (this.stopCount >= 0) {
            this.userStop = true;
        }
    }

    void doWork(long l) {
        int n;
        BehaviorRetained[] behaviorRetainedArray;
        int n2;
        this.lastStartTime = System.currentTimeMillis();
        if (this.stopCount >= 0) {
            VirtualUniverse.mc.sendRunMessage(this.univ, 1);
            if (--this.stopCount == 0) {
                this.userStop = true;
            }
        }
        if ((n2 = this.billBoardProcessList.size()) > 0) {
            behaviorRetainedArray = (BehaviorRetained[])this.billBoardProcessList.toArray(false);
            n = n2 - 1;
            while (n >= 0) {
                this.processList.add(behaviorRetainedArray[n]);
                --n;
            }
            this.billBoardProcessList.clear();
        }
        behaviorRetainedArray = (BehaviorRetained[])this.processList.toArray(false);
        n2 = this.processList.arraySize();
        n = 0;
        while (n < n2) {
            block17: {
                BehaviorRetained behaviorRetained;
                BehaviorRetained behaviorRetained2 = behaviorRetained = behaviorRetainedArray[n];
                synchronized (behaviorRetained2) {
                    Behavior behavior = (Behavior)behaviorRetained.source;
                    if (!behavior.isLive() || !behaviorRetained.conditionSet) {
                        break block17;
                    }
                    if (behaviorRetained.wakeupCondition.trigEnum == null) {
                        behaviorRetained.wakeupCondition.trigEnum = new WakeupCriteriaEnumerator(behaviorRetained.wakeupCondition, 1);
                    } else {
                        behaviorRetained.wakeupCondition.trigEnum.reset(behaviorRetained.wakeupCondition, 1);
                    }
                    behaviorRetained.wakeupCondition.cleanTree();
                    behaviorRetained.conditionSet = false;
                    BehaviorRetained behaviorRetained3 = behaviorRetained;
                    synchronized (behaviorRetained3) {
                        behaviorRetained.inCallback = true;
                        this.univ.inBehavior = true;
                        try {
                            behavior.processStimulus(behaviorRetained.wakeupCondition.trigEnum);
                        }
                        catch (RuntimeException runtimeException) {
                            System.err.println("Exception occurred during Behavior execution:");
                            runtimeException.printStackTrace();
                        }
                        this.univ.inBehavior = false;
                        behaviorRetained.inCallback = false;
                    }
                    if (!behaviorRetained.conditionSet) {
                        behaviorRetained.wakeupCondition = null;
                        behaviorRetained.active = false;
                        this.scheduleList.remove(behaviorRetained);
                    }
                }
            }
            ++n;
        }
        this.processList.clear();
        this.behaviorStructure.handleAWTEvent();
        this.behaviorStructure.handleBehaviorPost();
        this.lastStopTime = System.currentTimeMillis();
    }

    void free() {
        this.behaviorStructure = null;
        this.getThreadData(null, null).thread = null;
        this.univ = null;
        this.processList.clear();
        this.billBoardProcessList.clear();
        this.scheduleList.clear();
    }
}

