/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import visad.util.ColorWidget;

public class WidgetLayout
implements LayoutManager {
    private Container container;
    private int preferredX;
    private int preferredY;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private int width;
    private int height0;
    private int height1;

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public void layoutContainer(Container container) {
        if (container != this.container) {
            throw new AWTError("WidgetLayout: got layoutContainer() with incorrect parent");
        }
        this.calcDimensions();
        int n = this.container.getComponentCount();
        switch (n) {
            case 0: {
                break;
            }
            case 2: {
                this.container.getComponent(1).setBounds(this.container.getInsets().left, (int)Math.min((long)this.height0 + (long)this.container.getInsets().top, Integer.MAX_VALUE), this.width, this.height1);
            }
            case 1: {
                this.container.getComponent(0).setBounds(this.container.getInsets().left, this.container.getInsets().top, this.width, this.height0);
                break;
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        if (container != this.container) {
            throw new AWTError("WidgetLayout: got layoutContainer() with incorrect parent");
        }
        this.calcDimensions();
        return new Dimension(this.minX, this.minY);
    }

    public Dimension preferredLayoutSize(Container container) {
        if (container != this.container) {
            throw new AWTError("WidgetLayout: got layoutContainer() with incorrect parent");
        }
        this.calcDimensions();
        return new Dimension(this.preferredX, this.preferredY);
    }

    public Dimension maximumLayoutSize(Container container) {
        if (container != this.container) {
            throw new AWTError("WidgetLayout: got layoutContainer() with incorrect parent");
        }
        this.calcDimensions();
        return new Dimension(this.maxX, this.maxY);
    }

    private void calcDimensions() {
        int n = this.container.getComponentCount();
        switch (n) {
            case 0: {
                this.minX = 0;
                this.minY = 0;
                this.maxX = 0;
                this.maxY = 0;
                this.preferredX = 0;
                this.preferredY = 0;
                break;
            }
            case 1: {
                Component component = this.container.getComponent(0);
                this.minX = (int)Math.min((long)component.getMinimumSize().width + (long)this.container.getInsets().right + (long)this.container.getInsets().left, Integer.MAX_VALUE);
                this.minY = (int)Math.min((long)component.getMinimumSize().height + (long)this.container.getInsets().top + (long)this.container.getInsets().bottom, Integer.MAX_VALUE);
                this.minX = (int)Math.min((long)component.getMaximumSize().width + (long)this.container.getInsets().right + (long)this.container.getInsets().left, Integer.MAX_VALUE);
                this.minY = (int)Math.min((long)component.getMaximumSize().height + (long)this.container.getInsets().top + (long)this.container.getInsets().bottom, Integer.MAX_VALUE);
                this.preferredX = (int)Math.min((long)component.getPreferredSize().width + (long)this.container.getInsets().right + (long)this.container.getInsets().left, Integer.MAX_VALUE);
                this.preferredY = (int)Math.min((long)component.getPreferredSize().height + (long)this.container.getInsets().top + (long)this.container.getInsets().bottom, Integer.MAX_VALUE);
                this.width = this.container.getBounds().width;
                this.height0 = this.container.getBounds().height;
                this.height1 = 0;
                break;
            }
            default: {
                Component component = this.container.getComponent(0);
                Component component2 = this.container.getComponent(1);
                this.minX = (int)Math.min((long)component.getMinimumSize().width + (long)component2.getMinimumSize().width + (long)this.container.getInsets().right + (long)this.container.getInsets().left, Integer.MAX_VALUE);
                this.minY = (int)Math.min((long)component.getMinimumSize().height + (long)component2.getMinimumSize().height + (long)this.container.getInsets().top + (long)this.container.getInsets().bottom, Integer.MAX_VALUE);
                this.minX = (int)Math.min((long)component.getMaximumSize().width + (long)component2.getMaximumSize().width + (long)this.container.getInsets().right + (long)this.container.getInsets().left, Integer.MAX_VALUE);
                this.minY = (int)Math.min((long)component.getMaximumSize().height + (long)component2.getMaximumSize().height + (long)this.container.getInsets().top + (long)this.container.getInsets().bottom, Integer.MAX_VALUE);
                this.preferredX = (int)Math.min((long)component.getPreferredSize().width + (long)component2.getPreferredSize().width + (long)this.container.getInsets().right + (long)this.container.getInsets().left, Integer.MAX_VALUE);
                this.preferredY = (int)Math.min((long)component.getPreferredSize().height + (long)component2.getPreferredSize().height + (long)this.container.getInsets().top + (long)this.container.getInsets().bottom, Integer.MAX_VALUE);
                this.width = this.container.getBounds().width;
                this.height1 = Math.min(this.container.getBounds().height, component2.getPreferredSize().height);
                this.height0 = this.container.getBounds().height - this.height1;
                break;
            }
        }
    }

    public WidgetLayout(ColorWidget colorWidget) {
        this.container = colorWidget;
        this.calcDimensions();
    }
}

