/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Dimension;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.ActionImpl;
import visad.CellImpl;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Data;
import visad.DataImpl;
import visad.DataReference;
import visad.Display;
import visad.DisplayRealType;
import visad.PlotText;
import visad.Real;
import visad.RealType;
import visad.RemoteCellImpl;
import visad.RemoteDataReference;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.ScalarType;
import visad.ValueControl;
import visad.VisADException;
import visad.collab.CollabUtil;
import visad.util.Util;

public class VisADSlider
extends JPanel
implements ChangeListener,
ControlListener,
ScalarMapListener {
    private static final int D_TICKS = 1000;
    private static final int SLIDER_WIDTH = 150;
    private static final int LABEL_WIDTH = 200;
    private String head = "         ";
    private JSlider slider;
    private JLabel label;
    private ScalarMap map;
    private ValueControl control;
    private DataReference sRef;
    private RealType realType;
    private String sName;
    private double sMinimum;
    private double sMaximum;
    private double sCurrent;
    private int sTicks;
    private boolean smapControl;
    private boolean autoScale;

    private void initLabel() {
        this.label = new JLabel(this.sName + " = " + PlotText.shortString(this.sCurrent) + this.head);
        Dimension dimension = this.label.getMinimumSize();
        this.label.setMinimumSize(new Dimension(200, dimension.height));
        dimension = this.label.getPreferredSize();
        this.label.setPreferredSize(new Dimension(200, dimension.height));
        dimension = this.label.getMaximumSize();
        this.label.setMaximumSize(new Dimension(200, dimension.height));
        this.label.setAlignmentX(0.5f);
    }

    public synchronized void stateChanged(ChangeEvent changeEvent) {
        block7: {
            this.head = "";
            try {
                double d = this.slider.getValue();
                double d2 = (this.sMaximum - this.sMinimum) * (d / (double)this.sTicks) + this.sMinimum;
                if (Util.isApproximatelyEqual(this.sCurrent, d2)) break block7;
                if (this.smapControl) {
                    this.control.setValue(d2);
                    break block7;
                }
                if (this.sRef == null) break block7;
                try {
                    this.sRef.setData(new Real(this.realType, d2));
                }
                catch (RemoteException remoteException) {
                    if (CollabUtil.isDisconnectException(remoteException)) {
                        this.sRef = null;
                    }
                    throw remoteException;
                }
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }

    public void mapChanged(ScalarMapEvent scalarMapEvent) {
        if (!this.autoScale) {
            return;
        }
        double[] dArray = this.map.getRange();
        this.sMinimum = (float)dArray[0];
        this.sMaximum = (float)dArray[1];
        this.sCurrent = (float)this.control.getValue();
        if (this.sCurrent < this.sMinimum || this.sCurrent > this.sMaximum) {
            this.sCurrent = (this.sMinimum + this.sMaximum) / 2.0;
        }
        this.updateSlider(this.sCurrent);
    }

    public void controlChanged(ScalarMapControlEvent scalarMapControlEvent) {
        int n = scalarMapControlEvent.getId();
        if (n == 4 || n == 5) {
            this.control = null;
        }
        if (n == 5 || n == 3) {
            this.control = (ValueControl)((Object)scalarMapControlEvent.getScalarMap().getControl());
        }
    }

    public void controlChanged(ControlEvent controlEvent) throws VisADException, RemoteException {
        double d = this.control.getValue();
        if (!Util.isApproximatelyEqual(this.sCurrent, d)) {
            this.updateSlider(this.control.getValue());
        }
    }

    private synchronized void updateSlider(double d) {
        int n = (int)((double)this.sTicks * ((d - this.sMinimum) / (this.sMaximum - this.sMinimum)));
        if (Math.abs(this.slider.getValue() - n) > 1) {
            this.slider.removeChangeListener(this);
            this.slider.setValue(n);
            this.slider.addChangeListener(this);
        }
        this.sCurrent = d;
        this.label.setText(this.sName + " = " + PlotText.shortString(this.sCurrent) + this.head);
    }

    static /* synthetic */ DataReference access$0(VisADSlider visADSlider) {
        return visADSlider.sRef;
    }

    static /* synthetic */ void access$1(VisADSlider visADSlider, DataReference dataReference) {
        visADSlider.sRef = dataReference;
    }

    static /* synthetic */ double access$2(VisADSlider visADSlider) {
        return visADSlider.sCurrent;
    }

    static /* synthetic */ void access$3(VisADSlider visADSlider, double d) {
        visADSlider.updateSlider(d);
    }

    public VisADSlider(String string, int n, int n2, int n3, double d, DataReference dataReference, RealType realType) throws VisADException, RemoteException {
        this(dataReference, null, (float)((double)n * d), (float)((double)n2 * d), (float)((double)n3 * d), n2 - n, dataReference == null || dataReference.getData() instanceof Real ? null : realType, string);
    }

    public VisADSlider(ScalarMap scalarMap) throws VisADException, RemoteException {
        this(null, scalarMap, Float.NaN, Float.NaN, Float.NaN, 1000, null, null);
    }

    public VisADSlider(ScalarMap scalarMap, float f, float f2) throws VisADException, RemoteException {
        this(null, scalarMap, f, f2, Float.NaN, 1000, null, null);
    }

    public VisADSlider(DataReference dataReference, float f, float f2, float f3, RealType realType, String string) throws VisADException, RemoteException {
        this(dataReference, null, f, f2, f3, 1000, realType, string);
    }

    public VisADSlider(DataReference dataReference, float f, float f2) throws VisADException, RemoteException {
        this(dataReference, null, f, f2, Float.NaN, 1000, null, null);
    }

    private VisADSlider(DataReference dataReference, ScalarMap scalarMap, float f, float f2, float f3, int n, RealType realType, String string) throws VisADException, RemoteException {
        this.setAlignmentX(0.0f);
        this.setLayout(new BoxLayout(this, 0));
        this.sTicks = n;
        this.slider = new JSlider(0, this.sTicks, this.sTicks / 2);
        Dimension dimension = this.slider.getMinimumSize();
        this.slider.setMinimumSize(new Dimension(150, dimension.height));
        dimension = this.slider.getPreferredSize();
        this.slider.setPreferredSize(new Dimension(150, dimension.height));
        dimension = this.slider.getMaximumSize();
        this.slider.setMaximumSize(new Dimension(150, dimension.height));
        this.autoScale = false;
        if (dataReference == null) {
            if (scalarMap == null) {
                throw new VisADException("VisADSlider: must specify either a DataReference or a ScalarMap!");
            }
            DisplayRealType displayRealType = scalarMap.getDisplayScalar();
            if (displayRealType != Display.SelectValue) {
                throw new VisADException("VisADSlider: ScalarMap must be to Display.SelectValue!");
            }
            ScalarType scalarType = scalarMap.getScalar();
            if (!(scalarType instanceof RealType)) {
                throw new VisADException("VisADSlider: ScalarMap must be from a RealType!");
            }
            this.smapControl = true;
            this.map = scalarMap;
            this.control = (ValueControl)((Object)scalarMap.getControl());
            if (this.control == null) {
                throw new VisADException("VisADSlider: ScalarMap must be addMap'ed to a Display");
            }
            this.sRef = null;
            this.sName = scalarMap.getScalarName();
            f3 = (float)this.control.getValue();
            if (f == f && f2 == f2 && f3 == f3) {
                this.sMinimum = f;
                this.sMaximum = f2;
                this.sCurrent = f3;
                this.initLabel();
                scalarMap.setRange(f, f2);
                if (f3 < f || f3 > f2) {
                    f3 = (f + f2) / 2.0f;
                    this.control.setValue(f3);
                }
            } else {
                this.autoScale = true;
                this.initLabel();
            }
            this.control.addControlListener(this);
            scalarMap.addScalarMapListener(this);
        } else {
            Object object;
            this.smapControl = false;
            this.map = null;
            this.control = null;
            if (dataReference == null) {
                throw new VisADException("VisADSlider: DataReference cannot be null!");
            }
            this.sRef = dataReference;
            Data data = dataReference.getData();
            if (data == null) {
                if (realType == null) {
                    throw new VisADException("VisADSlider: RealType cannot be null!");
                }
                if (string == null) {
                    throw new VisADException("VisADSlider: name cannot be null!");
                }
                this.realType = realType;
                if (f != f || f2 != f2 || f3 != f3) {
                    throw new VisADException("VisADSlider: min, max, and start cannot be NaN!");
                }
                this.sMinimum = f;
                this.sMaximum = f2;
                this.sCurrent = f3 < f || f3 > f2 ? (f + f2) / 2.0f : f3;
                this.sRef.setData(new Real(this.realType, this.sCurrent));
            } else {
                if (!(data instanceof Real)) {
                    throw new VisADException("VisADSlider: DataReference must point to a Real!");
                }
                object = (Real)data;
                this.realType = (RealType)((DataImpl)object).getType();
                this.sCurrent = (float)((Real)object).getValue();
                if (f != f || f2 != f2) {
                    throw new VisADException("VisADSlider: minimum and maximum cannot be NaN!");
                }
                this.sMinimum = f;
                this.sMaximum = f2;
                if (this.sCurrent < (double)f || this.sCurrent > (double)f2) {
                    this.sCurrent = (f + f2) / 2.0f;
                }
            }
            this.sName = string != null ? string : this.realType.getName();
            this.initLabel();
            object = new CellImpl(this){
                private final /* synthetic */ VisADSlider this$0;

                public void doAction() throws VisADException, RemoteException {
                    if (VisADSlider.access$0(this.this$0) != null) {
                        try {
                            double d = ((Real)VisADSlider.access$0(this.this$0).getData()).getValue();
                            if (!Util.isApproximatelyEqual(VisADSlider.access$2(this.this$0), d)) {
                                VisADSlider.access$3(this.this$0, d);
                            }
                        }
                        catch (RemoteException remoteException) {
                            if (CollabUtil.isDisconnectException(remoteException)) {
                                VisADSlider.access$1(this.this$0, null);
                            }
                            throw remoteException;
                        }
                    }
                }
                {
                    this.this$0 = visADSlider;
                    this.constructor$0(visADSlider);
                }

                private final void constructor$0(VisADSlider visADSlider) {
                }
            };
            if (dataReference instanceof RemoteDataReference) {
                RemoteCellImpl remoteCellImpl = new RemoteCellImpl((CellImpl)object);
                remoteCellImpl.addReference(dataReference);
            } else {
                ((ActionImpl)object).addReference(dataReference);
            }
        }
        this.add(this.slider);
        this.add(this.label);
        this.slider.addChangeListener(this);
        this.updateSlider(f3);
    }
}

