/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import ncsa.hdf.hdf5lib.H5;
import visad.DisplayImpl;
import visad.util.ComboFileFilter;
import visad.util.ExtensionFileFilter;
import visad.util.McIDASFileFilter;

public class Util {
    public static boolean isApproximatelyEqual(float f, float f2, float f3) {
        if (Float.isNaN(f)) {
            return Float.isNaN(f2);
        }
        if (Float.isNaN(f2)) {
            return false;
        }
        if (Math.abs(f - f2) < f3) {
            return true;
        }
        if ((double)f == 0.0 || (double)f2 == 0.0) {
            return false;
        }
        float f4 = 1.1920929E-7f;
        return Math.abs(1.0f - f / f2) < 1.1920929E-7f;
    }

    public static boolean isApproximatelyEqual(float f, float f2) {
        return Util.isApproximatelyEqual((double)f, (double)f2, 1.0E-5);
    }

    public static boolean isApproximatelyEqual(double d, double d2, double d3) {
        if (Double.isNaN(d)) {
            return Double.isNaN(d2);
        }
        if (Double.isNaN(d2)) {
            return false;
        }
        if (Math.abs(d - d2) < d3) {
            return true;
        }
        if (d == 0.0 || d2 == 0.0) {
            return false;
        }
        double d4 = 2.220446049250313E-16;
        return Math.abs(1.0 - d / d2) < 2.220446049250313E-16;
    }

    public static boolean isApproximatelyEqual(double d, double d2) {
        return Util.isApproximatelyEqual(d, d2, 1.0E-9);
    }

    public static JFileChooser getVisADFileChooser() {
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("pic", "BioRad PIC images");
        ExtensionFileFilter extensionFileFilter2 = new ExtensionFileFilter("bmp", "BMP images");
        ExtensionFileFilter extensionFileFilter3 = new ExtensionFileFilter("fits", "FITS datasets");
        ExtensionFileFilter extensionFileFilter4 = new ExtensionFileFilter("flashpix", "FlashPix images");
        ExtensionFileFilter extensionFileFilter5 = new ExtensionFileFilter("gif", "GIF images");
        ExtensionFileFilter extensionFileFilter6 = new ExtensionFileFilter(new String[]{"hdf", "hdf5"}, "HDF-5 datasets");
        ExtensionFileFilter extensionFileFilter7 = new ExtensionFileFilter(new String[]{"hdf", "hdfeos"}, "HDF-EOS datasets");
        ExtensionFileFilter extensionFileFilter8 = new ExtensionFileFilter(new String[]{"jpg", "jpeg", "jpe"}, "JPEG images");
        McIDASFileFilter mcIDASFileFilter = new McIDASFileFilter();
        ExtensionFileFilter extensionFileFilter9 = new ExtensionFileFilter(new String[]{"nc", "ncf", "netcdf", "cdf"}, "netCDF datasets");
        ExtensionFileFilter extensionFileFilter10 = new ExtensionFileFilter("png", "PNG images");
        ExtensionFileFilter extensionFileFilter11 = new ExtensionFileFilter("pnm", "PNM images");
        ExtensionFileFilter extensionFileFilter12 = new ExtensionFileFilter(new String[]{"svd", "vad", "visad"}, "Serialized VisAD data");
        ExtensionFileFilter extensionFileFilter13 = new ExtensionFileFilter(new String[]{"tiff", "tif"}, "TIFF images");
        ExtensionFileFilter extensionFileFilter14 = new ExtensionFileFilter(new String[]{"csv", "tsv", "bsv", "txt"}, "ASCII text data");
        ExtensionFileFilter extensionFileFilter15 = new ExtensionFileFilter("v5d", "Vis5D datasets");
        ComboFileFilter comboFileFilter = new ComboFileFilter(new FileFilter[]{extensionFileFilter, extensionFileFilter2, extensionFileFilter3, extensionFileFilter4, extensionFileFilter5, extensionFileFilter6, extensionFileFilter7, extensionFileFilter8, mcIDASFileFilter, extensionFileFilter9, extensionFileFilter10, extensionFileFilter11, extensionFileFilter12, extensionFileFilter13, extensionFileFilter14, extensionFileFilter15}, "All VisAD file types");
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.addChoosableFileFilter(extensionFileFilter);
        jFileChooser.addChoosableFileFilter(extensionFileFilter2);
        jFileChooser.addChoosableFileFilter(extensionFileFilter3);
        jFileChooser.addChoosableFileFilter(extensionFileFilter4);
        jFileChooser.addChoosableFileFilter(extensionFileFilter5);
        jFileChooser.addChoosableFileFilter(extensionFileFilter6);
        jFileChooser.addChoosableFileFilter(extensionFileFilter7);
        jFileChooser.addChoosableFileFilter(extensionFileFilter8);
        jFileChooser.addChoosableFileFilter(mcIDASFileFilter);
        jFileChooser.addChoosableFileFilter(extensionFileFilter9);
        jFileChooser.addChoosableFileFilter(extensionFileFilter10);
        jFileChooser.addChoosableFileFilter(extensionFileFilter11);
        jFileChooser.addChoosableFileFilter(extensionFileFilter12);
        jFileChooser.addChoosableFileFilter(extensionFileFilter13);
        jFileChooser.addChoosableFileFilter(extensionFileFilter14);
        jFileChooser.addChoosableFileFilter(extensionFileFilter15);
        jFileChooser.addChoosableFileFilter(comboFileFilter);
        return jFileChooser;
    }

    public static void adjustTextField(JTextField jTextField) {
        Dimension dimension = jTextField.getMaximumSize();
        Dimension dimension2 = jTextField.getPreferredSize();
        dimension.height = dimension2.height;
        jTextField.setMaximumSize(dimension);
    }

    public static void centerWindow(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        ((Component)window).setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
    }

    public static boolean canDoHDF5() {
        boolean bl = false;
        try {
            H5.J2C(0);
            bl = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static boolean canDoJPEG() {
        return Util.canDoClass("com.sun.image.codec.jpeg.JPEGCodec") != null;
    }

    public static boolean canDoPython() {
        return Util.canDoClass("org.python.util.PythonInterpreter") != null;
    }

    public static boolean canDoJava3D() {
        return Util.canDoJava3D("1.0");
    }

    public static boolean canDoJava3D(String string) {
        Package package_;
        boolean bl;
        Class clazz = Util.canDoClass("javax.vecmath.Point3d");
        boolean bl2 = clazz != null ? Util.canDoClass("javax.media.j3d.SceneGraphObject") != null : (bl = false);
        if (bl && (package_ = clazz.getPackage()) != null) {
            try {
                bl = package_.isCompatibleWith(string);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    private static Class canDoClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public static void captureDisplay(DisplayImpl displayImpl, String string) {
        DisplayImpl displayImpl2 = displayImpl;
        File file = new File(string);
        Runnable runnable = new Runnable(displayImpl2, file){
            private final /* synthetic */ DisplayImpl val$disp;
            private final /* synthetic */ File val$fn;

            public void run() {
                BufferedImage bufferedImage = this.val$disp.getImage();
                try {
                    JPEGEncodeParam jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
                    jPEGEncodeParam.setQuality(1.0f, true);
                    FileOutputStream fileOutputStream = new FileOutputStream(this.val$fn);
                    JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
                    jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    System.err.println("Error whilst saving JPEG: " + exception);
                }
            }
            {
                this.val$disp = displayImpl;
                this.val$fn = file;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }
}

