/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.util.Vector;

public class ThreadPool {
    private static final String DEFAULT_PREFIX = "Minnow";
    private static final int DEFAULT_MIN_THREADS = 5;
    private static final int DEFAULT_MAX_THREADS = 10;
    private int maxQueuedTasks = 3;
    private int minThreads;
    private int maxThreads;
    private Object threadLock = new Object();
    private Object doneLock = new Object();
    private boolean terminateThread = false;
    private Vector threads = new Vector();
    private Vector tasks = new Vector();
    private Vector busy_tasks = new Vector();
    private String prefix;
    private int nextID = 0;

    public void remove(Runnable runnable) {
        Vector vector = this.tasks;
        synchronized (vector) {
            this.tasks.removeElement(runnable);
            this.busy_tasks.removeElement(runnable);
        }
    }

    public void queue(Runnable runnable) {
        if (this.terminateThread) {
            throw new Error("Task queued after threads stopped");
        }
        int n = 0;
        Object object = this.tasks;
        synchronized (object) {
            if (!this.tasks.contains(runnable)) {
                this.tasks.addElement(runnable);
                n = this.tasks.size();
            }
        }
        object = this.threadLock;
        synchronized (object) {
            if (n > this.maxQueuedTasks) {
                if (this.threads != null && this.threads.size() < this.maxThreads) {
                    try {
                        ThreadMinnow threadMinnow = new ThreadMinnow(this);
                        threadMinnow.setName(this.prefix + "-" + this.nextID++);
                        this.threads.addElement(threadMinnow);
                        this.threadLock.notify();
                    }
                    catch (SecurityException securityException) {}
                } else {
                    this.threadLock.notifyAll();
                }
            } else {
                this.threadLock.notify();
            }
        }
    }

    Runnable getTask() {
        Runnable runnable = null;
        Vector vector = this.tasks;
        synchronized (vector) {
            int n = this.tasks.size();
            int n2 = 0;
            while (n2 < n) {
                runnable = (Runnable)this.tasks.elementAt(n2);
                if (!this.busy_tasks.contains(runnable)) {
                    this.tasks.removeElementAt(n2);
                    this.busy_tasks.addElement(runnable);
                    break;
                }
                runnable = null;
                ++n2;
            }
        }
        return runnable;
    }

    void releaseTask(Runnable runnable) {
        Vector vector = this.tasks;
        synchronized (vector) {
            this.busy_tasks.removeElement(runnable);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean waitForTasks() {
        var1_1 = this.tasks.size();
        if (!(Thread.currentThread() instanceof ThreadMinnow)) ** GOTO lbl21
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException var2_2) {
            // empty catch block
        }
        return false;
lbl-1000:
        // 1 sources

        {
            try {
                var2_3 = this.doneLock;
                synchronized (var2_3) {
                    this.doneLock.wait();
                }
            }
            catch (InterruptedException var2_4) {
                // empty catch block
            }
            if (var1_1-- == 0) break;
lbl21:
            // 2 sources

            ** while (this.tasks.size() > 0)
        }
lbl22:
        // 2 sources

        return var1_1 > 0;
    }

    public void setThreadMaximum(int n) throws Exception {
        if (n < this.maxThreads) {
            throw new Exception("Cannot decrease maximum number of threads");
        }
        this.maxThreads = n;
    }

    /*
     * Unable to fully structure code
     */
    public void stopThreads() {
        if (this.terminateThread) {
            return;
        }
        this.terminateThread = true;
        var1_1 = this.threadLock;
        synchronized (var1_1) {
            this.threadLock.notifyAll();
        }
        var1_1 = this.threads;
        synchronized (var1_1) {
            var3_2 = this.threads;
            this.threads = null;
            var4_3 = var3_2.listIterator();
            // MONITOREXIT @DISABLED, blocks:[1, 5] lbl19 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl37
        }
        do {
            var5_4 = (Thread)var4_3.next();
            while (true) {
                var6_5 = var3_2;
                synchronized (var6_5) {
                    var3_2.notifyAll();
                }
                try {
                    var5_4.join();
                }
                catch (InterruptedException var8_6) {
                    continue;
                }
                break;
            }
            var4_3.remove();
lbl37:
            // 2 sources

        } while (var4_3.hasNext());
    }

    public ThreadPool() throws Exception {
        this(DEFAULT_PREFIX, 5, 10);
    }

    public ThreadPool(String string) throws Exception {
        this(string, 5, 10);
    }

    public ThreadPool(int n) throws Exception {
        this(5, n);
    }

    public ThreadPool(int n, int n2) throws Exception {
        this(DEFAULT_PREFIX, n, n2);
    }

    public ThreadPool(String string, int n, int n2) throws Exception {
        this.minThreads = n;
        this.maxThreads = n2;
        if (this.minThreads > this.maxThreads) {
            throw new Exception("Maximum number of threads (" + this.maxThreads + ") is less than minimum number of threads (" + this.minThreads + ")");
        }
        this.prefix = string;
        int n3 = 0;
        while (n3 < this.minThreads) {
            ThreadMinnow threadMinnow = new ThreadMinnow(this);
            threadMinnow.setName(string + "-" + this.nextID++);
            this.threads.addElement(threadMinnow);
            ++n3;
        }
    }

    private class ThreadMinnow
    extends Thread {
        private ThreadPool parent = null;

        public void run() {
            while (true) {
                Object object;
                Runnable runnable;
                if ((runnable = this.parent.getTask()) != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    this.parent.releaseTask(runnable);
                    object = ThreadPool.this.threadLock;
                    synchronized (object) {
                        ThreadPool.this.threadLock.notify();
                    }
                    object = ThreadPool.this.doneLock;
                    synchronized (object) {
                        ThreadPool.this.doneLock.notifyAll();
                    }
                }
                if (ThreadPool.this.terminateThread) {
                    return;
                }
                try {
                    object = ThreadPool.this.threadLock;
                    synchronized (object) {
                        ThreadPool.this.threadLock.wait();
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public ThreadMinnow(ThreadPool threadPool2) {
            this.parent = threadPool2;
            this.start();
        }
    }
}

