/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import visad.util.GUIFrame;
import visad.util.TextEditor;

public class TextFrame
extends GUIFrame
implements UndoableEditListener {
    protected TextEditor textPane;
    private String title = "VisAD Text Editor";

    protected void layoutGUI() {
        this.setContentPane(this.textPane);
        this.setTitle(this.title);
    }

    public void setTitle(String string) {
        this.title = string;
        this.refreshTitleBar();
    }

    public String getTitle() {
        return this.title;
    }

    private void refreshUndoMenuItems() {
        JMenuItem jMenuItem = this.getMenuItem("Edit", "Undo");
        JMenuItem jMenuItem2 = this.getMenuItem("Edit", "Redo");
        jMenuItem.setEnabled(this.textPane.canUndo());
        jMenuItem.setText(this.textPane.getUndoName());
        jMenuItem2.setEnabled(this.textPane.canRedo());
        jMenuItem2.setText(this.textPane.getRedoName());
    }

    private void refreshSaveMenuItem(boolean bl) {
        JMenuItem jMenuItem = this.getMenuItem("File", "Save");
        jMenuItem.setEnabled(bl);
    }

    private void refreshTitleBar() {
        String string = this.textPane.getFilename();
        super.setTitle(this.title + (string == null ? "" : " - " + string));
    }

    private void refreshMenuItems(boolean bl) {
        this.refreshUndoMenuItems();
        this.refreshSaveMenuItem(bl);
    }

    protected boolean askSaveChanges(boolean bl) {
        int n = JOptionPane.showConfirmDialog(this, "Save changes to the file?", this.getTitle(), bl ? 1 : 0);
        if (n == 0) {
            this.fileSave();
        }
        return n != 2;
    }

    public void showError(String string) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n3);
        while ((n = string.indexOf(13, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            n2 = n + 1;
        }
        stringBuffer.append(string.substring(n2));
        string = stringBuffer.toString();
        JOptionPane.showMessageDialog(this, string, this.getTitle(), 0);
    }

    public void fileNew() {
        if (this.textPane.hasChanged() && !this.askSaveChanges(true)) {
            return;
        }
        this.textPane.newFile();
        this.refreshMenuItems(false);
        this.refreshTitleBar();
    }

    public void fileOpen() {
        if (this.textPane.hasChanged() && !this.askSaveChanges(true)) {
            return;
        }
        this.textPane.openDialog();
        this.refreshMenuItems(false);
        this.refreshTitleBar();
    }

    public boolean fileSave() {
        boolean bl = this.textPane.saveFile();
        if (bl) {
            this.refreshSaveMenuItem(false);
        }
        return bl;
    }

    public boolean fileSaveAs() {
        boolean bl = this.textPane.saveDialog();
        if (bl) {
            this.refreshSaveMenuItem(false);
            this.refreshTitleBar();
        }
        return bl;
    }

    public void fileExit() {
        if (this.textPane.hasChanged()) {
            this.askSaveChanges(false);
        }
        System.exit(0);
    }

    public void editUndo() {
        this.textPane.undo();
        this.refreshMenuItems(true);
    }

    public void editRedo() {
        this.textPane.redo();
        this.refreshMenuItems(true);
    }

    public void editCut() {
        this.textPane.cut();
        this.refreshMenuItems(true);
    }

    public void editCopy() {
        this.textPane.copy();
        this.refreshUndoMenuItems();
    }

    public void editPaste() {
        this.textPane.paste();
        this.refreshMenuItems(true);
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (!undoableEditEvent.getEdit().isSignificant()) {
            return;
        }
        this.refreshMenuItems(true);
    }

    public TextEditor getTextPane() {
        return this.textPane;
    }

    public static void main(String[] stringArray) {
        TextFrame textFrame = new TextFrame();
        textFrame.addWindowListener(new WindowAdapter(textFrame){
            private final /* synthetic */ TextFrame val$frame;

            public void windowClosing(WindowEvent windowEvent) {
                this.val$frame.fileExit();
            }
            {
                this.val$frame = textFrame;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        ((Component)textFrame).setBounds(100, 100, 500, 800);
        ((Component)textFrame).setVisible(true);
    }

    public TextFrame() {
        this((String)null);
    }

    public TextFrame(String string) {
        this(new TextEditor(string));
    }

    public TextFrame(TextEditor textEditor) {
        this.textPane = textEditor;
        this.textPane.addUndoableEditListener(this);
        this.addMenuItem("File", "New", "fileNew", 'n');
        this.addMenuItem("File", "Open...", "fileOpen", 'o');
        this.addMenuItem("File", "Save", "fileSave", 's', false);
        this.addMenuItem("File", "Save as...", "fileSaveAs", 'a');
        this.addMenuItem("File", "Exit", "fileExit", 'x');
        this.addMenuItem("Edit", "Undo", "editUndo", 'u', false);
        this.addMenuItem("Edit", "Redo", "editRedo", 'r', false);
        this.addMenuItem("Edit", "Cut", "editCut", 't');
        this.addMenuItem("Edit", "Copy", "editCopy", 'c');
        this.addMenuItem("Edit", "Paste", "editPaste", 'p');
        this.layoutGUI();
    }
}

