/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import visad.util.ExtensionFileFilter;

public class TextEditor
extends JScrollPane
implements UndoableEditListener {
    public static final Font MONO = new Font("monospaced", 0, 12);
    public static final boolean DEBUG = false;
    protected JTextArea text;
    protected JFileChooser fileChooser;
    protected UndoManager undo = new UndoManager();
    protected File currentFile;
    protected boolean changed = false;

    public void newFile() {
        this.currentFile = null;
        this.setText("");
        this.undo.discardAllEdits();
        this.changed = false;
    }

    public void openFile(String string) throws IOException {
        File file = string == null ? null : new File(string);
        this.openFile(file);
    }

    public void openFile(File file) throws IOException {
        String string;
        if (file == null) {
            string = "";
        } else {
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
            fileInputStream.close();
            string = new String(byArray);
        }
        this.currentFile = file;
        this.setText(string);
        this.changed = false;
    }

    public void saveFile(String string) throws IOException {
        File file = string == null ? null : new File(string);
        this.saveFile(file);
    }

    public void saveFile(File file) throws IOException {
        byte[] byArray = this.getText().getBytes();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
        this.currentFile = file;
        this.changed = false;
    }

    public boolean openDialog() {
        this.fileChooser.setDialogType(0);
        if (this.fileChooser.showOpenDialog(this) != 0) {
            return false;
        }
        try {
            this.openFile(this.fileChooser.getSelectedFile());
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean saveDialog() {
        this.fileChooser.setDialogType(1);
        if (this.fileChooser.showSaveDialog(this) != 0) {
            return false;
        }
        try {
            this.saveFile(this.fileChooser.getSelectedFile());
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean saveFile() {
        boolean bl = false;
        if (this.currentFile == null) {
            bl = this.saveDialog();
        } else {
            try {
                this.saveFile(this.currentFile);
                bl = true;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Could not save the file.", "VisAD Text Editor", 0);
            }
        }
        return bl;
    }

    public void undo() throws CannotUndoException {
        this.undo.undo();
        this.changed = true;
    }

    public void redo() throws CannotRedoException {
        this.undo.redo();
        this.changed = true;
    }

    public void cut() {
        this.text.cut();
    }

    public void copy() {
        this.text.copy();
    }

    public void paste() {
        this.text.paste();
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String string) {
        this.text.setText(string);
    }

    public String getFilename() {
        return this.currentFile == null ? null : this.currentFile.getPath();
    }

    public File getFile() {
        return this.currentFile;
    }

    public boolean canUndo() {
        return this.undo.canUndo();
    }

    public boolean canRedo() {
        return this.undo.canRedo();
    }

    public String getUndoName() {
        return this.undo.getUndoPresentationName();
    }

    public String getRedoName() {
        return this.undo.getRedoPresentationName();
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (!undoableEditEvent.getEdit().isSignificant()) {
            return;
        }
        this.undo.addEdit(undoableEditEvent.getEdit());
        this.changed = true;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.text.getDocument().addUndoableEditListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.text.getDocument().removeUndoableEditListener(undoableEditListener);
    }

    public TextEditor() {
        this((String)null);
    }

    public TextEditor(String string) {
        this.text = new JTextArea();
        try {
            this.openFile(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.text.setFont(MONO);
        this.setViewportView(this.text);
        this.addUndoableEditListener(this);
        this.fileChooser = new JFileChooser(System.getProperty("user.dir"));
        this.fileChooser.addChoosableFileFilter(new ExtensionFileFilter("txt", "Text files"));
    }
}

