/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.util.ArrowSlider;
import visad.util.Slider;
import visad.util.SliderChangeEvent;
import visad.util.SliderChangeListener;

public class SliderLabel
extends JPanel
implements SliderChangeListener {
    private Slider slider;
    private String label;
    private boolean rangeVisible;
    private Color background;
    private Color text;
    Dimension minSize = null;
    Dimension prefSize = null;
    Dimension maxSize = null;
    private boolean rangeChanged;
    private String drawmin;
    private String drawmax;
    private String drawval;

    public void sliderChanged(SliderChangeEvent sliderChangeEvent) {
        if (sliderChangeEvent.type != SliderChangeEvent.VALUE_CHANGE) {
            this.rangeChanged = true;
        }
        this.validate();
        this.repaint();
    }

    public void update(Graphics graphics) {
        String string;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.rangeVisible) {
            if (this.rangeChanged) {
                graphics.setColor(this.background);
                if (this.drawmin == null) {
                    this.drawmin = "null";
                }
                if (this.drawmax == null) {
                    this.drawmax = "null";
                }
                graphics.drawString(this.drawmin, 3, this.getBounds().height - 1 - fontMetrics.getDescent());
                graphics.drawString(this.drawmax, this.getBounds().width - 4 - fontMetrics.stringWidth(this.drawmax), this.getBounds().height - 1 - fontMetrics.getDescent());
                this.rangeChanged = false;
            }
            graphics.setColor(this.text);
            string = Float.toString(this.slider.getMinimum());
            graphics.drawString(string, 3, this.getBounds().height - 1 - fontMetrics.getDescent());
            this.drawmin = string;
            String string2 = Float.toString(this.slider.getMaximum());
            graphics.drawString(string2, this.getBounds().width - 4 - fontMetrics.stringWidth(string2), this.getBounds().height - 1 - fontMetrics.getDescent());
            this.drawmax = string2;
        }
        graphics.setColor(this.background);
        if (this.drawval == null) {
            this.drawval = "null";
        }
        graphics.drawString(this.drawval, this.getBounds().width / 2 - fontMetrics.stringWidth(this.drawval) / 2 + 3, this.getBounds().height - 1 - fontMetrics.getDescent());
        graphics.setColor(this.text);
        string = new String(this.label + " = " + this.slider.getValue());
        graphics.drawString(string, this.getBounds().width / 2 - fontMetrics.stringWidth(string) / 2 + 3, this.getBounds().height - 1 - fontMetrics.getDescent());
        this.drawval = string;
    }

    public void paint(Graphics graphics) {
        String string;
        graphics.setColor(this.background);
        graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        graphics.setColor(this.text);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.rangeVisible) {
            string = Float.toString(this.slider.getMinimum());
            graphics.drawString(string, 3, this.getBounds().height - 1 - fontMetrics.getDescent());
            this.drawmin = string;
            String string2 = Float.toString(this.slider.getMaximum());
            graphics.drawString(string2, this.getBounds().width - 4 - fontMetrics.stringWidth(string2), this.getBounds().height - 1 - fontMetrics.getDescent());
            this.drawmax = string2;
        }
        string = new String(this.label + " = " + this.slider.getValue());
        graphics.drawString(string, this.getBounds().width / 2 - fontMetrics.stringWidth(string) / 2 + 3, this.getBounds().height - 1 - fontMetrics.getDescent());
        this.drawval = string;
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(256, 18);
        }
        return this.prefSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.prefSize = dimension;
    }

    public Dimension getMaximumSize() {
        if (this.maxSize == null) {
            this.maxSize = new Dimension(Integer.MAX_VALUE, 18);
        }
        return this.maxSize;
    }

    public void setMaximumSize(Dimension dimension) {
        this.maxSize = dimension;
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension(100, 18);
        }
        return this.minSize;
    }

    public void setMinimumSize(Dimension dimension) {
        this.minSize = dimension;
    }

    public static void main(String[] stringArray) {
        ArrowSlider arrowSlider = new ArrowSlider();
        SliderLabel sliderLabel = new SliderLabel(arrowSlider, "test");
        JFrame jFrame = new JFrame("Visad Slider Label");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        jFrame.setLayout(new BorderLayout());
        jFrame.add((Component)sliderLabel, "South");
        jFrame.add((Component)arrowSlider, "North");
        int n = ((JComponent)arrowSlider).getPreferredSize().height + sliderLabel.getPreferredSize().height;
        int n2 = Math.max(((JComponent)arrowSlider).getPreferredSize().width, sliderLabel.getPreferredSize().height);
        ((Component)jFrame).setSize(new Dimension(n2, n + 27));
        ((Component)jFrame).setVisible(true);
    }

    public SliderLabel(Slider slider) {
        this(slider, slider.getName());
    }

    public SliderLabel(Slider slider, Color color, Color color2) {
        this(slider, slider.getName(), color, color2);
    }

    public SliderLabel(Slider slider, String string, Color color, Color color2) {
        this(slider, string, true, color, color2);
    }

    public SliderLabel(Slider slider, String string) {
        this(slider, string, true);
    }

    public SliderLabel(Slider slider, String string, boolean bl) {
        this(slider, string, bl, Color.black, Color.white);
    }

    public SliderLabel(Slider slider, String string, boolean bl, Color color, Color color2) {
        this.slider = slider;
        this.label = string;
        this.rangeVisible = bl;
        this.background = color;
        this.text = color2;
        slider.addSliderChangeListener(this);
    }
}

